/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx40layer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitantRecorder;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingNode;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx40layer.MX40Group;
import jp.synthtarou.midimixer.mx40layer.MX40Layer;
import jp.synthtarou.midimixer.mx40layer.MX40View;

public class MX40Process
extends MXReceiver
implements MXSettingTarget {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX40Process.class);
    MX40View _view;
    MXVisitantRecorder _inputInfo;
    MXVisitantRecorder _outputInfo;
    MXNoteOffWatcher _noteOff;
    MXSetting _setting;
    ArrayList<MX40Group> _groupList = new ArrayList();

    public MX40Process() {
        this._inputInfo = new MXVisitantRecorder();
        this._outputInfo = new MXVisitantRecorder();
        this._noteOff = new MXNoteOffWatcher();
        this._view = new MX40View(this);
        this._setting = new MXSetting("SoundLayer");
        this._setting.setTarget(this);
    }

    public void exportSetting(File file) {
        MXSetting setting2 = new MXSetting(file, false);
        setting2.setTarget(this);
        setting2.writeToFile();
    }

    public void importSetting(File file) {
        MXSetting setting2 = new MXSetting(file, false);
        setting2.setTarget(this);
        setting2.readFile();
    }

    public void readSettings() {
        this._setting.readFile();
    }

    @Override
    public void sendToNext(MXMessage message) {
        this._outputInfo.tryPickup(message);
        super.sendToNext(message);
    }

    @Override
    public void processMXMessage(MXMessage message) {
        this._inputInfo.tryPickup(message);
        if (message.getExtype() != 256) {
            this.sendToNext(message);
            return;
        }
        if (!this.isUsingThisRecipe()) {
            this.sendToNext(message);
            return;
        }
        int port = message.getPort();
        int command = message.getCommand();
        int channel = message.getChannel();
        if (command == 128) {
            this._noteOff.notifyNoteOffEvent(port, channel, message.getNoteNumberFromBytes(), "@0");
            return;
        }
        boolean dispatched = false;
        if (message.isMessageTypeChannel()) {
            for (int i = 0; i < this._groupList.size(); ++i) {
                final MX40Group col = this._groupList.get(i);
                if (!col.processByGroup(message)) continue;
                if (command == 144) {
                    this._noteOff.addListener(message, message, new MXNoteOffWatcher.Handler(){

                        @Override
                        public void onNoteOffEvent(MXMessage target) {
                            MXMessage message = MXMessageFactory.fromShortMessage(target.getPort(), 128 + target.getChannel(), target.getNoteNumberFromBytes(), 0);
                            col.processByGroup(message);
                        }
                    }, "@0");
                }
                dispatched = true;
                break;
            }
        }
        if (!dispatched) {
            if (command == 144) {
                this._noteOff.addListener(message, message, new MXNoteOffWatcher.Handler(){

                    @Override
                    public void onNoteOffEvent(MXMessage target) {
                        MXMessage message = MXMessageFactory.fromShortMessage(target.getPort(), 128 + target.getChannel(), target.getNoteNumberFromBytes(), 0);
                        MX40Process.this.sendToNext(message);
                    }
                }, "@0");
            }
            if (message.getCommand() == 192 && message.getGate() < 0) {
                return;
            }
            this.sendToNext(message);
        }
    }

    @Override
    public String getReceiverName() {
        return "Sound Layer";
    }

    @Override
    public JComponent getReceiverView() {
        return this._view;
    }

    public synchronized void resendProgramChange() {
        for (int port = 0; port < 16; ++port) {
            for (int channel = 0; channel < 16; ++channel) {
                MXMessage programChange;
                MXVisitant info = this._inputInfo.getVisitant(port, channel);
                if (info.isHavingProgram()) {
                    programChange = MXMessageFactory.fromShortMessage(port, 192 + channel, info.getProgram(), 0);
                    this.processMXMessage(programChange);
                    continue;
                }
                programChange = MXMessageFactory.fromShortMessage(port, 192 + channel, 0, 0);
                programChange.setGate(-1);
                this.processMXMessage(programChange);
            }
        }
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        setting.register("Group[].title");
        setting.register("Group[].isWatchPort");
        setting.register("Group[].watchingPort");
        setting.register("Group[].isWatchChannel");
        setting.register("Group[].watchingCahnnel");
        setting.register("Group[].isWatchBank");
        setting.register("Group[].watchingBankMSB");
        setting.register("Group[].watchingBankLSB");
        setting.register("Group[].isWatchProgram");
        setting.register("Group[].watchingProgram");
        setting.register("Group[].rotateLayer");
        setting.register("Group[].rotatePoly");
        setting.register("Group[].Layer");
        setting.register("Group[].Layer[]");
        setting.register("Group[].Layer[].title");
        setting.register("Group[].Layer[].disabled");
        setting.register("Group[].Layer[].modPort");
        setting.register("Group[].Layer[].fixedPort");
        setting.register("Group[].Layer[].modChannel");
        setting.register("Group[].Layer[].fixedChannel");
        setting.register("Group[].Layer[].modBank");
        setting.register("Group[].Layer[].fixedBankMSB");
        setting.register("Group[].Layer[].fixedBankLSB");
        setting.register("Group[].Layer[].modProgram");
        setting.register("Group[].Layer[].fixedProgram");
        setting.register("Group[].Layer[].modPan");
        setting.register("Group[].Layer[].fixedPan");
        setting.register("Group[].Layer[].adjustExpression");
        setting.register("Group[].Layer[].adjustTranspose");
        setting.register("Group[].Layer[].adjustVelocity");
        setting.register("Group[].Layer[].sendKeyLowest");
        setting.register("Group[].Layer[].sendKeyHighest");
        setting.register("Group[].Layer[].sendVelocityLowest");
        setting.register("Group[].Layer[].sendVelocityHighest");
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        ArrayList<MX40Group> newGroupList = new ArrayList<MX40Group>();
        this._groupList = newGroupList;
        List<MXSettingNode> readingGroups = setting.findByPath("Group");
        if (readingGroups.size() > 0) {
            readingGroups = ((MXSettingNode)readingGroups.get(0)).findNumbers();
        }
        for (MXSettingNode node : readingGroups) {
            MX40Group group = new MX40Group(this);
            group._title = node.findNode((String)"title")._value;
            group._isWatchPort = node.getSettingAsBoolean("isWatchPort", false);
            group._watchingPort = node.getSettingAsInt("watchingPort", 0);
            group._isWatchChannel = node.getSettingAsBoolean("isWatchChannel", false);
            group._watchingChannel = node.getSettingAsInt("watchingCahnnel", 0);
            group._isRotate = node.getSettingAsBoolean("rotateLayer", false);
            group._rotatePoly = node.getSettingAsInt("rotatePoly", 16);
            group._isWatchBank = node.getSettingAsBoolean("isWatchBank", false);
            group._watchingBankMSB = node.getSettingAsInt("watchingBankMSB", 0);
            group._watchingBankLSB = node.getSettingAsInt("watchingBankLSB", 0);
            group._isWatchProgram = node.getSettingAsBoolean("isWatchProgram", false);
            group._watchingProgram = node.getSettingAsInt("watchingProgram", 0);
            newGroupList.add(group);
            MXSettingNode layerNode = node.findNode("Layer");
            if (layerNode == null) continue;
            List<MXSettingNode> numbers = layerNode.findNumbers();
            for (MXSettingNode node2 : numbers) {
                MX40Layer layer = new MX40Layer(this, group);
                layer._title = node2.getSetting("title");
                layer._disabled = node2.getSettingAsBoolean("disabled", false);
                layer._modPort = node2.getSettingAsInt("modPort", 1);
                layer._fixedPort = node2.getSettingAsInt("fixedPort", 0);
                layer._modChannel = node2.getSettingAsInt("modChannel", 1);
                layer._fixedChannel = node2.getSettingAsInt("fixedChannel", 0);
                layer._modBank = node2.getSettingAsInt("modBank", 1);
                layer._fixedBankMSB = node2.getSettingAsInt("fixedBankMSB", 0);
                layer._fixedBankLSB = node2.getSettingAsInt("fixedBankLSB", 0);
                layer._modProgram = node2.getSettingAsInt("modProgram", 1);
                layer._fixedProgram = node2.getSettingAsInt("fixedProgram", 0);
                layer._modPan = node2.getSettingAsInt("modPan", 1);
                layer._fixedPan = node2.getSettingAsInt("fixedPan", 64);
                layer._adjustExpression = node2.getSettingAsInt("adjustExpression", 100);
                layer._adjustTranspose = node2.getSettingAsInt("adjustTranspose", 0);
                layer._adjustVelocity = node2.getSettingAsInt("adjustVelocity", 0);
                layer.setAcceptKeyLowest(node2.getSettingAsInt("sendKeyLowest", 0));
                layer.setAcceptKeyHighest(node2.getSettingAsInt("sendKeyHighest", 127));
                layer.setAcceptVelocityLowest(node2.getSettingAsInt("sendVelocityLowest", 0));
                layer.setAcceptVelocityHighest(node2.getSettingAsInt("sendVelocityHighest", 127));
                group._listLayer.add(layer);
            }
        }
        this.resendProgramChange();
        this._view.justRefreshViewListAndPanel();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        for (int i = 0; i < this._groupList.size(); ++i) {
            String prefixG = "Group[" + i + "]";
            MX40Group group = this._groupList.get(i);
            setting.setSetting(prefixG + ".title", group._title);
            setting.setSetting(prefixG + ".isWatchPort", group._isWatchPort);
            setting.setSetting(prefixG + ".watchingPort", group._watchingPort);
            setting.setSetting(prefixG + ".isWatchChannel", group._isWatchChannel);
            setting.setSetting(prefixG + ".watchingCahnnel", group._watchingChannel);
            setting.setSetting(prefixG + ".isWatchBank", group._isWatchBank);
            setting.setSetting(prefixG + ".watchingBankMSB", group._watchingBankMSB);
            setting.setSetting(prefixG + ".watchingBankLSB", group._watchingBankLSB);
            setting.setSetting(prefixG + ".isWatchProgram", group._isWatchProgram);
            setting.setSetting(prefixG + ".watchingProgram", group._watchingProgram);
            setting.setSetting(prefixG + ".rotateLayer", group._isRotate);
            setting.setSetting(prefixG + ".rotatePoly", group._rotatePoly);
            for (int j = 0; j < group._listLayer.size(); ++j) {
                String prefixL = "Group[" + i + "].Layer[" + j + "]";
                MX40Layer layer = group._listLayer.get(j);
                setting.setSetting(prefixL + ".title", layer._title);
                setting.setSetting(prefixL + ".disabled", layer._disabled);
                setting.setSetting(prefixL + ".modPort", layer._modPort);
                setting.setSetting(prefixL + ".fixedPort", layer._fixedPort);
                setting.setSetting(prefixL + ".modChannel", layer._modChannel);
                setting.setSetting(prefixL + ".fixedChannel", layer._fixedChannel);
                setting.setSetting(prefixL + ".modBank", layer._modBank);
                setting.setSetting(prefixL + ".fixedBankMSB", layer._fixedBankMSB);
                setting.setSetting(prefixL + ".fixedBankLSB", layer._fixedBankLSB);
                setting.setSetting(prefixL + ".modProgram", layer._modProgram);
                setting.setSetting(prefixL + ".fixedProgram", layer._fixedProgram);
                setting.setSetting(prefixL + ".modPan", layer._modPan);
                setting.setSetting(prefixL + ".fixedPan", layer._fixedPan);
                setting.setSetting(prefixL + ".adjustExpression", layer._adjustExpression);
                setting.setSetting(prefixL + ".adjustTranspose", layer._adjustTranspose);
                setting.setSetting(prefixL + ".adjustVelocity", layer._adjustVelocity);
                setting.setSetting(prefixL + ".sendKeyLowest", layer.getAcceptKeyLowest());
                setting.setSetting(prefixL + ".sendKeyHighest", layer.getAcceptKeyHighest());
                setting.setSetting(prefixL + ".sendVelocityLowest", layer.getAcceptVelocityLowest());
                setting.setSetting(prefixL + ".sendVelocityHighest", layer.getAcceptVelocityHighest());
            }
        }
        this.resendProgramChange();
    }
}

