/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.swing.MXFocusAble;
import jp.synthtarou.midimixer.libs.swing.MXFocusGroupElement;
import jp.synthtarou.midimixer.mx30controller.CurvedSlider;
import jp.synthtarou.midimixer.mx30controller.MGStatus;
import jp.synthtarou.midimixer.mx30controller.MGStatusConfig;
import jp.synthtarou.midimixer.mx30controller.MX32MixerProcess;

public class MGCircle
extends JPanel
implements MXFocusAble,
MouseWheelListener {
    private static final MXDebugConsole _debug = new MXDebugConsole(MGCircle.class);
    MX32MixerProcess _process;
    int _row;
    int _column;
    Color foreground = null;
    boolean _disconnectMoment = false;
    ArrayList<MouseListener> backupedListener = new ArrayList();
    int _updating = -1;
    private JLabel jLabel1;
    private CurvedSlider jCircleValue;

    public MGStatus getStatus() {
        if (this._process == null) {
            return null;
        }
        return this._process._data.getCircleStatus(this._row, this._column);
    }

    public void setStatus(MGStatus status) {
        this._process._data.setCircleStatus(this._row, this._column, status);
    }

    public void setInverted(boolean invert) {
        this.jCircleValue.setInverted(invert);
    }

    public MGCircle(MX32MixerProcess process, int row, int column) {
        this._row = row;
        this._column = column;
        this._process = process;
        this.initComponents();
        this.updateUI();
        this.addMouseWheelListener(this);
    }

    @Override
    public void updateUI() {
        MGStatus status = this.getStatus();
        if (status != null) {
            status.fixRangedValue();
            this.jCircleValue.setRange(status.getRangeMin(), status.getRangeMax());
            this.jCircleValue.setInverted(status.isUiValueInvert());
            this.jCircleValue.setValue(status.getValue());
            if (status.getName() == null || status.getName().length() == 0) {
                MXMessage message = status.toMXMessage();
                if (message == null) {
                    this.jLabel1.setText("??3");
                } else {
                    this.jLabel1.setText(message.toShortString());
                }
            } else {
                this.jLabel1.setText(status.getName());
            }
            this.focusStatusChanged(false);
        }
        super.updateUI();
    }

    public void setValueChangeable(boolean usable) {
        if (!usable) {
            for (MouseListener l : this.jCircleValue.getMouseListeners()) {
                if (l instanceof MXFocusGroupElement.Listen) continue;
                this.backupedListener.add(l);
            }
            for (MouseListener l : this.backupedListener) {
                this.jCircleValue.removeMouseListener(l);
            }
        } else {
            for (MouseListener l : this.backupedListener) {
                this.jCircleValue.addMouseListener(l);
            }
            this.backupedListener.clear();
        }
    }

    private void initComponents() {
        this.jCircleValue = new CurvedSlider(45);
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jCircleValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MGCircle.this.jCircleValueStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jCircleValue, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
    }

    private void jCircleValueStateChanged(ChangeEvent evt) {
        int newValue = this.jCircleValue.getValue();
        if (this._updating == newValue) {
            return;
        }
        if (this.getStatus().getValue() == newValue) {
            return;
        }
        this._process.catchedValue(this.getStatus(), newValue, null);
    }

    public void updateUIOnly(final int newValue) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MGCircle.this.updateUIOnly(newValue);
                }
            });
            return;
        }
        this._updating = newValue;
        this.getStatus().setValue(newValue);
        if (this.jCircleValue.getValue() != newValue) {
            this.jCircleValue.setValue(newValue);
        }
        this._updating = -1;
    }

    @Override
    public void focusedMousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || this._process._parent._editingControl) {
            this._process._parent.enterEditMode(false);
            this.focusStatusChanged(false);
            this.editContoller();
        }
    }

    @Override
    public void focusStatusChanged(boolean flag) {
        if (flag) {
            this._process._parent.showTextForFocus(1, this._process._port, this._row, this._column);
        }
    }

    @Override
    public void focusChangingValue() {
        this._process._parent.showTextForFocus(1, this._process._port, this._row, this._column);
    }

    public void increment() {
        MGStatus status = this.getStatus();
        int newValue = status.getValue() + 1;
        if (status.isUiValueInvert()) {
            newValue = status.getValue() - 1;
        }
        if (newValue > status.getRangeMax()) {
            newValue = status.getRangeMax();
        }
        if (newValue < status.getRangeMin()) {
            newValue = status.getRangeMin();
        }
        if (newValue != status.getValue()) {
            this._process.catchedValue(status, newValue, null);
        }
    }

    public void decriment() {
        MGStatus status = this.getStatus();
        int newValue = status.getValue() - 1;
        if (status.isUiValueInvert()) {
            newValue = status.getValue() + 1;
        }
        if (newValue > status.getRangeMax()) {
            newValue = status.getRangeMax();
        }
        if (newValue < status.getRangeMin()) {
            newValue = status.getRangeMin();
        }
        if (newValue != status.getValue()) {
            this._process.catchedValue(status, newValue, null);
        }
    }

    public void editContoller() {
        this._process._parent.enterEditMode(false);
        MGStatusConfig config = new MGStatusConfig(this._process, this.getStatus());
        MXUtil.showAsDialog(this, config, "Enter Edit Circle {row:" + this._row + ", column:" + this._column + "}");
        if (config._okOption) {
            this.setStatus(config._status);
            this.jLabel1.setText(config._status.getName());
            this._process.notifyCacheBroken();
            this.updateUI();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int d = e.getUnitsToScroll();
        if (d > 0) {
            this.decriment();
        } else {
            this.increment();
        }
    }
}

