/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.util.Comparator;
import java.util.TreeSet;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.mx30controller.MGStatus;

public class DoubleCheck {
    TreeSet<MGStatus> _alreadyStatus = new TreeSet<MGStatus>(new StatusComparator());
    TreeSet<MXMessage> _alreadyMessage = new TreeSet<MXMessage>(new MessageComparator());
    final MXReceiver _receiver;

    public DoubleCheck(MXReceiver receiver) {
        this._receiver = receiver;
    }

    public boolean checkAlready(MGStatus status) {
        return this._alreadyStatus.contains(status);
    }

    public void push(MGStatus status) {
        this._alreadyStatus.add(status);
    }

    public boolean sendOnlyNeed(MXMessage message) {
        if (message.getCommand() == 144 && message.getValue() == 0) {
            message = MXMessageFactory.fromClone(message);
            message.setStatus(128 + message.getChannel());
        }
        if (this._receiver == null) {
            return false;
        }
        if (this._alreadyMessage.contains(message)) {
            return false;
        }
        this._alreadyMessage.add(message);
        this._receiver.processMXMessage(message);
        return true;
    }

    static class StatusComparator
    implements Comparator<MGStatus> {
        StatusComparator() {
        }

        @Override
        public int compare(MGStatus o1, MGStatus o2) {
            int p = o1.getPort() - o2.getPort();
            if (p < 0) {
                return -1;
            }
            if (p > 0) {
                return 1;
            }
            int z = o1.getUiType() - o2.getUiType();
            if (z < 0) {
                return -1;
            }
            if (z > 0) {
                return 1;
            }
            int y = o1.getRow() - o2.getRow();
            if (y < 0) {
                return -1;
            }
            if (y > 0) {
                return 1;
            }
            int x = o1.getColumn() - o2.getColumn();
            if (x < 0) {
                return -1;
            }
            if (x > 0) {
                return 1;
            }
            return 0;
        }
    }

    static class MessageComparator
    implements Comparator<MXMessage> {
        MessageComparator() {
        }

        @Override
        public int compare(MXMessage o1, MXMessage o2) {
            if (o1.getExtype() != o2.getExtype()) {
                int x = o1.getExtype() - o2.getExtype();
                if (x < 0) {
                    return -1;
                }
                if (x > 0) {
                    return 1;
                }
            }
            switch (o1.getExtype()) {
                case 512: 
                case 768: 
                case 65280: {
                    return 0;
                }
            }
            byte[] t1 = o1.getDataBytes();
            byte[] t2 = o2.getDataBytes();
            int x = t1.length - t2.length;
            if (x < 0) {
                return -1;
            }
            if (x > 0) {
                return 1;
            }
            for (int i = 0; i < t1.length; ++i) {
                x = t1[i] - t2[i];
                if (x < 0) {
                    return -1;
                }
                if (x <= 0) continue;
                return 1;
            }
            return 0;
        }
    }
}

