/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx11vcurve;

import javax.swing.JPanel;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.mx11vcurve.MX11Data;
import jp.synthtarou.midimixer.mx11vcurve.MX11View;

public class MX11Process
extends MXReceiver {
    MX11Data _data = new MX11Data();
    MX11View _view = new MX11View(this);
    int _type;

    public MX11Data getData() {
        return this._data;
    }

    @Override
    public void processMXMessage(MXMessage message) {
        if (!this.isUsingThisRecipe()) {
            this.sendToNext(message);
            return;
        }
        if (message.getCommand() == 144) {
            int newVelocity;
            int port = message.getPort();
            int velocity = message.getVelocityFromBytes();
            if (velocity == (newVelocity = this._data.transform(port, velocity))) {
                this.sendToNext(message);
            } else {
                int channel = message.getChannel();
                int note = message.getNoteNumberFromBytes();
                MXMessage newMessage = MXMessageFactory.fromShortMessage(port, 144 + channel, note, newVelocity);
                this.sendToNext(newMessage);
            }
        } else {
            this.sendToNext(message);
        }
    }

    @Override
    public String getReceiverName() {
        return "Velocity Curve";
    }

    @Override
    public JPanel getReceiverView() {
        return this._view;
    }
}

