/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx10input;

import javax.swing.JComponent;
import javax.swing.JPanel;
import jp.synthtarou.midimixer.MXMidiLogger;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx10input.MX10Data;
import jp.synthtarou.midimixer.mx10input.MX10View;
import jp.synthtarou.midimixer.mx12masterkeys.MX12Process;
import jp.synthtarou.midimixer.mx20patchbay.MX20Process;

public class MX10Process
extends MXReceiver
implements MXSettingTarget {
    MX10Data _data = new MX10Data();
    MX10View _view;
    MX20Process _patchBay = new MX20Process(true);
    MX12Process _masterKey;
    MXMidiLogger _logger;
    MXSetting _setting;

    public MX10Process() {
        this._view = new MX10View(this);
        this._logger = new MXMidiLogger("In");
        this._view.setLogger(this._logger);
        this._setting = new MXSetting("InputSkip");
        this._setting.setTarget(this);
        this._patchBay.setNextReceiver(new MXReceiver(){

            @Override
            public String getReceiverName() {
                return "dummy";
            }

            @Override
            public JComponent getReceiverView() {
                return null;
            }

            @Override
            public void processMXMessage(MXMessage message) {
                if (MX10Process.this.isUsingThisRecipe() && MX10Process.this._data.isMessageToSkip(message)) {
                    return;
                }
                if (MX10Process.this.isUseLogging()) {
                    MX10Process.this._logger.processMXMessage(message);
                }
                MX10Process.this.sendToNext(message);
            }
        });
    }

    public void readSettings() {
        this._setting.readFile();
        this._patchBay.readSettings();
    }

    public void setMasterKeyProcess(MX12Process master) {
        this._masterKey = master;
    }

    public void setUseMesssageFilter(boolean log) {
        this.setUsingThisRecipe(log);
    }

    public boolean isUseMessageFilter() {
        return this.isUsingThisRecipe();
    }

    public void setUsePortFowarding(boolean pf) {
        this._patchBay.setUsingThisRecipe(pf);
    }

    public boolean isUsePortFowarding() {
        if (this._patchBay == null) {
            return true;
        }
        return this._patchBay.isUsingThisRecipe();
    }

    public void setUseLogging(boolean pf) {
        this._logger.setUsingThisRecipe(pf);
    }

    public boolean isUseLogging() {
        if (this._logger == null) {
            return true;
        }
        return this._logger.isUsingThisRecipe();
    }

    @Override
    public void processMXMessage(MXMessage message) {
        this._patchBay.processMXMessage(message);
    }

    @Override
    public String getReceiverName() {
        return "Input Receiver";
    }

    @Override
    public JPanel getReceiverView() {
        return this._view;
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        String prefix = "Setting[].";
        for (String text : MX10Data.typeNames) {
            setting.register(prefix + text);
        }
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        block0: for (int port = 0; port < 16; ++port) {
            String prefix = "Setting[" + port + "].";
            StringBuffer str = new StringBuffer();
            int j = 0;
            while (true) {
                MX10Process mX10Process = this;
                if (j >= mX10Process._data.countOfTypes()) continue block0;
                String name = MX10Data.typeNames[j];
                boolean set = setting.getSettingAsBoolean(prefix + name, false);
                this._data.setSkip(port, j, set);
                ++j;
            }
        }
        this._view.resetTableModel();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        block0: for (int port = 0; port < 16; ++port) {
            String prefix = "Setting[" + port + "].";
            StringBuffer str = new StringBuffer();
            int j = 0;
            while (true) {
                MX10Process mX10Process = this;
                if (j >= mX10Process._data.countOfTypes()) continue block0;
                boolean set = this._data.isSkip(port, j);
                String name = MX10Data.typeNames[j];
                setting.setSetting(prefix + name, set);
                ++j;
            }
        }
    }
}

