/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import jp.synthtarou.midimixer.libs.swing.MXFocusAble;
import jp.synthtarou.midimixer.libs.swing.MXFocusGroup;

public class MXFocusGroupElement {
    MXFocusGroup _group;
    Component _root;
    LinkedList<Component> _element;
    Listen _listenerObject;
    static MXFocusGroup _lock = null;
    static MXFocusGroup _lockNew = null;

    MXFocusGroupElement(MXFocusGroup group, Component root) {
        this._group = group;
        this._root = root;
        this._element = new LinkedList();
        this._listenerObject = new Listen();
        this.installAllRecursible(this._root);
    }

    boolean checkMouseInTarget() {
        Point p1 = MouseInfo.getPointerInfo().getLocation();
        Component c = this._root;
        try {
            Point p2 = c.getLocationOnScreen();
            Point p3 = new Point(p2.x + c.getWidth(), p2.y + c.getHeight());
            if (p1.x >= p2.x && p1.y >= p2.y && p1.x < p3.x && p1.x < p3.x) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public synchronized void uninstallAll() {
        for (Component c : this._element) {
            c.removeMouseListener(this._listenerObject);
            c.removeMouseMotionListener(this._listenerObject);
        }
        this._element.clear();
    }

    public synchronized void installAllRecursible(Component c) {
        this._element.add(c);
        c.addMouseListener(this._listenerObject);
        c.addMouseMotionListener(this._listenerObject);
        if (c instanceof Container) {
            Container ct = (Container)c;
            Component[] child = ct.getComponents();
            for (int i = 0; i < child.length; ++i) {
                this.installAllRecursible(child[i]);
            }
        }
    }

    public class Listen
    implements MouseListener,
    MouseMotionListener {
        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            _lock = MXFocusGroupElement.this._group;
            if (!MXFocusGroupElement.this._group._checkEnable) {
                return;
            }
            if (MXFocusGroupElement.this._root.isEnabled()) {
                MXFocusGroupElement.this._group.comingFocus(MXFocusGroupElement.this._root);
                ((MXFocusAble)((Object)MXFocusGroupElement.this._root)).focusedMousePressed(e);
                ((MXFocusAble)((Object)MXFocusGroupElement.this._root)).focusChangingValue();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            _lock = null;
            if (MXFocusGroupElement.this._root.isEnabled()) {
                // empty if block
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            _lockNew = MXFocusGroupElement.this._group;
            if (_lock != null) {
                return;
            }
            if (!MXFocusGroupElement.this._group._checkEnable) {
                return;
            }
            if (MXFocusGroupElement.this._root.isEnabled()) {
                MXFocusGroupElement.this._group.comingFocus(MXFocusGroupElement.this._root);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (_lock != null) {
                return;
            }
            if (!MXFocusGroupElement.this._group._checkEnable) {
                return;
            }
            if (MXFocusGroupElement.this._root.isEnabled()) {
                _lockNew.doDoubleCheck();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (_lock != null && MXFocusGroupElement.this._root.isEnabled()) {
                ((MXFocusAble)((Object)MXFocusGroupElement.this._root)).focusChangingValue();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (_lock != null && MXFocusGroupElement.this._root.isEnabled()) {
                ((MXFocusAble)((Object)MXFocusGroupElement.this._root)).focusChangingValue();
            }
        }
    }
}

