/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.settings;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXLineReader;
import jp.synthtarou.midimixer.libs.MXLineWriter;
import jp.synthtarou.midimixer.libs.settings.MXSettingException;
import jp.synthtarou.midimixer.libs.settings.MXSettingNode;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.libs.settings.MXSettingUtil;
import jp.synthtarou.midimixer.libs.settings.Path;

public class MXSetting {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXSetting.class);
    protected File _settingFile;
    static ArrayList<MXSetting> everySetting = new ArrayList();
    private MXSettingTarget _target = null;
    private String _targetName;
    MXSettingNode _root = new MXSettingNode(this, null, null);
    protected TreeSet<Path> _registered;
    protected Comparator comparatorForRegister = new Comparator(){

        public int compare(Object o1, Object o2) {
            Path p1 = (Path)o1;
            Path p2 = (Path)o2;
            int length = Math.min(p1.size(), p2.size());
            for (int x = 0; x < length; ++x) {
                int d;
                String str1 = (String)p1.get(x);
                String str2 = (String)p2.get(x);
                if (MXSettingUtil.isInteger(str1)) {
                    str1 = "0";
                }
                if (MXSettingUtil.isInteger(str2)) {
                    str2 = "0";
                }
                if ((d = str1.compareTo(str2)) == 0) continue;
                return d;
            }
            if (p1.size() < p2.size()) {
                return -1;
            }
            if (p1.size() > p2.size()) {
                return 1;
            }
            return 0;
        }
    };

    public static void main(String[] args) {
        MXDebugConsole.globalSwitchOn();
        MXSetting root = new MXSetting("test");
        root.register("base.attribute");
        root.register("base.attribute[].text");
        root.register("base[b]");
        root.register("base[1]");
        root.register("base.[].position");
        root.setSetting("base", "123");
        root.setSetting("base.attribute[1].text", "a1");
        root.setSetting("base.attribute[2].text", "a2");
        root.setSetting("base.attribute[3].text", "a3");
        root.setSetting("base[12].position", "12");
        root.setSetting("base.[13].position", "13");
        root.setSetting("base[14]position", "14");
        try {
            root.dump(new OutputStreamWriter(System.out));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this._settingFile;
    }

    public MXSetting(File file) {
        this(file, true);
    }

    public MXSetting(File file, boolean addToEvery) {
        this._settingFile = file;
        this._registered = new TreeSet(this.comparatorForRegister);
        if (addToEvery) {
            everySetting.add(this);
        }
    }

    public MXSetting(String name) {
        this(new File(MXSettingUtil.getSettingDirectory(), name + ".ini"));
    }

    public static void saveEverySettingToFile() {
        for (MXSetting setting : everySetting) {
            try {
                setting.writeToFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setTarget(MXSettingTarget target) {
        if (target == null) {
            throw new NullPointerException();
        }
        this._target = target;
        this._target.prepareSettingFields(this);
        this._targetName = MXSetting.getClassName(this._target.getClass());
    }

    public static String getClassName(Class cls) {
        int x;
        String name = cls.getName();
        if (name != null && (x = name.lastIndexOf(46)) >= 0) {
            name = name.substring(x + 1);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFile() {
        if (this._registered.size() == 0) {
            return false;
        }
        InputStream fin = null;
        try {
            String line;
            this._root.clearValues();
            fin = new FileInputStream(this._settingFile);
            _debug.println("reading " + this._settingFile + " = " + this._targetName);
            MXLineReader reader = new MXLineReader(fin, "utf-8");
            while ((line = reader.readLine()) != null) {
                int index;
                char first;
                if (line.length() == 0 || (first = line.charAt(0)) == '#' || first == '/' || (index = line.indexOf(61)) < 0) continue;
                String key = line.substring(0, index);
                String value = line.substring(index + 1);
                this._root.setSetting(key, value);
            }
        }
        catch (FileNotFoundException e) {
            _debug.println("First Time for [" + this._settingFile + "]");
        }
        catch (MXSettingException e) {
            _debug.printStackTrace(e);
        }
        catch (IOException e) {
            _debug.printStackTrace(e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this._target != null) {
            this._target.afterReadSettingFile(this);
        }
        return true;
    }

    public boolean writeToFile() {
        if (this._target != null) {
            this._root.clearValues();
            this._target.beforeWriteSettingFile(this);
        }
        File temporary = MXSettingUtil.createTemporaryFile(this._settingFile);
        MXLineWriter writer = null;
        _debug.println("writing " + this._settingFile + " = " + this._targetName);
        try {
            writer = new MXLineWriter(temporary, "utf-8");
            this.dump(writer.getWriter());
            writer.close();
            File backup = MXSettingUtil.autobackupFile(this._settingFile);
            temporary.renameTo(this._settingFile);
            if (backup != null) {
                if (MXSettingUtil.isSameFile(backup, this._settingFile)) {
                    try {
                        backup.delete();
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        Desktop.getDesktop().moveToTrash(backup);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (IOException ioe) {
            _debug.printStackTrace(ioe);
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    _debug.printStackTrace(e);
                }
                temporary.delete();
            }
            return false;
        }
        return true;
    }

    public void clearValue() {
        this._root.clearValues();
    }

    public String getSetting(String name) {
        return this._root.getSetting(name);
    }

    public int getSettingAsInt(String name, int defvalue) {
        return this._root.getSettingAsInt(name, defvalue);
    }

    public boolean getSettingAsBoolean(String name, boolean defvalue) {
        return this._root.getSettingAsBoolean(name, defvalue);
    }

    public boolean setSetting(String name, String value) {
        try {
            return this._root.setSetting(name, value);
        }
        catch (MXSettingException e) {
            _debug.printStackTrace(e);
            return false;
        }
    }

    public boolean isEmpty() {
        return this._root.isEmpty();
    }

    public boolean setSetting(String name, int value) {
        return this.setSetting(name, String.valueOf(value));
    }

    public boolean setSetting(String name, boolean value) {
        if (value) {
            return this.setSetting(name, "1");
        }
        return this.setSetting(name, "0");
    }

    public boolean havingName(String name) {
        return this._root.childByKey(name) != null;
    }

    public void dump(Writer writer) throws IOException {
        this._root.recuesiveDump(writer);
        writer.flush();
    }

    public void register(String name) {
        try {
            Path p = this._root.getPath().clone();
            p.addAll(Path.parsePath(name));
            this.register(p);
        }
        catch (MXSettingException e) {
            _debug.println("Can't regist " + name + " for " + this.getFile());
        }
    }

    public void register(Path path) {
        this._registered.add(path);
    }

    public boolean isRegistered(String name) {
        Path p = this._root.getPath().clone();
        try {
            p.addAll(Path.parsePath(name));
            return this.isRegistered(p);
        }
        catch (MXSettingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isRegistered(Path path) {
        return this._registered.contains(path);
    }

    public ArrayList<MXSettingNode> findByPath(String name) {
        Path path = null;
        try {
            path = Path.parsePath(name);
        }
        catch (MXSettingException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<MXSettingNode> seeking = new ArrayList<MXSettingNode>();
        seeking.add(this._root);
        for (String text : path) {
            ArrayList<MXSettingNode> hit = new ArrayList<MXSettingNode>();
            boolean isInteger = MXSettingUtil.isInteger(text);
            for (MXSettingNode parent : seeking) {
                int count = parent.size();
                for (int x = 0; x < count; ++x) {
                    MXSettingNode child = parent.childByIndex(x);
                    if (isInteger) {
                        if (!child.isInteger()) continue;
                        hit.add(child);
                        continue;
                    }
                    if (!child.getName().equalsIgnoreCase(text)) continue;
                    hit.add(child);
                }
            }
            seeking = hit;
        }
        return seeking;
    }

    protected static class DetailArray {
        ArrayList<Detail> list = new ArrayList();

        protected DetailArray() {
        }
    }

    protected static class Detail {
        String key;
        String value;

        protected Detail() {
        }
    }
}

