/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;

public class SMFMessage
implements Comparable<SMFMessage> {
    long _tick;
    private int _seqTrack;
    private int _order;
    private int _status;
    private int _data1;
    private int _data2;
    private byte[] _binary;
    private int _dataType;

    public int getDataType() {
        return this._dataType;
    }

    public void setDataType(int dataType) {
        this._dataType = dataType;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int _status) {
        this._status = _status;
    }

    public int getData1() {
        return this._data1;
    }

    public void setData1(int data) {
        this._data1 = data;
    }

    public int getData2() {
        return this._data2;
    }

    public void setData2(int data2) {
        this._data2 = data2;
    }

    public byte[] getBinary() {
        if (this._binary != null) {
            byte[] binary = this._binary;
            return (byte[])this._binary.clone();
        }
        return null;
    }

    public void setBinary(byte[] binary) {
        this._binary = (byte[])binary.clone();
        if (binary.length >= 3 && binary[0] == 0) {
            new Throwable(MXUtil.dumpHexFF(binary)).printStackTrace();
        }
    }

    public long getTick() {
        return this._tick;
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public int getSeqTrack() {
        return this._seqTrack;
    }

    public void setSeqTrack(int _seqTrack) {
        this._seqTrack = _seqTrack;
    }

    public SMFMessage(long tick, int status, int data1, int data2) {
        this._tick = tick;
        this._status = status;
        this._data1 = data1;
        this._data2 = data2;
        this._binary = null;
    }

    public SMFMessage(long tick, int status, int dataType, byte[] binary) {
        this._tick = tick;
        this._status = status;
        this._dataType = dataType;
        this._data1 = 0;
        this._data2 = 0;
        this._binary = binary;
    }

    public String toString() {
        byte[] data = this.getBinary();
        if (data != null) {
            data = (byte[])data.clone();
            if (this.getStatus() == 255) {
                String meta = "";
                try {
                    meta = SMFMessage.dumpHexFF(data);
                    meta = new String(data, "ISO-8859-1");
                    meta = new String(data, "Shift_JIS");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return meta;
            }
            return SMFMessage.toHexFF(this.getStatus()) + " -> " + SMFMessage.dumpHexFF(data);
        }
        return SMFMessage.toHexFF(this.getStatus()) + ", " + SMFMessage.toHexFF(this.getData1()) + ", " + SMFMessage.toHexFF(this.getData2());
    }

    public static String toHexFF(int i) {
        String str = Integer.toHexString(i).toUpperCase();
        if (str.length() == 1) {
            return "0" + str;
        }
        if (str.length() >= 3) {
            return str.substring(str.length() - 2, str.length());
        }
        return str;
    }

    public static String dumpHexFF(byte[] data) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                str.append(" ");
            }
            str.append(SMFMessage.toHexFF(data[i]));
        }
        return str.toString();
    }

    public MXMessage toMXMessage() {
        MXMessage message = null;
        if (this.getStatus() >= 128 && this.getStatus() <= 239) {
            message = MXMessageFactory.fromShortMessage(0, this.getStatus(), this.getData1(), this.getData2());
        } else if (this.getStatus() == 240 && this.getStatus() == 247) {
            message = MXMessageFactory.fromSysexMessage(0, this.getStatus(), this.getBinary());
        } else if (this.getStatus() == 255) {
            message = MXMessageFactory.fromMeta(0, this.getData1(), this.getBinary());
        }
        return message;
    }

    @Override
    public int compareTo(SMFMessage o) {
        boolean isBank2;
        SMFMessage o1 = this;
        SMFMessage o2 = o;
        long x = o1._tick - o2._tick;
        if (x < 0L) {
            return -1;
        }
        if (x > 0L) {
            return 1;
        }
        long z = o1._seqTrack - o2._seqTrack;
        if (z < 0L) {
            return -1;
        }
        if (z > 0L) {
            return 1;
        }
        long y = o1._order - o2._order;
        if (y < 0L) {
            return -1;
        }
        if (y > 0L) {
            return 1;
        }
        boolean isProg1 = (o1.getStatus() & 0xF0) == 192;
        boolean isProg2 = (o2.getStatus() & 0xF0) == 192;
        boolean isBank1 = (o1.getStatus() & 0xF0) == 176 && (o1.getData1() == 0 || o1.getData1() == 32);
        boolean bl = isBank2 = (o2.getStatus() & 0xF0) == 176 && (o2.getData1() == 0 || o2.getData1() == 32);
        if (isBank1 && !isBank2) {
            return -1;
        }
        if (!isBank1 && isBank2) {
            return 1;
        }
        if (isProg1 && !isProg2) {
            return -1;
        }
        if (!isProg1 && isProg2) {
            return 1;
        }
        x = o1.getStatus() - o2.getStatus();
        if (x < 0L) {
            return -1;
        }
        if (x > 0L) {
            return 1;
        }
        x = o1.getData1() - o2.getData1();
        if (x < 0L) {
            return -1;
        }
        if (x > 0L) {
            return 1;
        }
        x = o1.getData2() - o2.getData2();
        if (x < 0L) {
            return -1;
        }
        if (x > 0L) {
            return 1;
        }
        if (o1.getBinary() != null || o2.getBinary() != null) {
            if (o2.getBinary() == null) {
                return -1;
            }
            if (o1.getBinary() == null) {
                return 1;
            }
            int len = o1.getBinary().length - o2.getBinary().length;
            if (len != 0) {
                return len;
            }
            for (int i = 0; i < o1.getBinary().length; ++i) {
                x = o1.getBinary()[i] - o2.getBinary()[i];
                if (x < 0L) {
                    return -1;
                }
                if (x <= 0L) continue;
                return 1;
            }
        }
        return 0;
    }

    public int getMetaTempo() {
        int b1 = (0xFF & this._binary[0]) << 16;
        int b2 = (0xFF & this._binary[1]) << 8;
        int b3 = 0xFF & this._binary[2];
        return b1 + b2 + b3;
    }

    public boolean isMetaMessage() {
        return this._status == 255;
    }

    public MidiMessage toJavaMessage() throws InvalidMidiDataException {
        if (this._status == 255) {
            return new MetaMessage(this.getDataType(), this._binary, this._binary.length);
        }
        if (this._status == 240 || this._status == 247) {
            return new SysexMessage(this._status, this._binary, this._binary.length);
        }
        return new ShortMessage(this._status, this._data1, this._data2);
    }
}

