/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import java.io.IOException;
import java.io.InputStream;

public class ByteReader {
    InputStream _input;
    byte[] _buffer = new byte[4096];
    int _pos = 0;
    int _length = -1;
    boolean _eof = false;
    boolean _error = false;

    public ByteReader(InputStream input) {
        this._input = input;
        this._length = -1;
        this._pos = 0;
    }

    public int read8() {
        if (this._pos >= this._length) {
            try {
                this._pos = 0;
                this._length = this._input.read(this._buffer);
            }
            catch (IOException e) {
                this._eof = true;
                this._error = true;
                return -1;
            }
            if (this._length == 0) {
                this._eof = true;
                return -1;
            }
        }
        if (this._pos < this._length) {
            return this._buffer[this._pos++] & 0xFF;
        }
        return -1;
    }

    public int read14() {
        int x = this.read8();
        int y = this.read8();
        if (x < 0 || y < 0) {
            return -1;
        }
        return (x &= 0x7F) << 7 | (y &= 0x7F);
    }

    public int read16() {
        int x = this.read8();
        int y = this.read8();
        if (x < 0 || y < 0) {
            return -1;
        }
        return x << 8 | y;
    }

    public int read32() {
        int x = this.read8();
        int y = this.read8();
        int z = this.read8();
        int a = this.read8();
        if (x < 0 || y < 0 || z < 0 || a < 0) {
            return -1;
        }
        return (x <<= 24) + (y <<= 16) + (z <<= 8) + a;
    }

    public int readBuffer(byte[] data, int length) {
        for (int i = 0; i < length; ++i) {
            int x = this.read8();
            if (x < 0) {
                return i;
            }
            data[i] = (byte)x;
        }
        return length;
    }

    public long readVariable() {
        long value = 0L;
        int currentByte = 0;
        do {
            if ((currentByte = this.read8()) < 0) {
                return -1L;
            }
            value = (value << 7) + (long)(currentByte & 0x7F);
        } while ((currentByte & 0x80) != 0);
        return value;
    }

    public void skip(int length) {
        this._pos += length;
    }
}

