/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.io.File;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MultiThreadQueue;
import jp.synthtarou.midimixer.libs.domino.DTextXML;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOutManager;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant16;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFileManager;
import jp.synthtarou.midimixer.libs.midi.recorder.MIDIRecorder;
import org.xml.sax.SAXException;

public class MXMIDIOut {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXMIDIOut.class);
    public static final MXMIDIOut OUTPUT_NONE = new MXMIDIOut("none", null);
    private MidiDevice _device;
    private String _name;
    private boolean _isopen = false;
    int _assigned;
    private File _DXMLFile;
    private MXVisitant16 _visitant16 = new MXVisitant16();
    Receiver _receiver;
    Thread _thread;
    MultiThreadQueue<MXMessage> _queue;

    protected MXMIDIOut(String name, MidiDevice device) {
        this(name, device, null);
        this._assigned = -1;
    }

    public int assignedPort() {
        return this._assigned;
    }

    public boolean isOpen() {
        return this._isopen;
    }

    protected MXMIDIOut(String name, MidiDevice device, Receiver receiver) {
        this._device = device;
        this._receiver = receiver;
        this._name = name;
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public File getDXMLFile() {
        return this._DXMLFile;
    }

    public void setDXMLFile(File file) throws SAXException {
        try {
            PDFileManager manager = PDFileManager.getManager();
            if (this._DXMLFile != null) {
                manager.unregist(this._DXMLFile.getName());
            }
            DTextXML parser = DTextXML.fromFile(file);
            this._DXMLFile = file;
            manager.register(parser);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        MXMIDIOut out = (MXMIDIOut)o;
        return out._name == this._name;
    }

    public String toString() {
        return this._name;
    }

    public long getTimestamp() {
        try {
            return this._device.getMicrosecondPosition();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public void processMidiOut(MXMessage message) {
        boolean _needDebugTrace = true;
        try {
            this.processMidiOutInternal(message);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processMidiOutInternal(MXMessage message) {
        if (this._receiver == null || !this._isopen || this._assigned < 0) {
            return;
        }
        try {
            if (MXVisitant.isMesssageHaveVisitant(message)) {
                this._visitant16.get(message.getChannel()).updateChannelVisitant(message);
            }
            long timeStamp = this.getTimestamp();
            long recTime = 0L;
            MIDIRecorder recorder = MIDIRecorder.getInstance();
            if (recorder.getPort() != this._assigned) {
                recorder = null;
            } else if (!recorder.isRecording()) {
                recorder = null;
            }
            Receiver recReceiver = null;
            if (recorder != null) {
                recReceiver = recorder.getReceiver();
                recTime = recorder.tickLength();
            }
            if (message.isMessageTypeChannel()) {
                MXMessage newMessage;
                MXVisitant msgVisitant = message.getVisitant();
                MXVisitant visitant = this._visitant16.get(message.getChannel());
                int command = message.getCommand();
                int channel = message.getChannel();
                int gate = message.getGate();
                if (command != 192 && msgVisitant != null && msgVisitant.isHavingProgram() && (!visitant.isHavingProgram() || visitant.getProgram() != message.getVisitant().getProgram())) {
                    visitant.mergeNew(message.getVisitant());
                    newMessage = MXMessageFactory.fromShortMessage(this._assigned, 192 + channel, visitant.getProgram(), 0);
                    newMessage.setVisitant(visitant.getSnapShot());
                    this.processMidiOutInternal(newMessage);
                }
                if ((command != 176 || gate != 0 && gate != 32) && msgVisitant != null && msgVisitant.isHavingBank() && (!visitant.isHavingBank() || visitant.getBankMSB() != msgVisitant.getBankMSB() || visitant.getBankLSB() != msgVisitant.getBankLSB())) {
                    visitant.mergeNew(message.getVisitant());
                    MXMessage newMessage1 = MXMessageFactory.fromShortMessage(this._assigned, 176 + channel, 0, visitant._bankMSB);
                    MXMessage newMessage2 = MXMessageFactory.fromShortMessage(this._assigned, 176 + channel, 32, visitant._bankLSB);
                    this.processMidiOutInternal(newMessage1);
                    this.processMidiOutInternal(newMessage2);
                }
                if (!(command == 176 && gate == 7 || msgVisitant == null || !msgVisitant.isHavingVolume() || visitant.isHavingVolume() && visitant.getInfoVolume() == msgVisitant.getInfoVolume())) {
                    visitant.mergeNew(message.getVisitant());
                    newMessage = MXMessageFactory.fromShortMessage(this._assigned, 176 + channel, 7, visitant.getInfoVolume());
                    this.processMidiOutInternal(newMessage);
                }
                if (!(command == 176 && gate == 11 || msgVisitant == null || !msgVisitant.isHavingExpression() || visitant.isHavingExpression() && visitant.getInfoExpression() == msgVisitant.getInfoExpression())) {
                    visitant.mergeNew(message.getVisitant());
                    newMessage = MXMessageFactory.fromShortMessage(this._assigned, 176 + channel, 11, visitant.getInfoExpression());
                    this.processMidiOutInternal(newMessage);
                }
                if (!(command == 176 && gate == 10 || msgVisitant == null || !msgVisitant.isHavingExpression() || visitant.isHavingPan() && visitant.getInfoPan() == msgVisitant.getInfoPan())) {
                    visitant.mergeNew(message.getVisitant());
                    newMessage = MXMessageFactory.fromShortMessage(this._assigned, 176 + channel, 10, visitant.getInfoPan());
                    this.processMidiOutInternal(newMessage);
                }
            }
            switch (message.getExtype()) {
                case 1024: {
                    MidiMessage msg;
                    try {
                        msg = MXMessageFactory.toJavaMessage(message);
                        this._receiver.send(msg, timeStamp);
                        if (recReceiver == null) return;
                        recReceiver.send(msg, recTime);
                        return;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    return;
                }
                case 1280: {
                    MidiMessage msg;
                    try {
                        msg = MXMessageFactory.toJavaMessage(message);
                        this._receiver.send(msg, timeStamp);
                        if (recReceiver == null) return;
                        recReceiver.send(msg, recTime);
                        return;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    return;
                }
                case 256: {
                    if (message.isMessageTypeDataentry()) {
                        MidiMessage msg1 = MXMessageFactory.toJavaDataroomMSB1(message);
                        MidiMessage msg2 = MXMessageFactory.toJavaDataroomLSB2(message);
                        MidiMessage data1 = MXMessageFactory.toJavaDatavalueMSB1(message);
                        MidiMessage data2 = MXMessageFactory.toJavaDatavalueLSB2(message);
                        Class<MXMIDIOut> clazz = MXMIDIOut.class;
                        synchronized (MXMIDIOut.class) {
                            if (msg1 == null || msg2 == null) return;
                            this._receiver.send(msg1, timeStamp);
                            this._receiver.send(msg2, timeStamp);
                            if (recReceiver != null) {
                                recReceiver.send(msg1, recTime);
                                recReceiver.send(msg2, recTime);
                            }
                            this._receiver.send(data1, timeStamp);
                            if (recReceiver != null) {
                                recReceiver.send(data1, recTime);
                            }
                            if (data2 == null) return;
                            this._receiver.send(data2, timeStamp);
                            if (recReceiver == null) return;
                            recReceiver.send(data2, recTime);
                            // ** MonitorExit[var12_17] (shouldn't be in output)
                            return;
                        }
                    }
                    if (message.getCommand() == 176 && message.isValue14bit()) {
                        ShortMessage data1 = new ShortMessage(176 + message.getChannel(), message.getGate(), message.getValue() >> 7 & 0x7F);
                        ShortMessage data2 = new ShortMessage(176 + message.getChannel(), message.getGate() + 32, message.getValue() & 0x7F);
                        Class<MXMIDIOut> clazz = MXMIDIOut.class;
                        synchronized (MXMIDIOut.class) {
                            this._receiver.send(data1, timeStamp);
                            this._receiver.send(data2, timeStamp);
                            if (recReceiver == null) return;
                            recReceiver.send(data1, recTime);
                            recReceiver.send(data2, recTime);
                            // ** MonitorExit[var10_13] (shouldn't be in output)
                            return;
                        }
                    }
                    MidiMessage msg = MXMessageFactory.toJavaMessage(message);
                    if (msg != null) {
                        Class<MXMIDIOut> clazz = MXMIDIOut.class;
                        synchronized (MXMIDIOut.class) {
                            this._receiver.send(msg, timeStamp);
                            if (recReceiver == null) return;
                            recReceiver.send(msg, recTime);
                            // ** MonitorExit[var9_10] (shouldn't be in output)
                            return;
                        }
                    }
                    System.out.println("Error " + message);
                    return;
                }
                case 1536: {
                    return;
                }
                default: {
                    System.out.println("Can't proc " + message);
                }
            }
            return;
        }
        catch (Throwable e) {
            _debug.printStackTrace(e);
        }
    }

    public void allNoteOff() {
        for (int ch = 0; ch < 16; ++ch) {
            try {
                MXMessage msg = MXMessageFactory.fromShortMessage(this._assigned, 176 + ch, 123, 127);
                this.processMidiOutInternal(msg);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        MXMIDIOutManager manager;
        MXMIDIOutManager mXMIDIOutManager = manager = MXMIDIOutManager.getManager();
        synchronized (mXMIDIOutManager) {
            manager.clearMIDIOutCache();
            if (this._assigned < 0) {
                return false;
            }
            if (this._isopen) {
                return true;
            }
            this._visitant16 = new MXVisitant16();
            if (this._receiver == null && this._device != null) {
                this._receiver = null;
                try {
                    if (!this._device.isOpen()) {
                        this._device.open();
                    }
                    this._receiver = this._device.getReceiver();
                }
                catch (MidiUnavailableException e) {
                    this._device.close();
                    return false;
                }
                this._isopen = true;
                if (this._thread == null) {
                    this._thread = new Thread(){

                        @Override
                        public void run() {
                            MXMessage message;
                            while ((message = MXMIDIOut.this._queue.pop()) != null) {
                                try {
                                    MXMIDIOut.this.processMidiOutInternal(message);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    };
                    this._queue = new MultiThreadQueue();
                    this._thread.setPriority(10);
                    this._thread.start();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MXMIDIOutManager manager;
        MXMIDIOutManager mXMIDIOutManager = manager = MXMIDIOutManager.getManager();
        synchronized (mXMIDIOutManager) {
            if (this._isopen) {
                this.allNoteOff();
                manager.onClose(this);
                this._isopen = false;
                if (!this._name.equals("Gervill") && this._device != null) {
                    this._device.close();
                }
                this._receiver = null;
            }
        }
    }
}

