/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;

public class MXNoteOffWatcher {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXNoteOffWatcher.class);
    private LinkedList<Element> _list = new LinkedList();
    Handler _lastHandler;

    public String toString() {
        return "(MXNoteOff + " + this._list.size();
    }

    public synchronized boolean addListener(MXMessage noteOn, MXMessage noteOff, Handler listener) {
        return this.addListener(noteOn, noteOff, listener, null);
    }

    public synchronized boolean addListener(MXMessage noteOn, MXMessage noteOff, Handler listener, String dolog) {
        if (noteOn.getCommand() != 144) {
            _debug.println("Its not note on " + noteOn);
            return false;
        }
        this._lastHandler = listener;
        Element e = new Element();
        e.caughtNoteOn = noteOn;
        if (noteOff.getCommand() == 144) {
            noteOff = MXMessageFactory.fromClone(noteOff);
            noteOff.setStatus(128 + noteOff.getChannel());
            noteOff.setValue(0);
        }
        e.sendingNoteOff = noteOff;
        e.listener = listener;
        this._list.add(e);
        return true;
    }

    public synchronized void allNoteOff() {
        ArrayList<Element> list = new ArrayList<Element>(this._list);
        this._list.clear();
        for (Element e : list) {
            e.listener.onNoteOffEvent(e.sendingNoteOff);
        }
    }

    public synchronized boolean notifyNoteOffEvent(int port, int ch, int note) {
        return this.notifyNoteOffEvent(port, ch, note, null);
    }

    public synchronized boolean notifyNoteOffEvent(int port, int ch, int note, String dolog) {
        boolean proc = false;
        boolean saveProc = false;
        do {
            proc = false;
            Iterator it = this._list.iterator();
            while (it.hasNext()) {
                Element e = (Element)it.next();
                if (e.caughtNoteOn.getPort() != port || e.caughtNoteOn.getChannel() != ch || e.caughtNoteOn.getNoteNumberFromBytes() != note) continue;
                e.listener.onNoteOffEvent(e.sendingNoteOff);
                it.remove();
                proc = true;
            }
            if (!proc) continue;
            saveProc = true;
        } while (proc);
        return saveProc;
    }

    public static interface Handler {
        public void onNoteOffEvent(MXMessage var1);
    }

    private static class Element {
        MXMessage caughtNoteOn;
        MXMessage sendingNoteOff;
        Handler listener;

        private Element() {
        }
    }
}

