/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;

public class MXMessageFactory {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXMessageFactory.class);

    public static MXMessage createDummy() {
        return new MXMessage();
    }

    public static MXMessage fromClone(MXMessage old) {
        if (old == null) {
            return MXMessageFactory.createDummy();
        }
        MXMessage message = new MXMessage();
        message.setExtype(old.getExtype());
        message._port = old._port;
        message._template = (int[])old._template.clone();
        message._dataBytesReady = false;
        message._checksumLength = old._checksumLength;
        message.setValue(old.getValue());
        message.setGate(old.getGate());
        message.setChannel(old.getChannel());
        message.setVisitant(old.getVisitant());
        message.setValue14bit(old.isValue14bit());
        return message;
    }

    public static MXMessage fromJavaMessage(int port, MidiMessage message) {
        if (message instanceof ShortMessage) {
            ShortMessage msg = (ShortMessage)message;
            return MXMessageFactory.fromShortMessage(port, msg.getStatus(), msg.getData1(), msg.getData2());
        }
        if (message instanceof SysexMessage) {
            MXMessage m = new MXMessage();
            m._port = port;
            byte[] data = ((SysexMessage)message).getData();
            int status = ((SysexMessage)message).getStatus();
            int[] template = new int[data.length + 1];
            template[0] = status;
            for (int i = 0; i < data.length; ++i) {
                template[i + 1] = data[i] & 0xFF;
            }
            m._template = template;
            if (status == 240) {
                m.setExtype(1024);
            } else if (status == 247) {
                m.setExtype(1280);
            } else {
                _debug.println("Can't inport message " + message.getClass());
            }
            return m;
        }
        if (message instanceof MetaMessage) {
            MetaMessage meta = (MetaMessage)message;
            return MXMessageFactory.fromMeta(port, meta.getType(), meta.getData());
        }
        _debug.println("Unknown " + message.getClass());
        return null;
    }

    public static MXMessage fromMeta(int port, int metaType, byte[] data) {
        MXMessage message = new MXMessage();
        message._port = port;
        message.setExtype(1536);
        message.setMetaType(metaType);
        String text = null;
        try {
            text = new String(data, "ASCII");
            text = new String(data);
            text = new String(data, "SJIS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        message._metaText = text;
        message._dataBytes = data;
        return message;
    }

    public static MXMessage fromProgramInc(int port, int channel) {
        MXMessage message = new MXMessage();
        message._port = port;
        message.setChannel(channel);
        message.setExtype(512);
        return message;
    }

    public static MXMessage fromProgramDec(int port, int channel) {
        MXMessage message = new MXMessage();
        message._port = port;
        message.setChannel(channel);
        message.setExtype(768);
        return message;
    }

    public static MXMessage fromSysexMessage(int port, int status, byte[] data) {
        MXMessage message = new MXMessage();
        message._port = port;
        int[] template = new int[data.length + 1];
        template[0] = status & 0xFF;
        for (int i = 0; i < data.length; ++i) {
            template[i + 1] = data[i] & 0xFF;
        }
        if (status == 240) {
            message.setExtype(1024);
        } else {
            message.setExtype(1280);
        }
        message._template = template;
        return message;
    }

    public static MidiMessage toJavaDataroomMSB1(MXMessage msg) throws InvalidMidiDataException {
        if (msg.getCommand() == 176 && msg.getGate() == 6) {
            if (msg.getVisitant().isHaveDataentryRPN()) {
                return new ShortMessage(176 + msg.getChannel(), 101, msg.getVisitant().getDataroomMSB());
            }
            if (msg.getVisitant().isHaveDataentryNRPN()) {
                return new ShortMessage(176 + msg.getChannel(), 99, msg.getVisitant().getDataroomMSB());
            }
        }
        return null;
    }

    public static MidiMessage toJavaDataroomLSB2(MXMessage msg) throws InvalidMidiDataException {
        if (msg.getCommand() == 176 && msg.getGate() == 6) {
            if (msg.getVisitant().isHaveDataentryRPN()) {
                return new ShortMessage(176 + msg.getChannel(), 100, msg.getVisitant().getDataroomLSB());
            }
            if (msg.getVisitant().isHaveDataentryNRPN()) {
                return new ShortMessage(176 + msg.getChannel(), 98, msg.getVisitant().getDataroomLSB());
            }
        }
        return null;
    }

    public static MidiMessage toJavaDatavalueMSB1(MXMessage msg) throws InvalidMidiDataException {
        if (msg.getCommand() == 176 && msg.getGate() == 6 && (msg.getVisitant().isHaveDataentryRPN() || msg.getVisitant().isHaveDataentryNRPN())) {
            return new ShortMessage(176 + msg.getChannel(), 6, msg.getVisitant().getDataentryMSB());
        }
        return null;
    }

    public static MidiMessage toJavaDatavalueLSB2(MXMessage msg) throws InvalidMidiDataException {
        if (msg.getCommand() == 176 && msg.getGate() == 6 && (msg.getVisitant().isHaveDataentryRPN() || msg.getVisitant().isHaveDataentryNRPN())) {
            return new ShortMessage(176 + msg.getChannel(), 38, msg.getVisitant().getDataentryLSB());
        }
        return null;
    }

    public static MidiMessage toJavaMessage(MXMessage msg) throws InvalidMidiDataException {
        byte[] data = msg.getDataBytes();
        int extype = msg.getExtype();
        if (extype == 65280) {
            return null;
        }
        if (extype == 256) {
            return new ShortMessage(data[0] & 0xFF, data[1] & 0xFF, data[2] & 0xFF);
        }
        byte[] newData = new byte[data.length - 1];
        for (int i = 0; i < data.length - 1; ++i) {
            newData[i] = data[i + 1];
        }
        switch (extype) {
            case 1024: {
                return new SysexMessage(data[0] & 0xFF, newData, newData.length);
            }
            case 1280: {
                return new SysexMessage(data[0] & 0xFF, newData, newData.length);
            }
            case 1536: {
                return new MetaMessage(msg.getMetaType(), newData, newData.length);
            }
        }
        throw new InvalidMidiDataException("Not supported.");
    }

    public static MXMessage fromShortMessage(int port, int status, int data1, int data2) {
        MXMessage message = new MXMessage();
        message._port = port;
        message._dataBytesReady = false;
        int command = status;
        int channel = 0;
        if (status >= 128 && status <= 224) {
            command = status & 0xF0;
            channel = status & 0xF;
        }
        message.setExtype(256);
        message.setChannel(channel);
        if (command < 0 || command > 255) {
            _debug.println("command = " + command);
            return null;
        }
        if (channel < 0 || channel > 15) {
            _debug.println("channel= " + channel);
            return null;
        }
        if (data1 < 0 || data1 > 127) {
            _debug.println("data1 = " + data1);
            return null;
        }
        if (data2 < 0 || data2 > 127) {
            _debug.println("data2 = " + data2);
            return null;
        }
        message._template[0] = status & 0xFF;
        message._template[1] = data1 & 0xFF;
        message._template[2] = data2 & 0xFF;
        int defValue = 0;
        switch (command) {
            case 192: {
                message.setChannel(channel);
                message._template[1] = 1024;
                message._template[2] = 0;
                message.setGate(data1);
                break;
            }
            case 176: {
                message._template[1] = 1024;
                message._template[2] = 512;
                message.setGate(data1);
                message.setValue(data2);
                switch (message.getGate()) {
                    case 10: {
                        defValue = 64;
                        break;
                    }
                    case 11: {
                        defValue = 127;
                    }
                }
                break;
            }
            case 128: 
            case 144: 
            case 160: {
                message._template[1] = 1024;
                message._template[2] = 512;
                message.setGate(data1);
                message.setValue(data2);
                break;
            }
            case 224: {
                message._template[1] = 512;
                message._template[2] = 768;
                message.setValue(data1 & 0x7F | data2 << 7);
                break;
            }
            case 208: {
                message._template[1] = 512;
                message.setValue(data1);
                break;
            }
            default: {
                if (command < 240 || command > 247) break;
                if (command == 242) {
                    message._template[1] = 512;
                    message._template[2] = 768;
                    message.setValue(data1 & 0x7F | data2 << 7);
                }
                if (command != 243) break;
                message._template[1] = 512;
                message.setValue(data1);
            }
        }
        return message;
    }

    public static MXMessage fromDtext(String text, int port, int channel, int gate, int value) {
        if (text == null || text.length() == 0) {
            return MXMessageFactory.createDummy();
        }
        while (text.startsWith(" ")) {
            text = text.substring(1);
        }
        while (text.endsWith(" ")) {
            text = text.substring(0, text.length() - 1);
        }
        if (text.equals("@PROG_INC")) {
            return MXMessageFactory.fromProgramInc(0, 0);
        }
        if (text.equals("@PROG_DEC")) {
            return MXMessageFactory.fromProgramDec(0, 0);
        }
        try {
            char[] line = text.toCharArray();
            char[] word = new char[line.length];
            int wx = 0;
            int readX = 0;
            ArrayList<String> separated = new ArrayList<String>();
            boolean inChecksum = false;
            int checksumKeep = -1;
            while (readX < line.length) {
                char ch;
                if ((ch = line[readX++]) == '[') {
                    inChecksum = true;
                    checksumKeep = 0;
                    continue;
                }
                if (ch == ']') {
                    if (inChecksum) {
                        inChecksum = false;
                        if (wx != 0) {
                            separated.add(new String(word, 0, wx));
                        }
                        separated.add("#CHECKSUM");
                        wx = 0;
                        continue;
                    }
                    _debug.println("Checksum have not opened");
                    _debug.printStackTrace();
                    continue;
                }
                if (ch == ' ' || ch == '\t' || ch == ',') {
                    if (wx != 0) {
                        separated.add(new String(word, 0, wx));
                        if (inChecksum) {
                            ++checksumKeep;
                        }
                    }
                    wx = 0;
                    continue;
                }
                word[wx++] = ch;
            }
            if (wx != 0) {
                separated.add(new String(word, 0, wx));
                if (inChecksum) {
                    ++checksumKeep;
                }
                wx = 0;
            }
            int gatetemp = -1;
            if (text.contains("@")) {
                ArrayList<String> sepa2 = new ArrayList<String>();
                for (int sx = 0; sx < separated.size(); ++sx) {
                    String str = (String)separated.get(sx);
                    if (str.startsWith("@")) {
                        String t;
                        if (str.equalsIgnoreCase("@PB")) {
                            sepa2.add("#ECH");
                            sepa2.add((String)separated.get(++sx));
                            sepa2.add((String)separated.get(++sx));
                            continue;
                        }
                        if (str.equalsIgnoreCase("@CP")) {
                            sepa2.add("#DCH");
                            sepa2.add((String)separated.get(++sx));
                            sepa2.add("#NONE");
                            continue;
                        }
                        if (str.equalsIgnoreCase("@PKP")) {
                            sepa2.add("#ACH");
                            t = (String)separated.get(++sx);
                            if (t.startsWith("#")) {
                                sepa2.add(t);
                            } else {
                                gatetemp = MXUtil.parseTextForNumber(t);
                                sepa2.add("#GL");
                            }
                            sepa2.add((String)separated.get(++sx));
                            continue;
                        }
                        if (str.equalsIgnoreCase("@CC")) {
                            sepa2.add("#BCH");
                            t = (String)separated.get(++sx);
                            if (t.startsWith("#")) {
                                sepa2.add(t);
                            } else {
                                gatetemp = MXUtil.parseTextForNumber(t);
                                sepa2.add("#GL");
                            }
                            if (separated.size() <= ++sx) {
                                return null;
                            }
                            sepa2.add((String)separated.get(sx));
                            continue;
                        }
                        if (str.equalsIgnoreCase("@SYSEX")) continue;
                        if (str.equalsIgnoreCase("@RPN")) {
                            int msb = MXMessage.readAliasText((String)separated.get(++sx));
                            int lsb = MXMessage.readAliasText((String)separated.get(++sx));
                            int data = MXMessage.readAliasText((String)separated.get(++sx));
                            if (separated.size() >= sx + 2) {
                                data <<= 7;
                                data |= MXMessage.readAliasText((String)separated.get(++sx));
                            }
                            return MXMessageFactory.fromDataentryRPN(0, channel, msb, lsb, data);
                        }
                        if (str.equalsIgnoreCase("@NRPN")) {
                            int msb = MXMessage.readAliasText((String)separated.get(++sx));
                            int lsb = MXMessage.readAliasText((String)separated.get(++sx));
                            int data = MXMessage.readAliasText((String)separated.get(++sx));
                            if (separated.size() >= sx + 2) {
                                data <<= 7;
                                data |= MXMessage.readAliasText((String)separated.get(++sx));
                            }
                            return MXMessageFactory.fromDataentryNRPN(0, channel, msb, lsb, data);
                        }
                        _debug.println("Not Support [" + text + "]");
                        return null;
                    }
                    sepa2.add(str);
                }
                separated = sepa2;
            }
            int[] compiled = new int[line.length];
            boolean cx = false;
            int px = 0;
            for (int sx = 0; sx < separated.size(); ++sx) {
                String str = (String)separated.get(sx);
                int code = MXMessage.readAliasText(str);
                if (code < 0) {
                    return null;
                }
                compiled[px++] = code;
            }
            int[] template = new int[Math.max(px, 3)];
            for (int i = 0; i < px; ++i) {
                template[i] = compiled[i];
            }
            MXMessage ret = new MXMessage(template, checksumKeep);
            ret.setChannel(channel);
            if (gatetemp > 0) {
                ret.setGate(gatetemp);
            } else {
                ret.setGate(gate);
            }
            ret.setValue(value);
            return ret;
        }
        catch (Exception e) {
            _debug.printStackTrace(e);
            return null;
        }
    }

    public static String toDText(MXMessage message) {
        ArrayList<String> array = message.toDArray();
        StringBuffer text = new StringBuffer();
        String last = "]";
        for (String seg : array) {
            if (seg.length() == 0) continue;
            if (!(text.length() < 0 || seg.equals("[") || seg.equals("]") || last.equals("[") || last.equals("]"))) {
                text.append(" ");
            }
            last = seg;
            text.append(seg);
        }
        return text.toString();
    }

    public static MXMessage fromDataentryRPN(int port, int channel, int msb, int lsb, int value) {
        int[] template = new int[]{13056, value >> 7 & 0x7F, value & 0x7F};
        MXMessage message = new MXMessage(template, -1);
        MXVisitant visitant = new MXVisitant();
        visitant.setDataroomType(1);
        visitant.setDataroomMSB(msb);
        visitant.setDataroomLSB(lsb);
        visitant.setDataentry14(value);
        message.setVisitant(visitant);
        return message;
    }

    public static MXMessage fromDataentryNRPN(int port, int channel, int msb, int lsb, int value) {
        int[] template = new int[]{13312, value >> 7 & 0x7F, value & 0x7F};
        MXMessage message = new MXMessage(template, -1);
        MXVisitant visitant = new MXVisitant();
        visitant.setDataroomType(2);
        visitant.setDataroomMSB(msb);
        visitant.setDataroomLSB(lsb);
        visitant.setDataentry14(value);
        message.setVisitant(visitant);
        return message;
    }

    static {
        _debug.switchOn();
    }
}

