/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.io.PrintStream;
import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;

public final class MXMessage {
    private MXVisitant _visitant;
    private static final MXDebugConsole _debug = new MXDebugConsole(MXMessage.class);
    public static final String EXCOMMAND_PROGRAM_INC = "@PROG_INC";
    public static final String EXCOMMAND_PROGRAM_DEC = "@PROG_DEC";
    public static final int EXTYPE_INIT_ERROR = 65024;
    public static final int EXTYPE_DUMMY = 65280;
    public static final int EXTYPE_SHORTMESSAGE = 256;
    public static final int EXTYPE_PROGRAM_INC = 512;
    public static final int EXTYPE_PROGRAM_DEC = 768;
    public static final int EXTYPE_SYSEX = 1024;
    public static final int EXTYPE_SYSEX_SPECIAL = 1280;
    public static final int EXTYPE_META = 1536;
    private int _extype = 65280;
    int _port;
    public boolean _dataBytesReady = false;
    private int _value = -1;
    private int _gate = -1;
    private int _channel = 0;
    protected byte[] _dataBytes = new byte[3];
    protected int _bytePosHiValue;
    protected int _bytePosValue;
    protected int _bytePosGate;
    protected int _bytePosHiGate;
    protected int _checksumLength = -1;
    private boolean _value14bit;
    public int[] _template = new int[3];
    public static final int DTEXT_NONE = 256;
    public static final int DTEXT_VL = 512;
    public static final int DTEXT_VH = 768;
    public static final int DTEXT_GL = 1024;
    public static final int DTEXT_GH = 1280;
    static final int DTEXT_CH = 1536;
    static final int DTEXT_1CH = 1792;
    static final int DTEXT_2CH = 2048;
    static final int DTEXT_3CH = 2304;
    static final int DTEXT_PCH = 2560;
    static final int DTEXT_1RCH = 2816;
    static final int DTEXT_2RCH = 3072;
    static final int DTEXT_3RCH = 3328;
    static final int DTEXT_4RCH = 3584;
    static final int DTEXT_VF1 = 3840;
    static final int DTEXT_VF2 = 4096;
    static final int DTEXT_VF3 = 4352;
    static final int DTEXT_VF4 = 4608;
    static final int DTEXT_VPGL = 4864;
    static final int DTEXT_VPGH = 5120;
    static final int DTEXT_CCNUM = 5376;
    static final int DTEXT_RSCTRT1 = 6656;
    static final int DTEXT_RSCTRT2 = 6912;
    static final int DTEXT_RSCTRT3 = 7168;
    static final int DTEXT_RSCTRT1P = 7424;
    static final int DTEXT_RSCTRT2P = 7680;
    static final int DTEXT_RSCTRT3P = 7936;
    static final int DTEXT_RSCTPT1 = 8192;
    static final int DTEXT_RSCTPT2 = 8448;
    static final int DTEXT_RSCTPT3 = 8704;
    static final int DTEXT_RSCTPT1P = 8960;
    static final int DTEXT_RSCTPT2P = 9216;
    static final int DTEXT_RSCTPT3P = 9472;
    public static final int DTEXT_CHECKSUM = 9728;
    static final int DTEXT_4CH = 9984;
    static final int DTEXT_5CH = 10240;
    static final int DTEXT_6CH = 10496;
    static final int DTEXT_7CH = 10752;
    static final int DTEXT_8CH = 11008;
    static final int DTEXT_9CH = 11264;
    static final int DTEXT_ACH = 11520;
    static final int DTEXT_BCH = 11776;
    static final int DTEXT_CCH = 12032;
    static final int DTEXT_DCH = 12288;
    static final int DTEXT_ECH = 12544;
    static final int DTEXT_FCH = 12800;
    public static final int DTEXT_RPN = 13056;
    public static final int DTEXT_NRPN = 13312;
    private int _metaType;
    public String _metaText;
    static MXWrapList<Integer> textAlias = new MXWrapList();

    public int getExtype() {
        return this._extype;
    }

    public void setExtype(int extype) {
        this._extype = extype;
    }

    public boolean canPaired14bit() {
        int cc;
        this.createBytes();
        if (this._bytePosValue < 0) {
            return false;
        }
        if (this._bytePosHiValue >= 0) {
            return true;
        }
        return this.getCommand() == 176 && (cc = this.getGate()) >= 0 && cc <= 31;
    }

    public boolean isValue14bit() {
        return this._value14bit;
    }

    public void setValue14bit(boolean value14bit) {
        if (this._value14bit != value14bit) {
            int value = this.getValue();
            if (!value14bit && value >= 128) {
                this.setValue(127);
            }
        }
        this._value14bit = value14bit;
    }

    public MXVisitant getVisitant() {
        return this._visitant;
    }

    public void setVisitant(MXVisitant visitant) {
        this._visitant = visitant;
        this._dataBytesReady = false;
    }

    public int getDValue(int alias) {
        int newValue = this.getValue();
        int newGate = this.getGate();
        switch (alias & 0xFF00) {
            case 256: {
                return -1;
            }
            case 512: {
                alias = newValue & 0x7F;
                break;
            }
            case 768: {
                alias = newValue >> 7 & 0x7F;
                break;
            }
            case 1024: {
                alias = newGate & 0x7F;
                break;
            }
            case 1280: {
                alias = newGate >> 7 & 0x7F;
                break;
            }
            case 1536: {
                alias = this.getChannel();
                break;
            }
            case 1792: {
                alias = 16 + this.getChannel();
                break;
            }
            case 2048: {
                alias = 32 + this.getChannel();
                break;
            }
            case 2304: {
                alias = 48 + this.getChannel();
                break;
            }
            case 9984: {
                alias = 64 + this.getChannel();
                break;
            }
            case 10240: {
                alias = 80 + this.getChannel();
                break;
            }
            case 10496: {
                alias = 96 + this.getChannel();
                break;
            }
            case 10752: {
                alias = 112 + this.getChannel();
                break;
            }
            case 11008: {
                alias = 128 + this.getChannel();
                break;
            }
            case 11264: {
                alias = 144 + this.getChannel();
                break;
            }
            case 11520: {
                alias = 160 + this.getChannel();
                break;
            }
            case 11776: {
                alias = 176 + this.getChannel();
                break;
            }
            case 12032: {
                alias = 192 + this.getChannel();
                break;
            }
            case 12288: {
                alias = 208 + this.getChannel();
                break;
            }
            case 12544: {
                alias = 224 + this.getChannel();
                break;
            }
            case 12800: {
                alias = 240 + this.getChannel();
                break;
            }
            case 2560: {
                if (this._port >= 0 && this._port <= 3) {
                    alias = this._port * 16 + this.getChannel();
                    break;
                }
                alias = 48 + this.getChannel();
                break;
            }
            case 2816: 
            case 3072: 
            case 3328: 
            case 3584: {
                throw new IllegalArgumentException("1RCH, 2RCH, 3RCH, 4RCH not supported.");
            }
            case 3840: {
                alias = this.getValue() & 0xF;
                break;
            }
            case 4096: {
                alias = this.getValue() >> 4 & 0xF;
                break;
            }
            case 4352: {
                alias = this.getValue() >> 8 & 0xF;
                break;
            }
            case 4608: {
                alias = this.getValue() >> 12 & 0xF;
                break;
            }
            case 4864: {
                alias = this.getValue() + this.getGate() & 0x7F;
                break;
            }
            case 5120: {
                alias = this.getValue() + this.getGate() >> 7 & 0x7F;
                break;
            }
            case 6656: 
            case 6912: 
            case 7168: {
                throw new IllegalArgumentException("RSCTRT1, RSCTRT2, RSCTRT3 not supported.");
            }
            case 7424: 
            case 7680: 
            case 7936: {
                throw new IllegalArgumentException("RSCTRT1P, RSCTRT2P, RSCTRT3P not supported.");
            }
            case 8192: 
            case 8448: 
            case 8704: {
                throw new IllegalArgumentException("RSCTPT1, RSCTPT2, RSCTPT3 not supported.");
            }
            case 8960: 
            case 9216: 
            case 9472: {
                throw new IllegalArgumentException("RSCTPT1P, RSCTPT2P, RSCTPT3P not supported.");
            }
            case 9728: {
                break;
            }
            case 13056: {
                new IllegalArgumentException("if DTEXT_RPN called shoudl handleit");
                alias = 0;
                break;
            }
            case 13312: {
                new IllegalArgumentException("if DTEXT_NRPN called shoudl handleit");
                alias = 0;
                break;
            }
            case 0: {
                return (byte)alias;
            }
            default: {
                boolean haveEx = false;
                throw new IllegalArgumentException("something wrong " + Integer.toHexString(alias));
            }
        }
        return (byte)alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] createBytes() {
        if (this._dataBytesReady) {
            return this._dataBytes;
        }
        MXMessage mXMessage = this;
        synchronized (mXMessage) {
            if (this._template.length != this._dataBytes.length) {
                this._dataBytes = new byte[this._template.length];
            }
            int _checksumTo = -1;
            this._bytePosHiValue = -1;
            this._bytePosValue = -1;
            this._bytePosGate = -1;
            this._bytePosHiGate = -1;
            for (int i = 0; i < this._template.length; ++i) {
                int x = this._template[i];
                if (this._template[i] == 512) {
                    this._bytePosValue = i;
                    this._dataBytes[i] = (byte)(this._value & 0x7F);
                    continue;
                }
                if (this._template[i] == 768) {
                    this._bytePosHiValue = i;
                    this._dataBytes[i] = (byte)(this._value >> 7);
                    continue;
                }
                if (this._template[i] == 1024) {
                    this._bytePosGate = i;
                    this._dataBytes[i] = (byte)(this._gate & 0x7F);
                    continue;
                }
                if (this._template[i] == 1280) {
                    this._bytePosHiGate = i;
                    this._dataBytes[i] = (byte)(this._gate >> 7);
                    continue;
                }
                if ((x & 0xFF00) != 0) {
                    if (x == 9728) {
                        _checksumTo = i;
                        x = 0;
                    } else {
                        x = this.getDValue(x);
                    }
                }
                this._dataBytes[i] = (byte)(x & 0xFF);
            }
            this._value14bit = this._bytePosValue >= 0 && this._bytePosHiValue >= 0;
            if (this._template[0] == 13056 || this._template[0] == 13312) {
                this._dataBytes[0] = (byte)(176 + this.getChannel());
                this._dataBytes[1] = 6;
                this._dataBytes[2] = 0;
            } else {
                int command = this._dataBytes[0] & 0xF0;
                if (command >= 128 && command <= 224) {
                    this._dataBytes[0] = (byte)(command + this.getChannel());
                }
                if (this._checksumLength >= 0 && _checksumTo >= 0) {
                    int x128 = 0;
                    for (int x = _checksumTo - this._checksumLength; x < _checksumTo; ++x) {
                        x128 += this._dataBytes[x];
                    }
                    int r = 128 - (x128 &= 0x7F);
                    this._dataBytes[_checksumTo] = (byte)(r & 0x7F);
                }
            }
            this._dataBytesReady = true;
        }
        return this._dataBytes;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        if (this._port != port) {
            this._dataBytesReady = false;
            this._port = port;
        }
    }

    public int getStatus() {
        this.createBytes();
        int status = this._dataBytes[0] & 0xFF;
        return status;
    }

    public int getCommand() {
        this.createBytes();
        int status = this._dataBytes[0] & 0xFF;
        if (status >= 128 && status <= 224) {
            return status & 0xF0;
        }
        return status;
    }

    public void setStatus(int status) {
        this._dataBytesReady = false;
        if (this.getExtype() != 256) {
            throw new IllegalStateException("setStatus on none ShortMessage");
        }
        this._template[0] = status & 0xFF;
    }

    public void setChannel(int channel) {
        if (this._channel != channel) {
            this._dataBytesReady = false;
            this._channel = channel;
        }
    }

    public int getData1() {
        this.createBytes();
        return this._dataBytes[1] & 0xFF;
    }

    public int getData2() {
        this.createBytes();
        return this._dataBytes[2] & 0xFF;
    }

    public int getNoteNumberFromBytes() {
        switch (this.getCommand()) {
            case 128: 
            case 144: 
            case 160: {
                return this.getData1();
            }
        }
        _debug.println("Its not note message.");
        return 0;
    }

    public int getVelocityFromBytes() {
        switch (this.getCommand()) {
            case 128: 
            case 144: 
            case 160: {
                return this.getData2();
            }
        }
        _debug.println("Its not note message.");
        return 0;
    }

    public int getChannel() {
        if (this._channel < 0 || this._channel > 15) {
            _debug.println("getAsChannel " + this._channel);
            return 0;
        }
        return this._channel;
    }

    public int getValue() {
        return this._value;
    }

    public void setValue(int value) {
        if (value != this._value) {
            this._value = value;
            this._dataBytesReady = false;
        }
    }

    public int getGate() {
        return this._gate;
    }

    public void setGate(int gate) {
        if (gate != this._gate) {
            this._gate = gate;
            this._dataBytesReady = false;
        }
    }

    public int getMetaType() {
        return this._metaType;
    }

    public void setMetaType(int metaCode) {
        if (metaCode != this._metaType) {
            this._metaType = metaCode;
            this._dataBytesReady = false;
        }
    }

    protected MXMessage() {
        this._extype = 65280;
    }

    protected MXMessage(int[] template, int checksumLength) {
        this._template = template;
        this._checksumLength = checksumLength;
        this._extype = template[0] == 0 ? 65280 : (template[0] == 240 ? 1024 : (template[0] == 247 ? 1280 : 256));
        if ((template[0] & 0xFFF0) == 176) {
            if ((template[1] & 0xFF00) == 0) {
                this._gate = template[1];
                template[1] = 1024;
            }
            if ((template[2] & 0xFF00) == 0) {
                this._value = template[1];
                template[1] = 512;
            }
        }
    }

    public byte[] getDataBytes() {
        this.createBytes();
        return this._dataBytes;
    }

    public boolean isMessageTypeChannel() {
        this.createBytes();
        if (this.getExtype() != 256) {
            return false;
        }
        return this.getCommand() >= 128 && this.getCommand() <= 224;
    }

    public boolean isMessageTypeSystemKnown() {
        this.createBytes();
        if (this.getExtype() != 256) {
            return false;
        }
        if (this.getCommand() >= 128 && this.getCommand() <= 224) {
            return true;
        }
        return this.getCommand() >= 240 && this.getCommand() <= 247;
    }

    public boolean isMessageTypeDataentry() {
        this.createBytes();
        if (this.getCommand() == 176) {
            switch (this.getData1()) {
                case 6: 
                case 96: 
                case 97: {
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        String str = this.toStringHeader();
        if (this.getCommand() == 192) {
            return str + "(" + this.getGate() + ")";
        }
        return str + "(" + this.getValue() + ")";
    }

    public String toStringHeader(int min, int max) {
        String str = this.toStringHeader();
        if (min != max) {
            return str + "= Range" + min + " to " + max;
        }
        return str + "= " + max;
    }

    public String toStringHeader() {
        String chname;
        this.createBytes();
        int port = this.getPort();
        switch (this.getExtype()) {
            case 65280: {
                return "ZERO";
            }
            case 65024: {
                return "ERROR";
            }
            case 1536: {
                return "Meta " + this.getMetaType();
            }
            case 1024: {
                return "Sysex [" + MXUtil.dumpHexFF(this.getDataBytes()) + "]";
            }
            case 1280: {
                return "SysexSpecial [" + MXUtil.dumpHexFF(this.getDataBytes()) + "]";
            }
            case 256: {
                break;
            }
            case 512: {
                return "Program UP Ch:" + (this.getChannel() + 1);
            }
            case 768: {
                return "Program DEC Ch:" + (this.getChannel() + 1);
            }
        }
        if (this.isMessageTypeChannel()) {
            int channel = this.getChannel();
            chname = "[" + MXUtilMidi.nameOfPort(port) + (channel + 1) + "]";
        } else {
            chname = "[" + MXUtilMidi.nameOfPort(port) + "]";
        }
        int command = this.getCommand();
        if (this._visitant != null && this.getCommand() == 176) {
            if (this.getData1() == 6) {
                if (this._visitant.isHaveDataentryRPN()) {
                    return chname + "RPN[" + MXUtil.toHexFF(this._visitant.getDataentryMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataentryLSB()) + "]=" + this._visitant.getDataentryValue14();
                }
                if (this._visitant.isHaveDataentryNRPN()) {
                    return chname + "NRPN[" + MXUtil.toHexFF(this._visitant.getDataentryMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataentryLSB()) + "]=" + this._visitant.getDataentryValue14();
                }
            } else if (this.getData1() == 96) {
                if (this._visitant.isHaveDataentryRPN()) {
                    return chname + "RPN[" + MXUtil.toHexFF(this._visitant.getDataentryMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataentryLSB()) + "]++";
                }
                if (this._visitant.isHaveDataentryNRPN()) {
                    return chname + "NRPN[" + MXUtil.toHexFF(this._visitant.getDataentryMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataentryLSB()) + "]++";
                }
            } else if (this.getData1() == 97) {
                if (this._visitant.isHaveDataentryRPN()) {
                    return chname + "RPN[" + MXUtil.toHexFF(this._visitant.getDataentryMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataentryLSB()) + "]--";
                }
                if (this._visitant.isHaveDataentryNRPN()) {
                    return chname + "NRPN[" + MXUtil.toHexFF(this._visitant.getDataentryMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataentryLSB()) + "]--";
                }
            }
        }
        String name = MXUtilMidi.nameOfMessage(this.getStatus(), this.getData1(), this.getData2());
        if (command == 176) {
            return chname + " " + name;
        }
        if (command == 128 || command == 144 || command == 160) {
            int note = this.getNoteNumberFromBytes();
            int velocity = this.getVelocityFromBytes();
            return chname + " " + name + MXUtilMidi.nameOfNote(note);
        }
        if (command == 192) {
            return chname + " " + name;
        }
        if (command == 208) {
            return chname + " " + name;
        }
        if (command == 224) {
            return chname + " " + name;
        }
        if (command == 242) {
            return name;
        }
        if (command == 243) {
            return name;
        }
        if (command >= 240 && command <= 247) {
            return name;
        }
        Object extype = "";
        switch (this.getExtype()) {
            case 65280: {
                extype = "-";
                break;
            }
            case 256: {
                extype = "ShortMessage";
                break;
            }
            case 512: {
                extype = "ProgINC";
                break;
            }
            case 768: {
                extype = "ProgDEC";
                break;
            }
            case 1024: {
                extype = "SysEX";
                break;
            }
            case 1280: {
                extype = "SysEXSpecial";
                break;
            }
            case 1536: {
                extype = "Meta(" + MXUtil.toHexFF(this.getMetaType()) + ")";
            }
        }
        return "type[" + (String)extype + ":" + MXUtil.dumpHexFF(this.getDataBytes()) + "]";
    }

    public boolean hasValueHiField() {
        this.createBytes();
        return this._bytePosHiValue >= 0;
    }

    public boolean hasValueLowField() {
        this.createBytes();
        return this._bytePosValue >= 0;
    }

    public boolean hasGateLowField() {
        this.createBytes();
        return this._bytePosGate >= 0;
    }

    public boolean hasGateHiField() {
        this.createBytes();
        return this._bytePosHiGate >= 0;
    }

    public static String fromD(int dtext) {
        int index = textAlias.indexOfValue(dtext);
        if (index >= 0) {
            return ((MXWrap)MXMessage.textAlias.get((int)index)).name;
        }
        return MXUtil.toHexFF(dtext) + "h";
    }

    public ArrayList<String> toDArray() {
        int i;
        ArrayList<String> texts = new ArrayList<String>();
        if (this.getExtype() == 512) {
            texts.add(EXCOMMAND_PROGRAM_INC);
            return texts;
        }
        if (this.getExtype() == 768) {
            texts.add(EXCOMMAND_PROGRAM_DEC);
            return texts;
        }
        this.createBytes();
        if (this._template[0] == 13056 || this._template[0] == 13312) {
            if (this._template[0] == 13056) {
                texts.add("@RPN");
            } else {
                texts.add("@NRPN");
            }
            if (this._visitant != null) {
                texts.add(MXMessage.fromD(this._visitant.getDataentryMSB()));
                texts.add(MXMessage.fromD(this._visitant.getDataentryLSB()));
                texts.add(MXMessage.fromD(this._value));
                return texts;
            }
            new Exception("RPN have no DATA").printStackTrace();
            return null;
        }
        if (this.isMessageTypeChannel()) {
            int command = this.getCommand();
            int channel = this.getChannel();
            int data1 = this.getData1();
            int data2 = this.getData2();
            if (command == 224) {
                texts.add("@PB");
                texts.add(MXMessage.fromD(this._template[1]));
                texts.add(MXMessage.fromD(this._template[2]));
                return texts;
            }
            if (command == 208) {
                texts.add("@CP");
                texts.add(MXMessage.fromD(this._template[1]));
                return texts;
            }
            if (command == 160) {
                texts.add("@PKP");
                texts.add(MXMessage.fromD(this._template[1]));
                texts.add(MXMessage.fromD(this._template[2]));
                return texts;
            }
            if (command == 176) {
                texts.add("@CC");
                texts.add(MXMessage.fromD(this._template[1]));
                texts.add(MXMessage.fromD(this._template[2]));
                return texts;
            }
        }
        int csumFrom = -1;
        if (this._checksumLength >= 0) {
            for (i = 0; i < this._template.length; ++i) {
                if (this._template[i] != 9728) continue;
                csumFrom = i - this._checksumLength;
                break;
            }
        }
        for (i = 0; i < this._template.length; ++i) {
            if (i == csumFrom) {
                texts.add("[");
            }
            int code = this._template[i];
            if (i == 0 && this.isMessageTypeChannel()) {
                code &= 0xF0;
            }
            if (code == 9728) {
                texts.add("]");
                continue;
            }
            texts.add(MXMessage.fromD(code));
        }
        return texts;
    }

    public String toShortString() {
        Object chname;
        this.createBytes();
        if (this.isMessageTypeChannel()) {
            int channel = this.getChannel();
            chname = "" + (channel + 1);
        } else {
            chname = "";
        }
        switch (this.getExtype()) {
            case 65280: {
                return "-";
            }
            case 512: {
                return (String)chname + "Prog+";
            }
            case 768: {
                return (String)chname + "Prog-";
            }
            case 1024: {
                return "Sys";
            }
            case 1280: {
                return "Sys2";
            }
            case 1536: {
                return "Meta";
            }
            case 256: {
                break;
            }
            default: {
                return "???";
            }
        }
        int command = this.getCommand();
        if (command == 176) {
            int data1 = this.getData1();
            if (data1 == 6 && this._visitant != null) {
                if (this._visitant.isHaveDataentryRPN()) {
                    return (String)chname + "RPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]";
                }
                if (this._visitant.isHaveDataentryNRPN()) {
                    return (String)chname + "NRPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]";
                }
            } else if (data1 == 96 && this._visitant != null) {
                if (this._visitant.isHaveDataentryRPN()) {
                    return (String)chname + "RPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]+";
                }
                if (this._visitant.isHaveDataentryNRPN()) {
                    return (String)chname + "NRPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]+";
                }
            } else if (data1 == 97 && this._visitant != null) {
                if (this._visitant.isHaveDataentryRPN()) {
                    return (String)chname + "RPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]-";
                }
                if (this._visitant.isHaveDataentryNRPN()) {
                    return (String)chname + "NRPN[" + MXUtil.toHexFF(this._visitant.getDataroomMSB()) + ":" + MXUtil.toHexFF(this._visitant.getDataroomLSB()) + "]-";
                }
            }
            return (String)chname + MXUtilMidi.nameOfControlChange(data1);
        }
        if (command == 128) {
            int note = this.getNoteNumberFromBytes();
            int velocity = this.getVelocityFromBytes();
            return (String)chname + MXUtilMidi.nameOfNote(note) + "-";
        }
        if (command == 144) {
            int note = this.getNoteNumberFromBytes();
            int velocity = this.getVelocityFromBytes();
            return (String)chname + MXUtilMidi.nameOfNote(note);
        }
        if (command == 160) {
            int note = this.getNoteNumberFromBytes();
            int velocity = this.getVelocityFromBytes();
            return (String)chname + "PPrs";
        }
        if (command == 192) {
            int program = this.getGate();
            return (String)chname + "PG" + program;
        }
        if (command == 208) {
            return (String)chname + "ChPrs";
        }
        if (command == 224) {
            return (String)chname + "Pitch";
        }
        if (command == 242) {
            return (String)chname + "Pos";
        }
        if (command == 243) {
            return (String)chname + "Song";
        }
        if (this.isMessageTypeChannel()) {
            return (String)chname + MXUtilMidi.nameOfMessage(this.getStatus(), this.getData1(), this.getData2());
        }
        return MXUtilMidi.nameOfMessage(this.getStatus(), this.getData1(), this.getData2());
    }

    public static void main(String[] args) {
        MXMessage message = MXMessageFactory.fromShortMessage(0, 144, 64, 127);
        String dtext = MXMessageFactory.toDText(message);
        MXMessage msg = MXMessageFactory.fromDtext(dtext, message.getPort(), message.getChannel(), message.getGate(), message.getValue());
        PrintStream console = System.out;
        console.println(message);
        console.println(dtext);
        console.println(msg);
        msg.setPort(6);
        msg.setChannel(2);
        msg.setValue(100);
        console.println(msg);
        console.println("----------------");
        MXMessage message2 = MXMessageFactory.fromShortMessage(0, 177, 7, 127);
        console.println(message2);
        String dtext2 = MXMessageFactory.toDText(message2);
        MXMessage msg2 = MXMessageFactory.fromDtext(dtext2, message2.getPort(), message2.getChannel(), message2.getGate(), message2.getValue());
        console.println(dtext2);
        console.println(msg2);
        msg2.setPort(6);
        msg2.setChannel(2);
        msg2.setValue(100);
        console.println(msg2);
        console.println("----------------");
    }

    public void debugDump(String func) {
        PrintStream console = System.out;
        StringBuffer buf = new StringBuffer();
        buf.append(func + " debugDump [template = ");
        for (int i = 0; i < this._template.length; ++i) {
            buf.append(Integer.toHexString(this._template[i]) + " ");
        }
        buf.append("] bytes = [ ");
        byte[] b = this.getDataBytes();
        for (int i = 0; i < b.length; ++i) {
            buf.append(MXUtil.toHexFF(b[i]) + " ");
        }
        buf.append("]");
        buf.append(" gate = " + this.getGate());
        buf.append(" value = " + this.getValue());
        console.println(buf);
    }

    public String toDumpString() {
        Object chname;
        this.createBytes();
        if (this.isMessageTypeChannel()) {
            int channel = this.getChannel();
            chname = "" + (channel + 1);
        } else {
            chname = "";
        }
        switch (this.getExtype()) {
            case 65280: {
                return "-";
            }
            case 512: {
                return (String)chname + "Prog+";
            }
            case 768: {
                return (String)chname + "Prog-";
            }
            case 256: 
            case 1024: 
            case 1280: {
                return MXUtil.dumpHexFF(this._dataBytes);
            }
            case 1536: {
                char[] ch = new char[this._template.length];
                for (int i = 0; i < ch.length; ++i) {
                    ch[i] = (char)this._template[i];
                }
                return new String(ch);
            }
        }
        return "???";
    }

    public void recalcGate() {
        if (this.getCommand() == 176 && this._template[1] != 512) {
            int gate = this._template[1];
            this._template[1] = 512;
            this.setGate(gate);
        }
    }

    public static int readAliasText(String str) {
        int find;
        int code = -1;
        if (str.startsWith("#") && (find = textAlias.indexOfName(str)) >= 0) {
            code = (Integer)((MXWrap)MXMessage.textAlias.get((int)find)).value;
            return code;
        }
        return MXUtil.parseTextForNumber(str);
    }

    public boolean importBytesToValue(byte[] data) {
        this.createBytes();
        byte vl = this._bytePosValue >= 0 ? data[this._bytePosValue] : (byte)0;
        byte vh = this._bytePosHiValue >= 0 ? data[this._bytePosHiValue] : (byte)0;
        byte gl = this._bytePosGate >= 0 ? data[this._bytePosGate] : (byte)0;
        byte gh = this._bytePosHiGate >= 0 ? data[this._bytePosHiGate] : (byte)0;
        this._value = (vh & 0x7F) << 7 | vl & 0x7F;
        this._gate = (gh & 0x7F) << 7 | gl & 0x7F;
        return true;
    }

    static {
        textAlias.addNameAndValue("#NONE", 256);
        textAlias.addNameAndValue("#VL", 512);
        textAlias.addNameAndValue("#VH", 768);
        textAlias.addNameAndValue("#GL", 1024);
        textAlias.addNameAndValue("#GH", 1280);
        textAlias.addNameAndValue("#CH", 1536);
        textAlias.addNameAndValue("#1CH", 1792);
        textAlias.addNameAndValue("#2CH", 2048);
        textAlias.addNameAndValue("#3CH", 2304);
        textAlias.addNameAndValue("#PCH", 2560);
        textAlias.addNameAndValue("#1RCH", 2816);
        textAlias.addNameAndValue("#2RCH", 3072);
        textAlias.addNameAndValue("#3RCH", 3328);
        textAlias.addNameAndValue("#4RCH", 3584);
        textAlias.addNameAndValue("#VF1", 3840);
        textAlias.addNameAndValue("#VF2", 4096);
        textAlias.addNameAndValue("#VF3", 4352);
        textAlias.addNameAndValue("#VF4", 4608);
        textAlias.addNameAndValue("#VPGL", 4864);
        textAlias.addNameAndValue("#VPGH", 5120);
        textAlias.addNameAndValue("#RSCTRT1", 6656);
        textAlias.addNameAndValue("#RSCTRT2", 6912);
        textAlias.addNameAndValue("#RSCTRT3", 7168);
        textAlias.addNameAndValue("#RSCTRT1P", 7424);
        textAlias.addNameAndValue("#RSCTRT2P", 7680);
        textAlias.addNameAndValue("#RSCTRT3P", 7936);
        textAlias.addNameAndValue("#RSCTPT1", 8192);
        textAlias.addNameAndValue("#RSCTPT2", 8448);
        textAlias.addNameAndValue("#RSCTPT3", 8704);
        textAlias.addNameAndValue("#RSCTPT1P", 8960);
        textAlias.addNameAndValue("#RSCTPT2P", 9216);
        textAlias.addNameAndValue("#RSCTPT3P", 9472);
        textAlias.addNameAndValue("#CHECKSUM", 9728);
        textAlias.addNameAndValue("#4CH", 9984);
        textAlias.addNameAndValue("#5CH", 10240);
        textAlias.addNameAndValue("#6CH", 10496);
        textAlias.addNameAndValue("#7CH", 10752);
        textAlias.addNameAndValue("#8CH", 11008);
        textAlias.addNameAndValue("#9CH", 11264);
        textAlias.addNameAndValue("#ACH", 11520);
        textAlias.addNameAndValue("#BCH", 11776);
        textAlias.addNameAndValue("#CCH", 12032);
        textAlias.addNameAndValue("#DCH", 12288);
        textAlias.addNameAndValue("#ECH", 12544);
        textAlias.addNameAndValue("#FCH", 12800);
        textAlias.addNameAndValue("#RPN", 13056);
        textAlias.addNameAndValue("#NRPN", 13312);
    }
}

