/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.console;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jp.synthtarou.midimixer.libs.MXTimer;
import jp.synthtarou.midimixer.libs.MultiThreadQueue;
import jp.synthtarou.midimixer.libs.console.MXConsoleMidiRenderer;

public class MXConsoleModel<T>
implements ListModel {
    private T[] listLogging = null;
    private int indexFrom = 0;
    private int indexTo = 0;
    private JList bind = null;
    private boolean _pause = false;
    private MXConsoleMidiRenderer _render;
    private ArrayList<ListDataListener> listListner = new ArrayList();
    private MultiThreadQueue<T> _queue;
    private String _name;
    static byte[] _hex = "0123456789ABCDEF".getBytes();
    DateTimeFormatter simpleFormat = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    boolean reserved = false;
    long lastTick = 0L;

    public void setPause(boolean pause) {
        this._pause = pause;
    }

    public synchronized void clearText() {
        this.indexFrom = 0;
        this.indexTo = 0;
    }

    public MXConsoleModel(String name, int maxRowCount) {
        this.listLogging = new Object[maxRowCount];
        this._name = name;
        this._queue = new MultiThreadQueue();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    Object text;
                    if ((text = MXConsoleModel.this._queue.pop()) == null) break;
                    MXConsoleModel.this.addTextInThread(text);
                }
                MXConsoleModel.this._queue.quit();
            }
        }).start();
    }

    public MXConsoleMidiRenderer getRenderer() {
        if (this.bind == null) {
            throw new IllegalStateException("try installConsole before getRender");
        }
        return this._render;
    }

    public void installConsole(JList list) {
        this.bind = list;
        this.bind.setModel(this);
        this._render = new MXConsoleMidiRenderer(this._name);
        list.setCellRenderer(this._render);
    }

    @Override
    public int getSize() {
        int count = this.indexTo - this.indexFrom;
        return count >= 0 ? count : count + this.listLogging.length;
    }

    public Object getElementAt(int index) {
        int pos;
        for (pos = this.indexFrom + index; pos >= this.listLogging.length; pos -= this.listLogging.length) {
        }
        return this.listLogging[pos];
    }

    public void addConsoleMessage(T msg) {
        if (this._pause) {
            return;
        }
        this._queue.push(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTextInThread(final T message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MXConsoleModel.this.addTextInThread(message);
                }
            });
            return;
        }
        boolean eventRemoved = false;
        boolean eventAdded = false;
        this.listLogging[this.indexTo++] = message;
        if (this.indexTo >= this.listLogging.length) {
            this.indexTo -= this.listLogging.length;
        }
        eventAdded = true;
        if (this.indexTo == this.indexFrom) {
            this.listLogging[this.indexFrom++] = null;
            if (this.indexFrom >= this.listLogging.length) {
                this.indexFrom -= this.listLogging.length;
            }
            eventRemoved = true;
        }
        MXConsoleModel mXConsoleModel = this;
        synchronized (mXConsoleModel) {
            if (eventRemoved) {
                ListDataEvent e = new ListDataEvent(this, 2, 0, 0);
                for (ListDataListener listener : this.listListner) {
                    listener.intervalRemoved(e);
                }
            }
            if (eventAdded) {
                int size = this.getSize();
                ListDataEvent e = new ListDataEvent(this, 1, size - 1, size - 1);
                for (ListDataListener listener : this.listListner) {
                    listener.intervalAdded(e);
                }
            }
            if (this.bind != null && !eventRemoved) {
                this.bind.ensureIndexIsVisible(this.bind.getModel().getSize() - 1);
            }
        }
    }

    @Override
    public synchronized void addListDataListener(ListDataListener l) {
        this.listListner.add(l);
    }

    @Override
    public synchronized void removeListDataListener(ListDataListener l) {
        this.listListner.remove(l);
    }

    public synchronized void fireRepaint() {
        long tickNow = System.currentTimeMillis();
        if (tickNow - this.lastTick < 1000L) {
            if (this.reserved) {
                return;
            }
            this.reserved = true;
            MXTimer.letsCountdown(1000L - tickNow - this.lastTick, new Runnable(){

                @Override
                public void run() {
                    MXConsoleModel.this.fireImpl();
                }
            });
        } else {
            this.reserved = true;
            this.fireImpl();
        }
    }

    protected synchronized void fireImpl() {
        if (this.reserved) {
            this.lastTick = System.currentTimeMillis();
            this.reserved = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ListDataEvent e = new ListDataEvent(this, 0, 0, MXConsoleModel.this.getSize());
                    for (ListDataListener listener : MXConsoleModel.this.listListner) {
                        listener.contentsChanged(e);
                    }
                }
            });
        }
    }
}

