/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class MXLineReader {
    InputStream _in;
    String _charset;
    byte[] _buffer;
    int _pos;
    int _bufferSize;

    public MXLineReader(InputStream in) {
        this(in, "utf-8");
    }

    public MXLineReader(InputStream in, String charset) {
        this._in = in;
        this._charset = charset;
        this._buffer = new byte[4096];
        this._pos = 0;
        this._bufferSize = 0;
    }

    protected boolean fetchIfNeed() throws IOException {
        if (this._pos >= this._bufferSize) {
            int newSize = this._in.read(this._buffer, 0, this._buffer.length);
            if (newSize <= 0) {
                return false;
            }
            this._bufferSize = newSize;
            this._pos = 0;
        }
        return true;
    }

    public String readLine() throws IOException {
        byte[] line = new byte[256];
        int x = 0;
        while (this._pos < this._bufferSize || this.fetchIfNeed()) {
            byte ch;
            if ((ch = this._buffer[this._pos++]) == 13) continue;
            if (ch == 10) break;
            line[x++] = ch;
            if (x < line.length) continue;
            byte[] newLine = new byte[line.length * 2];
            System.arraycopy(line, 0, newLine, 0, line.length);
            line = newLine;
        }
        if (x == 0 && this._pos >= this._bufferSize) {
            return null;
        }
        String text = new String(line, 0, x, "ASCII");
        try {
            if (text.startsWith("#charset=")) {
                try {
                    String newCharset = text.substring(9);
                    Charset.forName(newCharset);
                    this._charset = newCharset;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            text = new String(line, 0, x, this._charset);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }
}

