/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MXDOMElement {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXDOMElement.class);
    MXDOMElement _parent;
    String _nodeName;
    String _text;
    List<String> _nodePath;
    MXWrapList<MXDOMElement> _childElements;
    MXWrapList<String> _attributes;
    public int _userDataType;
    public Object _userData;

    public MXDOMElement(MXDOMElement parent, Element element) {
        this._parent = parent;
        this._childElements = new MXWrapList();
        this._attributes = new MXWrapList();
        this._attributes.setIgnoreCase(true);
        this._nodeName = element.getNodeName();
        ArrayList<String> nodePath = new ArrayList<String>();
        nodePath.add(element.getNodeName());
        for (Node seek = element.getParentNode(); seek != null; seek = seek.getParentNode()) {
            if (seek.getNodeName().startsWith("#")) continue;
            nodePath.add(0, seek.getNodeName());
        }
        this._nodePath = Collections.unmodifiableList(nodePath);
        NodeList list = element.getChildNodes();
        for (int x = 0; x < list.getLength(); ++x) {
            String text1;
            Node node = list.item(x);
            if (node.getNodeType() == 1) {
                this._childElements.addNameAndValue(node.getNodeName(), new MXDOMElement(this, (Element)node));
            }
            if (node.getNodeType() != 3 || (text1 = MXDOMElement.shrinkSpace(node.getNodeValue())) == null) continue;
            this._text = text1;
        }
        NamedNodeMap fusion = element.getAttributes();
        for (int x = 0; x < fusion.getLength(); ++x) {
            Node n = fusion.item(x);
            String name = n.getNodeName();
            String value = n.getNodeValue();
            if ((value = MXDOMElement.shrinkSpace(value)) != null && value.length() == 0) {
                value = null;
            }
            this._attributes.addNameAndValue(name, value);
        }
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public List<String> getNodePath() {
        return this._nodePath;
    }

    public static MXDOMElement fromDocument(Document doc) {
        return new MXDOMElement(null, doc.getDocumentElement());
    }

    public static MXDOMElement fromFile(File file) throws SAXException {
        Document document;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            return null;
        }
        try {
            document = builder.parse(file);
        }
        catch (SAXException ex) {
            throw ex;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        MXDOMElement docElement = MXDOMElement.fromDocument(document);
        return docElement;
    }

    public MXDOMElement getParentNode() {
        return this._parent;
    }

    public List<MXDOMElement> getChildElements() {
        return this._childElements.valueList();
    }

    public List<MXDOMElement> getChildElements(String name) {
        ArrayList<MXDOMElement> list = new ArrayList<MXDOMElement>();
        for (MXWrap mXWrap : this._childElements) {
            if (!name.equals(((MXDOMElement)mXWrap.value).getNodeName())) continue;
            list.add((MXDOMElement)mXWrap.value);
        }
        return list;
    }

    public String getText() {
        return this._text;
    }

    public int countAttributes() {
        return this._attributes.size();
    }

    public String getAttributeName(int x) {
        return this._attributes.nameOfIndex(x);
    }

    public String getAttributeValue(int x) {
        return this._attributes.valueOfIndex(x);
    }

    public String getAttributeValue(String name) {
        return this._attributes.valueOfName(name);
    }

    public MXWrapList<String> getAttributesMap() {
        return this._attributes;
    }

    public static String shrinkSpace(String original) {
        if (original == null) {
            return null;
        }
        StringBuffer text = new StringBuffer(original);
        while (text.length() > 0) {
            char c = text.charAt(0);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                text.deleteCharAt(0);
                continue;
            }
            c = text.charAt(text.length() - 1);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    public static void main(String[] args) throws Exception {
        MXDOMElement rootElement;
        PrintStream console = System.out;
        MXDebugConsole.globalSwitchOn();
        MXDOMElement docElement = rootElement = MXDOMElement.fromFile(new File("C:/Domino144/Module/GMLevel1.xml"));
        ArrayList<MXDOMElement> process = new ArrayList<MXDOMElement>();
        process.add(docElement);
        if (docElement.countAttributes() > 0) {
            console.print("{");
            for (int i = 0; i < docElement.countAttributes(); ++i) {
                String name = docElement.getAttributeName(i);
                String value = docElement.getAttributeValue(i);
                if (i > 0) {
                    console.print(",");
                }
                console.print(name + "=" + value);
            }
            console.print("}");
        }
        while (process.size() > 0) {
            MXDOMElement element = (MXDOMElement)process.remove(process.size() - 1);
            String nodeName = element.getNodeName();
            String text = element.getText();
            List<MXDOMElement> child = element.getChildElements();
            List<String> path = element.getNodePath();
            console.print("<" + path + ">");
            if (text != null && text.length() > 0) {
                console.print("text = " + text);
            }
            if (element.countAttributes() > 0) {
                console.print("{");
                for (int i = 0; i < element.countAttributes(); ++i) {
                    String name = element.getAttributeName(i);
                    String value = element.getAttributeValue(i);
                    if (i > 0) {
                        console.print(",");
                    }
                    console.print(name + "=" + value);
                }
                console.print("}");
            }
            _debug.println();
            if (child.size() <= 0) continue;
            for (int x = child.size() - 1; x >= 0; --x) {
                process.add(child.get(x));
            }
        }
        process.clear();
        process.add(docElement);
        while (process.size() > 0) {
            MXDOMElement e = (MXDOMElement)process.remove(0);
            _debug.println("-" + e.getNodeName());
            List<MXDOMElement> instList = e.getChildElements("InstrumentList");
            while (instList.size() > 0) {
                MXDOMElement inst = instList.remove(0);
                List<MXDOMElement> mapList = inst.getChildElements("Map");
                while (mapList.size() > 0) {
                    MXDOMElement map = mapList.remove(0);
                    List<MXDOMElement> listPC = map.getChildElements("PC");
                    while (listPC.size() > 0) {
                        MXDOMElement pc = listPC.remove(0);
                        _debug.println(pc.getNodeName() + "=" + pc.getText() + pc.getAttributesMap());
                        List<MXDOMElement> listBank = pc.getChildElements("Bank");
                        while (listBank.size() > 0) {
                            MXDOMElement bank = listBank.remove(0);
                            _debug.println(bank.getNodeName() + "=" + bank.getText() + bank.getAttributesMap());
                        }
                    }
                }
            }
        }
    }

    public void dump(PrintStream console) {
        ArrayList<MXDOMElement> process = new ArrayList<MXDOMElement>();
        MXDOMElement e = this;
        process.add(e);
        if (e.countAttributes() > 0) {
            console.print("{");
            for (int i = 0; i < e.countAttributes(); ++i) {
                String name = e.getAttributeName(i);
                String value = e.getAttributeValue(i);
                if (i > 0) {
                    console.print(",");
                }
                console.print(name + "=" + value);
            }
            console.print("}");
        }
        while (process.size() > 0) {
            MXDOMElement element = (MXDOMElement)process.remove(process.size() - 1);
            String nodeName = element.getNodeName();
            String text = element.getText();
            List<MXDOMElement> child = element.getChildElements();
            List<String> path = element.getNodePath();
            console.print("<" + path + ">");
            if (text != null && text.length() > 0) {
                console.print("text = " + text);
            }
            if (element.countAttributes() > 0) {
                console.print("{");
                for (int i = 0; i < element.countAttributes(); ++i) {
                    String name = element.getAttributeName(i);
                    String value = element.getAttributeValue(i);
                    if (i > 0) {
                        console.print(",");
                    }
                    console.print(name + "=" + value);
                }
                console.print("}");
            }
            _debug.println();
            if (child.size() <= 0) continue;
            for (int x = child.size() - 1; x >= 0; --x) {
                process.add(child.get(x));
            }
        }
        _debug.println("-------------------------");
        process.clear();
        process.add(e);
        while (process.size() > 0) {
            e = (MXDOMElement)process.remove(0);
            _debug.println("-" + e.getNodeName());
            List<MXDOMElement> instList = e.getChildElements("InstrumentList");
            while (instList.size() > 0) {
                MXDOMElement inst = instList.remove(0);
                List<MXDOMElement> mapList = inst.getChildElements("Map");
                while (mapList.size() > 0) {
                    MXDOMElement map = mapList.remove(0);
                    List<MXDOMElement> listPC = map.getChildElements("PC");
                    while (listPC.size() > 0) {
                        MXDOMElement pc = listPC.remove(0);
                        _debug.println(pc.getNodeName() + "=[" + pc.getText() + "]" + pc.getAttributesMap());
                        List<MXDOMElement> listBank = pc.getChildElements("Bank");
                        while (listBank.size() > 0) {
                            MXDOMElement bank = listBank.remove(0);
                            _debug.println("    " + bank.getNodeName() + "=[" + bank.getText() + "]" + bank.getAttributesMap());
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        return this._nodePath.toString();
    }
}

