/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.windows;

import jp.synthtarou.midimixer.libs.common.async.TransactionBox;
import jp.synthtarou.midimixer.mx80vst.MX80Process;

public class MXLIB02VST3 {
    static MXLIB02VST3 _instance = new MXLIB02VST3();
    private boolean _loaded = false;

    public static MXLIB02VST3 getInstance() {
        return _instance;
    }

    protected MXLIB02VST3() {
        try {
            System.loadLibrary("MXLIB02");
            this._loaded = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isUsable() {
        return this._loaded;
    }

    public native int countStream();

    public native void postInitializeStream(int var1);

    public native void postOpenStream(int var1, int var2, int var3, int var4);

    public native void postCloseStream(int var1);

    public native boolean isStreamOpen();

    public native String nameOfStream(int var1);

    public native String typeNameOfStream(int var1);

    public native void postLaunchVST(boolean var1, int var2, String var3, int var4);

    public native boolean isLaunchedVST(boolean var1, int var2);

    public native void postOpenEditor(boolean var1, int var2, int var3, int var4);

    public native void postCloseEditor(boolean var1, int var2, int var3);

    public native boolean isEditorOpen(boolean var1, int var2);

    public native boolean isBlackListed(boolean var1, int var2);

    public native void postRemoveSynth(boolean var1, int var2, int var3);

    public native void savePreset(boolean var1, int var2, String var3, int var4);

    public native void loadPreset(boolean var1, int var2, String var3, int var4);

    public native void waitQueued(int var1);

    public native boolean postShortMessage(boolean var1, int var2, int var3);

    public native boolean postLongMessage(boolean var1, int var2, byte[] var3);

    public native float getMasterVolume();

    public native void setMasterVolume(float var1);

    public native int getBusCount(boolean var1, int var2);

    public native float getBusVolume(boolean var1, int var2, int var3);

    public native void setBusVolume(boolean var1, int var2, int var3, float var4);

    public native float getInsertBalance(int var1);

    public native void setInsertBalance(int var1, float var2);

    public native float getAuxSend(int var1);

    public native void setAuxSend(int var1, float var2);

    public native void stopEngine(int var1);

    private static void cbCallText(String text) {
        System.out.println("VST-[" + text.toString() + "]");
    }

    private static void cbBlackListed(boolean effect, int port) {
        MX80Process vstProcess = MX80Process.getInstance();
        vstProcess.addBlackList(effect, port);
    }

    private static void cbTaskDone(int id, int result) {
        TransactionBox.getInstance().callmeWhenFinished(id, result);
    }

    public int firstStreamTypedIndex(String seekType) {
        int count = this.countStream();
        System.out.println(count);
        int found = -1;
        System.out.println("Searching in " + count);
        for (int i = 0; i < count; ++i) {
            String name = this.nameOfStream(i);
            String typeName = this.typeNameOfStream(i);
            if (!typeName.startsWith(seekType) || found >= 0) continue;
            found = i;
        }
        return found;
    }

    public int firstAsioIndex() {
        int asio = this.firstStreamTypedIndex("ASIO");
        if (asio < 0) {
            return this.firstDirectXIndex();
        }
        System.out.println("First ASIO = " + asio);
        return asio;
    }

    public int firstDirectXIndex() {
        int directx = this.firstStreamTypedIndex("Windows DirectSound");
        System.out.println("First Windows DirectSound = " + directx);
        return directx;
    }

    public void main2(String[] args) {
        try {
            if (!this.isUsable()) {
                MXLIB02VST3.cbCallText("Dll Not Standby");
                return;
            }
            MXLIB02VST3.cbCallText("Dll Okay");
            String uniPath = "C:/Program Files/Common Files/VST3/KORG/M1.vst3";
            this.postInitializeStream(0);
            this.waitQueued(0);
            this.postOpenStream(this.firstAsioIndex(), 44100, 1024, 0);
            this.waitQueued(0);
            System.out.println("stream open = " + this.isStreamOpen());
            if (!this.isStreamOpen()) {
                return;
            }
            String path = "C:\\github\\MXLIB01\\x64\\Debug\\VSTSTATE.BIN";
            int synth0 = 0;
            this.postLaunchVST(false, synth0, uniPath, 0);
            System.out.println("postLaunchVST " + synth0);
            this.postOpenEditor(false, synth0, 1, 0);
            this.waitQueued(2);
            Thread.sleep(7000L);
            this.savePreset(false, synth0, path, 8);
            int synth1 = 1;
            this.postLaunchVST(false, synth1, uniPath, 9);
            this.postOpenEditor(false, synth1, 10, 0);
            this.waitQueued(11);
            Thread.sleep(1000L);
            this.loadPreset(false, synth1, path, 12);
            Thread.sleep(5000L);
            this.postCloseEditor(false, synth1, 13);
            this.postOpenEditor(false, synth1, 14, 0);
            this.postCloseEditor(false, synth1, 15);
            this.postOpenEditor(false, synth1, 16, 0);
            this.waitQueued(17);
            Thread.sleep(1000L);
            this.postRemoveSynth(false, synth0, 0);
            this.postRemoveSynth(false, synth1, 0);
            this.postCloseStream(0);
            this.waitQueued(0);
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

