/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx80vst;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.common.async.Transaction;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOut;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOutManager;
import jp.synthtarou.midimixer.libs.vst.IndexedFile;
import jp.synthtarou.midimixer.libs.vst.MXPresetAction;
import jp.synthtarou.midimixer.libs.vst.MXPresetPanel;
import jp.synthtarou.midimixer.libs.vst.VSTInstance;
import jp.synthtarou.midimixer.libs.vst.VSTStream;
import jp.synthtarou.midimixer.mx80vst.MX80Panel;
import jp.synthtarou.midimixer.mx80vst.MX80Process;
import jp.synthtarou.midimixer.mx80vst.VSTVolume;

public class VSTInstancePanel
extends JPanel {
    VSTInstance _instance;
    MX80Panel _parent;
    boolean _initDone = false;
    Transaction _loadHandler = new Transaction("loadHandler"){

        @Override
        public void run() {
            if (VSTInstancePanel.this._instance.getPath() == null || VSTInstancePanel.this._instance.getPath().isEmpty()) {
                VSTInstancePanel.this.jLabelName.setText("-");
                VSTInstancePanel.this.jLabelName.setToolTipText("-");
                VSTInstancePanel.this.jButtonLoad.setText("Open By Navi");
                VSTInstancePanel.this.jButtonLoad.setEnabled(true);
                VSTInstancePanel.this._editorHandler.run();
                VSTInstancePanel.this.jButtonLaunch.setEnabled(false);
                VSTInstancePanel.this.jButtonEdit.setEnabled(false);
                VSTInstancePanel.this.jButtonPreset.setEnabled(false);
            } else {
                VSTInstancePanel.this.jLabelName.setText(VSTInstancePanel.this._instance.getName());
                VSTInstancePanel.this.jLabelName.setToolTipText(VSTInstancePanel.this._instance.getPath());
                VSTInstancePanel.this.jButtonLoad.setText("Bye For Now");
                VSTInstancePanel.this.jButtonLoad.setEnabled(true);
                if (VSTInstancePanel.this._instance.isOpen()) {
                    VSTInstancePanel.this.jButtonLaunch.setEnabled(true);
                    VSTInstancePanel.this.jButtonLaunch.setText("Close");
                    VSTInstancePanel.this.jButtonEdit.setEnabled(true);
                    VSTInstancePanel.this.jButtonPreset.setEnabled(true);
                } else {
                    VSTInstancePanel.this.jButtonLaunch.setEnabled(true);
                    VSTInstancePanel.this.jButtonLaunch.setText("Load");
                    VSTInstancePanel.this.jButtonEdit.setEnabled(false);
                    VSTInstancePanel.this.jButtonPreset.setEnabled(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VSTInstancePanel.this.jPanelVolume.removeAll();
                            VSTInstancePanel.this.jPanelVolume.updateUI();
                        }
                    });
                }
                VSTInstancePanel.this._editorHandler.run();
            }
            VSTInstancePanel.this.createVolumePanel();
            if (VSTInstancePanel.this._parent != null) {
                VSTInstancePanel.this._parent.onResizeSynth();
            }
        }
    };
    Transaction _editorHandler = new Transaction("editorHandler"){

        @Override
        public void run() {
            if (!VSTInstancePanel.this._instance.isOpen()) {
                VSTInstancePanel.this.jButtonEdit.setEnabled(false);
                VSTInstancePanel.this.jButtonEdit.setText("Editor");
                VSTInstancePanel.this.jButtonPreset.setEnabled(false);
            } else {
                VSTInstancePanel.this.jButtonEdit.setEnabled(true);
                VSTInstancePanel.this.jButtonPreset.setEnabled(true);
                if (VSTInstancePanel.this._instance.isEditorOpen()) {
                    VSTInstancePanel.this.jButtonEdit.setText("Close Editor");
                } else {
                    VSTInstancePanel.this.jButtonEdit.setText("Editor");
                }
            }
        }
    };
    private JButton jButtonEdit;
    private JButton jButtonLaunch;
    private JButton jButtonLoad;
    private JButton jButtonPreset;
    private JLabel jLabelInsert;
    private JLabel jLabelName;
    private JLabel jLabelSend;
    private JPanel jPanelVolume;
    private JSlider jSliderInsert;
    private JSlider jSliderSend;

    public void setParent(MX80Panel parent) {
        this._parent = parent;
    }

    public void noticeBlackListed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int opt = JOptionPane.showConfirmDialog(VSTInstancePanel.this, "Do you want to try Reload?", "BlackListed by Exception", 0);
                if (opt == 0) {
                    VSTInstancePanel.this.enterCloseVST();
                    VSTInstancePanel.this.enterOpenVST();
                } else {
                    VSTInstancePanel.this.enterCloseVST();
                }
            }
        });
    }

    public VSTInstancePanel(VSTInstance vst) {
        this.initComponents();
        this._instance = vst;
        this.jLabelName.setText(this._instance.getName());
        this.jLabelName.setToolTipText(this._instance.getPath());
        this._loadHandler.run();
        if (vst.isEffect()) {
            char ch = (char)(65 + vst.getSlot());
            String slot = "Effect " + Character.toString(ch);
            slot = vst.getSlot() == 0 ? slot + ":Insert" : slot + ":Aux Send";
            this.setBorder(BorderFactory.createTitledBorder(slot));
        } else {
            char ch = (char)(65 + vst.getSlot());
            String slot = "Slot " + Character.toString(ch);
            this.setBorder(BorderFactory.createTitledBorder(slot));
        }
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jButtonLoad = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonLaunch = new JButton();
        this.jButtonPreset = new JButton();
        this.jPanelVolume = new JPanel();
        this.jLabelSend = new JLabel();
        this.jSliderSend = new JSlider();
        this.jSliderInsert = new JSlider();
        this.jLabelInsert = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder("Slot 1"));
        this.setLayout(new GridBagLayout());
        this.jLabelName.setText("Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.add((Component)this.jLabelName, gridBagConstraints);
        this.jButtonLoad.setText("from Navi");
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSTInstancePanel.this.jButtonLoadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jButtonLoad, gridBagConstraints);
        this.jButtonEdit.setText("Editor");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSTInstancePanel.this.jButtonEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButtonEdit, gridBagConstraints);
        this.jButtonLaunch.setText("Launch");
        this.jButtonLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSTInstancePanel.this.jButtonLaunchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jButtonLaunch, gridBagConstraints);
        this.jButtonPreset.setText("Preset");
        this.jButtonPreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSTInstancePanel.this.jButtonPresetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jButtonPreset, gridBagConstraints);
        this.jPanelVolume.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanelVolume, gridBagConstraints);
        this.jLabelSend.setText("Insert Bal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelSend, gridBagConstraints);
        this.jSliderSend.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VSTInstancePanel.this.jSliderSendStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jSliderSend, gridBagConstraints);
        this.jSliderInsert.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VSTInstancePanel.this.jSliderInsertStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jSliderInsert, gridBagConstraints);
        this.jLabelInsert.setText("Aux Send");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelInsert, gridBagConstraints);
    }

    public void enterGoodbyeVST() {
        int opt = JOptionPane.showConfirmDialog(this, "Do you want to bye VST[" + this._instance.getName() + "] for Now?", "Confirm", 2);
        if (opt == 0) {
            this.jButtonLoad.setEnabled(false);
            this._instance.setPath(null);
            this._instance.postCloseVST(this._loadHandler.copyWithNewTicket("postCloseVST"));
            File file = VSTInstance.getTotalRecallSetting(this._instance.isEffect(), this._instance.getSlot());
            file.delete();
        }
    }

    public void enterSetVST(File file) {
        this.jButtonLaunch.setEnabled(false);
        this.jButtonLoad.setEnabled(false);
        this._instance.setPath(file.getPath());
        this.enterOpenVST();
    }

    public void enterOpenVST() {
        this.jButtonLaunch.setEnabled(false);
        MX80Process process = MX80Process.getInstance();
        this._instance.postLaunchVST(this._loadHandler.copyWithNewTicket("enterOpenVST"));
    }

    public void enterCloseVST() {
        this.jButtonLaunch.setEnabled(false);
        this._instance.postCloseEditor(this._editorHandler.copyWithNewTicket("postCloseEditor"));
        this._instance.postCloseVST(this._loadHandler.copyWithNewTicket("postCloseVSTi"));
    }

    public void enterOpenEditor() {
        this.jButtonEdit.setEnabled(false);
        this._instance.postOpenEditor(this._editorHandler.copyWithNewTicket("postOpenEditor"), this._editorHandler.copyWithNewTicket("postOpenEditor#close"));
    }

    public void enterCloseEditor() {
        this.jButtonEdit.setEnabled(false);
        this._instance.postCloseEditor(this._editorHandler.copyWithNewTicket("postCloseEditor"));
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        if (this._instance.getPath() != null && this._instance.getPath().length() > 0) {
            this.enterGoodbyeVST();
            return;
        }
        File file = this._parent.getSelectedFileAsVST();
        if (file != null && file.exists()) {
            this.enterSetVST(file);
            if (!VSTStream.getInstance().isOpen()) {
                JOptionPane.showMessageDialog(this, "Please Open Steram too", "Notice", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Select VST from Left Navigateion", "Message", 0);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this._instance.isEditorOpen()) {
            this.enterCloseEditor();
        } else {
            this.enterOpenEditor();
        }
    }

    private void jButtonLaunchActionPerformed(ActionEvent evt) {
        if (this._instance.isOpen()) {
            Transaction tr = new Transaction("closeVST - preset");
            this._instance.postSavePreset(VSTInstance.getTotalRecallSetting(this._instance.isEffect(), this._instance.getSlot()).getPath(), tr);
            this.enterCloseVST();
        } else {
            this.enterOpenVST();
            Transaction tr = new Transaction("openVST - preset");
            File file = VSTInstance.getTotalRecallSetting(this._instance.isEffect(), this._instance.getSlot());
            if (file.exists() && file.isFile()) {
                this._instance.postLoadPreset(file.getPath(), tr);
            }
            if (!this._instance.isEffect()) {
                MXWrapList<MXMIDIOut> list = MXMIDIOutManager.getManager().listSelectedOutput();
                MXMIDIOut found = null;
                for (int i = 0; i < list.getSize(); ++i) {
                    int x;
                    MXMIDIOut out = list.valueOfIndex(i);
                    if (!out.isDriverTypeVSTi() || (x = out.getVStiDriverNumber()) != this._instance.getSlot()) continue;
                    found = out;
                    break;
                }
                if (found == null) {
                    JOptionPane.showMessageDialog(this, "Not Assigned @ Output Tab", "Please Assign", 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonPresetActionPerformed(ActionEvent evt) {
        IndexedFile root = VSTInstance.getGlobalSetting(this._instance.getPath());
        if (!root.getLock()) {
            JOptionPane.showMessageDialog(this, "Can't occupation", "Error", 0);
            return;
        }
        try {
            MXPresetPanel panel = new MXPresetPanel(root, new MXPresetAction(){

                @Override
                public boolean presetActionSave(File file) {
                    if (file != null) {
                        Transaction tr = new Transaction("presetActinoSave");
                        VSTInstancePanel.this._instance.postSavePreset(file.getPath(), tr);
                        return tr.awaitResult() == 0;
                    }
                    return false;
                }

                @Override
                public boolean presetActionLoad(File file) {
                    if (file != null && file.exists()) {
                        Transaction tr = new Transaction("presetActionLoad");
                        VSTInstancePanel.this._instance.postLoadPreset(file.getPath(), tr);
                        return tr.awaitResult() == 0;
                    }
                    return false;
                }
            });
            MXUtil.showAsDialog(this, panel, "Preset for Slot " + this._instance.getSlot());
        }
        finally {
            root.releaseLock();
        }
    }

    private void jSliderInsertStateChanged(ChangeEvent evt) {
        if (this._initDone) {
            this._instance.setInsertBalance(this.jSliderInsert.getValue());
        }
    }

    private void jSliderSendStateChanged(ChangeEvent evt) {
        if (this._initDone) {
            this._instance.setAuxSend(this.jSliderSend.getValue());
        }
    }

    public boolean isOpen() {
        return this._instance.isOpen();
    }

    public void createVolumePanel() {
        if (this._instance.isEffect()) {
            this.jLabelSend.setVisible(false);
            this.jLabelInsert.setVisible(false);
            this.jSliderSend.setVisible(false);
            this.jSliderInsert.setVisible(false);
            return;
        }
        this._initDone = false;
        this.jPanelVolume.removeAll();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int count = this._instance.getBusCount();
        int contents = 0;
        if (!this._instance.isOpen()) {
            count = 0;
        }
        for (int bus = 0; bus < count; ++bus) {
            if (bus % 8 == 0) {
                this.jPanelVolume.add(panel);
                panel.updateUI();
                panel.setBorder(null);
                panel = new JPanel();
                contents = 0;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = bus;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            VSTVolume slider = new VSTVolume(this._instance, bus);
            panel.add((Component)slider, gridBagConstraints);
            ++contents;
        }
        if (contents > 0) {
            this.jPanelVolume.add(panel);
            panel.updateUI();
        }
        if (this._instance.getPath() == null) {
            this.jSliderInsert.setEnabled(false);
            this.jSliderSend.setEnabled(false);
        } else {
            this.jSliderInsert.setEnabled(true);
            this.jSliderInsert.setMinimum(0);
            this.jSliderInsert.setMaximum(127);
            this.jSliderInsert.setValue(this._instance.getInsertBalanace());
            this.jSliderSend.setEnabled(true);
            this.jSliderSend.setMinimum(0);
            this.jSliderSend.setMaximum(127);
            this.jSliderSend.setValue(this._instance.getAuxSend());
        }
        this._initDone = true;
    }

    public void onResize(int width) {
        boolean debug = false;
        this.setMinimumSize(new Dimension(width - 5, 100));
        this.setMaximumSize(null);
        Dimension temp = new Dimension(width - 5, 800);
        this.setPreferredSize(temp);
        if (debug) {
            System.out.println("width = " + width + " debug size " + this.jPanelVolume.getSize());
        }
        int maxy = 10;
        for (int i = 0; i < this.jPanelVolume.getComponentCount(); ++i) {
            Component c = this.jPanelVolume.getComponent(i);
            int y = c.getHeight() + c.getY();
            if (maxy >= y) continue;
            maxy = y;
        }
        int thisy = maxy + this.jButtonEdit.getY() + this.jButtonEdit.getHeight() + 3;
        Dimension min = new Dimension(100, maxy);
        Dimension thismin = new Dimension(100, thisy);
        this.jPanelVolume.setMinimumSize(min);
        this.setMinimumSize(thismin);
        Dimension max = new Dimension(width, maxy);
        Dimension thismax = new Dimension(width, thisy);
        this.jPanelVolume.setPreferredSize(max);
        this.setPreferredSize(thismax);
        if (debug) {
            System.out.println("onResize min " + min);
            System.out.println("onResize min " + max);
        }
        this.updateUI();
    }
}

