/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx80vst;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.common.async.Transaction;
import jp.synthtarou.midimixer.libs.swing.MXSliderUIForTablet;
import jp.synthtarou.midimixer.libs.vst.VSTFolder;
import jp.synthtarou.midimixer.libs.vst.VSTInstance;
import jp.synthtarou.midimixer.libs.vst.VSTStream;
import jp.synthtarou.midimixer.mx80vst.FolderBrowser;
import jp.synthtarou.midimixer.mx80vst.MX80Process;
import jp.synthtarou.midimixer.mx80vst.VSTInstancePanel;
import jp.synthtarou.midimixer.windows.MXLIB02VST3;

public class MX80Panel
extends JPanel {
    static MX80Panel _instance = new MX80Panel();
    boolean _initDone = false;
    MXWrapList<Integer> _streamModel;
    MXWrapList<Integer> _sampleRateModel;
    MXWrapList<Integer> _latencyModel;
    Transaction streamHandler = new Transaction("streamHandler"){

        @Override
        public void run() {
            VSTStream stream = VSTStream.getInstance();
            if (stream.isOpen()) {
                MX80Panel.this.jComboBoxStream.setEnabled(false);
                MX80Panel.this.jComboBoxSampleRate.setEnabled(false);
                MX80Panel.this.jComboBoxLatency.setEnabled(false);
                MX80Panel.this.jButtonOpenStream.setText("Close Stream");
            } else {
                MX80Panel.this.jComboBoxStream.setEnabled(true);
                MX80Panel.this.jComboBoxSampleRate.setEnabled(true);
                MX80Panel.this.jComboBoxLatency.setEnabled(true);
                MX80Panel.this.jButtonOpenStream.setText("Open Stream");
            }
            MX80Panel.this.jButtonOpenStream.setEnabled(true);
        }
    };
    private JButton jButton1;
    private JButton jButtonAddRoot;
    private JButton jButtonAddSkip;
    private JButton jButtonAddSkipBrowse;
    private JButton jButtonOpenStream;
    private JButton jButtonRemoveRoot;
    private JButton jButtonRemoveSkip;
    private JButton jButtonStartQuickScan;
    private JButton jButtonStartRescan;
    private JComboBox<String> jComboBoxLatency;
    private JComboBox<String> jComboBoxSampleRate;
    private JComboBox<String> jComboBoxStream;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelDirectory;
    private JLabel jLabelSpacer;
    private JList<String> jListSkip;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelEffectsContainer;
    private JPanel jPanelSynths;
    private JPanel jPanelSynthsContainer;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPaneSynthContainer;
    private JSlider jSliderMasterVolume;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane3;
    private JTree jTreeMain;
    MX80Process.Callback _callback = new MX80Process.Callback(){

        @Override
        public void vstScanProgress(String text, long hit, long total) {
            MX80Panel.this.jLabelDirectory.setText("Scan " + text + ", " + hit + " / " + total);
        }

        @Override
        public void vstScanCanceled() {
            MX80Panel.this.jLabelDirectory.setText("Cancelled");
        }

        @Override
        public void vstScanFinished() {
            MX80Panel.this.jLabelDirectory.setText("Done");
            MX80Panel.this.updateMainTree();
        }
    };

    public static synchronized MX80Panel getInstance() {
        return _instance;
    }

    public static void main(String[] args) {
        MX80Panel panel = MX80Panel.getInstance();
        panel.addFilter(new File("C:/Program Files/Common Files/VST3"));
        panel.addFilter(new File("C:/Program Files/Steinberg"));
        MXUtil.showAsDialog(null, panel, "VST Picker");
    }

    MX80Panel() {
        this.initComponents();
        this.updateMainTree();
        this.jListSkip.setModel(this.createSkipListModel());
        this.updateLoadList();
        this.updateEffectList();
        this.jLabelSpacer.setText("");
        VSTStream stream = VSTStream.getInstance();
        this._streamModel = this.createStreamModel();
        this.jComboBoxStream.setModel(this._streamModel);
        this._streamModel.writeComboBox(this.jComboBoxStream, stream.getStream());
        this._latencyModel = this.createLatencyModel();
        this.jComboBoxLatency.setModel(this._latencyModel);
        this._latencyModel.writeComboBox(this.jComboBoxLatency, stream.getBlockSize());
        this._sampleRateModel = this.createSampleRateModel();
        this.jComboBoxSampleRate.setModel(this._sampleRateModel);
        this._sampleRateModel.writeComboBox(this.jComboBoxSampleRate, stream.getSampleRate());
        this.streamHandler.run();
        if (!MXLIB02VST3.getInstance().isUsable()) {
            return;
        }
        float vol1 = MXLIB02VST3.getInstance().getMasterVolume();
        int vol1000 = (int)(vol1 * 1000.0f);
        this.jSliderMasterVolume.setMinimum(0);
        this.jSliderMasterVolume.setMaximum(1000);
        this.jSliderMasterVolume.setValue(vol1000);
        new MXSliderUIForTablet(this.jSliderMasterVolume);
        this._initDone = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container cont = MXUtil.getOwnerWindow(MX80Panel.this);
                if (cont != null && cont instanceof JDialog) {
                    JDialog frame = (JDialog)cont;
                    System.out.println("Install Close Fook");
                    frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            for (VSTInstance vst : MX80Process.getInstance()._listInstrument) {
                                vst.postCloseVST(null).awaitResult();
                            }
                        }

                        @Override
                        public void windowClosed(WindowEvent e) {
                        }
                    });
                }
            }
        });
    }

    MXWrapList<Integer> createStreamModel() {
        MXWrapList<Integer> model = new MXWrapList<Integer>();
        VSTStream stream = VSTStream.getInstance();
        for (int i = 0; i < stream.count(); ++i) {
            if (!stream.getTypeName(i).equals("ASIO")) continue;
            model.addNameAndValue(stream.getName(i), i);
        }
        return model;
    }

    MXWrapList<Integer> createLatencyModel() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        int[] entry = new int[]{128, 256, 512, 1024, 2048, 4096};
        for (int i = 0; i < entry.length; ++i) {
            int x = entry[i];
            list.addNameAndValue(Integer.toString(x) + " samples", x);
        }
        return list;
    }

    MXWrapList<Integer> createSampleRateModel() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        list.addNameAndValue("22.05khz", 22050);
        list.addNameAndValue("44.1khz", 44100);
        list.addNameAndValue("48khz", 48000);
        list.addNameAndValue("88.2khz", 88200);
        list.addNameAndValue("96khz", 96000);
        return list;
    }

    private int readPanelLatency() {
        Integer x = this._latencyModel.readCombobox(this.jComboBoxLatency);
        if (x != null) {
            return x;
        }
        return -1;
    }

    private int readPanelSampleRate() {
        Integer x = this._sampleRateModel.readCombobox(this.jComboBoxSampleRate);
        if (x != null) {
            return x;
        }
        return -1;
    }

    public void openStream(int x, int sampleRate, int blockSize) {
        this.jButtonOpenStream.setEnabled(false);
        this._streamModel.writeComboBox(this.jComboBoxStream, x);
        VSTStream stream = VSTStream.getInstance();
        stream.setStream(x);
        stream.setSampleRate(sampleRate);
        stream.setBlockSize(blockSize);
        stream.postOpenStream(this.streamHandler.copyWithNewTicket("postOpenStream"));
    }

    public void closeStream() {
        this.jButtonOpenStream.setEnabled(false);
        VSTStream stream = VSTStream.getInstance();
        stream.postCloseStream(this.streamHandler.copyWithNewTicket("postCloseStream"));
    }

    public TreeModel createInitialModel(String message) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        node.setUserObject(message);
        root.add(node);
        DefaultTreeModel model = new DefaultTreeModel(root);
        return model;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane3 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTreeMain = new JTree();
        this.jButtonAddRoot = new JButton();
        this.jButtonRemoveRoot = new JButton();
        this.jButtonStartRescan = new JButton();
        this.jButtonStartQuickScan = new JButton();
        this.jPanel1 = new JPanel();
        this.jButtonAddSkip = new JButton();
        this.jButtonAddSkipBrowse = new JButton();
        this.jButtonRemoveSkip = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jListSkip = new JList();
        this.jPanelSynthsContainer = new JPanel();
        this.jScrollPaneSynthContainer = new JScrollPane();
        this.jPanelSynths = new JPanel();
        this.jComboBoxStream = new JComboBox();
        this.jButtonOpenStream = new JButton();
        this.jComboBoxLatency = new JComboBox();
        this.jComboBoxSampleRate = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jSliderMasterVolume = new JSlider();
        this.jPanelEffectsContainer = new JPanel();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabelDirectory = new JLabel();
        this.jLabelSpacer = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MX80Panel.this.jSplitPane1PropertyChange(evt);
            }
        });
        this.jSplitPane3.setDividerLocation(400);
        this.jSplitPane3.setOrientation(0);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("RootList"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jTreeMain);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonAddRoot.setText("Add ...");
        this.jButtonAddRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX80Panel.this.jButtonAddRootActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonAddRoot, gridBagConstraints);
        this.jButtonRemoveRoot.setText("Remove From List");
        this.jButtonRemoveRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX80Panel.this.jButtonRemoveRootActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonRemoveRoot, gridBagConstraints);
        this.jButtonStartRescan.setText("ReScan(EveryFolder)");
        this.jButtonStartRescan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX80Panel.this.jButtonStartRescanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.jPanel2.add((Component)this.jButtonStartRescan, gridBagConstraints);
        this.jButtonStartQuickScan.setText("Scan(OnlyNewFolder)");
        this.jButtonStartQuickScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX80Panel.this.jButtonStartQuickScanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.jPanel2.add((Component)this.jButtonStartQuickScan, gridBagConstraints);
        this.jSplitPane3.setLeftComponent(this.jPanel2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("SkipList"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonAddSkip.setText("Add < Selection");
        this.jButtonAddSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX80Panel.this.jButtonAddSkipActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonAddSkip, gridBagConstraints);
        this.jButtonAddSkipBrowse.setText("Add ...");
        this.jButtonAddSkipBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX80Panel.this.jButtonAddSkipBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonAddSkipBrowse, gridBagConstraints);
        this.jButtonRemoveSkip.setText("Remove From List");
        this.jButtonRemoveSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX80Panel.this.jButtonRemoveSkipActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonRemoveSkip, gridBagConstraints);
        this.jListSkip.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane3.setViewportView(this.jListSkip);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jSplitPane3.setBottomComponent(this.jPanel1);
        this.jSplitPane1.setLeftComponent(this.jSplitPane3);
        this.jPanelSynthsContainer.setBorder(BorderFactory.createTitledBorder("LoadList"));
        this.jPanelSynthsContainer.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MX80Panel.this.jPanelSynthsContainerComponentResized(evt);
            }
        });
        this.jPanelSynthsContainer.setLayout(new GridBagLayout());
        this.jPanelSynths.setLayout(new BoxLayout(this.jPanelSynths, 3));
        this.jScrollPaneSynthContainer.setViewportView(this.jPanelSynths);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelSynthsContainer.add((Component)this.jScrollPaneSynthContainer, gridBagConstraints);
        this.jComboBoxStream.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelSynthsContainer.add(this.jComboBoxStream, gridBagConstraints);
        this.jButtonOpenStream.setText("Open Stream");
        this.jButtonOpenStream.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX80Panel.this.jButtonOpenStreamActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanelSynthsContainer.add((Component)this.jButtonOpenStream, gridBagConstraints);
        this.jComboBoxLatency.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.jPanelSynthsContainer.add(this.jComboBoxLatency, gridBagConstraints);
        this.jComboBoxSampleRate.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanelSynthsContainer.add(this.jComboBoxSampleRate, gridBagConstraints);
        this.jLabel1.setText("MasterVolume");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanelSynthsContainer.add((Component)this.jLabel1, gridBagConstraints);
        this.jSliderMasterVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MX80Panel.this.jSliderMasterVolumeStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelSynthsContainer.add((Component)this.jSliderMasterVolume, gridBagConstraints);
        this.jPanelEffectsContainer.setBorder(BorderFactory.createBevelBorder(0));
        this.jPanelEffectsContainer.setLayout(new BoxLayout(this.jPanelEffectsContainer, 2));
        this.jLabel2.setText("jLabel2");
        this.jPanelEffectsContainer.add(this.jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelSynthsContainer.add((Component)this.jPanelEffectsContainer, gridBagConstraints);
        this.jButton1.setText("Repaint");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX80Panel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        this.jPanelSynthsContainer.add((Component)this.jButton1, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanelSynthsContainer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.jLabelDirectory.setText("......");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabelDirectory, gridBagConstraints);
        this.jLabelSpacer.setText("spacer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabelSpacer, gridBagConstraints);
    }

    private void jButtonStartQuickScanActionPerformed(ActionEvent evt) {
        this.startScanDirectory(true);
    }

    private void jButtonAddRootActionPerformed(ActionEvent evt) {
        FolderBrowser browse = new FolderBrowser();
        browse._onlyDirectory = true;
        MXUtil.showAsDialog(this, browse, "Select and Enter");
        if (browse._result != null) {
            this.addFilter(browse._result);
        }
    }

    private void jButtonRemoveRootActionPerformed(ActionEvent evt) {
        File file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            TreePath path = this.jTreeMain.getSelectionPath();
            if (path != null) {
                System.out.println("pathcount " + path.getPathCount());
                if (path.getPathCount() <= 2) {
                    int opt = JOptionPane.showConfirmDialog(this, "Remove " + file + " from List", "Confirm", 0);
                    if (opt == 0) {
                        this.removeFilter(file);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, file + " is not Root Folder", "Error", 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jButtonAddSkipActionPerformed(ActionEvent evt) {
        File file = this.getSelectedFile();
        if (file != null) {
            try {
                String path = file.getPath();
                if (!MX80Process.getInstance()._listSkip.contains(path)) {
                    this.addSkip(path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void jButtonRemoveSkipActionPerformed(ActionEvent evt) {
        String path;
        int opt;
        int sel = this.jListSkip.getSelectedIndex();
        if (sel >= 0 && (opt = JOptionPane.showConfirmDialog(this, "Remove " + (path = MX80Process.getInstance()._listSkip.get(sel)) + " from SkipList", "Confirm", 0)) == 0) {
            this.removeSkip(path);
        }
    }

    private void jButtonAddSkipBrowseActionPerformed(ActionEvent evt) {
        FolderBrowser browse = new FolderBrowser();
        browse._onlyDirectory = false;
        MXUtil.showAsDialog(this, browse, "Select and Enter");
        if (browse._result != null) {
            try {
                String path = browse._result.getPath();
                if (!MX80Process.getInstance()._listSkip.contains(path)) {
                    this.addSkip(path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void jButtonStartRescanActionPerformed(ActionEvent evt) {
        this.startScanDirectory(false);
    }

    private void jButtonOpenStreamActionPerformed(ActionEvent evt) {
        if (VSTStream.getInstance().isOpen()) {
            this.closeStream();
        } else {
            MX80Process process = MX80Process.getInstance();
            int sel = this._streamModel.readCombobox(this.jComboBoxStream);
            int sampleRate = this._sampleRateModel.readCombobox(this.jComboBoxSampleRate);
            int blockSize = this._latencyModel.readCombobox(this.jComboBoxLatency);
            this.openStream(sel, sampleRate, blockSize);
        }
    }

    private void jSliderMasterVolumeStateChanged(ChangeEvent evt) {
        if (this._initDone) {
            int vol1000 = this.jSliderMasterVolume.getValue();
            float vol1 = (float)vol1000 * 0.001f;
            MXLIB02VST3.getInstance().setMasterVolume(vol1);
        }
    }

    private void jPanelSynthsContainerComponentResized(ComponentEvent evt) {
        this.onResizeSynth();
    }

    private void jSplitPane1PropertyChange(PropertyChangeEvent evt) {
        this.onResizeSynth();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.updateLoadList();
    }

    public File getSelectedFileAsVST() {
        TreePath path = this.jTreeMain.getSelectionPath();
        if (path == null) {
            return null;
        }
        if (path.getPathCount() != 4) {
            return null;
        }
        return this.getSelectedFile();
    }

    public File getSelectedFile() {
        TreePath path = this.jTreeMain.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node == null) {
            return null;
        }
        Object obj = node.getUserObject();
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)node.getParent();
            Object user = root.getUserObject();
            if (user instanceof File) {
                return new File((File)user, (String)obj);
            }
            new Throwable(user.getClass() + "(" + user + ") is not file").printStackTrace();
            return null;
        }
        if (obj instanceof File) {
            return (File)obj;
        }
        new Throwable(obj.getClass() + " unknown type").printStackTrace();
        return null;
    }

    public void addSkip(String path) {
        MX80Process.getInstance()._listSkip.add(path);
        this.updateSkipList();
    }

    public void removeSkip(String path) {
        MX80Process.getInstance()._listSkip.remove(path);
        this.updateSkipList();
    }

    public void addFilter(File file) {
        MX80Process.getInstance().addFolder(file);
        this.updateMainTree();
    }

    public void removeFilter(File file) {
        MX80Process.getInstance().removeFolder(file);
        this.updateMainTree();
    }

    public void startScanDirectory(boolean quick) {
        MX80Process.getInstance()._callback = this._callback;
        MX80Process.getInstance().startScan(quick);
    }

    public void updateMainTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeModel newModel = MX80Panel.this.createFolderTreeModel();
                MX80Panel.this.jTreeMain.setModel(newModel);
                MX80Panel.this.jTreeMain.setRootVisible(false);
                MX80Panel.this.jTreeMain.setCellRenderer(new SystemFilRenderer());
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)newModel.getRoot();
                for (int i = 0; i < rootNode.getChildCount(); ++i) {
                    TreeNode second = rootNode.getChildAt(i);
                    TreePath path = new TreePath(new Object[]{rootNode, second});
                    MX80Panel.this.jTreeMain.expandPath(path);
                }
            }
        });
    }

    public void updateSkipList() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListModel<String> list = MX80Panel.this.createSkipListModel();
                MX80Panel.this.jListSkip.setModel(list);
            }
        });
    }

    public ListModel<String> createSkipListModel() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String path : MX80Process.getInstance()._listSkip) {
            model.addElement(path);
        }
        return model;
    }

    public void updateLoadList() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MX80Panel.this.updateLoadList();
                }
            });
            return;
        }
        this.jPanelSynths.removeAll();
        this.jPanelSynths.setLayout(new GridBagLayout());
        int i = 0;
        while (i < MX80Process.getInstance()._listInstrumentPanel.size()) {
            VSTInstancePanel vstPanel = MX80Process.getInstance()._listInstrumentPanel.get(i);
            GridBagConstraints pos = new GridBagConstraints();
            vstPanel.setParent(this);
            pos.weightx = 1.0;
            pos.weighty = 1.0;
            pos.fill = 1;
            pos.gridx = 0;
            pos.gridy = i++;
            pos.gridwidth = 1;
            pos.gridheight = 1;
            this.jPanelSynths.add((Component)vstPanel, pos);
        }
        this.jPanelSynthsContainer.setBorder(BorderFactory.createEmptyBorder());
        this.jPanelSynthsContainer.setBorder(BorderFactory.createTitledBorder("LoadList"));
    }

    public void updateEffectList() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MX80Panel.this.updateEffectList();
                }
            });
            return;
        }
        this.jPanelEffectsContainer.removeAll();
        for (int i = 0; i < MX80Process.getInstance()._listEffect.size(); ++i) {
            VSTInstancePanel vstPanel = MX80Process.getInstance()._listEffectPanel.get(i);
            vstPanel.setParent(this);
            this.jPanelEffectsContainer.add(vstPanel);
        }
        Dimension size = this.jPanelEffectsContainer.getSize();
        this.jPanelEffectsContainer.setBorder(BorderFactory.createEmptyBorder());
        this.jPanelEffectsContainer.setBorder(BorderFactory.createBevelBorder(0));
    }

    public TreeModel createFolderTreeModel() {
        DefaultMutableTreeNode realRootNode = new DefaultMutableTreeNode("Root");
        for (int i = 0; i < MX80Process.getInstance().countFolder(); ++i) {
            VSTFolder filter = MX80Process.getInstance().getFolder(i);
            File root = filter._rootDirectory;
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(root);
            rootNode.setAllowsChildren(true);
            realRootNode.add(rootNode);
            if (filter.getListResult() == null) continue;
            for (File dir : filter.getListResult().keySet()) {
                DefaultMutableTreeNode dirNode = new DefaultMutableTreeNode(dir);
                dirNode.setAllowsChildren(true);
                if (filter.getListResult() != null && filter.getListResult().size() > 0) {
                    ArrayList<File> children = filter.getListResult().get(dir);
                    for (File file : children) {
                        DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(file);
                        dirNode.add(fileNode);
                        fileNode.setAllowsChildren(false);
                    }
                }
                rootNode.add(dirNode);
            }
        }
        DefaultTreeModel model = new DefaultTreeModel(realRootNode);
        model.setAsksAllowsChildren(true);
        return model;
    }

    public void onResizeSynth() {
        VSTInstancePanel vstPanel;
        int i;
        int width = (int)this.jScrollPaneSynthContainer.getViewport().getViewRect().getWidth();
        this.jScrollPaneSynthContainer.getViewport().setMinimumSize(new Dimension(200, 100));
        Dimension parent = this.getParent().getSize();
        this.jPanelSynths.setMaximumSize(new Dimension(width, 20000));
        for (i = 0; i < MX80Process.getInstance()._listInstrumentPanel.size(); ++i) {
            vstPanel = MX80Process.getInstance()._listInstrumentPanel.get(i);
            vstPanel.onResize(width);
        }
        width = (int)(this.jPanelEffectsContainer.getSize().getWidth() / 2.0 - 2.0);
        for (i = 0; i < MX80Process.getInstance()._listEffect.size(); ++i) {
            vstPanel = MX80Process.getInstance()._listEffectPanel.get(i);
            vstPanel.onResize(width);
        }
    }

    static class SystemFilRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer _defRenderer = new JTree().getCellRenderer();
        private FileSystemView _view = FileSystemView.getFileSystemView();

        SystemFilRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component = this._defRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (!(value instanceof DefaultMutableTreeNode)) {
                return component;
            }
            DefaultMutableTreeNode node = null;
            DefaultMutableTreeNode parentNode = null;
            DefaultMutableTreeNode parentParentNode = null;
            Object user = null;
            Object parent = null;
            Object parentPanrent = null;
            node = (DefaultMutableTreeNode)value;
            user = node.getUserObject();
            if (node != null && (parentNode = (DefaultMutableTreeNode)node.getParent()) != null) {
                parent = parentNode.getUserObject();
            }
            if (parentNode != null && (parentParentNode = (DefaultMutableTreeNode)parentNode.getParent()) != null) {
                parentPanrent = parentParentNode.getUserObject();
            }
            JLabel label = (JLabel)component;
            String name = user.toString();
            Icon icon = null;
            String path = user.toString();
            if (user != null && user instanceof VSTFolder) {
                label.setIcon(icon);
                label.setText(name);
                label.setToolTipText(path);
                return label;
            }
            if (parent != null && parent instanceof VSTFolder) {
                VSTFolder vst = (VSTFolder)parent;
                File folder = vst._rootDirectory;
                File target = (File)user;
                name = VSTFolder.getAsAbsolute(folder, target);
                label.setIcon(icon);
                label.setText(name);
                label.setToolTipText(path);
                return label;
            }
            if (parent != null && parent instanceof File) {
                File folder = (File)parent;
                File target = (File)user;
                name = VSTFolder.getAsAbsolute(folder, target);
                icon = this._view.getSystemIcon(target);
                label.setIcon(icon);
                label.setText(name);
                label.setToolTipText(path);
                return label;
            }
            return label;
        }
    }
}

