/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx80vst;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import jp.synthtarou.midimixer.libs.common.MXUtil;

public class FolderBrowser
extends JPanel {
    FileSystemView _view = FileSystemView.getFileSystemView();
    DefaultTreeModel _model;
    TreeSet<File> _already;
    boolean _onlyDirectory = false;
    File _selection;
    File _result = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel2;
    private JLabel jLabelSelection;
    private JScrollPane jScrollPane1;
    private JTree jTree1;

    public static void main(String[] args) {
        FolderBrowser chooser = new FolderBrowser();
        chooser._onlyDirectory = true;
        MXUtil.showAsDialog(null, chooser, "FolderPicker");
        System.out.println("Return " + chooser._result.getPath());
    }

    public FolderBrowser() {
        this.initComponents();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(null);
        this.fillRoot(node);
        this.jLabel2.setText("");
        this._model = new DefaultTreeModel(node);
        this._model.setAsksAllowsChildren(true);
        this.jTree1.setCellRenderer(new MyRenderer());
        this.jTree1.setRootVisible(false);
        this.jTree1.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                FolderBrowser.this.fillChildren(node);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this.jTree1.setModel(this._model);
        this.jTree1.expandRow(0);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    File f;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    FolderBrowser.this._selection = f = (File)node.getUserObject();
                    FolderBrowser.this.jLabelSelection.setText(f.toString());
                }
            }
        });
        this.jTree1.setRequestFocusEnabled(true);
        this.jTree1.requestFocusInWindow();
        this.jTree1.setSelectionRow(0);
        this.setPreferredSize(new Dimension(500, 300));
    }

    protected void fillRoot(DefaultMutableTreeNode node) {
        if (this._already != null) {
            return;
        }
        this._already = new TreeSet();
        File[] listChild = this._view.getRoots();
        if (listChild != null) {
            for (File c : listChild) {
                DefaultMutableTreeNode cnode = new DefaultMutableTreeNode(c);
                node.add(cnode);
                cnode.setAllowsChildren(true);
            }
            node.setAllowsChildren(true);
        }
    }

    public boolean filterIfNetwork(File f) {
        return f.getPath().startsWith("::") && (f.toString().equals("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af") || f.toString().equalsIgnoreCase("network"));
    }

    public boolean isUsableFile(File target) {
        if (this._onlyDirectory) {
            return target.isDirectory();
        }
        return true;
    }

    protected void fillChildren(DefaultMutableTreeNode node) {
        File file = (File)node.getUserObject();
        if (!this._already.contains(file)) {
            this._already.add(file);
            if (this.filterIfNetwork(file)) {
                return;
            }
            File[] listChild = this._view.getFiles(file, true);
            if (listChild != null) {
                for (File c : listChild) {
                    if (!this.isUsableFile(c)) continue;
                    DefaultMutableTreeNode cnode = new DefaultMutableTreeNode(c);
                    if (c.isDirectory()) {
                        boolean deepThought = true;
                        if (deepThought) {
                            if (this.filterIfNetwork(c)) {
                                cnode.setAllowsChildren(false);
                            } else {
                                File[] seek = c.listFiles();
                                boolean found = false;
                                if (seek != null) {
                                    for (File f : seek) {
                                        if (!this.isUsableFile(f)) continue;
                                        found = true;
                                    }
                                }
                                cnode.setAllowsChildren(found);
                            }
                        } else {
                            cnode.setAllowsChildren(true);
                        }
                    } else {
                        cnode.setAllowsChildren(false);
                    }
                    node.add(cnode);
                }
            }
        }
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelSelection = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jLabel2 = new JLabel();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FolderBrowser.this.formKeyPressed(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.jButtonOK.setText("Enter");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderBrowser.this.jButtonOKActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderBrowser.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jLabelSelection.setText("Please Select 1 From Tree");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jLabelSelection, gridBagConstraints);
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FolderBrowser.this.jTree1MouseClicked(evt);
            }
        });
        this.jTree1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FolderBrowser.this.jTree1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel2.setText("-hide");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabel2, gridBagConstraints);
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setResultAndClose(this._selection);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setResultAndClose(null);
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            // empty if block
        }
    }

    private void jTree1KeyPressed(KeyEvent evt) {
        switch (evt.getExtendedKeyCode()) {
            case 10: {
                this.setResultAndClose(this._selection);
                return;
            }
            case 27: {
                this.setResultAndClose(null);
                return;
            }
        }
    }

    private void formKeyPressed(KeyEvent evt) {
        switch (evt.getExtendedKeyCode()) {
            case 10: {
                this.setResultAndClose(this._selection);
                return;
            }
            case 27: {
                this.setResultAndClose(null);
                return;
            }
        }
    }

    public void setResultAndClose(File result) {
        if (result == null) {
            this._result = null;
        } else {
            if (result.getPath().startsWith("::")) {
                JOptionPane.showMessageDialog(this, "Can't select System Folder", "notice", 0);
                return;
            }
            this._result = result.getAbsoluteFile();
        }
        Container c = MXUtil.getOwnerWindow(this);
        c.setVisible(false);
    }

    static class MyRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer _defRenderer = new JTree().getCellRenderer();
        private FileSystemView _view = FileSystemView.getFileSystemView();

        MyRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object user;
            Component component = this._defRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (user = (node = (DefaultMutableTreeNode)value).getUserObject()) != null && user instanceof File) {
                File file = (File)node.getUserObject();
                JLabel label = (JLabel)component;
                label.setIcon(this._view.getSystemIcon(file));
                label.setText(this._view.getSystemDisplayName(file));
                label.setToolTipText(file.getPath());
            }
            return component;
        }
    }
}

