/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx70console;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.swing.JTextArea;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.MXThreadList;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.port.FinalMIDIOut;
import jp.synthtarou.midimixer.libs.midi.smf.ByteReader;
import jp.synthtarou.midimixer.libs.text.MXLineReader;
import jp.synthtarou.midimixer.mx70console.SysexProgress;

public class SysEXFile {
    ArrayList<byte[]> _contents = new ArrayList();
    public static final int ID_NOTHING = 0;
    public static final int ID_AMERICAN_1 = 1;
    public static final int ID_EUROPEAN_1 = 2;
    public static final int ID_JAPANESE_1 = 3;
    public static final int ID_OTHER_1 = 4;
    public static final int ID_SPECIAL_1 = 5;
    public static final int ID_AMERICAN_3 = 6;
    public static final int ID_EUROPEAN_3 = 7;
    public static final int ID_JAPANESE_3 = 8;
    public static final int ID_OTHER_3 = 9;
    public static final int ID_UNKNOWN_3 = 10;
    public static final String HANDSHAKE_ACK_TEXT = "F0 7E @Device 7F @Packet F7";
    public static final String HANDSHAKE_NAK_TEXT = "F0 7E @Device 7F @Packet F7";
    public static final String HANDSHAKE_CANCEL_TEXT = "F0 7E @Device 7D @Packet F7";
    public static final String HANDSHAKE_WAIT_TEXT = "F0 7E @Device 7C @Packet F7";
    public static final String HANDSHAKE_EOF_TEXT = "F0 7E @Device 7B @Packet F7";
    public int handShakeDevice;
    public int handShakeMessage;
    public int handShakePacket;
    public static final int HANDSHAKE_ACK = 127;
    public static final int HANDSHAKE_NAK = 127;
    public static final int HANDSHAKE_CANCEL = 125;
    public static final int HANDSHAKE_WAIT = 124;
    public static final int HANDSHAKE_EOF = 123;

    public boolean readText(File file) {
        MXLineReader in = null;
        FileInputStream fin = null;
        try {
            String line;
            fin = new FileInputStream(file);
            in = new MXLineReader(fin);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((line = in.readLine()) != null) {
                int num = 0;
                int readed = 0;
                for (int i = 0; i < line.length(); ++i) {
                    char ch = line.charAt(i);
                    if (ch >= '0' && ch <= '9') {
                        num *= 16;
                        num += ch - 48;
                        ++readed;
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        num *= 16;
                        num += ch - 97 + 10;
                        ++readed;
                        continue;
                    }
                    if (ch >= 'A' && ch <= 'F') {
                        num *= 16;
                        num += ch - 65 + 10;
                        ++readed;
                        continue;
                    }
                    if (readed < true) continue;
                    out.write(num);
                    num = 0;
                    readed = 0;
                }
                if (readed < true) continue;
                out.write(num);
                num = 0;
                readed = 0;
            }
            this.setContents(out.toByteArray());
            fin.close();
            fin = null;
            return true;
        }
        catch (IOException ex) {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public boolean readBinary(File file) {
        Object in = null;
        FileInputStream fin = null;
        try {
            int x;
            fin = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] chunk = new byte[256];
            while ((x = fin.read(chunk)) >= 1) {
                out.write(chunk, 0, x);
            }
            this.setContents(out.toByteArray());
            fin.close();
            fin = null;
            return true;
        }
        catch (IOException ex) {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public void setContents(byte[] data) {
        int sig;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ByteReader reader = new ByteReader(in);
        this._contents.clear();
        int error = 0;
        while ((sig = reader.read8()) >= 0) {
            if (sig == 240 || sig == 247) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(sig);
                while ((sig = reader.read8()) >= 0) {
                    out.write(sig);
                    if (sig != 240 && sig != 247) continue;
                }
                byte[] segment = out.toByteArray();
                this._contents.add(segment);
                continue;
            }
            ++error;
        }
    }

    public void add(byte[] data, JTextArea area) {
        this._contents.add(data);
        this.bind(area);
    }

    public void bind(JTextArea area) {
        StringBuffer text = new StringBuffer();
        int count = 1;
        for (byte[] data : this._contents) {
            text.append(count + " = " + data.length + " bytes)\n");
            ++count;
            text.append(MXUtil.dumpHexFF(data));
            text.append("\n");
        }
        area.setEditable(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setText(text.toString());
    }

    public void clear(JTextArea area) {
        this._contents.clear();
        area.setText("");
    }

    public boolean writeText(File file) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter write = new OutputStreamWriter(bout);
            for (byte[] data : this._contents) {
                for (int x = 0; x < data.length; ++x) {
                    String hex = MXUtil.toHexFF(data[x]);
                    if (x != 0) {
                        write.write(" ");
                    }
                    write.write(hex);
                }
                write.write("\n");
            }
            write.flush();
            fout.close();
            return true;
        }
        catch (IOException e) {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                file.delete();
            }
            return false;
        }
    }

    public boolean writeBinary(File file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        try {
            for (byte[] data : this._contents) {
                bout.write(data);
            }
            bout.flush();
            return true;
        }
        catch (IOException e) {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                file.delete();
            }
            return false;
        }
    }

    public void sendTo(final int port, final SysexProgress progress) {
        MXThreadList.newThread("SysEXFile", new Runnable(){

            @Override
            public void run() {
                int count = SysEXFile.this._contents.size();
                int x = 0;
                FinalMIDIOut out = FinalMIDIOut.getInstance();
                for (byte[] data : SysEXFile.this._contents) {
                    progress.progress(x++, count);
                    MXMessage longMessage = MXMessageFactory.fromSysexMessage(port, data[0] & 0xFF, data);
                    MXMain.getMain().messageDispatch(longMessage, out);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
                progress.progress(x, count);
            }
        }).start();
    }

    public int isHandShakeMesage(byte[] data) {
        if (data.length == 6 && data[0] == 240 && data[1] == 126) {
            int device = data[2];
            int message = data[3];
            int packet = data[4];
            if (data[5] == 247) {
                this.handShakeDevice = device;
                this.handShakeMessage = message;
                this.handShakePacket = packet;
                return this.handShakeMessage;
            }
        }
        return -1;
    }

    public boolean isMaybeFinish(byte[] data) {
        return data[data.length - 1] == 247;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseTest1(byte[] data) {
        int x = 0;
        try {
            byte device;
            byte start = data[x++];
            if (start == 240 || start == 247) {
                byte maker1 = data[x++];
                byte maker2 = 0;
                byte maker3 = 0;
                int id = 0;
                if (maker1 >= 1 && maker1 <= 31) {
                    id = 1;
                } else if (maker1 >= 32 && maker1 <= 63) {
                    id = 2;
                } else if (maker1 >= 64 && maker1 <= 95) {
                    id = 3;
                } else if (maker1 >= 96 && maker1 <= 124) {
                    id = 4;
                } else if (maker1 >= 125 && maker1 <= 127) {
                    id = 5;
                } else if (maker1 == 0) {
                    maker2 = data[x++];
                    maker3 = data[x++];
                    if (maker2 >= 1 && maker2 <= 31) {
                        id = 6;
                    } else if (maker2 >= 32 && maker2 <= 63) {
                        id = 7;
                    } else if (maker2 >= 64 && maker2 <= 95) {
                        id = 8;
                    } else if (maker2 >= 96 && maker2 <= 127) {
                        id = 9;
                    }
                } else {
                    maker2 = data[x++];
                    maker3 = data[x++];
                    id = 10;
                }
            }
            if ((device = data[x++]) != 127) return;
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
    }
}

