/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx70console;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.console.ConsoleElement;
import jp.synthtarou.midimixer.libs.console.ConsoleModel;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.MXFileOpenChooser;
import jp.synthtarou.midimixer.mx70console.SysEXFile;
import jp.synthtarou.midimixer.mx70console.SysexProgress;

public class MX70SysexPanel
extends JPanel {
    ConsoleModel _list;
    SysEXFile _file;
    MXWrapList<Integer> _listPort = MXUtilMidi.createPortAssigned(false);
    private JButton jButton5;
    private JButton jButtonClearFile;
    private JButton jButtonClearLog;
    private JButton jButtonCompact;
    private JButton jButtonDumpSysex;
    private JButton jButtonLoadSysex;
    private JButton jButtonSaveSysex;
    private JComboBox<String> jComboBoxPort;
    private JLabel jLabel1;
    private JList<String> jListScan;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTextArea jTextArea1;
    private JToggleButton jToggleButton1;

    public MX70SysexPanel(ConsoleModel sysex) {
        this.initComponents();
        this._list = sysex;
        this._list.bind(this.jListScan);
        this._list._globalSelection = false;
        this._list.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                MX70SysexPanel.this.jListScan.repaint();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                MX70SysexPanel.this.jListScan.repaint();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                MX70SysexPanel.this.jListScan.repaint();
            }
        });
        this._file = new SysEXFile();
        this._file.bind(this.jTextArea1);
        this.setPreferredSize(new Dimension(800, 600));
        this.jComboBoxPort.setModel(this._listPort);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListScan = new JList();
        this.jButtonLoadSysex = new JButton();
        this.jButtonSaveSysex = new JButton();
        this.jButtonDumpSysex = new JButton();
        this.jComboBoxPort = new JComboBox();
        this.jButton5 = new JButton();
        this.jToggleButton1 = new JToggleButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jProgressBar1 = new JProgressBar();
        this.jButtonClearLog = new JButton();
        this.jButtonClearFile = new JButton();
        this.jLabel1 = new JLabel();
        this.jButtonCompact = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jListScan);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonLoadSysex.setText("Load .sysex");
        this.jButtonLoadSysex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70SysexPanel.this.jButtonLoadSysexActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jButtonLoadSysex, gridBagConstraints);
        this.jButtonSaveSysex.setText("Save .sysex");
        this.jButtonSaveSysex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70SysexPanel.this.jButtonSaveSysexActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jButtonSaveSysex, gridBagConstraints);
        this.jButtonDumpSysex.setText("Dump To");
        this.jButtonDumpSysex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70SysexPanel.this.jButtonDumpSysexActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jButtonDumpSysex, gridBagConstraints);
        this.jComboBoxPort.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.jComboBoxPort, gridBagConstraints);
        this.jButton5.setText("This Line To File");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70SysexPanel.this.jButton5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.jButton5, gridBagConstraints);
        this.jToggleButton1.setText("Pause");
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70SysexPanel.this.jToggleButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.jToggleButton1, gridBagConstraints);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jProgressBar1, gridBagConstraints);
        this.jButtonClearLog.setText("ClearLog");
        this.jButtonClearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70SysexPanel.this.jButtonClearLogActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButtonClearLog, gridBagConstraints);
        this.jButtonClearFile.setText("ClearFile");
        this.jButtonClearFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70SysexPanel.this.jButtonClearFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButtonClearFile, gridBagConstraints);
        this.jLabel1.setText("-> UWP will device automatically");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jButtonCompact.setText("Compact");
        this.jButtonCompact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70SysexPanel.this.jButtonCompactActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.jButtonCompact, gridBagConstraints);
    }

    private void jButtonLoadSysexActionPerformed(ActionEvent evt) {
        MXFileOpenChooser chooser = new MXFileOpenChooser();
        chooser.addExtension(".txt", "TEXT");
        chooser.addExtension(".sysex", "SysEX");
        chooser.addExtension(".syx", "SysEX");
        if (chooser.showOpenDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            boolean success = false;
            success = file.getName().toLowerCase().endsWith(".txt") ? this._file.readText(file) : this._file.readBinary(file);
            this._file.bind(this.jTextArea1);
            if (success) {
                JOptionPane.showMessageDialog(this, "Done", "Done Read" + file, 0);
            } else {
                JOptionPane.showMessageDialog(this, "Fail", "Fail Read" + file, 0);
            }
        }
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this._list.switchPause(this.jToggleButton1.isSelected());
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        int index = this.jListScan.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = this._list.getConsoleElement(index);
            switch (e.getType()) {
                case 2: {
                    byte[] data = e.getData();
                    this._file.add(data, this.jTextArea1);
                    break;
                }
                case 3: {
                    byte[] data2 = e.getMessage().getDataBytes();
                    this._file.add(data2, this.jTextArea1);
                }
            }
            this._file.bind(this.jTextArea1);
        }
    }

    private void jButtonSaveSysexActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showSaveDialog(this) == 0) {
            int opt;
            File file = chooser.getSelectedFile();
            String extCheck = file.getName().toLowerCase();
            boolean isText = false;
            isText = extCheck.endsWith(".txt") ? true : (extCheck.endsWith(".sysex") || extCheck.endsWith("syx") ? false : (opt = JOptionPane.showConfirmDialog(this, "Save as Text?", "SYSEX EXPORT", 0)) == 0);
            boolean success = false;
            try {
                success = isText ? this._file.writeText(file) : this._file.writeBinary(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (success) {
                JOptionPane.showMessageDialog(this, "Done", "Done Write " + file, 0);
            } else {
                JOptionPane.showMessageDialog(this, "Error", "Error", 0);
            }
        }
    }

    private void jButtonDumpSysexActionPerformed(ActionEvent evt) {
        Integer port = this._listPort.readCombobox(this.jComboBoxPort);
        if (port != null) {
            this._file.sendTo(port, new SysexProgress(){

                @Override
                public void progress(int pos, int total) {
                    MX70SysexPanel.this.jProgressBar1.setMaximum(total);
                    MX70SysexPanel.this.jProgressBar1.setValue(pos);
                }
            });
        }
    }

    private void jButtonClearLogActionPerformed(ActionEvent evt) {
        this._list.clear();
        this.jListScan.repaint();
    }

    private void jButtonClearFileActionPerformed(ActionEvent evt) {
        this._file.clear(this.jTextArea1);
    }

    private void jButtonCompactActionPerformed(ActionEvent evt) {
        int countf0 = 0;
        int countf7 = 0;
        for (byte[] data : this._file._contents) {
            int ch = data[0] & 0xFF;
            if (ch == 240) {
                ++countf0;
                continue;
            }
            if (ch == 247) {
                if (countf0 == 0) {
                    JOptionPane.showMessageDialog(this, "No header for 0xf7 message");
                    return;
                }
                ++countf7;
                continue;
            }
            JOptionPane.showMessageDialog(this, "Header not 0xf0 or 0xf7");
            return;
        }
        if (countf7 == 0) {
            JOptionPane.showMessageDialog(this, "Any message not start with 0xf7");
            return;
        }
        ArrayList<byte[]> newList = new ArrayList<byte[]>();
        ByteArrayOutputStream cache = new ByteArrayOutputStream();
        for (byte[] data : this._file._contents) {
            int ch = data[0] & 0xFF;
            if (ch == 240) {
                if (cache.size() != 0) {
                    newList.add(cache.toByteArray());
                    cache = new ByteArrayOutputStream();
                }
                cache.write(data, 0, data.length);
                continue;
            }
            if (ch != 247) continue;
            cache.write(data, 1, data.length - 1);
        }
        if (cache.size() != 0) {
            newList.add(cache.toByteArray());
            cache = new ByteArrayOutputStream();
        }
        this._file._contents = newList;
        this._file.bind(this.jTextArea1);
    }
}

