/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx70console;

import jp.synthtarou.midimixer.libs.console.ConsoleElement;
import jp.synthtarou.midimixer.libs.console.ConsoleModel;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx70console.MX70Panel;
import jp.synthtarou.midimixer.mx70console.MX70SysexPanel;

public class MX70Process
implements MXSettingTarget {
    MXSetting _setting;
    MX70Panel _view;
    ConsoleModel _outsideInput = new ConsoleModel();
    ConsoleModel _insideInput = new ConsoleModel();
    ConsoleModel _insideOutput = new ConsoleModel();
    ConsoleModel _outsideOutput = new ConsoleModel();
    ConsoleModel _listBinary = new ConsoleModel();
    MX70SysexPanel _sysex;

    public MX70Process() {
        this._setting = new MXSetting("FreeConsole");
        this._setting.setTarget(this);
    }

    public void readSettings() {
        this._setting.readSettingFile();
    }

    public void createWindow() {
        if (this._view != null && this._view.isOwnerWindowVisible()) {
            return;
        }
        this._view = new MX70Panel(this);
        this._view.showAsWindow();
    }

    public void addOutsideInput(ConsoleElement e) {
        this._outsideInput.add(e);
        e.getTiming().recordWrap(0);
    }

    public void addInsideInput(MXMessage msg) {
        ConsoleElement e = new ConsoleElement(msg);
        this._insideInput.add(e);
        e.getTiming().recordWrap(1);
        if (msg.isBinMessage()) {
            this._listBinary.add(e);
        }
    }

    public void addInsideOutput(MXMessage msg) {
        ConsoleElement e = new ConsoleElement(msg);
        this._insideOutput.add(e);
        try {
            e.getTiming().recordWrap(2);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    public void addOutsideOutput(ConsoleElement e) {
        this._outsideOutput.add(e);
        e.getTiming().recordWrap(3);
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
    }

    public synchronized MX70SysexPanel createSysexPanel() {
        if (this._sysex == null) {
            this._sysex = new MX70SysexPanel(this._listBinary);
        }
        return this._sysex;
    }
}

