/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx70console;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jp.synthtarou.midimixer.libs.MXGlobalTimer;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.console.ConsoleElement;
import jp.synthtarou.midimixer.libs.console.ConsoleModel;
import jp.synthtarou.midimixer.libs.midi.MXTiming;
import jp.synthtarou.midimixer.mx70console.MX70Process;
import jp.synthtarou.midimixer.mx70console.MX70SysexPanel;

public class MX70Panel
extends JPanel {
    MX70Process _process;
    private JButton jButtonAddTest;
    private JButton jButtonLogMenu;
    private JButton jButtonRemoveTest;
    private JButton jButtonSysEXMenu;
    private JButton jButtonTestMenu;
    private JLabel jLabelInsideInput;
    private JLabel jLabelInsideOutput;
    private JLabel jLabelOutsideInput;
    private JLabel jLabelOutsideOutput;
    private JLabel jLabelTestInput;
    private JLabel jLabelTestOuput;
    private JLabel jLabelTestText;
    private JList<String> jListInsideInput;
    private JList<String> jListInsideOutput;
    private JList<String> jListOutsideInput;
    private JList<String> jListOutsideOutput;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanelInsideInput;
    private JPanel jPanelInsideOutput;
    private JPanel jPanelOutsideInput;
    private JPanel jPanelOutsideOutput;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane8;
    private JSplitPane jSplitPane1;
    private JTable jTableTestCase;
    private JTextField jTextFieldTestInput;
    private JTextField jTextFieldTestName;
    private JTextField jTextFieldTestOutput;
    private JToggleButton jToggleButtonPause;
    NumberFormat formatter3 = new DecimalFormat("0.000");

    public MX70Panel(MX70Process process) {
        this._process = process;
        this.initComponents();
        Dimension size = this.getSize();
        size.width /= 4;
        size.width -= 4;
        size.height -= 4;
        this.jScrollPane2.setPreferredSize(size);
        this.jScrollPane3.setPreferredSize(size);
        this.jScrollPane4.setPreferredSize(size);
        this.jScrollPane5.setPreferredSize(size);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MX70Panel.this._process._outsideInput.bind(MX70Panel.this.jListOutsideInput);
                MX70Panel.this._process._insideInput.bind(MX70Panel.this.jListInsideInput);
                MX70Panel.this._process._insideOutput.bind(MX70Panel.this.jListInsideOutput);
                MX70Panel.this._process._outsideOutput.bind(MX70Panel.this.jListOutsideOutput);
                MX70Panel.this.showTimeSpend();
            }
        });
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jPanelOutsideInput = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jListOutsideInput = new JList();
        this.jPanelInsideInput = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jListInsideInput = new JList();
        this.jPanelInsideOutput = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jListInsideOutput = new JList();
        this.jPanelOutsideOutput = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jListOutsideOutput = new JList();
        this.jLabelOutsideInput = new JLabel();
        this.jLabelInsideInput = new JLabel();
        this.jLabelInsideOutput = new JLabel();
        this.jLabelOutsideOutput = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane8 = new JScrollPane();
        this.jTableTestCase = new JTable();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jButtonAddTest = new JButton();
        this.jButtonRemoveTest = new JButton();
        this.jTextFieldTestName = new JTextField();
        this.jLabelTestInput = new JLabel();
        this.jLabelTestOuput = new JLabel();
        this.jTextFieldTestInput = new JTextField();
        this.jTextFieldTestOutput = new JTextField();
        this.jLabelTestText = new JLabel();
        this.jButtonLogMenu = new JButton();
        this.jButtonTestMenu = new JButton();
        this.jButtonSysEXMenu = new JButton();
        this.jToggleButtonPause = new JToggleButton();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setOrientation(0);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanelOutsideInput.setBorder(BorderFactory.createTitledBorder("Outside Input"));
        this.jPanelOutsideInput.setLayout(new BoxLayout(this.jPanelOutsideInput, 2));
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jListOutsideInput.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX70Panel.this.jListOutsideInputMousePressed(evt);
            }
        });
        this.jListOutsideInput.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX70Panel.this.jListOutsideInputValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListOutsideInput);
        this.jPanelOutsideInput.add(this.jScrollPane2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanelOutsideInput, gridBagConstraints);
        this.jPanelInsideInput.setBorder(BorderFactory.createTitledBorder("Inide Input"));
        this.jPanelInsideInput.setLayout(new BoxLayout(this.jPanelInsideInput, 2));
        this.jScrollPane3.setToolTipText("");
        this.jScrollPane3.setVerticalScrollBarPolicy(22);
        this.jListInsideInput.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX70Panel.this.jListInsideInputMousePressed(evt);
            }
        });
        this.jListInsideInput.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX70Panel.this.jListInsideInputValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jListInsideInput);
        this.jPanelInsideInput.add(this.jScrollPane3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanelInsideInput, gridBagConstraints);
        this.jPanelInsideOutput.setBorder(BorderFactory.createTitledBorder("Inside Output"));
        this.jPanelInsideOutput.setLayout(new BoxLayout(this.jPanelInsideOutput, 2));
        this.jScrollPane4.setVerticalScrollBarPolicy(22);
        this.jListInsideOutput.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX70Panel.this.jListInsideOutputMousePressed(evt);
            }
        });
        this.jListInsideOutput.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX70Panel.this.jListInsideOutputValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jListInsideOutput);
        this.jPanelInsideOutput.add(this.jScrollPane4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanelInsideOutput, gridBagConstraints);
        this.jPanelOutsideOutput.setBorder(BorderFactory.createTitledBorder("Outsde Output"));
        this.jPanelOutsideOutput.setLayout(new BoxLayout(this.jPanelOutsideOutput, 2));
        this.jScrollPane5.setVerticalScrollBarPolicy(22);
        this.jListOutsideOutput.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MX70Panel.this.jListOutsideOutputMousePressed(evt);
            }
        });
        this.jListOutsideOutput.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX70Panel.this.jListOutsideOutputValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jListOutsideOutput);
        this.jPanelOutsideOutput.add(this.jScrollPane5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanelOutsideOutput, gridBagConstraints);
        this.jLabelOutsideInput.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jLabelOutsideInput, gridBagConstraints);
        this.jLabelInsideInput.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jLabelInsideInput, gridBagConstraints);
        this.jLabelInsideOutput.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jLabelInsideOutput, gridBagConstraints);
        this.jLabelOutsideOutput.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jLabelOutsideOutput, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jTableTestCase.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Text", "Input", "OutWish", "OutNow", "OK?"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane8.setViewportView(this.jTableTestCase);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane8, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        this.jButtonAddTest.setText("+ Add As Test");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel5.add((Component)this.jButtonAddTest, gridBagConstraints);
        this.jButtonRemoveTest.setText("- Remove");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel5.add((Component)this.jButtonRemoveTest, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jTextFieldTestName, gridBagConstraints);
        this.jLabelTestInput.setText("Input");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel5.add((Component)this.jLabelTestInput, gridBagConstraints);
        this.jLabelTestOuput.setText("Output");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel5.add((Component)this.jLabelTestOuput, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jTextFieldTestInput, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jTextFieldTestOutput, gridBagConstraints);
        this.jLabelTestText.setText("Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.jLabelTestText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.jButtonLogMenu.setText("Log");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jButtonLogMenu, gridBagConstraints);
        this.jButtonTestMenu.setText("Test");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jButtonTestMenu, gridBagConstraints);
        this.jButtonSysEXMenu.setText("SysEX");
        this.jButtonSysEXMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70Panel.this.jButtonSysEXMenuActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jButtonSysEXMenu, gridBagConstraints);
        this.jToggleButtonPause.setText("Pause");
        this.jToggleButtonPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX70Panel.this.jToggleButtonPauseActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.jToggleButtonPause, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    public void selectByTimingCall(final JList list, final MXTiming trace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MX70Panel.this.selectByTiming(list, trace);
            }
        });
    }

    public void selectByTiming(JList list, MXTiming trace) {
        this._process._outsideInput.setSelectedTiming(trace);
        this._process._insideInput.setSelectedTiming(trace);
        this._process._insideOutput.setSelectedTiming(trace);
        this._process._outsideOutput.setSelectedTiming(trace);
    }

    private void jListOutsideInputValueChanged(ListSelectionEvent evt) {
        int index = this.jListOutsideInput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = this._process._outsideInput.getConsoleElement(index);
            if (e != null) {
                this.selectByTimingCall(this.jListOutsideInput, e.getTiming());
                this.jTextFieldTestName.setText(e.getTiming() + " => 0 = " + e.getTiming().thisWrap(0) + ", 1 = " + e.getTiming().thisWrap(1) + ", 2 = " + e.getTiming().thisWrap(2) + ", 3 = =" + e.getTiming().thisWrap(3));
            } else {
                this.selectByTimingCall(this.jListOutsideInput, null);
            }
        }
    }

    private void jListInsideInputValueChanged(ListSelectionEvent evt) {
        int index = this.jListInsideInput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = this._process._insideInput.getConsoleElement(index);
            if (e != null) {
                this.selectByTimingCall(this.jListInsideInput, e.getTiming());
                this.jTextFieldTestName.setText(e.getTiming() + " => 0 = " + e.getTiming().thisWrap(0) + ", 1 = " + e.getTiming().thisWrap(1) + ", 2 = " + e.getTiming().thisWrap(2) + ", 3 = =" + e.getTiming().thisWrap(3));
            } else {
                this.selectByTimingCall(this.jListInsideInput, null);
            }
        }
    }

    private void jListInsideOutputValueChanged(ListSelectionEvent evt) {
        int index = this.jListInsideOutput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = this._process._insideOutput.getConsoleElement(index);
            if (e != null) {
                this.selectByTimingCall(this.jListInsideOutput, e.getTiming());
                this.jTextFieldTestName.setText(e.getTiming() + " => 0 = " + e.getTiming().thisWrap(0) + ", 1 = " + e.getTiming().thisWrap(1) + ", 2 = " + e.getTiming().thisWrap(2) + ", 3 = =" + e.getTiming().thisWrap(3));
            } else {
                this.selectByTimingCall(this.jListInsideOutput, null);
            }
        }
    }

    private void jListOutsideOutputValueChanged(ListSelectionEvent evt) {
        int index = this.jListOutsideOutput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = this._process._outsideOutput.getConsoleElement(index);
            if (e != null) {
                this.selectByTimingCall(this.jListOutsideOutput, e.getTiming());
                this.jTextFieldTestName.setText(e.getTiming() + " => 0 = " + e.getTiming().thisWrap(0) + ", 1 = " + e.getTiming().thisWrap(1) + ", 2 = " + e.getTiming().thisWrap(2) + ", 3 = =" + e.getTiming().thisWrap(3));
            } else {
                this.selectByTimingCall(this.jListOutsideOutput, null);
            }
        }
    }

    private void jListOutsideInputMousePressed(MouseEvent evt) {
        int index = this.jListOutsideInput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = this._process._outsideInput.getConsoleElement(index);
            if (e != null) {
                this.selectByTimingCall(this.jListOutsideInput, e.getTiming());
            } else {
                this.selectByTimingCall(this.jListOutsideInput, null);
            }
        }
    }

    private void jListInsideInputMousePressed(MouseEvent evt) {
        int index = this.jListInsideInput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = this._process._insideInput.getConsoleElement(index);
            if (e != null) {
                this.selectByTimingCall(this.jListInsideInput, e.getTiming());
            } else {
                this.selectByTimingCall(this.jListInsideInput, null);
            }
        }
    }

    private void jListInsideOutputMousePressed(MouseEvent evt) {
        int index = this.jListInsideOutput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = this._process._insideOutput.getConsoleElement(index);
            if (e != null) {
                this.selectByTimingCall(this.jListInsideOutput, e.getTiming());
            } else {
                this.selectByTimingCall(this.jListInsideOutput, null);
            }
        }
    }

    private void jListOutsideOutputMousePressed(MouseEvent evt) {
        int index = this.jListOutsideOutput.getSelectedIndex();
        if (index >= 0) {
            ConsoleElement e = this._process._outsideOutput.getConsoleElement(index);
            if (e != null) {
                this.selectByTimingCall(this.jListOutsideOutput, e.getTiming());
            } else {
                this.selectByTimingCall(this.jListOutsideOutput, null);
            }
        }
    }

    private void jToggleButtonPauseActionPerformed(ActionEvent evt) {
        boolean pause = this.jToggleButtonPause.isSelected();
        this._process._outsideInput.switchPause(pause);
        this._process._insideInput.switchPause(pause);
        this._process._insideOutput.switchPause(pause);
        this._process._outsideOutput.switchPause(pause);
    }

    private void jButtonSysEXMenuActionPerformed(ActionEvent evt) {
        MX70SysexPanel panel = this._process.createSysexPanel();
        MXUtil.showAsDialog(this, panel, "System Exclusive");
    }

    public boolean isOwnerWindowVisible() {
        try {
            Container cont = MXUtil.getOwnerWindow(this);
            return cont.isVisible();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void showTimeSpend() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    block8: for (int i = 0; i < 4; ++i) {
                        long count = MXTiming.totalCount(i);
                        long spend = MXTiming.totalWrap(i);
                        long bottom = MXTiming.totalBottom(i);
                        String div = MX70Panel.this.formatter3.format(1.0 * (double)spend / (double)count);
                        String text = "<html>" + spend + "ms/" + count + "=" + div + "<br> bottom" + bottom + "ms</html>";
                        switch (i) {
                            case 0: {
                                MX70Panel.this.jLabelOutsideInput.setText(text);
                                continue block8;
                            }
                            case 1: {
                                MX70Panel.this.jLabelInsideInput.setText(text);
                                continue block8;
                            }
                            case 2: {
                                MX70Panel.this.jLabelInsideOutput.setText(text);
                                continue block8;
                            }
                            case 3: {
                                MX70Panel.this.jLabelOutsideOutput.setText(text);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                for (Container parent = MX70Panel.this.getParent(); parent != null; parent = parent.getParent()) {
                    Dialog d;
                    Window w;
                    if (parent instanceof Window && !(w = (Window)parent).isVisible()) {
                        return;
                    }
                    if (!(parent instanceof Dialog) || (d = (Dialog)parent).isVisible()) continue;
                    return;
                }
                MXGlobalTimer.letsCountdown(1000L, new Runnable(){

                    @Override
                    public void run() {
                        MX70Panel.this.showTimeSpend();
                    }
                });
            }
        });
    }

    public void showAsWindow() {
        JFrame newFrame = new JFrame();
        newFrame.setTitle("Free Consone / SysEX(MIX Recipe)");
        newFrame.pack();
        newFrame.getContentPane().add(this);
        this.setPreferredSize(new Dimension(800, 600));
        newFrame.pack();
        MXUtil.centerWindow(newFrame);
        newFrame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int count = ConsoleModel.getGlobalCapacity() - 1;
                MX70Panel.this.jListOutsideInput.ensureIndexIsVisible(count);
                MX70Panel.this.jListInsideInput.ensureIndexIsVisible(count);
                MX70Panel.this.jListInsideOutput.ensureIndexIsVisible(count);
                MX70Panel.this.jListOutsideOutput.ensureIndexIsVisible(count);
            }
        });
    }
}

