/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx60output;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;
import jp.synthtarou.midimixer.mx60output.MX60Data;
import jp.synthtarou.midimixer.mx60output.MX60MidiOutListPanel;
import jp.synthtarou.midimixer.mx60output.MX60Process;

public class MX60View
extends JPanel {
    MX60Process _process;
    private static final MXDebugPrint _debug = new MXDebugPrint(MX60View.class);
    JTableWithColumnHeader _jTableSkip;
    boolean _useSkipCC = true;
    MXWrapList<Integer> _recPortList;
    MX60MidiOutListPanel _midiPanel;
    ButtonGroup _recorderGroup;
    private ButtonGroup buttonGroup1;
    private JButton jButtonSongExport;
    private JCheckBox jCheckBoxUseSkip;
    private JLabel jLabelRecorderText;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelOutputSelect;
    private JProgressBar jProgressBar1;
    private JRadioButton jRadioButtonSong1;
    private JRadioButton jRadioButtonSong2;
    private JRadioButton jRadioButtonSong3;
    private JRadioButton jRadioButtonSong4;
    private JRadioButton jRadioButtonSong5;
    private JSplitPane jSplitPane2;
    private JToggleButton jToggleButtonPlay;
    private JToggleButton jToggleButtonRec;

    public MX60View(MX60Process process) {
        this._process = process;
        this.initComponents();
        this._midiPanel = new MX60MidiOutListPanel();
        this.jPanelOutputSelect.add(this._midiPanel);
        this._jTableSkip = new JTableWithFooter(this.jPanel1);
        this.resetTableModel();
        this._jTableSkip.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (MX60View.this._jTableSkip.isEnabled()) {
                    MX60View.this.jTableSkip_MouseClicked(evt);
                }
            }
        });
        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(0);
        for (int i = 1; i < this._jTableSkip.getColumnCount(); ++i) {
            TableColumn col = this._jTableSkip.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }
        this.jCheckBoxUseSkip.setSelected(this._process.isUsingThisRecipe());
        this._jTableSkip.setEnabled(this._process.isUsingThisRecipe());
        this._recorderGroup = new ButtonGroup();
        this._recorderGroup.add(this.jRadioButtonSong1);
        this._recorderGroup.add(this.jRadioButtonSong2);
        this._recorderGroup.add(this.jRadioButtonSong3);
        this._recorderGroup.add(this.jRadioButtonSong4);
        this._recorderGroup.add(this.jRadioButtonSong5);
        this.jRadioButtonSong1.setSelected(true);
        this.enableRecordingButton();
        this.jProgressBar1.setMinimum(0);
        this.jProgressBar1.setMaximum(10000);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jCheckBoxUseSkip = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabelRecorderText = new JLabel();
        this.jRadioButtonSong1 = new JRadioButton();
        this.jRadioButtonSong2 = new JRadioButton();
        this.jRadioButtonSong3 = new JRadioButton();
        this.jRadioButtonSong4 = new JRadioButton();
        this.jRadioButtonSong5 = new JRadioButton();
        this.jButtonSongExport = new JButton();
        this.jToggleButtonRec = new JToggleButton();
        this.jToggleButtonPlay = new JToggleButton();
        this.jProgressBar1 = new JProgressBar();
        this.jPanelOutputSelect = new JPanel();
        this.setLayout(new BoxLayout(this, 2));
        this.jSplitPane2.setDividerLocation(250);
        this.jSplitPane2.setOrientation(0);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("1.Output Filter"));
        this.jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jCheckBoxUseSkip.setText("Use This Recipe");
        this.jCheckBoxUseSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jCheckBoxUseSkipActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.jCheckBoxUseSkip, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("2. Recorder"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabelRecorderText.setText("Tempo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jLabelRecorderText, gridBagConstraints);
        this.jRadioButtonSong1.setText("Song1");
        this.jRadioButtonSong1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jRadioButtonSong1ActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jRadioButtonSong1, new GridBagConstraints());
        this.jRadioButtonSong2.setText("Song2");
        this.jRadioButtonSong2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jRadioButtonSong2ActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jRadioButtonSong2, new GridBagConstraints());
        this.jRadioButtonSong3.setText("Song3");
        this.jRadioButtonSong3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jRadioButtonSong3ActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jRadioButtonSong3, new GridBagConstraints());
        this.jRadioButtonSong4.setText("Song4");
        this.jRadioButtonSong4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jRadioButtonSong4ActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jRadioButtonSong4, new GridBagConstraints());
        this.jRadioButtonSong5.setText("Song5");
        this.jRadioButtonSong5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jRadioButtonSong5ActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jRadioButtonSong5, new GridBagConstraints());
        this.jButtonSongExport.setText("MXIRecipe Wont Save Recorder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel4.add((Component)this.jButtonSongExport, gridBagConstraints);
        this.jToggleButtonRec.setText("Rec");
        this.jToggleButtonRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jToggleButtonRecActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jToggleButtonRec, gridBagConstraints);
        this.jToggleButtonPlay.setText("Play");
        this.jToggleButtonPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX60View.this.jToggleButtonPlayActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jToggleButtonPlay, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jProgressBar1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.jPanel3);
        this.jPanelOutputSelect.setBorder(BorderFactory.createTitledBorder("2.Output Assign"));
        this.jPanelOutputSelect.setLayout(new BoxLayout(this.jPanelOutputSelect, 2));
        this.jSplitPane2.setLeftComponent(this.jPanelOutputSelect);
        this.add(this.jSplitPane2);
    }

    private void jCheckBoxUseSkipActionPerformed(ActionEvent evt) {
        this._process.setUsingThisRecipe(this.jCheckBoxUseSkip.isSelected());
        this._jTableSkip.setEnabled(this.jCheckBoxUseSkip.isSelected());
    }

    private void jToggleButtonRecActionPerformed(ActionEvent evt) {
        int x = this.getSelectedTrack();
        if (x < 0) {
            return;
        }
        if (this.jToggleButtonRec.isSelected()) {
            this._process.startRecording(x);
        } else {
            this._process.stopRecording();
        }
        this.enableRecordingButton();
    }

    private void jToggleButtonPlayActionPerformed(ActionEvent evt) {
        int x = this.getSelectedTrack();
        if (x < 0) {
            return;
        }
        if (this.jToggleButtonPlay.isSelected()) {
            this._process.startPlaying(x);
        } else {
            this._process.stopPlaying();
        }
        this.enableRecordingButton();
    }

    private void jRadioButtonSong5ActionPerformed(ActionEvent evt) {
        this.enableRecordingButton();
    }

    private void jRadioButtonSong4ActionPerformed(ActionEvent evt) {
        this.enableRecordingButton();
    }

    private void jRadioButtonSong3ActionPerformed(ActionEvent evt) {
        this.enableRecordingButton();
    }

    private void jRadioButtonSong2ActionPerformed(ActionEvent evt) {
        this.enableRecordingButton();
    }

    private void jRadioButtonSong1ActionPerformed(ActionEvent evt) {
        this.enableRecordingButton();
    }

    public synchronized TableModel createSkipTableModel() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.addColumn("");
        for (int i = 0; i < 16; ++i) {
            model.addColumn(MXUtilMidi.nameOfPortShort(i));
        }
        int row = 0;
        while (true) {
            MX60Data cfr_ignored_0 = this._process._data;
            if (row >= 10) break;
            Vector<String> line = new Vector<String>();
            MX60Data cfr_ignored_1 = this._process._data;
            line.add(MX60Data.typeNames[row]);
            for (int delivery = 0; delivery < 16; ++delivery) {
                int type = row + 1;
                if (this._process._data.isSkip(delivery, type)) {
                    line.add("Skip");
                    continue;
                }
                line.add("");
            }
            model.addRow(line);
            ++row;
        }
        return model;
    }

    private void jTableSkip_MouseClicked(MouseEvent evt) {
        int row = this._jTableSkip.rowAtPoint(evt.getPoint());
        int column = this._jTableSkip.columnAtPoint(evt.getPoint());
        int type = row + 1;
        int port = column - 1;
        DefaultTableModel model = (DefaultTableModel)this._jTableSkip.getModel();
        if (type >= 1) {
            MX60Data cfr_ignored_0 = this._process._data;
            if (type <= 10 && port >= 0 && port < 16) {
                if (this._process._data.isSkip(port, type)) {
                    this._process._data.setSkip(port, type, false);
                    model.setValueAt("", row, column);
                } else {
                    this._process._data.setSkip(port, type, true);
                    model.setValueAt("Skip", row, column);
                }
            }
        }
    }

    public void resetTableModel() {
        this._jTableSkip.setModel(this.createSkipTableModel());
        this._jTableSkip.getColumnModel().getColumn(0).setMinWidth(150);
    }

    public void refreshList() {
        this._midiPanel.refreshList();
    }

    public void setRecorderText(String text) {
        this.jLabelRecorderText.setText(text);
    }

    public void setNoteCount(int recorder, int count) {
        JRadioButton button = null;
        switch (recorder) {
            case 0: {
                button = this.jRadioButtonSong1;
                break;
            }
            case 1: {
                button = this.jRadioButtonSong2;
                break;
            }
            case 2: {
                button = this.jRadioButtonSong3;
                break;
            }
            case 3: {
                button = this.jRadioButtonSong4;
                break;
            }
            case 4: {
                button = this.jRadioButtonSong5;
            }
        }
        button.setText("Song" + (recorder + 1) + ":" + count);
    }

    public int countSongButton() {
        return 5;
    }

    public JRadioButton getSongButton(int x) {
        switch (x) {
            case 0: {
                return this.jRadioButtonSong1;
            }
            case 1: {
                return this.jRadioButtonSong2;
            }
            case 2: {
                return this.jRadioButtonSong3;
            }
            case 3: {
                return this.jRadioButtonSong4;
            }
            case 4: {
                return this.jRadioButtonSong5;
            }
        }
        return null;
    }

    public int getSelectedTrack() {
        for (int i = 0; i < this.countSongButton(); ++i) {
            if (!this.getSongButton(i).isSelected()) continue;
            return i;
        }
        return -1;
    }

    public void enableRecordingButton() {
        int x = this.getSelectedTrack();
        if (this._process.isRecording()) {
            this.jToggleButtonPlay.setEnabled(false);
            this.jToggleButtonRec.setEnabled(true);
        } else if (this._process.isPlaying()) {
            this.jToggleButtonPlay.setEnabled(true);
            this.jToggleButtonRec.setEnabled(false);
        } else {
            this.jToggleButtonPlay.setSelected(false);
            this.jToggleButtonRec.setSelected(false);
            this.jToggleButtonRec.setEnabled(true);
            if (this._process.hasRecorning(x)) {
                this.jToggleButtonPlay.setEnabled(true);
            } else {
                this.jToggleButtonPlay.setEnabled(false);
            }
        }
    }

    public void progress(int pos, int max) {
        double x = pos * 10000;
        x = max == 0 ? 10000.0 : (x /= (double)max);
        this.jProgressBar1.setValue((int)x);
    }

    public void progressStart() {
        this.enableRecordingButton();
    }

    public void progressFinish(boolean fine) {
        this.enableRecordingButton();
    }
}

