/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx60output;

import javax.swing.JComponent;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.MXTiming;
import jp.synthtarou.midimixer.libs.midi.smf.SMFCallback;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFPlayer;
import jp.synthtarou.midimixer.libs.midi.smf.SMFRecorder;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx10input.MX10Data;
import jp.synthtarou.midimixer.mx60output.MX60Data;
import jp.synthtarou.midimixer.mx60output.MX60View;

public class MX60Process
extends MXReceiver
implements MXSettingTarget {
    public MX60Data _data = new MX60Data();
    private MX60View _view = new MX60View(this);
    private SMFRecorder[] _listRecorder;
    private int _recordingTrack = -1;
    private SMFPlayer _playingTrack;
    MXSetting _setting = new MXSetting("OutputSkip");

    public MX60Process() {
        this._setting.setTarget(this);
        this._listRecorder = new SMFRecorder[5];
        for (int i = 0; i < this._listRecorder.length; ++i) {
            this._listRecorder[i] = new SMFRecorder();
        }
        this._playingTrack = null;
    }

    public void readSettings() {
        this._setting.readSettingFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMXMessageImpl(MXMessage message) {
        if (this.isUsingThisRecipe() && this._data.isMarkedToSkip(message)) {
            return;
        }
        if (this.isRecording()) {
            MX60Process mX60Process = this;
            synchronized (mX60Process) {
                SMFRecorder recorder = this._listRecorder[this._recordingTrack];
                recorder.addNote(message);
                this._view.setNoteCount(this._recordingTrack, recorder.getPlayer().listMessage().size());
            }
        }
        this.sendToNext(message);
    }

    @Override
    public String getReceiverName() {
        return "Output Dispatcher";
    }

    @Override
    public JComponent getReceiverView() {
        return this._view;
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        block0: for (int port = 0; port < 16; ++port) {
            String prefix = "Setting[" + port + "].";
            StringBuffer str = new StringBuffer();
            int j = 0;
            while (true) {
                MX60Process mX60Process = this;
                if (j >= mX60Process._data.countOfTypes()) continue block0;
                String name = MX60Data.typeNames[j];
                boolean set = setting.getSettingAsBoolean(prefix + name, false);
                this._data.setSkip(port, j, set);
                ++j;
            }
        }
        this._view.resetTableModel();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        block0: for (int port = 0; port < 16; ++port) {
            String prefix = "Setting[" + port + "].";
            StringBuffer str = new StringBuffer();
            int j = 0;
            while (true) {
                MX60Process mX60Process = this;
                if (j >= mX60Process._data.countOfTypes()) continue block0;
                boolean set = this._data.isSkip(port, j);
                String name = MX60Data.typeNames[j];
                setting.setSetting(prefix + name, set);
                ++j;
            }
        }
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        String prefix = "Setting[].";
        for (String text : MX10Data.typeNames) {
            setting.register(prefix + text);
        }
    }

    public synchronized void startRecording(int x) {
        this._recordingTrack = x;
        this._listRecorder[x].startRecording();
    }

    public synchronized boolean isRecording() {
        return this._recordingTrack >= 0;
    }

    public synchronized void stopRecording() {
        this._recordingTrack = -1;
    }

    public synchronized void startPlaying(int x) {
        this._playingTrack = this._listRecorder[x].getPlayer();
        this._playingTrack.setCurrentPosition(this._playingTrack.getPositionOfFirstNote());
        this._playingTrack.startPlayer(new SMFCallback(){
            MXNoteOffWatcher _noteOff = new MXNoteOffWatcher();

            @Override
            public void smfPlayNote(SMFMessage e) {
                MXMessage message = e.fromSMFtoMX(e._port);
                if (message == null) {
                    return;
                }
                if (message.getCommand() == 144 && message.getData2() == 0) {
                    message = MXMessageFactory.fromShortMessage(message.getPort(), 128 + message.getChannel(), message.getData1(), 0);
                }
                if (message.getCommand() == 128 && this._noteOff.raiseHandler(message.getPort(), message._timing, message.getChannel(), message.getData1())) {
                    return;
                }
                if (message.getCommand() == 144) {
                    this._noteOff.setHandler(message, message, new MXNoteOffWatcher.Handler(){

                        @Override
                        public void onNoteOffEvent(MXMessage target) {
                            MXMessage noteOff = MXMessageFactory.fromShortMessage(target.getPort(), 128 + target.getChannel(), target.getData1(), 0);
                            MX60Process.this.sendToNext(target);
                        }
                    });
                }
                MX60Process.this.sendToNext(message);
            }

            @Override
            public void smfStarted() {
                MX60Process.this._view.progressStart();
            }

            @Override
            public void smfStoped(boolean fineFinish) {
                this._noteOff.allNoteOff(new MXTiming());
                MX60Process.this._view.progressFinish(fineFinish);
            }

            @Override
            public void smfProgress(int pos, int finish) {
                MX60Process.this._view.progress(pos, finish);
            }
        });
    }

    public synchronized void stopPlaying() {
        if (this._playingTrack == null) {
            return;
        }
        if (this._playingTrack.isRunning()) {
            this._playingTrack.stopPlayer();
        }
        this._playingTrack = null;
    }

    public synchronized boolean isPlaying() {
        return this._playingTrack != null && this._playingTrack.isRunning();
    }

    public boolean hasRecorning(int x) {
        if (this._listRecorder == null) {
            return false;
        }
        return this._listRecorder[x].getPlayer().listMessage().size() > 0;
    }
}

