/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx40layer;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitantRecorder;
import jp.synthtarou.midimixer.mx40layer.MX40Layer;
import jp.synthtarou.midimixer.mx40layer.MX40Process;

public class MX40Group {
    private static final MXDebugPrint _debug = new MXDebugPrint(MX40Group.class);
    public ArrayList<MX40Layer> _listLayer = new ArrayList();
    public String _title = "New";
    public boolean _isWatchPort = false;
    public int _watchingPort = 0;
    public boolean _isWatchChannel = false;
    public int _watchingChannel = 0;
    public boolean _isWatchBank = false;
    public int _watchingBankMSB = 0;
    public int _watchingBankLSB = 0;
    public boolean _isWatchProgram = false;
    public int _watchingProgram = 0;
    public boolean _isRotate = false;
    public int _rotatePoly = 16;
    public int[] _rotateCount = new int[144];
    private int _lastLayerPos = -1;
    private final MX40Process _process;
    MXNoteOffWatcher _noteOff = new MXNoteOffWatcher();

    public MX40Group(MX40Process process) {
        this._process = process;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("By ");
        str.append("Port=").append(this._isWatchPort).append("[").append(MXUtilMidi.nameOfPortOutput(this._watchingPort)).append("]");
        str.append("Channel=").append(this._isWatchChannel).append("[").append(this._watchingChannel + 1).append("]");
        str.append("Program=").append(this._isWatchProgram).append("[").append(this._watchingProgram).append("]");
        str.append("Bank=").append(this._watchingBankMSB).append(":").append(this._watchingBankLSB).append("]");
        return str.toString();
    }

    public boolean isAssigned(int port, int channel) {
        MXVisitantRecorder info = this._process._inputInfo;
        MXVisitant e = info.getVisitant(port, channel);
        int infoBankMSB = e.isHavingBank() ? e.getBankMSB() : -1;
        int infoBankLSB = e.isHavingBank() ? e.getBankLSB() : -1;
        int infoProgram = e.isHavingProgram() ? e.getProgram() : -1;
        boolean assigned = false;
        if (this._listLayer.size() == 0) {
            return false;
        }
        if (this._isWatchPort || this._isWatchChannel || this._isWatchProgram || this._isWatchBank) {
            assigned = true;
            if (this._isWatchPort && this._watchingPort != port) {
                assigned = false;
            }
            if (this._isWatchChannel && this._watchingChannel != channel) {
                assigned = false;
            }
            if (this._isWatchProgram && this._watchingProgram != infoProgram) {
                assigned = false;
            }
            if (this._isWatchBank && (this._watchingBankMSB != infoBankMSB || this._watchingBankLSB != infoBankLSB)) {
                assigned = false;
            }
        } else {
            assigned = false;
            if (e.isHavingBank() || e.isHavingProgram()) {
                assigned = true;
            }
        }
        return assigned;
    }

    public boolean willDoFixProgram(int port, int channel) {
        for (MX40Layer layer : this._listLayer) {
            if (layer._modProgram != 2) continue;
            return true;
        }
        return false;
    }

    public boolean processByGroup(MXMessage message) {
        boolean assigned;
        if (!message.isMessageTypeChannel()) {
            return false;
        }
        int port = message.getPort();
        int command = message.getCommand();
        int channel = message.getChannel();
        if (command == 128 && this._noteOff.raiseHandler(port, message._timing, channel, message.getGate())) {
            return true;
        }
        if (command == 176) {
            int cc = message.getGate();
            if (cc == 0) {
                return true;
            }
            if (cc == 32) {
                return true;
            }
        }
        if (command == 192) {
            assigned = this.isAssigned(port, channel);
            if (assigned) {
                for (MX40Layer layer : this._listLayer) {
                    layer.processProgramChange(message);
                }
                return true;
            }
            return false;
        }
        assigned = this.isAssigned(port, channel);
        if (!assigned) {
            return false;
        }
        boolean proced = false;
        if (this._listLayer.size() == 0) {
            return false;
        }
        if (this._rotatePoly >= 1 && command == 144) {
            int found = this._lastLayerPos + 1;
            if (found < 0 || found >= this._listLayer.size()) {
                found = 0;
            }
            this._lastLayerPos = found;
            if (this._rotateCount[found] >= this._rotatePoly) {
                int foundPoly = 100;
                for (int i = 0; i < this._listLayer.size(); ++i) {
                    MX40Layer layer = this._listLayer.get(i);
                    if (this._rotateCount[i] >= foundPoly) continue;
                    found = i;
                    foundPoly = this._rotateCount[i];
                }
            }
            int n = found;
            this._rotateCount[n] = this._rotateCount[n] + 1;
            MX40Layer layer = this._listLayer.get(found);
            proced = layer.processByLayer(message);
            MXMessage msg2 = MXMessageFactory.fromShortMessage(port, 128 + channel, message.getGate(), 0);
            msg2._timing = message._timing;
            this._noteOff.setHandler(message, msg2, new NoteOffWatcher2(layer, found));
        } else {
            for (MX40Layer layer : this._listLayer) {
                layer.processByLayer(message);
                if (command == 144) {
                    MXMessage msg2 = MXMessageFactory.fromShortMessage(port, 128 + channel, message.getGate(), 0);
                    msg2._timing = message._timing;
                    this._noteOff.setHandler(message, msg2, new NoteOffWatcher2(layer, -1));
                }
                proced = true;
            }
        }
        return proced;
    }

    public boolean equals(Object o) {
        MX40Group target = (MX40Group)o;
        return this._title.equals(target._title) && this._isWatchPort == target._isWatchPort && this._watchingPort == target._watchingPort && this._isWatchChannel == target._isWatchChannel && this._watchingChannel == target._watchingChannel && this._isWatchBank == target._isWatchBank && this._watchingBankMSB == target._watchingBankMSB && this._watchingBankLSB == target._watchingBankLSB && this._isWatchProgram == target._isWatchProgram && this._watchingProgram == target._watchingProgram && this._isRotate == target._isRotate && this._rotatePoly == target._rotatePoly;
    }

    public void checkEquals(String name, Object v1, Object v2) {
        if (!v1.equals(v2)) {
            System.out.println(name + " is changing " + v1 + " > " + v2);
        }
    }

    public void caneChageTo(MX40Group target) {
        this.checkEquals("titile", this._title, target._title);
        this.checkEquals("isWatchPort", this._isWatchPort, target._isWatchPort);
        this.checkEquals("watchingPort", this._watchingPort, target._watchingPort);
        this.checkEquals("isWatchChannel", this._isWatchChannel, target._isWatchChannel);
        this.checkEquals("watchingChannel", this._watchingChannel, target._watchingChannel);
        this.checkEquals("isWatchBank", this._isWatchBank, target._isWatchBank);
        this.checkEquals("watchingBankMSB", this._watchingBankMSB, target._watchingBankMSB);
        this.checkEquals("watchingBankLSB", this._watchingBankLSB, target._watchingBankLSB);
        this.checkEquals("isWatchProgram", this._isWatchProgram, target._isWatchProgram);
        this.checkEquals("watchingProgram", this._watchingProgram, target._watchingProgram);
        this.checkEquals("isRotate", this._isRotate, target._isRotate);
        this.checkEquals("rotatePoly", this._rotatePoly, target._rotatePoly);
    }

    class NoteOffWatcher2
    implements MXNoteOffWatcher.Handler {
        int _rotatePos;
        MX40Layer _layer;

        NoteOffWatcher2(MX40Layer layer, int rotatePos) {
            this._layer = layer;
            this._rotatePos = rotatePos;
        }

        @Override
        public void onNoteOffEvent(MXMessage target) {
            this._layer.processByLayer(target);
            if (this._rotatePos >= 0) {
                int n = this._rotatePos;
                MX40Group.this._rotateCount[n] = MX40Group.this._rotateCount[n] - 1;
            }
        }
    }
}

