/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.SoftBevelBorder;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.MXPianoComponent;

public class MXNotePicker
extends JPanel {
    MXPianoComponent _piano;
    MXWrapList<Integer> _watchPort = MXUtilMidi.createPortAssigned(true);
    MXWrapList<Integer> _watchChannel = MXUtilMidi.createChannel(false);
    boolean _closeOK = false;
    int[] _retNote = null;
    int _valuePitch = -1;
    int _valueModulation = -1;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabelNoteList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public static void main(String[] args) {
        MXDebugPrint.globalSwitchOn();
        new MXNotePicker().showAsModalDialog(null);
    }

    public boolean showAsModalDialog(Component owner) {
        JDialog owner1 = null;
        JFrame owner2 = null;
        while (owner != null) {
            if (owner instanceof JDialog) {
                owner1 = (JDialog)owner;
                break;
            }
            if (owner instanceof JFrame) {
                owner2 = (JFrame)owner;
                break;
            }
            owner = owner.getParent();
        }
        JDialog dialog = null;
        dialog = owner1 != null ? new JDialog((Dialog)owner1, true) : new JDialog((Frame)owner2, true);
        dialog.setTitle("Master Keys (MIX Recipe)");
        dialog.pack();
        dialog.getContentPane().add(this);
        this.setPreferredSize(new Dimension(800, 200));
        dialog.pack();
        MXUtil.centerWindow(dialog);
        dialog.setVisible(true);
        this.scrollToCenter();
        return this._closeOK;
    }

    public MXNotePicker() {
        this.initComponents();
        this._piano = new MXPianoComponent();
        this._piano.setAllowMultiSelect(true);
        this._piano.setNoteRange(0, 11);
        this._piano.setMinimumSize(new Dimension(1800, 1));
        this._piano.setPreferredSize(new Dimension(1800, 150));
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setViewportView(this._piano);
        this._piano.setHandler(new MXPianoComponent.Handler(){

            @Override
            public void noteOn(int note) {
            }

            @Override
            public void noteOff(int note) {
            }

            @Override
            public void selectionChanged() {
                MXNotePicker.this.noteSelectionChanged();
            }
        });
        String title = "Select Output to Connect.";
        MXMain.getMain().addLaunchSequence(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void scrollToCenter() {
        Dimension scrollSize = this.jScrollPane1.getSize();
        Dimension pianoSize = this._piano.getSize();
        Rectangle rect = new Rectangle((int)(pianoSize.getWidth() - scrollSize.getWidth()) / 2, 0, (int)scrollSize.getWidth(), 50);
        this.jScrollPane1.getViewport().scrollRectToVisible(rect);
    }

    public void noteSelectionChanged() {
        this._retNote = this._piano.listMultiSelected();
        this.jLabelNoteList.setText(MXUtilMidi.noteListToText(this._retNote));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabelNoteList = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanel1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setBorder(new SoftBevelBorder(0));
        this.jLabel1.setText("Selected Note:");
        this.jPanel2.add(this.jLabel1);
        this.jLabelNoteList.setText("C1");
        this.jPanel2.add(this.jLabelNoteList);
        this.add((Component)this.jPanel2, new GridBagConstraints());
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXNotePicker.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXNotePicker.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jButtonCancel, gridBagConstraints);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        MXUtil.closeOwnerWindow(this);
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this._closeOK = true;
        MXUtil.closeOwnerWindow(this);
    }

    public int[] getSelectedNoteList() {
        return this._retNote;
    }

    public void setSelectedNoteList(int[] note) {
        if (note != null) {
            for (int x : note) {
                this._piano.selectNote(x, true);
            }
        }
    }
}

