/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import jp.synthtarou.midimixer.libs.MXGlobalTimer;
import jp.synthtarou.midimixer.libs.UniqueChecker;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.MXScaledNumber;
import jp.synthtarou.midimixer.libs.midi.MXTiming;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant16;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingNode;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx30controller.MGCircle;
import jp.synthtarou.midimixer.mx30controller.MGPad;
import jp.synthtarou.midimixer.mx30controller.MGSlider;
import jp.synthtarou.midimixer.mx30controller.MGStatus;
import jp.synthtarou.midimixer.mx30controller.MX30Process;
import jp.synthtarou.midimixer.mx30controller.MX32MixerData;
import jp.synthtarou.midimixer.mx30controller.MX32MixerView;

public class MX32MixerProcess
extends MXReceiver
implements MXSettingTarget {
    final int _port;
    final MX30Process _parent;
    final MX32MixerView _view;
    MXNoteOffWatcher _noteOff;
    MXSetting _setting;
    MXVisitant16 _visitant16 = new MXVisitant16();
    String _mixerName;
    MX32MixerData _data;
    int _patchToMixer = -1;
    boolean _patchTogether = false;
    MXMessage _poolFor14bit = null;
    MGStatus _poolFor14bitStatus = null;
    int _gotValue14bit = 0;
    long lastTick = 0L;

    public MX32MixerProcess(MX30Process parent, int port) {
        this._parent = parent;
        this._port = port;
        this._data = new MX32MixerData(this);
        this._view = new MX32MixerView(this);
        this._setting = new MXSetting("Mixing" + (port + 1));
        this._setting.setTarget(this);
    }

    public void readSettings() {
        this._setting.readSettingFile();
        this._view.updateUI();
    }

    @Override
    public String getReceiverName() {
        return "#" + MXUtilMidi.nameOfPortShort(this._port);
    }

    @Override
    public JComponent getReceiverView() {
        return this._view;
    }

    @Override
    protected void processMXMessageImpl(MXMessage message) {
        if (!this.isUsingThisRecipe()) {
            this.sendToNext(message);
            return;
        }
        this.letsTryMessage(message, new UniqueChecker(this._parent.getNextReceiver()));
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        setting.register("PatchToMixer");
        setting.register("Circle[].name");
        setting.register("Circle[].note");
        setting.register("Circle[].type");
        setting.register("Circle[].row");
        setting.register("Circle[].column");
        setting.register("Circle[].message");
        setting.register("Circle[].channel");
        setting.register("Circle[].gate");
        setting.register("Circle[].value");
        setting.register("Circle[].valuemin");
        setting.register("Circle[].valuemax");
        setting.register("Circle[].valueinvert");
        setting.register("Circle[].attributes");
        setting.register("Circle[].dataentryType");
        setting.register("Circle[].dataentryMSB");
        setting.register("Circle[].dataentryLSB");
        setting.register("Circle[].isValue14bit");
        setting.register("Slider[].name");
        setting.register("Slider[].note");
        setting.register("Slider[].type");
        setting.register("Slider[].row");
        setting.register("Slider[].column");
        setting.register("Slider[].message");
        setting.register("Slider[].channel");
        setting.register("Slider[].gate");
        setting.register("Slider[].value");
        setting.register("Slider[].valuemin");
        setting.register("Slider[].valuemax");
        setting.register("Slider[].valueinvert");
        setting.register("Slider[].attributes");
        setting.register("Slider[].dataentryType");
        setting.register("Slider[].dataentryMSB");
        setting.register("Slider[].dataentryLSB");
        setting.register("Slider[].isValue14bit");
        setting.register("Pad[].name");
        setting.register("Pad[].note");
        setting.register("Pad[].type");
        setting.register("Pad[].row");
        setting.register("Pad[].column");
        setting.register("Pad[].message");
        setting.register("Pad[].channel");
        setting.register("Pad[].gate");
        setting.register("Pad[].value");
        setting.register("Pad[].valuemin");
        setting.register("Pad[].valuemax");
        setting.register("Pad[].valueinvert");
        setting.register("Pad[].attributes");
        setting.register("Pad[].isValue14bit");
        setting.register("Pad[].dataentryType");
        setting.register("Pad[].dataentryMSB");
        setting.register("Pad[].dataentryLSB");
        setting.register("Pad[].switchType");
        setting.register("Pad[].switchWithToggle");
        setting.register("Pad[].switchInputType");
        setting.register("Pad[].switchOutPort");
        setting.register("Pad[].switchOutChannel");
        setting.register("Pad[].switchOutOnType");
        setting.register("Pad[].switchOutOnValue");
        setting.register("Pad[].switchOutOnValueFixed");
        setting.register("Pad[].switchOutOnText");
        setting.register("Pad[].switchOutOnTextGate");
        setting.register("Pad[].switchOutOff");
        setting.register("Pad[].switchOutOffValue");
        setting.register("Pad[].switchOutOffText");
        setting.register("Pad[].switchOutOffTextGate");
        setting.register("Pad[].switchHarmonyVelocityType");
        setting.register("Pad[].switchHarmonyVelocityFixed");
        setting.register("Pad[].switchHarmonyNotes");
        setting.register("Pad[].switchSequencerFile");
        setting.register("Pad[].switchSequencerSingltTrack");
        setting.register("Pad[].switchSequencerOneChannel");
        setting.register("Pad[].switchSequencerSeekStart");
        setting.register("Pad[].switchSequencerFilterNote");
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        int value;
        int gate;
        int channel;
        String msgText;
        MGStatus status;
        int column;
        int row;
        int type;
        ArrayList<MXSettingNode> children = setting.findByPath("Circle[]");
        this._patchToMixer = setting.getSettingAsInt("PatchToMixer", -1);
        for (MXSettingNode node : children) {
            type = node.getSettingAsInt("type", -1);
            row = node.getSettingAsInt("row", -1);
            column = node.getSettingAsInt("column", -1);
            if (type < 0 || row < 0 || column < 0) break;
            status = new MGStatus(this._port, type, row, column);
            try {
                status.setName(node.getSetting("name"));
                status.setMemo(node.getSetting("note"));
                msgText = node.getSetting("message");
                channel = node.getSettingAsInt("channel", 0);
                gate = node.getSettingAsInt("gate", 0);
                value = node.getSettingAsInt("value", 0);
                status.setRangeMin(node.getSettingAsInt("valuemin", 0));
                status.setRangeMax(node.getSettingAsInt("valuemax", 127));
                status.setUiValueInvert(node.getSettingAsBoolean("valueinvert", false));
                status.setMonitoringTarget(msgText, channel, gate, value);
                status.setDataroomType(node.getSettingAsInt("dataentryType", 0));
                status.setDataroomMSB(node.getSettingAsInt("dataentryMSB", 0));
                status.setDataroomLSB(node.getSettingAsInt("dataentryLSB", 0));
                this._data.setCircleStatus(row, column, status);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        children = setting.findByPath("Slider[]");
        for (MXSettingNode node : children) {
            type = node.getSettingAsInt("type", -1);
            row = node.getSettingAsInt("row", -1);
            column = node.getSettingAsInt("column", -1);
            if (type < 0 || row < 0 || column < 0) break;
            status = new MGStatus(this._port, type, row, column);
            try {
                status.setName(node.getSetting("name"));
                status.setMemo(node.getSetting("note"));
                msgText = node.getSetting("message");
                channel = node.getSettingAsInt("channel", 0);
                gate = node.getSettingAsInt("gate", 0);
                value = node.getSettingAsInt("value", 0);
                status.setMonitoringTarget(msgText, channel, gate, value);
                status.setRangeMin(node.getSettingAsInt("valuemin", 0));
                status.setRangeMax(node.getSettingAsInt("valuemax", 127));
                status.setUiValueInvert(node.getSettingAsBoolean("valueinvert", false));
                status.setDataroomType(node.getSettingAsInt("dataentryType", 0));
                status.setDataroomMSB(node.getSettingAsInt("dataentryMSB", 0));
                status.setDataroomLSB(node.getSettingAsInt("dataentryLSB", 0));
                this._data.setSliderStatus(row, column, status);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        children = setting.findByPath("Pad[]");
        int count = 0;
        for (MXSettingNode node : children) {
            int type2 = node.getSettingAsInt("type", -1);
            int row2 = node.getSettingAsInt("row", -1);
            int column2 = node.getSettingAsInt("column", -1);
            if (type2 < 0 || row2 < 0 || column2 < 0) break;
            if (row2 == 0 && column2 == 0) {
                ++count;
            }
            MGStatus status2 = new MGStatus(this._port, type2, row2, column2);
            try {
                status2.setName(node.getSetting("name"));
                status2.setMemo(node.getSetting("note"));
                msgText = node.getSetting("message");
                int channel2 = node.getSettingAsInt("channel", 0);
                int gate2 = node.getSettingAsInt("gate", 0);
                int value2 = node.getSettingAsInt("value", 0);
                status2.setMonitoringTarget(msgText, channel2, gate2, value2);
                status2.setRangeMin(node.getSettingAsInt("valuemin", 0));
                status2.setRangeMax(node.getSettingAsInt("valuemax", 127));
                status2.setUiValueInvert(node.getSettingAsBoolean("valueinvert", false));
                status2.setDataroomType(node.getSettingAsInt("dataentryType", 0));
                status2.setDataroomMSB(node.getSettingAsInt("dataentryMSB", 0));
                status2.setDataroomLSB(node.getSettingAsInt("dataentryLSB", 0));
                status2.setSwitchType(node.getSettingAsInt("switchType", 2));
                status2.setSwitchWithToggle(node.getSettingAsBoolean("switchWithToggle", false));
                status2.setSwitchInputType(node.getSettingAsInt("switchInputType", 2));
                status2.setSwitchOutOnType(node.getSettingAsInt("switchOutOnType", 5));
                status2.setSwitchOutOnTypeOfValue(node.getSettingAsInt("switchOutOnValue", 9));
                status2.setSwitchOutOnText(node.getSetting("switchOutOnText"));
                status2.setSwitchOutOnTextGate(node.getSettingAsInt("switchOutOnTextGate", 127));
                status2.setSwitchOutOnValueFixed(node.getSettingAsInt("switchOutOnValueFixed", 127));
                status2.setSwitchOutOffType(node.getSettingAsInt("switchOutOff", 12));
                status2.setSwitchOutOffTypeOfValue(node.getSettingAsInt("switchOutOffValue", 15));
                status2.setSwitchOutOffText(node.getSetting("switchOutOffText"));
                status2.setSwitchOutOffTextGate(node.getSettingAsInt("switchOutOffTextGate", 0));
                status2.setSwitchOutChannel(node.getSettingAsInt("switchOutChannel", 0));
                status2.setSwitchHarmonyVelocityType(node.getSettingAsInt("switchHarmonyVelocityType", 20));
                status2.setSwitchHarmonyVelocityFixed(node.getSettingAsInt("switchHarmonyVelocityFixed", 100));
                status2.setSwitchHarmonyNotes(node.getSetting("switchHarmonyNotes"));
                status2.setSwitchSequencerFile(node.getSetting("switchSequencerFile"));
                status2.setSwitchSequencerToSingltTrack(node.getSettingAsBoolean("switchSequencerSingltTrack", true));
                status2.setSwitchSequenceSeekStart(node.getSettingAsBoolean("switchSequencerSeekStart", true));
                status2.setSwitchSequencerFilterNote(node.getSettingAsBoolean("switchSequencerFilterNote", true));
                status2.setSwitchOutPort(node.getSettingAsInt("switchOutPort", 0));
                status2.setSwitchOutChannel(node.getSettingAsInt("switchOutChannel", 0));
                this._data.setDrumPadStatus(row2, column2, status2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        MXMessage message;
        MGStatus status;
        String prefix;
        int row;
        int column;
        int counter = 1;
        setting.setSetting("PatchToMixer", this._patchToMixer);
        for (column = 0; column < 17; ++column) {
            for (row = 0; row < 4; ++row) {
                prefix = "Circle[" + counter + "].";
                status = this._data.getCircleStatus(row, column);
                message = status.toMXMessage(null);
                setting.setSetting(prefix + "name", status.getName());
                setting.setSetting(prefix + "note", status.getMemo());
                setting.setSetting(prefix + "type", status.getUiType());
                setting.setSetting(prefix + "row", row);
                setting.setSetting(prefix + "column", column);
                setting.setSetting(prefix + "message", status.getTextCommand());
                setting.setSetting(prefix + "channel", message.getChannel());
                setting.setSetting(prefix + "gate", message.getGate());
                setting.setSetting(prefix + "value", status.getValue());
                setting.setSetting(prefix + "valuemin", status.getRangeMin());
                setting.setSetting(prefix + "valuemax", status.getRangeMax());
                setting.setSetting(prefix + "valueinvert", status.isUiValueInvert());
                setting.setSetting(prefix + "dataentryType", status.getDataroomType());
                setting.setSetting(prefix + "dataentryMSB", status.getDataeroomMSB());
                setting.setSetting(prefix + "dataentryLSB", status.getDataroomLSB());
                ++counter;
            }
        }
        counter = 1;
        for (column = 0; column < 17; ++column) {
            for (row = 0; row < 1; ++row) {
                prefix = "Slider[" + counter + "].";
                status = this._data.getSliderStatus(row, column);
                message = status.toMXMessage(null);
                setting.setSetting(prefix + "name", status.getName());
                setting.setSetting(prefix + "note", status.getMemo());
                setting.setSetting(prefix + "type", status.getUiType());
                setting.setSetting(prefix + "row", row);
                setting.setSetting(prefix + "column", column);
                setting.setSetting(prefix + "message", status.getTextCommand());
                setting.setSetting(prefix + "channel", message.getChannel());
                setting.setSetting(prefix + "gate", message.getGate());
                setting.setSetting(prefix + "value", status.getValue());
                setting.setSetting(prefix + "valuemin", status.getRangeMin());
                setting.setSetting(prefix + "valuemax", status.getRangeMax());
                setting.setSetting(prefix + "valueinvert", status.isUiValueInvert());
                setting.setSetting(prefix + "dataentryType", status.getDataroomType());
                setting.setSetting(prefix + "dataentryMSB", status.getDataeroomMSB());
                setting.setSetting(prefix + "dataentryLSB", status.getDataroomLSB());
                ++counter;
            }
        }
        counter = 1;
        for (column = 0; column < 17; ++column) {
            for (row = 0; row < 3; ++row) {
                prefix = "Pad[" + counter + "].";
                status = this._data.getDrumPadStatus(row, column);
                message = status.toMXMessage(null);
                setting.setSetting(prefix + "name", status.getName());
                setting.setSetting(prefix + "note", status.getMemo());
                setting.setSetting(prefix + "type", status.getUiType());
                setting.setSetting(prefix + "row", row);
                setting.setSetting(prefix + "column", column);
                setting.setSetting(prefix + "message", status.getTextCommand());
                setting.setSetting(prefix + "channel", message.getChannel());
                setting.setSetting(prefix + "gate", message.getGate());
                setting.setSetting(prefix + "value", status.getValue());
                setting.setSetting(prefix + "valuemin", status.getRangeMin());
                setting.setSetting(prefix + "valuemax", status.getRangeMax());
                setting.setSetting(prefix + "valueinvert", status.isUiValueInvert());
                setting.setSetting(prefix + "dataentryType", status.getDataroomType());
                setting.setSetting(prefix + "dataentryMSB", status.getDataeroomMSB());
                setting.setSetting(prefix + "dataentryLSB", status.getDataroomLSB());
                setting.setSetting(prefix + "switchType", status.getSwitchType());
                setting.setSetting(prefix + "switchWithToggle", status.isSwitchWithToggle());
                setting.setSetting(prefix + "switchInputType", status.getSwitchInputType());
                setting.setSetting(prefix + "switchOutOnType", status.getSwitchOutOnType());
                setting.setSetting(prefix + "switchOutOnValue", status.getSwitchOutOnTypeOfValue());
                setting.setSetting(prefix + "switchOutOnValueFixed", status.getSwitchOutOnValueFixed());
                setting.setSetting(prefix + "switchOutOnText", status.getSwitchOutOnText());
                setting.setSetting(prefix + "switchOutOnTextGate", status.getSwitchOutOnTextGate());
                setting.setSetting(prefix + "switchOutOff", status.getSwitchOutOffType());
                setting.setSetting(prefix + "switchOutOffValue", status.getSwitchOutOffTypeOfValue());
                setting.setSetting(prefix + "switchOutOffText", status.getSwitchOutOffText());
                setting.setSetting(prefix + "switchOutOffTextGate", status.getSwitchOutOffTextGate());
                setting.setSetting(prefix + "switchOutPort", status.getSwitchOutPort());
                setting.setSetting(prefix + "switchOutChannel", status.getSwitchOutChannel());
                setting.setSetting(prefix + "switchHarmonyVelocityType", status.getSwitchHarmonyVelocityType());
                setting.setSetting(prefix + "switchHarmonyVelocityFixed", status.getSwitchHarmonyVelocityFixed());
                setting.setSetting(prefix + "switchHarmonyNotes", status.getSwitchHarmonyNotes());
                setting.setSetting(prefix + "switchSequencerFile", status.getSwitchSequencerFile());
                setting.setSetting(prefix + "switchSequencerSingltTrack", status.isSwitchSequencerToSingltTrack());
                setting.setSetting(prefix + "switchSequencerSeekStart", status.isSwitchSequenceSeekStart());
                setting.setSetting(prefix + "switchSequencerFilterNote", status.isSwitchSequencerFilterNote());
                ++counter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void catchedValue(MGStatus status, MXTiming timing, int newValue, UniqueChecker already) {
        Object object = MXTiming.mutex;
        synchronized (object) {
            MXMessage message;
            if (!this._data.ready()) {
                return;
            }
            if (already == null) {
                already = new UniqueChecker(this.getNextReceiver());
            }
            if (already.checkAlready(status)) {
                return;
            }
            if (timing == null) {
                timing = new MXTiming();
            }
            int row = status.getRow();
            int column = status.getColumn();
            MGSlider slider = null;
            MGCircle circle = null;
            Object drumpad = null;
            if (status.getUiType() == 2) {
                slider = this._data.getSlider(row, column);
                already.push(status);
                status.setValue(newValue);
                slider.updateUIOnly(timing, newValue);
            }
            if (status.getUiType() == 1) {
                circle = this._data.getCircle(row, column);
                already.push(status);
                status.setValue(newValue);
                circle.changeUIOnly(timing, newValue);
            }
            if (status.getUiType() == 3) {
                status.setValue(newValue);
                if (status.isDrumOn(newValue)) {
                    this.catchedValueDrum(status, timing, true, newValue, already);
                } else {
                    this.catchedValueDrum(status, timing, false, 0, already);
                }
                return;
            }
            if (this._patchToMixer >= 0) {
                MX32MixerProcess nextMixer = this._parent.getPage(this._patchToMixer);
                MGStatus nextStatus = null;
                switch (status.getUiType()) {
                    case 2: {
                        nextStatus = nextMixer._data.getSliderStatus(row, column);
                        break;
                    }
                    case 1: {
                        nextStatus = nextMixer._data.getCircleStatus(row, column);
                        break;
                    }
                    case 3: {
                        nextStatus = nextMixer._data.getDrumPadStatus(row, column);
                    }
                }
                if (nextStatus.getRangeMax() != status.getRangeMax() || nextStatus.getRangeMin() != status.getRangeMin()) {
                    int fromRange = status.getRangeMax() - status.getRangeMin();
                    int toRange = nextStatus.getRangeMax() - nextStatus.getRangeMin();
                    int fromOffset = status.getValue() - status.getRangeMin();
                    boolean invert = false;
                    invert = status.isUiValueInvert() ? !nextStatus.isUiValueInvert() : nextStatus.isUiValueInvert();
                    MXScaledNumber trans = new MXScaledNumber(fromRange, toRange);
                    int toOffset = trans.getNewNumber(fromOffset, invert);
                    newValue = nextStatus.getRangeMin() + toOffset;
                }
                nextMixer.catchedValue(nextStatus, timing, newValue, already);
                if (!this._patchTogether) {
                    return;
                }
            }
            if ((message = status.toMXMessage(timing)).getValue() == 0) {
                message.setValue(newValue);
            }
            if (message != null && message.getValue() == 0 && message.getCommand() == 144) {
                message = MXMessageFactory.fromShortMessage(this._port, 128 + message.getChannel(), message.getData1(), 0);
                message._timing = timing;
            }
            already.sendOnlyNeed(message);
            this.letsTryMessage(message, already);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void catchedValueDrum(MGStatus status, MXTiming timing, boolean newValue, int velocity, UniqueChecker already) {
        Object object = MXTiming.mutex;
        synchronized (object) {
            boolean flag;
            if (already == null) {
                already = new UniqueChecker(this.getNextReceiver());
            }
            if (already.checkAlready(status)) {
                return;
            }
            already.push(status);
            if (timing == null) {
                timing = new MXTiming();
            }
            int row = status.getRow();
            int column = status.getColumn();
            Object slider = null;
            Object circle = null;
            MGPad drumpad = null;
            if (status.getUiType() != 3) {
                throw new IllegalStateException();
            }
            drumpad = this._data.getDrumPad(row, column);
            if (this._patchToMixer >= 0) {
                MX32MixerProcess nextMixer = this._parent.getPage(this._patchToMixer);
                MGStatus nextStatus = null;
                switch (status.getUiType()) {
                    case 2: {
                        nextStatus = nextMixer._data.getSliderStatus(row, column);
                        break;
                    }
                    case 1: {
                        nextStatus = nextMixer._data.getCircleStatus(row, column);
                        break;
                    }
                    case 3: {
                        nextStatus = nextMixer._data.getDrumPadStatus(row, column);
                    }
                }
                nextMixer.catchedValueDrum(nextStatus, timing, newValue, velocity, already);
                if (!this._patchTogether) {
                    return;
                }
            }
            boolean now = newValue;
            boolean prev = status.isValueLastDetect();
            int value = status.getValue();
            if (status.toMXMessage(timing).getCommand() == 192) {
                value = 0;
            }
            status.setSwitchLastDetected(velocity);
            boolean bl = flag = prev != now;
            if (!flag && !status.toMXMessage(timing).hasValueLowField()) {
                flag = true;
            }
            if (!flag && status.getSwitchInputType() == 1) {
                flag = true;
            }
            if (flag) {
                status.setValueLastDetect(now);
                if (now) {
                    if (status.isSwitchWithToggle()) {
                        boolean lastSent = status.isValueLastSent();
                        now = !lastSent;
                    }
                } else if (status.isSwitchWithToggle()) {
                    return;
                }
                MXMessage message = null;
                status.setValueLastSent(now);
                drumpad.updateUIOnly(now);
                if (now) {
                    if (status.getSwitchType() == 5) {
                        status.startSequence();
                        return;
                    }
                    if (status.getSwitchType() == 4) {
                        int[] noteList;
                        String notes = status.getSwitchHarmonyNotes();
                        int veltype = status.getSwitchHarmonyVelocityType();
                        if (veltype == 19) {
                            velocity = value != 0 ? value : status.getSwitchHarmonyVelocityFixed();
                        } else if (veltype == 20) {
                            velocity = status.getSwitchHarmonyVelocityFixed();
                        } else {
                            throw new IllegalStateException("velocity unknown");
                        }
                        for (int note : noteList = MXUtilMidi.textToNoteList(notes)) {
                            message = MXMessageFactory.fromShortMessage(this._port, 144 + status.getSwitchOutChannel(), note, velocity);
                            message._timing = timing;
                            already.sendOnlyNeed(message);
                        }
                        return;
                    }
                    message = status.toMXMessageCaseDrumOn(timing);
                    if (message == null) {
                        return;
                    }
                } else {
                    if (status.getSwitchType() == 1) {
                        return;
                    }
                    if (status.getSwitchType() == 5) {
                        status.stopSequence();
                        return;
                    }
                    if (status.getSwitchType() == 4) {
                        int[] noteList;
                        String notes = status.getSwitchHarmonyNotes();
                        for (int note : noteList = MXUtilMidi.textToNoteList(notes)) {
                            message = MXMessageFactory.fromShortMessage(this._port, 128 + status.getSwitchOutChannel(), note, 0);
                            message._timing = timing;
                            already.sendOnlyNeed(message);
                        }
                        return;
                    }
                    message = status.toMXMessageCaseDrumOff(timing);
                    if (message == null) {
                        return;
                    }
                }
                if ((message = MXMessageFactory.fromClone(message)).getValue() == 0 && message.getCommand() == 144) {
                    message = MXMessageFactory.fromShortMessage(this._port, 128 + message.getChannel(), message.getData1(), 0);
                }
                message._timing = timing;
                this.letsTryMessage(message, already);
            }
        }
    }

    public void makeCacheInternal1(MGStatus status) {
        if (status == null) {
            return;
        }
        MXMessage message = status.toMXMessage(null);
        if (message.getCommand() == 176) {
            int data1 = message.getData1();
            if (data1 == 6 || data1 == 96 || data1 == 97) {
                this._data._cachedDataentry.add(status);
                return;
            }
            if (this._data._cachedControlChange[message.getChannel()][data1] == null) {
                this._data._cachedControlChange[message.getChannel()][data1] = new ArrayList();
            }
            this._data._cachedControlChange[message.getChannel()][data1].add(status);
            int data2 = -1;
            if (data1 >= 0 && data1 <= 31 && status.isCCHasPair32()) {
                data2 = data1 + 32;
                if (this._data._cachedControlChange[message.getChannel()][data2] == null) {
                    this._data._cachedControlChange[message.getChannel()][data2] = new ArrayList();
                }
                this._data._cachedControlChange[message.getChannel()][data2].add(status);
            }
        } else if (message.getCommand() == 144 || message.getCommand() == 128 || message.getCommand() == 160) {
            int note = message.getData1();
            if (this._data._cachedNoteMessage[message.getChannel()][note] == null) {
                this._data._cachedNoteMessage[message.getChannel()][note] = new ArrayList();
            }
            this._data._cachedNoteMessage[message.getChannel()][note].add(status);
        } else if (message.isMessageTypeChannel()) {
            if (this._data._cachedChannelMessage[message.getChannel()][message.getCommand()] == null) {
                this._data._cachedChannelMessage[message.getChannel()][message.getCommand()] = new ArrayList();
            }
            this._data._cachedChannelMessage[message.getChannel()][message.getCommand()].add(status);
        } else {
            this._data._cachedSystemMessage.add(status);
        }
    }

    public synchronized List<MGStatus> getCachedList(MXMessage request) {
        if (this._data._cachedControlChange == null) {
            int column;
            int row;
            this._data._cachedControlChange = new ArrayList[16][256];
            this._data._cachedChannelMessage = new ArrayList[16][256];
            this._data._cachedNoteMessage = new ArrayList[16][256];
            this._data._cachedSystemMessage = new ArrayList();
            this._data._cachedDataentry = new ArrayList();
            for (row = 0; row < 1; ++row) {
                for (column = 0; column < 17; ++column) {
                    this.makeCacheInternal1(this._data.getSliderStatus(row, column));
                }
            }
            for (row = 0; row < 4; ++row) {
                for (column = 0; column < 17; ++column) {
                    this.makeCacheInternal1(this._data.getCircleStatus(row, column));
                }
            }
            for (row = 0; row < 3; ++row) {
                for (column = 0; column < 17; ++column) {
                    MGStatus status = this._data.getDrumPadStatus(row, column);
                    this.makeCacheInternal1(status);
                }
            }
        }
        if (request.getCommand() == 176) {
            int data1 = request.getData1();
            if (data1 == 6 || data1 == 96 || data1 == 97) {
                return this._data._cachedDataentry;
            }
            return this._data._cachedControlChange[request.getChannel()][request.getGate()];
        }
        if (request.getCommand() == 144 || request.getCommand() == 128 || request.getCommand() == 160) {
            return this._data._cachedNoteMessage[request.getChannel()][request.getGate()];
        }
        if (request.isMessageTypeChannel()) {
            return this._data._cachedChannelMessage[request.getChannel()][request.getCommand()];
        }
        return this._data._cachedSystemMessage;
    }

    public boolean isPairToPooled14bit(MXMessage message) {
        return this._poolFor14bit != null && message.getCommand() == 176 && (message.getGate() >= 0 && message.getGate() < 32 ? message.getGate() + 32 == this._poolFor14bit.getGate() : message.getGate() == this._poolFor14bit.getGate() + 32);
    }

    public int valueForPair(MXMessage message) {
        if (this.isPairToPooled14bit(message) && message.getCommand() == 176) {
            if (message.getGate() >= 0 && message.getGate() < 32) {
                if (message.getGate() + 32 == this._poolFor14bit.getGate()) {
                    return message.getValue() * 128 + this._poolFor14bit.getValue();
                }
            } else if (message.getGate() >= 32 && message.getChannel() <= 64 && message.getGate() == this._poolFor14bit.getGate() + 32) {
                return message.getValue() + this._poolFor14bit.getValue() * 128;
            }
        }
        throw new IllegalStateException("valueForPair not work at the moment");
    }

    public boolean isSameToPooled14bit(MXMessage message) {
        return this._poolFor14bit != null && message.getCommand() == 176 && message.getGate() == this._poolFor14bit.getGate();
    }

    public synchronized void clearPoolImpl() {
        if (this.lastTick + 400L < System.currentTimeMillis() && this._poolFor14bit != null) {
            MXMessage prev = this._poolFor14bit;
            this._poolFor14bit = null;
            prev.setValue14bit(true);
            this.sendToNext(prev);
            return;
        }
    }

    public synchronized void letsTryMessage(MXMessage message, UniqueChecker already) {
        if (already == null) {
            already = new UniqueChecker(this.getNextReceiver());
        }
        int fail = 0;
        int hit = 0;
        if (this._poolFor14bit != null) {
            if (this.isPairToPooled14bit(message)) {
                int value = this.valueForPair(message);
                this._poolFor14bit = null;
                message = MXMessageFactory.fromClone(message);
                message.setValue14bit(true);
                message.setValue(value);
                already.sendOnlyNeed(message);
                this.catchedValue(this._poolFor14bitStatus, message._timing, value, already);
                return;
            }
            this.clearPoolImpl();
        }
        int port = message.getPort();
        List<MGStatus> list = this.getCachedList(message);
        if (list != null) {
            boolean foundSome = false;
            for (int i = 0; i < list.size(); ++i) {
                MGStatus status = list.get(i);
                if (status.statusTryCatch(message)) {
                    int command = message.getCommand();
                    int gate = message.getGate();
                    if (command == 176 && gate >= 0 && gate < 32 && status.isCCHasPair32()) {
                        if (gate == message.getGate()) {
                            this._poolFor14bit = message;
                            this._poolFor14bitStatus = status;
                        } else {
                            if (gate + 32 != message.getGate()) continue;
                            this._poolFor14bit = message;
                            this._poolFor14bitStatus = status;
                        }
                        this.lastTick = System.currentTimeMillis();
                        foundSome = true;
                        ++hit;
                        MXGlobalTimer.letsCountdown(500L, new Runnable(){

                            @Override
                            public void run() {
                                MX32MixerProcess.this.clearPoolImpl();
                            }
                        });
                    }
                    this.catchedValue(status, message._timing, status.getValue(), already);
                    foundSome = true;
                    ++hit;
                    continue;
                }
                ++fail;
            }
            if (foundSome) {
                return;
            }
        }
        if (MXVisitant.isMesssageHaveVisitant(message)) {
            this._visitant16.get(message.getChannel()).updateVisitantChannel(message);
        }
        if (message.isMessageTypeChannel()) {
            this._visitant16.get(message.getChannel()).attachChannelVisitantToMessage(message);
        }
        already.sendOnlyNeed(message);
    }

    public void notifyCacheBroken() {
        this._data._cachedControlChange = null;
    }
}

