/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.mx30controller.MX30Process;
import jp.synthtarou.midimixer.mx30controller.MX32MixerProcess;
import jp.synthtarou.midimixer.mx30controller.MX32MixerView;

public class MX30View
extends JPanel {
    private static final MXDebugPrint _debug = new MXDebugPrint(MX30View.class);
    MX30Process _process;
    private JCheckBox jCheckBoxUseThisMixRecipe;
    private JTabbedPane jTabbedPane1;

    public MX30View(MX30Process process) {
        this._process = process;
        this.initComponents();
        this.jCheckBoxUseThisMixRecipe.setSelected(true);
    }

    public void addPage(int port, MX32MixerProcess process) {
        MX32MixerView view = (MX32MixerView)process.getReceiverView();
        this.jTabbedPane1.add(process.getReceiverName(), view);
        view.initControllers();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jCheckBoxUseThisMixRecipe = new JCheckBox();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MX30View.this.formFocusGained(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.jTabbedPane1.setBorder(BorderFactory.createTitledBorder("Controllers"));
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MX30View.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTabbedPane1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MX30View.this.jTabbedPane1FocusGained(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jCheckBoxUseThisMixRecipe.setText("Use This Recipe");
        this.jCheckBoxUseThisMixRecipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX30View.this.jCheckBoxUseThisMixRecipeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jCheckBoxUseThisMixRecipe, gridBagConstraints);
    }

    private void jCheckBoxUseThisMixRecipeActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxUseThisMixRecipe.isSelected()) {
            MXUtil.swingTreeEnable(this, true);
        } else {
            MXUtil.swingTreeEnable(this, false);
        }
        this.jCheckBoxUseThisMixRecipe.setEnabled(true);
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        int x = this.jTabbedPane1.getSelectedIndex();
        if (x >= 0) {
            MX32MixerView view = (MX32MixerView)this.jTabbedPane1.getComponentAt(x);
            view.setFocusString("");
        }
    }

    private void formFocusGained(FocusEvent evt) {
        int x = this.jTabbedPane1.getSelectedIndex();
        if (x >= 0) {
            Component c = this.jTabbedPane1.getComponentAt(x);
            c.requestFocusInWindow();
        }
    }

    private void jTabbedPane1FocusGained(FocusEvent evt) {
        int x = this.jTabbedPane1.getSelectedIndex();
        if (x >= 0) {
            Component c = this.jTabbedPane1.getComponentAt(x);
            c.requestFocusInWindow();
        }
    }

    public void lockAnothereTabs(boolean lock) {
        int x = this.jTabbedPane1.getSelectedIndex();
        if (lock) {
            for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
                this.jTabbedPane1.setEnabledAt(i, i == x);
            }
            MXUtil.swingTreeEditable(this.jTabbedPane1.getSelectedComponent(), false);
        } else {
            for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
                this.jTabbedPane1.setEnabledAt(i, true);
            }
            MXUtil.swingTreeEditable(this.jTabbedPane1.getSelectedComponent(), true);
        }
    }
}

