/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx30controller;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrap;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.domino.DTextMessage;
import jp.synthtarou.midimixer.libs.domino.DTextPicker;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMessageTemplate;
import jp.synthtarou.midimixer.libs.midi.MXTiming;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.capture.GateInfomation;
import jp.synthtarou.midimixer.libs.midi.capture.MXMessageCapture;
import jp.synthtarou.midimixer.libs.midi.capture.MXMessageCapturePanel;
import jp.synthtarou.midimixer.libs.swing.MXFileOpenChooser;
import jp.synthtarou.midimixer.libs.swing.SafeSpinnerNumberModel;
import jp.synthtarou.midimixer.mx30controller.MGStatus;
import jp.synthtarou.midimixer.mx30controller.MX32MixerProcess;
import jp.synthtarou.midimixer.mx30controller.MXNotePicker;

public class MGStatusConfig
extends JPanel {
    boolean _okOption = false;
    MX32MixerProcess _process;
    MXWrapList<Integer> _channelModel;
    MXWrapList<Integer> _ccGateModel;
    MXWrapList<Integer> _keyGateModel;
    MXWrapList<Integer> _normalGateModel;
    MXWrapList<Integer> _rpnMSBModel;
    MXWrapList<Integer> _rpnLSBModel;
    String _textCommadStartWith;
    protected MGStatus _status;
    boolean skipDataExchange = true;
    private ArrayList<String> textValidate = new ArrayList();
    private ArrayList<String> textTemplate = new ArrayList();
    MXWrapList<Integer> _drumInputType;
    MXWrapList<Integer> _drumOutOnType;
    MXWrapList<Integer> _drumOutOnValue;
    MXWrapList<Integer> _drumHarmonyVelocityType;
    MXWrapList<Integer> _drumOutOffType;
    MXWrapList<Integer> _drumOutOffValue;
    MXWrapList<Integer> _drumOutChannel;
    MXWrapList<Integer> _drumOutPort;
    static final String PROG_INC = "Program INC";
    static final String PROG_DEC = "Program DEC";
    MXMessageCapture _capture = null;
    ActionListener selectInternalCommand = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(MGStatusConfig.PROG_INC)) {
                MGStatusConfig.this._status.setTextCommand("@PROG_INC");
                MGStatusConfig.this.writeBufferToPanelSlider();
                MGStatusConfig.this.disableUnusedOnPanel();
                return;
            }
            if (e.getActionCommand().equals(MGStatusConfig.PROG_DEC)) {
                MGStatusConfig.this._status.setTextCommand("@PROG_DEC");
                MGStatusConfig.this.writeBufferToPanelSlider();
                MGStatusConfig.this.disableUnusedOnPanel();
                return;
            }
        }
    };
    private JButton jButton1;
    private JButton jButtonActionQuickMenu;
    private JButton jButtonCancel;
    private JButton jButtonCheckValue;
    private JButton jButtonFromBefore;
    private JButton jButtonFromList;
    private JButton jButtonHarmonyEdit;
    private JButton jButtonInputEdit;
    private JButton jButtonInternalCommand;
    private JButton jButtonOK;
    private JButton jButtonOutputOffEdit;
    private JButton jButtonOutputOnEdit;
    private JButton jButtonQuickMenuDrum;
    private JButton jButtonSequenceFileBrowse;
    private JCheckBox jCheckBoxCC14bit;
    private JCheckBox jCheckBoxSequencerFilterNote;
    private JCheckBox jCheckBoxSequencerSeekStart;
    private JCheckBox jCheckBoxSequencerSingleTrack;
    private JCheckBox jCheckBoxToggle;
    private JComboBox<String> jComboBoxChannel;
    private JComboBox<String> jComboBoxDrumChannel;
    private JComboBox<String> jComboBoxDrumPort;
    private JComboBox<String> jComboBoxGate;
    private JComboBox<String> jComboBoxHarmonyVelocityType;
    private JComboBox<String> jComboBoxInputType;
    private JComboBox<String> jComboBoxLSB;
    private JComboBox<String> jComboBoxMSB;
    private JComboBox<String> jComboBoxOutputOffType;
    private JComboBox<String> jComboBoxOutputOffValue;
    private JComboBox<String> jComboBoxOutputOnType;
    private JComboBox<String> jComboBoxOutputOnValue;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelBlank1;
    private JLabel jLabelBlank2;
    private JLabel jLabelInputText;
    private JLabel jLabelNameDefault;
    private JLabel jLabelOutputOffText;
    private JLabel jLabelOutputOnText;
    private JLabel jLabelStartWith;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonHarmony;
    private JRadioButton jRadioButtonOn;
    private JRadioButton jRadioButtonOnOff;
    private JRadioButton jRadioButtonSequence;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSpinner jSpinnerHarmonyVelocityFixed;
    private JSpinner jSpinnerMax;
    private JSpinner jSpinnerMin;
    private JSpinner jSpinnerOutOffValueFixed;
    private JSpinner jSpinnerOutOnValueFixed;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextAreaTemplate;
    private JTextArea jTextAreaValidation;
    private JTextField jTextFieldHarmonyNoteList;
    private JTextField jTextFieldMemo;
    private JTextField jTextFieldName;
    private JTextField jTextFieldSequenceFile;
    private JTextField jTextFieldTextCommand;

    public MGStatusConfig(MX32MixerProcess process, MGStatus status) {
        this.initComponents();
        this._process = process;
        this._status = status;
        this._textCommadStartWith = this._status.getTextCommand();
        this.jLabelStartWith.setText(this._textCommadStartWith);
        this.jLabelBlank2.setText("");
        this.jLabelBlank1.setText("");
        this.setPreferredSize(new Dimension(900, 700));
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRadioButtonOn);
        group.add(this.jRadioButtonOnOff);
        group.add(this.jRadioButtonHarmony);
        group.add(this.jRadioButtonSequence);
        if (this._status.getUiType() == 3) {
            this.jTabbedPane1.setEnabledAt(1, true);
        } else {
            this.jTabbedPane1.setEnabledAt(1, false);
        }
        this.skipDataExchange = false;
        this.jTextFieldTextCommand.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MGStatusConfig.this._status.setTextCommand(MGStatusConfig.this.jTextFieldTextCommand.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MGStatusConfig.this._status.setTextCommand(MGStatusConfig.this.jTextFieldTextCommand.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MGStatusConfig.this._status.setTextCommand(MGStatusConfig.this.jTextFieldTextCommand.getText());
            }
        });
        this.writeBufferToPanelSlider();
        this.writeBufferToPanelDrum();
        this.readBufferFromPanelSlider();
        this.readBufferFromPanelDrum();
        this.disableUnusedOnPanel();
        this.validateBuffer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBufferToPanelSlider() {
        if (this.skipDataExchange) {
            return;
        }
        this.skipDataExchange = true;
        try {
            if (this._channelModel == null) {
                this._channelModel = MXUtilMidi.createChannel(false);
                this._ccGateModel = MXUtilMidi.createControlChange();
                this._keyGateModel = MXUtilMidi.createNoteNo();
                this._normalGateModel = MXUtilMidi.createNormalGate();
                this._rpnMSBModel = MXUtilMidi.createXSB();
                this._rpnLSBModel = MXUtilMidi.createXSB();
            }
            if (this._status.getName() == null) {
                this._status.setName("");
            }
            if (!this.jTextFieldName.getText().equals(this._status.getName())) {
                this.jTextFieldName.setText(this._status.getName());
            }
            if (this._status.getMemo() == null) {
                this._status.setMemo("");
            }
            if (!this.jTextFieldMemo.getText().equals(this._status.getMemo())) {
                this.jTextFieldMemo.setText(this._status.getMemo());
            }
            if (this._status.getTextCommand() == null) {
                this._status.setTextCommand("");
            }
            if (!this.jTextFieldTextCommand.getText().equals(this._status.getTextCommand())) {
                this.jTextFieldTextCommand.setText(this._status.getTextCommand());
            }
            this.jLabelStartWith.setText(this._textCommadStartWith);
            this._channelModel.writeComboBox(this.jComboBoxChannel, this._status.getChannel());
            MXMessage message = this._status.toMXMessage(null);
            int command = message.getCommand();
            boolean initTurn = true;
            if (this.jComboBoxGate.getModel() instanceof MXWrapList) {
                initTurn = false;
            }
            this.jLabelNameDefault.setText("Empty means-> '" + message.toShortString() + "'");
            if (command == 208 || command == 144 || command == 128) {
                this.jComboBoxGate.setModel(this._keyGateModel);
                if (initTurn || ((Integer)((MXWrap)this.jComboBoxGate.getSelectedItem()).value).intValue() != this._status.getGate()) {
                    this._keyGateModel.writeComboBox(this.jComboBoxGate, this._status.getGate());
                }
            } else if (command == 176) {
                this.jComboBoxGate.setModel(this._ccGateModel);
                if (initTurn || ((Integer)((MXWrap)this.jComboBoxGate.getSelectedItem()).value).intValue() != this._status.getGate()) {
                    this._ccGateModel.writeComboBox(this.jComboBoxGate, this._status.getGate());
                }
            } else {
                this.jComboBoxGate.setModel(this._normalGateModel);
                if (initTurn || ((Integer)((MXWrap)this.jComboBoxGate.getSelectedItem()).value).intValue() != this._status.getGate()) {
                    this._normalGateModel.writeComboBox(this.jComboBoxGate, this._status.getGate());
                }
            }
            this.jSpinnerOutOnValueFixed.setModel(new SafeSpinnerNumberModel(this._status.getSwitchOutOnValueFixed(), 0, 16383, 1));
            this.jSpinnerOutOffValueFixed.setModel(new SafeSpinnerNumberModel(this._status.getSwitchOutOffValueFixed(), 0, 16383, 1));
            this.jSpinnerMin.setModel(new SafeSpinnerNumberModel(this._status.getRangeMin(), 0, 16383, 1));
            this.jSpinnerMax.setModel(new SafeSpinnerNumberModel(this._status.getRangeMax(), 0, 16383, 1));
            this._rpnMSBModel.writeComboBox(this.jComboBoxMSB, this._status.getDataeroomMSB());
            this._rpnLSBModel.writeComboBox(this.jComboBoxLSB, this._status.getDataroomLSB());
            if (this.jCheckBoxCC14bit.isSelected()) {
                if (this._status.isCCHasPair32()) {
                } else {
                    this.jCheckBoxCC14bit.setSelected(this._status.isCCHasPair32());
                }
            } else if (this._status.isCCHasPair32()) {
                this.jCheckBoxCC14bit.setSelected(this._status.isCCHasPair32());
            }
        }
        finally {
            this.skipDataExchange = false;
        }
        this.updateUI();
    }

    public int validateBuffer(boolean canDialog) {
        String errorText;
        int wishMax;
        if (this.skipDataExchange) {
            return -1;
        }
        ArrayList<String> result = new ArrayList<String>();
        MGStatus data = this._status;
        if (data.getName() == null) {
            data.setName("");
        }
        if (data.getName().length() == 0) {
            // empty if block
        }
        if (data.getMemo() == null) {
            data.setMemo("");
        }
        if (data.getMemo().length() == 0) {
            // empty if block
        }
        if (data.getTextCommand() == null) {
            data.setTextCommand("");
        }
        if (data.getTextCommand().length() == 0) {
            result.add("TextCommand is empty. Please fill it.");
        } else {
            try {
                MXMessage message = data.toMXMessage(null);
                if (message == null) {
                    result.add("TextCommand [" + data.getTextCommand() + "] is not valid.");
                }
                if (message.isDataentry()) {
                    if (message.getVisitant() == null || message.getVisitant().getDataroomType() == 0) {
                        result.add("If you need DATAENTRY. try QuickMenu.");
                    } else if (message.getVisitant() != null && !message.getVisitant().isHaveDataentryRPN() && message.getVisitant().isHaveDataentryNRPN()) {
                        // empty if block
                    }
                } else if (message.isMessageTypeChannel() && message.getCommand() == 176 && !message.isDataentry()) {
                    String newText = "@CC #GL #VL";
                    if (!data.getTextCommand().equals(newText)) {
                        String errorText2 = "ControlChange's Text Command can be '" + newText + "'";
                        if (canDialog && JOptionPane.showConfirmDialog(this, errorText2, "Smart Replace", 0) == 0) {
                            this.skipDataExchange = true;
                            data.setTextCommand(newText);
                            this.jTextFieldTextCommand.setText(newText);
                            data.setGate(message.getGate());
                            this._ccGateModel.writeComboBox(this.jComboBoxGate, data.getGate());
                            this.skipDataExchange = false;
                        } else {
                            result.add(errorText2);
                        }
                    }
                }
            }
            catch (Exception e) {
                result.add("TextCommand [" + data.getTextCommand() + "] is not valid.");
            }
        }
        if (data.getChannel() < 0 || data.getChannel() < 16) {
            // empty if block
        }
        int min = data.getRangeMin();
        int max = data.getRangeMax();
        int n = wishMax = data.toMXMessage(null).hasValueHiField() ? 16383 : 127;
        if (max != wishMax || min != 0) {
            errorText = "Seems custom ranged value, Do you want to reset to 0 ... " + wishMax;
            if (canDialog && JOptionPane.showConfirmDialog(this, errorText, "Smart Replace", 0) == 0) {
                this.skipDataExchange = true;
                data.setRangeMin(0);
                data.setRangeMin(wishMax);
                this.jSpinnerMin.setValue(0);
                this.jSpinnerMax.setValue(wishMax);
                this.skipDataExchange = false;
                result.add("value range reset ok. push OK again");
            }
        }
        if (max > wishMax || min < 0 || max < min) {
            errorText = "Valid Range must 0 <= min <= max <= " + wishMax;
            result.add(errorText);
        }
        this.validateBufferSubDrum(result);
        this.textValidate = result;
        this.printValidateResult();
        return result.size();
    }

    public void printValidateResult() {
        StringBuffer str = new StringBuffer();
        if (this.textValidate.size() == 0) {
            str.append("**Validation All OK**\n");
        } else {
            str.append("**Validation Result**\n");
            for (String line : this.textValidate) {
                str.append("\n");
                str.append(line);
            }
        }
        if (str.charAt(str.length() - 1) == '\n') {
            str.setLength(str.length() - 1);
        }
        this.jTextAreaValidation.setText(str.toString());
    }

    public void printTemplateResult() {
        StringBuffer str = new StringBuffer();
        if (this.textTemplate.size() != 0) {
            boolean firstColumn = true;
            for (String line : this.textTemplate) {
                if (firstColumn) {
                    str.append("**Template [" + line + "] Need Fill*\n");
                    firstColumn = false;
                    continue;
                }
                str.append(line);
                str.append("\n");
            }
        }
        this.jTextAreaTemplate.setText(str.toString());
    }

    public void validateBufferSubDrum(ArrayList<String> result) {
        if (this._status.getUiType() != 3) {
            return;
        }
    }

    public void disableUnusedOnPanel() {
        if (this._status == null) {
            return;
        }
        boolean isdataentry = false;
        MXMessageTemplate temp = this._status.getTemplate();
        if (temp.get(0) == 16384 || temp.get(0) == 16640) {
            isdataentry = true;
        }
        this.jComboBoxLSB.setEnabled(isdataentry);
        this.jComboBoxMSB.setEnabled(isdataentry);
        if (this._status.getUiType() != 3) {
            return;
        }
        int type = this.getDrumType();
        boolean zoneX = false;
        boolean zoneA = false;
        boolean zoneB = false;
        boolean zoneC = false;
        boolean zoneD = false;
        boolean zoneE = false;
        switch (type) {
            case 1: {
                zoneX = true;
                zoneA = true;
                break;
            }
            case 2: {
                zoneX = true;
                zoneA = true;
                zoneB = true;
                zoneC = true;
                break;
            }
            case 4: {
                zoneX = true;
                zoneA = false;
                zoneB = false;
                zoneC = true;
                zoneD = true;
                zoneE = false;
                break;
            }
            case 5: {
                zoneX = true;
                zoneA = false;
                zoneB = false;
                zoneC = true;
                zoneD = false;
                zoneE = true;
            }
        }
        this.jButtonInputEdit.setEnabled(zoneX);
        this.jComboBoxInputType.setEnabled(zoneX);
        this.jButtonOutputOnEdit.setEnabled(zoneA);
        this.jComboBoxOutputOnType.setEnabled(zoneA);
        this.jComboBoxOutputOnValue.setEnabled(zoneA);
        int x = this._drumOutOnValue.readCombobox(this.jComboBoxOutputOnValue);
        this.jSpinnerOutOnValueFixed.setEnabled(zoneA);
        this.jComboBoxDrumPort.setEnabled(zoneA || zoneB || zoneC || zoneD);
        this.jComboBoxDrumChannel.setEnabled(zoneA || zoneB || zoneC || zoneD);
        this.jButtonOutputOffEdit.setEnabled(zoneB);
        this.jComboBoxOutputOffType.setEnabled(zoneB);
        this.jComboBoxOutputOffValue.setEnabled(zoneB);
        x = this._drumOutOffValue.readCombobox(this.jComboBoxOutputOffValue);
        this.jSpinnerOutOffValueFixed.setEnabled(zoneB && x == 18);
        this.jCheckBoxToggle.setEnabled(zoneC);
        this.jButtonHarmonyEdit.setEnabled(zoneD);
        this.jTextFieldHarmonyNoteList.setEnabled(zoneD);
        this.jComboBoxHarmonyVelocityType.setEnabled(zoneD);
        x = this._drumHarmonyVelocityType.readCombobox(this.jComboBoxHarmonyVelocityType);
        this.jSpinnerHarmonyVelocityFixed.setEnabled(zoneD);
        this.jTextFieldSequenceFile.setEnabled(zoneE);
        this.jButtonSequenceFileBrowse.setEnabled(zoneE);
        this.jCheckBoxSequencerSeekStart.setEnabled(zoneE);
        this.jCheckBoxSequencerSingleTrack.setEnabled(zoneE);
        this.jCheckBoxSequencerFilterNote.setEnabled(zoneE);
    }

    public void writeBufferToPanelDrum() {
        int switchType;
        if (this.skipDataExchange) {
            return;
        }
        if (this._status.getUiType() != 3) {
            return;
        }
        if (this._drumInputType == null) {
            this._drumInputType = new MXWrapList();
            this._drumInputType.addNameAndValue("value >= min + 1", 2);
            this._drumInputType.addNameAndValue("any", 1);
            this._drumInputType.addNameAndValue("value >= half", 3);
            this._drumInputType.addNameAndValue("value == max", 4);
            this.jComboBoxInputType.setModel(this._drumInputType);
            this._drumOutOnType = new MXWrapList();
            this._drumOutOnType.addNameAndValue("same as input", 5);
            this._drumOutOnType.addNameAndValue("custom", 6);
            this.jComboBoxOutputOnType.setModel(this._drumOutOnType);
            this._drumOutOnValue = new MXWrapList();
            this._drumOutOnValue.addNameAndValue("on value = as input", 9);
            this._drumOutOnValue.addNameAndValue("on value = as input+1  (... max)", 8);
            this._drumOutOnValue.addNameAndValue("fixed", 10);
            this.jComboBoxOutputOnValue.setModel(this._drumOutOnValue);
            this.jSpinnerOutOnValueFixed.setModel(new SpinnerNumberModel(127, 0, 16383, 1));
            this._drumOutOffType = new MXWrapList();
            this._drumOutOffType.addNameAndValue("none", 11);
            this._drumOutOffType.addNameAndValue("same as input", 12);
            this._drumOutOffType.addNameAndValue("same as output on", 13);
            this._drumOutOffType.addNameAndValue("custom", 14);
            this.jComboBoxOutputOffType.setModel(this._drumOutOffType);
            this._drumOutOffValue = new MXWrapList();
            this._drumOutOffValue.addNameAndValue("0", 15);
            this._drumOutOffValue.addNameAndValue("same as min", 16);
            this._drumOutOffValue.addNameAndValue("same as input", 17);
            this._drumOutOffValue.addNameAndValue("fixed value", 18);
            this.jComboBoxOutputOffValue.setModel(this._drumOutOffValue);
            this.jSpinnerOutOffValueFixed.setModel(new SpinnerNumberModel(127, 0, 16383, 1));
            this._drumHarmonyVelocityType = new MXWrapList();
            this._drumHarmonyVelocityType.addNameAndValue("same as input", 19);
            this._drumHarmonyVelocityType.addNameAndValue("fixed value", 20);
            this.jComboBoxHarmonyVelocityType.setModel(this._drumHarmonyVelocityType);
            this.jSpinnerHarmonyVelocityFixed.setModel(new SpinnerNumberModel(127, 0, 127, 1));
            this.jTextFieldHarmonyNoteList.setText("");
            this.jTextFieldSequenceFile.setText("");
            this.jLabelBlank2.setText("");
            this._drumOutPort = MXUtilMidi.createPortAssigned(false);
            this._drumOutChannel = MXUtilMidi.createChannel(false);
            this.jComboBoxDrumPort.setModel(this._drumOutPort);
            this.jComboBoxDrumChannel.setModel(this._drumOutChannel);
        }
        this.jRadioButtonOn.setSelected((switchType = this._status.getSwitchType()) == 1);
        this.jRadioButtonOnOff.setSelected(switchType == 2);
        this.jRadioButtonHarmony.setSelected(switchType == 4);
        this.jRadioButtonSequence.setSelected(switchType == 5);
        this.jComboBoxInputType.setSelectedIndex(this._drumInputType.indexOfValue(this._status.getSwitchInputType()));
        this.jComboBoxOutputOnType.setSelectedIndex(this._drumOutOnType.indexOfValue(this._status.getSwitchOutOnType()));
        this.jComboBoxOutputOnValue.setSelectedIndex(this._drumOutOnValue.indexOfValue(this._status.getSwitchOutOnTypeOfValue()));
        this.showsub1();
        this.jSpinnerOutOnValueFixed.setValue(this._status.getSwitchOutOnValueFixed());
        this.jComboBoxOutputOffType.setSelectedIndex(this._drumOutOffType.indexOfValue(this._status.getSwitchOutOffType()));
        this.jComboBoxOutputOffValue.setSelectedIndex(this._drumOutOffValue.indexOfValue(this._status.getSwitchOutOffTypeOfValue()));
        this.jSpinnerOutOffValueFixed.setValue(this._status.getSwitchOutOffValueFixed());
        this.jCheckBoxToggle.setSelected(this._status.isSwitchWithToggle());
        this.jComboBoxHarmonyVelocityType.setSelectedIndex(this._drumHarmonyVelocityType.indexOfValue(this._status.getSwitchHarmonyVelocityType()));
        this.jSpinnerHarmonyVelocityFixed.setValue(this._status.getSwitchHarmonyVelocityFixed());
        this.jTextFieldHarmonyNoteList.setText(this._status.getSwitchHarmonyNotes());
        this.jTextFieldSequenceFile.setText(this._status.getSwitchSequencerFile());
        this._drumOutPort.writeComboBox(this.jComboBoxDrumPort, this._status.getSwitchOutPort());
        this._drumOutChannel.writeComboBox(this.jComboBoxDrumChannel, this._status.getSwitchOutChannel());
        this.jCheckBoxSequencerSeekStart.setSelected(this._status.isSwitchSequenceSeekStart());
        this.jCheckBoxSequencerSingleTrack.setSelected(this._status.isSwitchSequencerToSingltTrack());
        this.jCheckBoxSequencerFilterNote.setSelected(this._status.isSwitchSequencerFilterNote());
    }

    public void fillMeanAndSuggestion() {
        MGStatus data = this._status;
        data.setName(this.jTextFieldName.getText());
        data.setMemo(this.jTextFieldMemo.getText());
        data.setTextCommand(this.jTextFieldTextCommand.getText());
        data.setChannel(this._channelModel.readCombobox(this.jComboBoxChannel));
        MXWrap x = (MXWrap)this.jComboBoxGate.getSelectedItem();
        data.setGate((Integer)x.value);
        data.setRangeMin((Integer)this.jSpinnerMin.getValue());
        data.setRangeMax((Integer)this.jSpinnerMax.getValue());
    }

    public void readBufferFromPanelSlider() {
        if (this.skipDataExchange) {
            return;
        }
        this._status.setName(this.jTextFieldName.getText());
        this._status.setMemo(this.jTextFieldMemo.getText());
        this._status.setTextCommand(this.jTextFieldTextCommand.getText());
        this._status.setChannel(this._channelModel.readCombobox(this.jComboBoxChannel));
        MXWrap x = (MXWrap)this.jComboBoxGate.getSelectedItem();
        this._status.setGate((Integer)x.value);
        this._status.setRangeMin((Integer)this.jSpinnerMin.getValue());
        this._status.setRangeMax((Integer)this.jSpinnerMax.getValue());
        this._status.setDataroomMSB(this._rpnMSBModel.readCombobox(this.jComboBoxMSB));
        this._status.setDataroomLSB(this._rpnLSBModel.readCombobox(this.jComboBoxLSB));
        boolean changed = false;
        try {
            this._status.setDataroomType(0);
            MXMessageTemplate template = MXMessageFactory.fromDtext(this._status.getTextCommand(), this._status.getChannel());
            MXMessage message = template.buildMessage(this._status.getPort(), this._status.getGate(), this._status.getValue());
            this.skipDataExchange = true;
            if (message.getGate() != this._status.getGate()) {
                this._status.setGate(message.getGate());
                changed = true;
            }
            if (message.getTemplate(0) == 16384) {
                this._status.setDataroomType(1);
                changed = true;
            } else if (message.getTemplate(0) == 16640) {
                this._status.setDataroomType(2);
                changed = true;
            }
            this.skipDataExchange = false;
            if (changed) {
                this.writeBufferToPanelSlider();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MXMessage msg = this._status.toMXMessage(null);
        boolean canHave14bit = false;
        if (msg.getCommand() == 176 && msg.getData1() >= 0 && msg.getData1() < 32) {
            canHave14bit = true;
        }
        if (canHave14bit) {
            this._status.setCCHasPair32(this.jCheckBoxCC14bit.isSelected());
            this.jCheckBoxCC14bit.setEnabled(true);
        } else {
            this._status.setCCHasPair32(false);
            this.jCheckBoxCC14bit.setEnabled(false);
            this.jCheckBoxCC14bit.setSelected(false);
        }
    }

    public void readBufferFromPanelDrum() {
        if (this.skipDataExchange) {
            return;
        }
        if (this._status.getUiType() != 3) {
            return;
        }
        MGStatus data = this._status;
        data.setSwitchType(this.getDrumType());
        data.setSwitchInputType(this._drumInputType.readCombobox(this.jComboBoxInputType));
        data.setSwitchOutOnType(this._drumOutOnType.readCombobox(this.jComboBoxOutputOnType));
        data.setSwitchOutOnTypeOfValue(this._drumOutOnValue.readCombobox(this.jComboBoxOutputOnValue));
        data.setSwitchOutOnValueFixed((Integer)this.jSpinnerOutOnValueFixed.getValue());
        data.setSwitchOutOffType(this._drumOutOffType.readCombobox(this.jComboBoxOutputOffType));
        data.setSwitchOutOffTypeOfValue(this._drumOutOffValue.readCombobox(this.jComboBoxOutputOffValue));
        data.setSwitchOutOffValueFixed((Integer)this.jSpinnerOutOffValueFixed.getValue());
        data.setSwitchWithToggle(this.jCheckBoxToggle.isSelected());
        data.setSwitchOutPort(this._drumOutPort.readCombobox(this.jComboBoxDrumPort));
        data.setSwitchOutChannel(this._drumOutChannel.readCombobox(this.jComboBoxDrumChannel));
        data.setSwitchHarmonyVelocityType(this._drumHarmonyVelocityType.readCombobox(this.jComboBoxHarmonyVelocityType));
        data.setSwitchHarmonyVelocityFixed((Integer)this.jSpinnerHarmonyVelocityFixed.getValue());
        data.setSwitchHarmonyNotes(this.jTextFieldHarmonyNoteList.getText());
        data.setSwitchSequencerFile(this.jTextFieldSequenceFile.getText());
        data.setSwitchSequenceSeekStart(this.jCheckBoxSequencerSeekStart.isSelected());
        data.setSwitchSequencerToSingltTrack(this.jCheckBoxSequencerSingleTrack.isSelected());
        data.setSwitchSequencerFilterNote(this.jCheckBoxSequencerFilterNote.isSelected());
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldTextCommand = new JTextField();
        this.jButtonFromBefore = new JButton();
        this.jButtonFromList = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldMemo = new JTextField();
        this.jButtonInternalCommand = new JButton();
        this.jLabelStartWith = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel9 = new JLabel();
        this.jSpinnerMax = new JSpinner();
        this.jButtonActionQuickMenu = new JButton();
        this.jLabel10 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSpinnerMin = new JSpinner();
        this.jComboBoxGate = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jComboBoxChannel = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabelBlank1 = new JLabel();
        this.jLabelNameDefault = new JLabel();
        this.jSeparator5 = new JSeparator();
        this.jComboBoxMSB = new JComboBox();
        this.jComboBoxLSB = new JComboBox();
        this.jLabel23 = new JLabel();
        this.jLabel33 = new JLabel();
        this.jSeparator6 = new JSeparator();
        this.jLabel15 = new JLabel();
        this.jCheckBoxCC14bit = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jCheckBoxToggle = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.jComboBoxInputType = new JComboBox();
        this.jRadioButtonOnOff = new JRadioButton();
        this.jRadioButtonHarmony = new JRadioButton();
        this.jRadioButtonSequence = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jRadioButtonOn = new JRadioButton();
        this.jLabel18 = new JLabel();
        this.jComboBoxOutputOnType = new JComboBox();
        this.jComboBoxOutputOffType = new JComboBox();
        this.jSpinnerHarmonyVelocityFixed = new JSpinner();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jComboBoxOutputOffValue = new JComboBox();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jTextFieldHarmonyNoteList = new JTextField();
        this.jButtonSequenceFileBrowse = new JButton();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jTextFieldSequenceFile = new JTextField();
        this.jLabel30 = new JLabel();
        this.jComboBoxOutputOnValue = new JComboBox();
        this.jSpinnerOutOnValueFixed = new JSpinner();
        this.jSpinnerOutOffValueFixed = new JSpinner();
        this.jButtonOutputOffEdit = new JButton();
        this.jButtonOutputOnEdit = new JButton();
        this.jLabelOutputOnText = new JLabel();
        this.jLabelOutputOffText = new JLabel();
        this.jComboBoxDrumChannel = new JComboBox();
        this.jButtonHarmonyEdit = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jLabelBlank2 = new JLabel();
        this.jLabelInputText = new JLabel();
        this.jButtonInputEdit = new JButton();
        this.jComboBoxHarmonyVelocityType = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jComboBoxDrumPort = new JComboBox();
        this.jCheckBoxSequencerSeekStart = new JCheckBox();
        this.jCheckBoxSequencerSingleTrack = new JCheckBox();
        this.jCheckBoxSequencerFilterNote = new JCheckBox();
        this.jLabel32 = new JLabel();
        this.jButtonQuickMenuDrum = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaValidation = new JTextArea();
        this.jButtonCheckValue = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaTemplate = new JTextArea();
        this.setBorder(new SoftBevelBorder(0));
        this.setLayout(new GridBagLayout());
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MGStatusConfig.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Start was");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel3.setText("Command Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextFieldTextCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jTextFieldTextCommandActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 3.0;
        this.jPanel2.add((Component)this.jTextFieldTextCommand, gridBagConstraints);
        this.jButtonFromBefore.setText("Reset Command Text To When Start");
        this.jButtonFromBefore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonFromBeforeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jButtonFromBefore, gridBagConstraints);
        this.jButtonFromList.setText("Domino XML");
        this.jButtonFromList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonFromListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jButtonFromList, gridBagConstraints);
        this.jLabel2.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 3.0;
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel7.setText("Memo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 3.0;
        this.jPanel2.add((Component)this.jTextFieldMemo, gridBagConstraints);
        this.jButtonInternalCommand.setText("From Internal");
        this.jButtonInternalCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonInternalCommandActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jButtonInternalCommand, gridBagConstraints);
        this.jLabelStartWith.setText("F7 00 F0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jLabelStartWith, gridBagConstraints);
        this.jButton1.setText("From Capture");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel9.setText("Information");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints);
        this.jSpinnerMax.setModel(new SpinnerNumberModel(0, 0, 16383, 1));
        this.jSpinnerMax.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MGStatusConfig.this.jSpinnerMaxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jSpinnerMax, gridBagConstraints);
        this.jButtonActionQuickMenu.setText("Quick Menu");
        this.jButtonActionQuickMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonActionQuickMenuActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jButtonActionQuickMenu, gridBagConstraints);
        this.jLabel10.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel4.setText("Channel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jSpinnerMin.setModel(new SpinnerNumberModel(0, 0, 16383, 1));
        this.jSpinnerMin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MGStatusConfig.this.jSpinnerMinStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jSpinnerMin, gridBagConstraints);
        this.jComboBoxGate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxGateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.jPanel2.add(this.jComboBoxGate, gridBagConstraints);
        this.jLabel5.setText("Gate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jComboBoxChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxChannelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.jPanel2.add(this.jComboBoxChannel, gridBagConstraints);
        this.jLabel11.setText("Value Range    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setText("I/O Data (Common)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        this.jPanel2.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabelBlank1.setText("BLANK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jLabelBlank1, gridBagConstraints);
        this.jLabelNameDefault.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabelNameDefault, gridBagConstraints);
        this.jPanel2.add((Component)this.jSeparator5, new GridBagConstraints());
        this.jComboBoxMSB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MGStatusConfig.this.jComboBoxMSBItemStateChanged(evt);
            }
        });
        this.jComboBoxMSB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxMSBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add(this.jComboBoxMSB, gridBagConstraints);
        this.jComboBoxLSB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MGStatusConfig.this.jComboBoxLSBItemStateChanged(evt);
            }
        });
        this.jComboBoxLSB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxLSBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add(this.jComboBoxLSB, gridBagConstraints);
        this.jLabel23.setText("DataEntry MSB");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel33.setText("LSB");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.jLabel33, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jSeparator6, gridBagConstraints);
        this.jLabel15.setText("ControlChange");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel15, gridBagConstraints);
        this.jCheckBoxCC14bit.setText("Allow 14 bit with (CC: 0 to 31 can pair with #+32, And RPN NRPN)");
        this.jCheckBoxCC14bit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jCheckBoxCC14bitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jCheckBoxCC14bit, gridBagConstraints);
        this.jTabbedPane1.addTab("Configuration", this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jCheckBoxToggle.setText("Toggle Switch");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jCheckBoxToggle, gridBagConstraints);
        this.jLabel13.setText("When Turn ON");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel13, gridBagConstraints);
        this.jComboBoxInputType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxInputTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add(this.jComboBoxInputType, gridBagConstraints);
        this.jRadioButtonOnOff.setText("ON / OFF");
        this.jRadioButtonOnOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jRadioButtonOnOffActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jRadioButtonOnOff, gridBagConstraints);
        this.jRadioButtonHarmony.setText("Chord Harmony");
        this.jRadioButtonHarmony.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jRadioButtonHarmonyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jRadioButtonHarmony, gridBagConstraints);
        this.jRadioButtonSequence.setText("Sequence");
        this.jRadioButtonSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jRadioButtonSequenceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jRadioButtonSequence, gridBagConstraints);
        this.jLabel6.setText("Output Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel16.setText("Ouput [On]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel17.setText("Output [Off]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel17, gridBagConstraints);
        this.jRadioButtonOn.setText("ON (Single)");
        this.jRadioButtonOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jRadioButtonOnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jRadioButtonOn, gridBagConstraints);
        this.jLabel18.setText("jLabel18");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel18, gridBagConstraints);
        this.jComboBoxOutputOnType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxOutputOnTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add(this.jComboBoxOutputOnType, gridBagConstraints);
        this.jComboBoxOutputOffType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxOutputOffTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add(this.jComboBoxOutputOffType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jSpinnerHarmonyVelocityFixed, gridBagConstraints);
        this.jLabel20.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel21.setText("Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel21, gridBagConstraints);
        this.jLabel22.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel22, gridBagConstraints);
        this.jComboBoxOutputOffValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxOutputOffValueActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add(this.jComboBoxOutputOffValue, gridBagConstraints);
        this.jLabel24.setText("Harmony/Sequence");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel25.setText("Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel25, gridBagConstraints);
        this.jTextFieldHarmonyNoteList.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jTextFieldHarmonyNoteList, gridBagConstraints);
        this.jButtonSequenceFileBrowse.setText("Browse");
        this.jButtonSequenceFileBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonSequenceFileBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jButtonSequenceFileBrowse, gridBagConstraints);
        this.jLabel26.setText("Port/Channel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel27.setText("NoteList");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel27, gridBagConstraints);
        this.jLabel28.setText("Velocity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel28, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jTextFieldSequenceFile, gridBagConstraints);
        this.jLabel30.setText("SMF File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel30, gridBagConstraints);
        this.jComboBoxOutputOnValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxOutputOnValueActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanel3.add(this.jComboBoxOutputOnValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jSpinnerOutOnValueFixed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jSpinnerOutOffValueFixed, gridBagConstraints);
        this.jButtonOutputOffEdit.setText("Edit");
        this.jButtonOutputOffEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonOutputOffEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jButtonOutputOffEdit, gridBagConstraints);
        this.jButtonOutputOnEdit.setText("Edit");
        this.jButtonOutputOnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonOutputOnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jButtonOutputOnEdit, gridBagConstraints);
        this.jLabelOutputOnText.setText("=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabelOutputOnText, gridBagConstraints);
        this.jLabelOutputOffText.setText("=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabelOutputOffText, gridBagConstraints);
        this.jComboBoxDrumChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxDrumChannelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add(this.jComboBoxDrumChannel, gridBagConstraints);
        this.jButtonHarmonyEdit.setText("Edit");
        this.jButtonHarmonyEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonHarmonyEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jButtonHarmonyEdit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jSeparator4, gridBagConstraints);
        this.jLabelBlank2.setText("BLANK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jLabelBlank2, gridBagConstraints);
        this.jLabelInputText.setText("=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabelInputText, gridBagConstraints);
        this.jButtonInputEdit.setText("Edit");
        this.jButtonInputEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonInputEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jButtonInputEdit, gridBagConstraints);
        this.jComboBoxHarmonyVelocityType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jComboBoxHarmonyVelocityTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add(this.jComboBoxHarmonyVelocityType, gridBagConstraints);
        this.jLabel8.setText("Fix or Mouse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        this.jPanel3.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel14.setText("Fix or Mouse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 13;
        this.jPanel3.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel19.setText("Fix or Mouse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 17;
        this.jPanel3.add((Component)this.jLabel19, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add(this.jComboBoxDrumPort, gridBagConstraints);
        this.jCheckBoxSequencerSeekStart.setText("Play Start Timing = 1st Note");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jCheckBoxSequencerSeekStart, gridBagConstraints);
        this.jCheckBoxSequencerSingleTrack.setText("Play in Single  Track");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jCheckBoxSequencerSingleTrack, gridBagConstraints);
        this.jCheckBoxSequencerFilterNote.setText("Only Play Note, Pitch, Wheel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jCheckBoxSequencerFilterNote, gridBagConstraints);
        this.jLabel32.setText("Play Option");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel32, gridBagConstraints);
        this.jButtonQuickMenuDrum.setText("QuickMenu");
        this.jButtonQuickMenuDrum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonQuickMenuDrumActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jButtonQuickMenuDrum, gridBagConstraints);
        this.jTabbedPane1.addTab("Drum Config", this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jButtonCancel.setText("Cancel Edit");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jButtonOK, gridBagConstraints);
        this.jTextAreaValidation.setEditable(false);
        this.jTextAreaValidation.setColumns(20);
        this.jTextAreaValidation.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaValidation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonCheckValue.setText("Validation");
        this.jButtonCheckValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGStatusConfig.this.jButtonCheckValueActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jButtonCheckValue, gridBagConstraints);
        this.jTextAreaTemplate.setColumns(20);
        this.jTextAreaTemplate.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextAreaTemplate);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    private void jButtonFromBeforeActionPerformed(ActionEvent evt) {
        this.jTextFieldTextCommand.setText(this.jLabelStartWith.getText());
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.readBufferFromPanelSlider();
        this.readBufferFromPanelDrum();
        this.disableUnusedOnPanel();
        if (this.validateBuffer(true) > 0) {
            return;
        }
        if (this._status.toMXMessage(null) == null) {
            JOptionPane.showMessageDialog(this, "invalid text command", "Error", 0);
            return;
        }
        this._okOption = true;
        MXUtil.closeOwnerWindow(this);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this._okOption = false;
        MXUtil.closeOwnerWindow(this);
    }

    private void jButtonFromListActionPerformed(ActionEvent evt) {
        DTextPicker picker = new DTextPicker();
        MXUtil.showAsDialog(this, picker, "Picker");
        DTextMessage x = picker.getTextReturn();
        if (x != null) {
            try {
                MXMessageTemplate template = MXMessageFactory.fromDtext(x.getDataText(), 0);
                MXMessage msg = template.buildMessage(this._process._port, x.getGate(), 0);
                this._status.setTextCommand(x.getDataText());
                String min = x.getValueMin();
                String max = x.getValueMax();
                String offset = x.getValueOffset();
                if (min == null && max == null) {
                    if (msg.canPaired14bit()) {
                        this._status.setRangeMin(0);
                        this._status.setRangeMax(16383);
                    } else {
                        this._status.setRangeMin(0);
                        this._status.setRangeMax(127);
                    }
                } else {
                    try {
                        if (min == null) {
                            min = "0";
                        }
                        if (max == null) {
                            max = "127";
                        }
                        if (offset == null) {
                            offset = "0";
                        }
                        int offsetN = Integer.parseInt(offset);
                        this._status.setRangeMin(Integer.parseInt(min) + offsetN);
                        this._status.setRangeMax(Integer.parseInt(max) + offsetN);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._status.setGate(x.getGate());
                this._status.setMemo(x.getName());
                this._status.setName("");
                this.writeBufferToPanelSlider();
                this.disableUnusedOnPanel();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void jComboBoxGateActionPerformed(ActionEvent evt) {
        if (this.skipDataExchange) {
            return;
        }
        Object sel = this.jComboBoxGate.getModel().getSelectedItem();
        MXWrap wrap = (MXWrap)sel;
        int gate = (Integer)wrap.value;
        if (this._status.getGate() != gate) {
            this._status.setGate(gate);
            this.writeBufferToPanelSlider();
            this.disableUnusedOnPanel();
            if (gate == 6) {
                this.fillDataentry(1);
            }
        }
    }

    private void jComboBoxChannelActionPerformed(ActionEvent evt) {
        if (this.skipDataExchange) {
            return;
        }
        Object sel = this.jComboBoxChannel.getModel().getSelectedItem();
        MXWrap wrap = (MXWrap)sel;
        int channel = (Integer)wrap.value;
        if (this._status.getChannel() != channel) {
            this._status.setChannel(channel);
            this.writeBufferToPanelSlider();
            this.disableUnusedOnPanel();
        }
    }

    private void jTextFieldTextCommandActionPerformed(ActionEvent evt) {
    }

    private void jButtonInternalCommandActionPerformed(ActionEvent evt) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menu1 = new JMenuItem(PROG_INC);
        menu1.addActionListener(this.selectInternalCommand);
        menu.add(menu1);
        JMenuItem menu2 = new JMenuItem(PROG_DEC);
        menu2.addActionListener(this.selectInternalCommand);
        menu.add(menu2);
        menu.show(this.jButtonInternalCommand, 0, this.jButtonInternalCommand.getHeight());
    }

    private void jSpinnerMaxStateChanged(ChangeEvent evt) {
        if (this.skipDataExchange) {
            return;
        }
        this._status.setRangeMax((Integer)this.jSpinnerMax.getValue());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this._capture = new MXMessageCapture();
        MXMain.setCapture(this._capture);
        MXMessageCapturePanel panel = new MXMessageCapturePanel();
        MXUtil.showAsDialog(this, panel, "Capture ...");
        GateInfomation retval = panel._selected;
        if (retval != null) {
            this._status.setTextCommand(retval._parent.dtext);
            this._status.setChannel(retval._parent.channel);
            this._status.setGate(retval._gate);
            this._status.setRangeMin(retval._minValue);
            this._status.setRangeMax(retval._maxValue);
            String dtext = retval._parent.dtext;
            this.writeBufferToPanelSlider();
            MXMessage message = this._status.toMXMessage(new MXTiming());
            if (message.getCommand() == 128) {
                int z = JOptionPane.showConfirmDialog(this, "Seems you choiced Note Off\nYou want to use Note ON?", "Offer (adjust value range)", 0);
                if (z == 0) {
                    message = MXMessageFactory.fromShortMessage(message.getPort(), 144 + message.getChannel(), message.getData1(), 127);
                    this._status.setMonitoringTarget(message.toDText(), message.getChannel(), message.getGate(), 127);
                    this._status.setRangeMin(0);
                    this._status.setRangeMax(127);
                }
            } else {
                int z;
                int max = 127;
                if (message.canPaired14bit()) {
                    max = 16383;
                }
                if ((retval._minValue != 0 || retval._maxValue != max) && (z = JOptionPane.showConfirmDialog(this, "min-max = " + retval._minValue + "-" + retval._maxValue + "\n I will offer you reset to 0 - " + max, "Offer (adjust value rnage)", 0)) == 0) {
                    this._status.setRangeMin(0);
                    this._status.setRangeMax(max);
                }
            }
            this.writeBufferToPanelSlider();
            this.disableUnusedOnPanel();
        }
    }

    public void actionSetValueRange(int min, int max) {
        int x;
        if (min < 0) {
            min = 0;
        }
        if (max >= 16383) {
            max = 16383;
        }
        if (min > max) {
            max = min;
        }
        if ((x = JOptionPane.showConfirmDialog(this, "Reset Value Range from " + min + " ... " + max, "ok?", 0)) == 0) {
            this.skipDataExchange = true;
            this.jSpinnerMin.setValue(min);
            this.jSpinnerMax.setValue(max);
            this.skipDataExchange = false;
            this._status.setRangeMin(min);
            this._status.setRangeMax(max);
        }
    }

    private void jButtonActionQuickMenuActionPerformed(ActionEvent evt) {
        JPopupMenu popup = new JPopupMenu();
        String text = this.jTextFieldTextCommand.getText();
        int max = 127;
        try {
            if (this._status.isCCHasPair32()) {
                max = 16383;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        final int resetTo = max;
        JMenuItem menu = new JMenuItem("Set ValueRange = 0 - " + max);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.actionSetValueRange(0, resetTo);
                MGStatusConfig.this.writeBufferToPanelSlider();
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
            }
        });
        popup.add(menu);
        menu = new JMenuItem("Quick ModeSet = Note");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.fillNote(48);
                MGStatusConfig.this.writeBufferToPanelSlider();
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
            }
        });
        popup.add(menu);
        menu = new JMenuItem("Quick ModeSet = Control Change");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.fillControlChange();
                MGStatusConfig.this.writeBufferToPanelSlider();
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
            }
        });
        popup.add(menu);
        menu = new JMenuItem("Quick ModeSet = DataEntry RPN");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.fillDataentry(1);
                MGStatusConfig.this.writeBufferToPanelSlider();
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
            }
        });
        popup.add(menu);
        menu = new JMenuItem("Quick ModeSet = DataEntry NRPN");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.fillDataentry(2);
                MGStatusConfig.this.writeBufferToPanelSlider();
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
            }
        });
        popup.add(menu);
        popup.show(this.jButtonActionQuickMenu, 0, this.jButtonActionQuickMenu.getHeight());
    }

    private void jRadioButtonOnActionPerformed(ActionEvent evt) {
        this._status.setSwitchType(1);
        this.disableUnusedOnPanel();
    }

    private void jRadioButtonOnOffActionPerformed(ActionEvent evt) {
        this._status.setSwitchType(2);
        this.disableUnusedOnPanel();
    }

    private void jRadioButtonHarmonyActionPerformed(ActionEvent evt) {
        this._status.setSwitchType(4);
        this.disableUnusedOnPanel();
    }

    private void jRadioButtonSequenceActionPerformed(ActionEvent evt) {
        this._status.setSwitchType(5);
        this.disableUnusedOnPanel();
    }

    private void jButtonInputEditActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jComboBoxInputTypeActionPerformed(ActionEvent evt) {
        this._status.setSwitchInputType(this._drumInputType.readCombobox(this.jComboBoxInputType));
        this.disableUnusedOnPanel();
    }

    private void jComboBoxOutputOnValueActionPerformed(ActionEvent evt) {
        this._status.setSwitchOutOnType(this._drumOutOnType.readCombobox(this.jComboBoxOutputOnType));
        this.disableUnusedOnPanel();
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
    }

    private void jComboBoxOutputOffValueActionPerformed(ActionEvent evt) {
        this._status.setSwitchOutOffTypeOfValue(this._drumOutOffValue.readCombobox(this.jComboBoxOutputOffValue));
        this.disableUnusedOnPanel();
    }

    private void jComboBoxDrumChannelActionPerformed(ActionEvent evt) {
        this._status.setSwitchOutChannel(this._drumOutChannel.readCombobox(this.jComboBoxDrumChannel));
        this.disableUnusedOnPanel();
    }

    private void jComboBoxHarmonyVelocityTypeActionPerformed(ActionEvent evt) {
        this._status.setSwitchHarmonyVelocityType(this._drumHarmonyVelocityType.readCombobox(this.jComboBoxHarmonyVelocityType));
        this.disableUnusedOnPanel();
    }

    private void jButtonCheckValueActionPerformed(ActionEvent evt) {
        this.readBufferFromPanelSlider();
        this.readBufferFromPanelDrum();
        this.disableUnusedOnPanel();
        this.validateBuffer(true);
    }

    private void jButtonOutputOnEditActionPerformed(ActionEvent evt) {
        MGStatus status = new MGStatus(this._status.getPort(), 4, this._status.getRow(), this._status.getColumn());
        status.setTextCommand(this._status.getSwitchOutOnText());
        status.setGate(this._status.getSwitchOutOnTextGate());
        status.setChannel(this._status.getSwitchOutChannel());
        MGStatusConfig config = new MGStatusConfig(this._process, status);
        MXUtil.showAsDialog(this, config, "Edit Output-On signal");
        if (config._okOption) {
            this._status.setSwitchOutOnType(6);
            this._status.setSwitchOutOnText(config._status.getTextCommand());
            this._status.setSwitchOutOnTextGate(config._status.getGate());
            this._status.setSwitchOutChannel(config._status.getChannel());
            this.showsub1();
        }
    }

    private void jButtonOutputOffEditActionPerformed(ActionEvent evt) {
        MGStatus status = new MGStatus(this._status.getPort(), 4, this._status.getRow(), this._status.getColumn());
        status.setTextCommand(this._status.getSwitchOutOffText());
        status.setGate(this._status.getSwitchOutOffTextGate());
        status.setChannel(this._status.getSwitchOutChannel());
        MGStatusConfig config = new MGStatusConfig(this._process, status);
        MXUtil.showAsDialog(this, config, "Edit Output-Off signal");
        if (config._okOption) {
            this._status.setSwitchOutOffType(14);
            this._status.setSwitchOutOffText(config._status.getTextCommand());
            this._status.setSwitchOutOffTextGate(config._status.getGate());
            this._status.setSwitchOutChannel(config._status.getChannel());
            this.showsub1();
        }
    }

    private void jComboBoxOutputOnTypeActionPerformed(ActionEvent evt) {
        int val = this._drumOutOnType.readCombobox(this.jComboBoxOutputOnType);
        this._status.setSwitchOutOnType(val);
        this.showsub1();
    }

    private void jComboBoxOutputOffTypeActionPerformed(ActionEvent evt) {
        int val = this._drumOutOffType.readCombobox(this.jComboBoxOutputOffType);
        this._status.setSwitchOutOffType(val);
        this.showsub1();
    }

    private void jButtonSequenceFileBrowseActionPerformed(ActionEvent evt) {
        MXFileOpenChooser chooser = new MXFileOpenChooser();
        chooser.addExtension(".mid", "Standard MIDI File");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle("Chose Standard MIDI File");
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        String file = chooser.getSelectedFile().getAbsolutePath();
        this.jTextFieldSequenceFile.setText(file);
        this._status.setSwitchSequencerFile(file);
    }

    private void jButtonHarmonyEditActionPerformed(ActionEvent evt) {
        MXNotePicker picker = new MXNotePicker();
        picker.setSelectedNoteList(MXUtilMidi.textToNoteList(this.jTextFieldHarmonyNoteList.getText()));
        if (picker.showAsModalDialog(this)) {
            int[] note = picker.getSelectedNoteList();
            String text = MXUtilMidi.noteListToText(note);
            this.jTextFieldHarmonyNoteList.setText(text);
        }
    }

    private void jButtonQuickMenuDrumActionPerformed(ActionEvent evt) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menu2 = new JMenuItem("Button For Slider's MAX");
        menu2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.skipDataExchange = false;
                MGStatusConfig.this._process._data.fillMaxOfSlider(MGStatusConfig.this._status, MGStatusConfig.this._status.getColumn());
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
                MGStatusConfig.this.textTemplate.clear();
                MGStatusConfig.this.textTemplate.add("Slider's MAX");
                MGStatusConfig.this.textTemplate.add("- Nothing To Do -");
                MGStatusConfig.this.printTemplateResult();
            }
        });
        popup.add(menu2);
        JMenuItem menu0 = new JMenuItem("Button For Slider'sMIDDLE");
        menu0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.skipDataExchange = false;
                MGStatusConfig.this._process._data.fillMiddleOfSlider(MGStatusConfig.this._status, MGStatusConfig.this._status.getColumn());
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
                MGStatusConfig.this.textTemplate.clear();
                MGStatusConfig.this.textTemplate.add("Slider's Max");
                MGStatusConfig.this.textTemplate.add("- Nothing To Do -");
                MGStatusConfig.this.printTemplateResult();
            }
        });
        popup.add(menu0);
        JMenuItem menu1 = new JMenuItem("Button For Slider'sMIN");
        menu1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.skipDataExchange = false;
                MGStatusConfig.this._process._data.fillMinOfSlider(MGStatusConfig.this._status, MGStatusConfig.this._status.getColumn());
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
                MGStatusConfig.this.textTemplate.clear();
                MGStatusConfig.this.textTemplate.add("Slider's MIN");
                MGStatusConfig.this.textTemplate.add("- Nothing To Do -");
                MGStatusConfig.this.printTemplateResult();
            }
        });
        popup.add(menu1);
        JMenuItem menu3 = new JMenuItem("Note To Pedal ON / OFF");
        menu3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.fillTogglePedal();
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
                MGStatusConfig.this.textTemplate.clear();
                MGStatusConfig.this.textTemplate.add("Note To Pedal ON/OFF");
                MGStatusConfig.this.textTemplate.add("Page1's Note(Gate)");
                MGStatusConfig.this.printTemplateResult();
            }
        });
        popup.add(menu3);
        JMenuItem menu4 = new JMenuItem("Song Play / Stop");
        menu4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MGStatusConfig.this.skipDataExchange = false;
                MGStatusConfig.this._status.setSwitchType(5);
                MGStatusConfig.this._status.setSwitchWithToggle(true);
                MGStatusConfig.this.writeBufferToPanelDrum();
                MGStatusConfig.this.disableUnusedOnPanel();
                MGStatusConfig.this.textTemplate.clear();
                MGStatusConfig.this.textTemplate.add("Slider's MAX");
                MGStatusConfig.this.textTemplate.add("Page1's Trigger");
                MGStatusConfig.this.textTemplate.add("Page2's Sequencer Section");
                MGStatusConfig.this.printTemplateResult();
            }
        });
        popup.add(menu4);
        popup.show(this.jButtonQuickMenuDrum, 0, this.jButtonActionQuickMenu.getHeight());
    }

    private void jCheckBoxCC14bitActionPerformed(ActionEvent evt) {
        this.skipDataExchange = true;
        this._status.setRangeMin((Integer)this.jSpinnerMin.getValue());
        this._status.setRangeMax((Integer)this.jSpinnerMax.getValue());
        if (this.jCheckBoxCC14bit.isEnabled() && this.jCheckBoxCC14bit.isSelected()) {
            this._status.setCCHasPair32(true);
        }
        this.jSpinnerMin.setValue(this._status.getRangeMin());
        this.jSpinnerMax.setValue(this._status.getRangeMax());
        if (this._status.getDataroomType() == 1) {
            this.fillDataentry(1);
        } else if (this._status.getDataroomType() == 2) {
            this.fillDataentry(2);
        }
        this.skipDataExchange = false;
        this.writeBufferToPanelSlider();
    }

    private void jComboBoxMSBActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxLSBActionPerformed(ActionEvent evt) {
    }

    private void jSpinnerMinStateChanged(ChangeEvent evt) {
        if (this.skipDataExchange) {
            return;
        }
        this._status.setRangeMin((Integer)this.jSpinnerMin.getValue());
    }

    private void jComboBoxMSBItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this._status.setDataroomMSB(this._rpnMSBModel.readCombobox(this.jComboBoxMSB));
            if (this._status.getDataroomType() == 1) {
                this.fillDataentry(1);
            } else if (this._status.getDataroomType() == 2) {
                this.fillDataentry(2);
            }
            this.writeBufferToPanelSlider();
        }
    }

    private void jComboBoxLSBItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this._status.setDataroomLSB(this._rpnLSBModel.readCombobox(this.jComboBoxLSB));
            if (this._status.getDataroomType() == 1) {
                this.fillDataentry(1);
            } else if (this._status.getDataroomType() == 2) {
                this.fillDataentry(2);
            }
            this.writeBufferToPanelSlider();
        }
    }

    public int getDrumType() {
        if (this.jRadioButtonOn.isSelected()) {
            return 1;
        }
        if (this.jRadioButtonOnOff.isSelected()) {
            return 2;
        }
        if (this.jRadioButtonHarmony.isSelected()) {
            return 4;
        }
        if (this.jRadioButtonSequence.isSelected()) {
            return 5;
        }
        return 0;
    }

    public void showsub1() {
        if (this._status.getSwitchOutOnType() == 6) {
            this.jLabelOutputOnText.setText("Custom " + this._status.getSwitchOutOnText() + "(Gate:" + this._status.getSwitchOutOnTextGate() + ")");
        } else if (this._status.getSwitchOutOnType() == 5) {
            this.jLabelOutputOnText.setText("Same " + this._status.getTextCommand() + "(Gate:" + this._status.getGate() + ")");
        } else {
            this.jLabelOutputOnText.setText("Unknwon(" + this._status.getSwitchOutOnType());
        }
        if (this._status.getSwitchOutOffType() == 14) {
            this.jLabelOutputOffText.setText("Custom " + this._status.getSwitchOutOffText() + "(Gate:" + this._status.getSwitchOutOffTextGate() + ")");
        } else if (this._status.getSwitchOutOffType() == 11) {
            this.jLabelOutputOffText.setText("None");
        } else if (this._status.getSwitchOutOffType() == 12) {
            this.jLabelOutputOffText.setText("Same(Input)" + this._status.getTextCommand() + "(Gate:" + this._status.getGate() + ")");
        } else if (this._status.getSwitchOutOffType() == 13) {
            this.jLabelOutputOffText.setText("Same(Output-ON)" + this._status.getTextCommand() + "(Gate:" + this._status.getSwitchOutOnTextGate() + ")");
        } else {
            this.jLabelOutputOffText.setText("Unknwon(" + this._status.getSwitchOutOffType());
        }
    }

    public void fillControlChange() {
        this.skipDataExchange = true;
        try {
            this._status.setTextCommand("@CC #GL #VL");
            this._status.setSwitchOutChannel(0);
            this._status.setSwitchInputType(2);
            this._status.setSwitchWithToggle(false);
            this._status.setGate(0);
            this._status.setChannel(0);
            this._status.setCCHasPair32(false);
            this.writeBufferToPanelDrum();
            this.textTemplate.clear();
            this.textTemplate.add("Control Change");
            this.textTemplate.add("1st Page's ControlChange Number");
            this.printTemplateResult();
        }
        finally {
            this.skipDataExchange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillDataentry(int dataroomType) {
        this.skipDataExchange = true;
        try {
            String msb = MXUtil.toHexFF(this._status.getDataeroomMSB()) + "h";
            String lsb = MXUtil.toHexFF(this._status.getDataroomLSB()) + "h";
            this._status.setDataroomType(dataroomType);
            this._status.setRangeMin(0);
            this._status.setRangeMax(16383);
            if (dataroomType == 1) {
                this._status.setTextCommand("@RPN " + msb + " " + lsb + " #VH #VL");
            } else if (dataroomType == 2) {
                this._status.setTextCommand("@NRPN " + msb + " " + lsb + " #VH #VL");
            } else {
                new IllegalStateException().printStackTrace();
            }
            this.writeBufferToPanelSlider();
            this.readBufferFromPanelSlider();
            this.disableUnusedOnPanel();
            this.textTemplate.clear();
            this.textTemplate.add("DataEntry");
            this.textTemplate.add("1st Page's DataEntry **");
            this.printTemplateResult();
        }
        finally {
            this.skipDataExchange = false;
        }
    }

    public void fillTogglePedal() {
        this.fillNote(48);
        this.skipDataExchange = true;
        try {
            this._status.setSwitchType(2);
            this._status.setSwitchWithToggle(true);
            this._status.setSwitchInputType(2);
            this._status.setSwitchOutOnType(6);
            this._status.setSwitchOutOnText("@CC #GL #VL");
            this._status.setSwitchOutOnTextGate(64);
            this._status.setSwitchOutOnTypeOfValue(10);
            this._status.setSwitchOutOnValueFixed(127);
            this._status.setSwitchOutOffType(13);
            this._status.setSwitchOutOffTextGate(64);
            this._status.setSwitchOutOffTypeOfValue(18);
            this._status.setSwitchOutOffValueFixed(0);
            this._status.setSwitchWithToggle(true);
            this.writeBufferToPanelDrum();
            this.readBufferFromPanelDrum();
            this.disableUnusedOnPanel();
        }
        finally {
            this.skipDataExchange = false;
        }
    }

    public void fillNote(int note) {
        this.fillNormalSlider();
        this.skipDataExchange = true;
        try {
            this._status.setTextCommand("90h #GL #VL");
            this._status.setGate(note);
            this._status.setChannel(0);
            this._status.setName("");
            this._status.setMemo("");
            this._status.setSwitchWithToggle(true);
            this._status.setSwitchInputType(2);
            this._status.setSwitchOutOnTextGate(1);
            this._status.setSwitchOutOnValueFixed(100);
            this.writeBufferToPanelDrum();
            this.readBufferFromPanelDrum();
            this.disableUnusedOnPanel();
            this.textTemplate.clear();
            this.textTemplate.add("Note");
            this.textTemplate.add("1st Page's Note(Gate)");
            this.textTemplate.add("2nd Page's Output ***");
            this.printTemplateResult();
        }
        finally {
            this.skipDataExchange = false;
        }
    }

    public void fillNormalSlider() {
        this.skipDataExchange = true;
        try {
            this._status.setTextCommand("@CC #GL #VL");
            this._status.setGate(7);
            this._status.setValue(0);
            this._status.setCCHasPair32(false);
            this._status.setRangeMin(0);
            this._status.setRangeMax(127);
            this._status.setChannel(0);
            this._status.setName("");
            this._status.setMemo("");
            this._status.setSwitchType(2);
            this._status.setSwitchWithToggle(false);
            this._status.setSwitchInputType(4);
            this._status.setSwitchOutOnType(5);
            this._status.setSwitchOutOnText("");
            this._status.setSwitchOutOnTextGate(127);
            this._status.setSwitchOutOnTypeOfValue(5);
            this._status.setSwitchOutOnValueFixed(127);
            this._status.setSwitchOutOffType(13);
            this._status.setSwitchOutOffTextGate(0);
            this._status.setSwitchOutOffTypeOfValue(15);
            this._status.setSwitchOutOffValueFixed(0);
            this._status.setSwitchWithToggle(true);
            this.writeBufferToPanelDrum();
            this.readBufferFromPanelDrum();
            this.disableUnusedOnPanel();
            this.textTemplate.clear();
            this.textTemplate.add("Normal Slider");
            this.textTemplate.add("As You Like");
            this.printTemplateResult();
        }
        finally {
            this.skipDataExchange = false;
        }
    }
}

