/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx12masterkeys;

import javax.swing.JComponent;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.common.MXWrap;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx12masterkeys.MX12MasterkeysPanel;

public class MX12Process
extends MXReceiver
implements MXSettingTarget {
    private static final MXDebugPrint _debug = new MXDebugPrint(MX12Process.class);
    private MXSetting _setting = new MXSetting("MasterKey");
    MX12MasterkeysPanel _view;
    MXNoteOffWatcher _noteOff;
    private int _mousePort = 0;
    private int _mouseChannel = 0;
    private boolean _overwriteInputChannel;
    private int _mouseVelocity = 100;
    boolean _construction = true;
    private boolean _acceptThisPageSignal;
    private boolean _acceptInputPanelSignal;

    public MX12Process() {
        this._setting.setTarget(this);
        this._noteOff = new MXNoteOffWatcher();
        this._overwriteInputChannel = false;
        this._construction = false;
    }

    public void readSettings() {
        this._setting.readSettingFile();
        if (this._view != null) {
            this._view.updateViewForSettingChange();
        }
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        setting.register("outputReceiver");
        setting.register("outputPort");
        setting.register("outputChannel");
        setting.register("overwriteControllerChannel");
        setting.register("outputVelocity");
        setting.register("acceptThisPanelSignal");
        setting.register("acceptInputPanelSignal");
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        int x;
        String receiverName = setting.getSetting("outputReceiver");
        if (receiverName != null && (x = MXMain.getMain().getReceiverList().indexOfName(receiverName)) >= 0) {
            this.setNextReceiver((MXReceiver)((MXWrap)MXMain.getMain().getReceiverList().get((int)x)).value);
        }
        this.setOverwriteInputChannel(setting.getSettingAsInt("overwriteControllerChannel", 0) != 0);
        this.setMousePort(setting.getSettingAsInt("outputPort", 0));
        this.setMouseChannel(setting.getSettingAsInt("outputChannel", 0));
        this.setMouseVelocity(setting.getSettingAsInt("outputVelocity", 100));
        this._acceptThisPageSignal = setting.getSettingAsBoolean("acceptThisPanelSignal", true);
        this._acceptInputPanelSignal = setting.getSettingAsBoolean("acceptInputPanelSignal", true);
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        if (this.getNextReceiver() == null) {
            setting.setSetting("outputReceiver", "");
        } else {
            setting.setSetting("outputReceiver", this.getNextReceiver().getReceiverName());
        }
        setting.setSetting("outputPort", this.getMousePort());
        setting.setSetting("outputChannel", this.getMouseChannel());
        setting.setSetting("overwriteControllerChannel", this.isOverwriteInputChannel());
        setting.setSetting("outputVelocity", this.getMouseVelocity());
        setting.setSetting("acceptThisPanelSignal", this._acceptThisPageSignal);
        setting.setSetting("acceptInputPanelSignal", this._acceptInputPanelSignal);
    }

    @Override
    public String getReceiverName() {
        return "Master Key";
    }

    @Override
    public JComponent getReceiverView() {
        return this._view;
    }

    public void processMasterPath(MXMessage message) {
        if (message.isMessageTypeChannel()) {
            int port = message.getPort();
            int ch = message.getChannel();
            int command = message.getCommand();
            int data1 = message.getData1();
            int data2 = message.getData2();
            if (command == 144 && data2 == 0) {
                command = 128;
            }
            if (command == 128 && this._noteOff.raiseHandler(port, message._timing, ch, data1)) {
                return;
            }
            MXMessage newMessage = null;
            if (this.isOverwriteInputChannel()) {
                newMessage = MXMessageFactory.fromClone(message);
                newMessage.setPort(this.getMousePort());
                if (newMessage.isMessageTypeChannel()) {
                    newMessage.setChannel(this.getMouseChannel());
                }
            }
            if (command == 144) {
                this._view._piano.noteOn(data1);
                if (newMessage != null) {
                    this._noteOff.setHandler(message, newMessage, new MyNoteOffHandler(this.getNextReceiver()));
                } else {
                    this._noteOff.setHandler(message, message, new MyNoteOffHandler(this.getNextReceiver()));
                }
            } else if (command == 176 && data1 == 64) {
                this._view._piano.sustain(data2);
            } else if (command == 224) {
                this._view.setPitchBend(message.getValue());
            } else if (command == 176 && data1 == 1) {
                this._view.setModulatoinWheel(message.getValue());
            }
            if (newMessage != null) {
                this.sendToNext(newMessage);
            } else {
                this.sendToNext(message);
            }
            return;
        }
        this.sendToNext(message);
    }

    @Override
    protected void processMXMessageImpl(MXMessage message) {
    }

    public void mouseMessage(MXMessage message) {
        if (this._construction) {
            return;
        }
        this.sendToNext(message);
    }

    public boolean isAcceptThisPageSignal() {
        return this._acceptThisPageSignal;
    }

    public void setAcceptThisPageSignal(boolean acceptThisPageSignal) {
        this._acceptThisPageSignal = acceptThisPageSignal;
    }

    public boolean isAcceptInputPanelSignal() {
        return this._acceptInputPanelSignal;
    }

    public void setAcceptInputPanelSignal(boolean acceptInputPanelSignal) {
        this._acceptInputPanelSignal = acceptInputPanelSignal;
    }

    public int getMousePort() {
        return this._mousePort;
    }

    public void setMousePort(int _mousePort) {
        this._mousePort = _mousePort;
    }

    public int getMouseChannel() {
        return this._mouseChannel;
    }

    public void setMouseChannel(int _mouseChannel) {
        this._mouseChannel = _mouseChannel;
    }

    public boolean isOverwriteInputChannel() {
        return this._overwriteInputChannel;
    }

    public void setOverwriteInputChannel(boolean overwriteInputChannel) {
        this._overwriteInputChannel = overwriteInputChannel;
    }

    public int getMouseVelocity() {
        return this._mouseVelocity;
    }

    public void setMouseVelocity(int _mouseVelocity) {
        this._mouseVelocity = _mouseVelocity;
    }

    public void createWindow() {
        if (this._view != null && this._view.isOwnerwindowVisible()) {
            return;
        }
        this._view = new MX12MasterkeysPanel(this);
        this._view.showAsWindow();
    }

    public boolean isAvail() {
        if (this._view == null) {
            return false;
        }
        if (!this._view.isOwnerwindowVisible()) {
            this._view = null;
            return false;
        }
        return true;
    }

    public class MyNoteOffHandler
    implements MXNoteOffWatcher.Handler {
        MXReceiver _receiver;

        public MyNoteOffHandler(MXReceiver receiver) {
            this._receiver = receiver;
        }

        @Override
        public void onNoteOffEvent(MXMessage target) {
            MXMain.getMain().messageDispatch(target, this._receiver);
            if (MX12Process.this._view != null) {
                MX12Process.this._view._piano.noteOff(target.getGate());
            }
        }
    }
}

