/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx10input;

import javax.swing.JPanel;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx10input.MX10Data;
import jp.synthtarou.midimixer.mx10input.MX10View;

public class MX10Process
extends MXReceiver
implements MXSettingTarget {
    MX10Data _data = new MX10Data();
    MX10View _view = new MX10View(this);
    MXSetting _setting = new MXSetting("InputSkip");

    public MX10Process() {
        this._setting.setTarget(this);
    }

    public void readSettings() {
        this._setting.readSettingFile();
    }

    public void setUseMesssageFilter(boolean log) {
        this.setUsingThisRecipe(log);
    }

    public boolean isUseMessageFilter() {
        return this.isUsingThisRecipe();
    }

    @Override
    protected void processMXMessageImpl(MXMessage message) {
        if (this.isUsingThisRecipe() && this._data.isMarkedToSkip(message)) {
            return;
        }
        this.sendToNext(message);
    }

    @Override
    public String getReceiverName() {
        return "Input Receiver";
    }

    @Override
    public JPanel getReceiverView() {
        return this._view;
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        String prefix = "Setting[].";
        for (String text : MX10Data.typeNames) {
            setting.register(prefix + text);
        }
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        block0: for (int port = 0; port < 16; ++port) {
            String prefix = "Setting[" + port + "].";
            StringBuffer str = new StringBuffer();
            int j = 0;
            while (true) {
                MX10Process mX10Process = this;
                if (j >= mX10Process._data.countOfTypes()) continue block0;
                String name = MX10Data.typeNames[j];
                boolean set = setting.getSettingAsBoolean(prefix + name, false);
                this._data.setSkip(port, j, set);
                ++j;
            }
        }
        this._view.resetTableModel();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        block0: for (int port = 0; port < 16; ++port) {
            String prefix = "Setting[" + port + "].";
            StringBuffer str = new StringBuffer();
            int j = 0;
            while (true) {
                MX10Process mX10Process = this;
                if (j >= mX10Process._data.countOfTypes()) continue block0;
                boolean set = this._data.isSkip(port, j);
                String name = MX10Data.typeNames[j];
                setting.setSetting(prefix + name, set);
                ++j;
            }
        }
    }
}

