/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx10input;

import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXMessage;

public class MX10Data {
    private static final MXDebugPrint _debug = new MXDebugPrint(MX10Data.class);
    public static final int TYPE_NOTE = 1;
    public static final int TYPE_DAMPER_PEDAL = 2;
    public static final int TYPE_PITCH_BEND = 3;
    public static final int TYPE_MOD_WHEEL = 4;
    public static final int TYPE_BANK_SELECT = 5;
    public static final int TYPE_PROGRAM_CHANGE = 6;
    public static final int TYPE_DATA_ENTRY = 7;
    public static final int TYPE_ANOTHER_CC = 8;
    public static final int TYPE_SYSEX = 9;
    public static final int TYPE_ACTIVE_SENSING = 10;
    public static final int TYPE_COUNT = 10;
    public static final int TYPE_ZERO = 0;
    public static final String[] typeNames = new String[]{"Note", "DamperPedal", "PitchBend", "ModWheel", "BankChange", "ProgramChange", "DataEntry", "AnotherCC", "SysEX", "Active&Clock"};
    long[] _whichToSkip = new long[16];
    int _portCount = 16;

    public MX10Data() {
        for (int i = 0; i < this._whichToSkip.length; ++i) {
            this._whichToSkip[i] = 1024L;
        }
    }

    public boolean isMarkedToSkip(MXMessage message) {
        if (message == null) {
            return true;
        }
        int port = message.getPort();
        int command = message.getCommand();
        int type = 0;
        int data1 = message.getGate();
        if (command == 144 || command == 128) {
            type = 1;
        } else if (command == 176 && data1 == 64) {
            type = 2;
        } else if (command == 224) {
            type = 3;
        } else if (command == 176 && data1 == 1) {
            type = 4;
        } else if (command == 176 && (data1 == 0 || data1 == 32)) {
            type = 5;
        } else if (command == 192) {
            type = 6;
        } else if (command == 176 && (data1 == 6 || data1 == 96 || data1 == 97)) {
            type = 7;
        } else if (command == 176 && data1 >= 98 && data1 <= 101) {
            type = 7;
        } else if (command == 176) {
            type = 8;
        } else if (command == 240 || command == 247) {
            type = 9;
        } else if (command == 254 || command == 248) {
            type = 10;
        }
        return this.isSkip(port, type);
    }

    public void setSkip(int port, int type, boolean skipFlag) {
        long bit = 1L << type;
        if ((this._whichToSkip[port] & bit) != 0L) {
            if (skipFlag) {
                return;
            }
            int n = port;
            this._whichToSkip[n] = this._whichToSkip[n] - bit;
        } else if (skipFlag) {
            int n = port;
            this._whichToSkip[n] = this._whichToSkip[n] | bit;
        } else {
            return;
        }
    }

    public boolean isSkip(int port, int type) {
        long bit = 1L << type;
        return (this._whichToSkip[port] & bit) != 0L;
    }

    public static int countOfTypes() {
        return 10;
    }

    public static String nameOfType(int x) {
        return typeNames[x];
    }
}

