/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx00playlist;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.common.FileWithId;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIIn;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInForPlayer;
import jp.synthtarou.midimixer.libs.midi.smf.SMFCallback;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.swing.MXFileOpenChooser;
import jp.synthtarou.midimixer.libs.swing.MXPianoComponent;
import jp.synthtarou.midimixer.mx00playlist.MX00DrumPadPanel;
import jp.synthtarou.midimixer.mx00playlist.MX00PianoPanel;
import jp.synthtarou.midimixer.mx00playlist.MX00Process;

public class MX00View
extends JPanel
implements SMFCallback {
    private static final MXDebugPrint _debug = new MXDebugPrint(MX00View.class);
    static int DRUM_CH = 9;
    MX00PianoPanel[] _listKeyboard = new MX00PianoPanel[16];
    MX00DrumPadPanel _drumPanel = null;
    MX00Process _process;
    MXMIDIInForPlayer _player;
    FileWithId _selectedItem = null;
    private ComboBoxModel _comboModel;
    private ComboBoxModel _channelSelectModel;
    private JButton jButtonAdd;
    private JButton jButtonDown;
    private JButton jButtonErase;
    private JButton jButtonPlay;
    private JButton jButtonUp;
    private JCheckBox jCheckBoxChain;
    private JCheckBox jCheckBoxRepeat;
    private JList<String> jListFileInfo;
    private JList<String> jListPlayList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanelPiano;
    private JPanel jPanelPianoParent;
    private JPanel jPanelRight;
    private JPanel jPanelSelInfo1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPanePlayList;
    private JSlider jSlider1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTextField jTextFieldSongFile;
    private JButton \uff4aButtonPause;
    FileWithId _lastPlayeed = null;

    public MX00View(MX00Process process) {
        this.initComponents();
        this.jSlider1.setMinimum(0);
        this.jSlider1.setMaximum(10);
        this.jSlider1.setValue(0);
        this._process = process;
        this._player = MXMIDIIn.INTERNAL_PLAYER;
        this.jSplitPane1.setDividerLocation(350);
        this.jSplitPane2.setDividerLocation(300);
    }

    public void settingUpdated() {
        this.jListPlayList.setModel(this._process._playListModel);
        this.jCheckBoxChain.setSelected(this._process._playAsChained);
        this.jCheckBoxRepeat.setSelected(this._process._playAsRepeated);
    }

    public void setSongName(String songName) {
        this.jTextFieldSongFile.setText(songName);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jScrollPanePlayList = new JScrollPane();
        this.jListPlayList = new JList();
        this.jPanel3 = new JPanel();
        this.jButtonUp = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonDown = new JButton();
        this.jButtonErase = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanelSelInfo1 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jListFileInfo = new JList();
        this.jPanel2 = new JPanel();
        this.jButtonPlay = new JButton();
        this.jCheckBoxChain = new JCheckBox();
        this.jCheckBoxRepeat = new JCheckBox();
        this.jPanelRight = new JPanel();
        this.jSlider1 = new JSlider();
        this.jPanelPianoParent = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jPanelPiano = new JPanel();
        this.jTextFieldSongFile = new JTextField();
        this.\uff4aButtonPause = new JButton();
        this.setMinimumSize(new Dimension(100, 30));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MX00View.this.formComponentResized(evt);
            }
        });
        this.setLayout(new CardLayout());
        this.jSplitPane2.setDividerLocation(350);
        this.jSplitPane2.setOrientation(0);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("1.PlayList"));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 3));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jListPlayList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MX00View.this.jListPlayListValueChanged(evt);
            }
        });
        this.jScrollPanePlayList.setViewportView(this.jListPlayList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPanePlayList, gridBagConstraints);
        this.jPanel1.add(this.jPanel4);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jButtonUp.setText("Up");
        this.jButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX00View.this.jButtonUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel3.add((Component)this.jButtonUp, gridBagConstraints);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX00View.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel3.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonDown.setText("Down");
        this.jButtonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX00View.this.jButtonDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel3.add((Component)this.jButtonDown, gridBagConstraints);
        this.jButtonErase.setText("Del");
        this.jButtonErase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX00View.this.jButtonEraseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel3.add((Component)this.jButtonErase, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel1.add(this.jPanel3);
        this.jSplitPane2.setLeftComponent(this.jPanel1);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanelSelInfo1.setBorder(BorderFactory.createTitledBorder("2.Information"));
        this.jPanelSelInfo1.setLayout(new BoxLayout(this.jPanelSelInfo1, 2));
        this.jScrollPane4.setViewportView(this.jListFileInfo);
        this.jPanelSelInfo1.add(this.jScrollPane4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        this.jPanel6.add((Component)this.jPanelSelInfo1, gridBagConstraints);
        this.jButtonPlay.setText("Play");
        this.jButtonPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX00View.this.jButtonPlayActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonPlay);
        this.jCheckBoxChain.setText("Chained");
        this.jCheckBoxChain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX00View.this.jCheckBoxChainActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jCheckBoxChain);
        this.jCheckBoxRepeat.setText("Repeat");
        this.jCheckBoxRepeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX00View.this.jCheckBoxRepeatActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jCheckBoxRepeat);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel6.add((Component)this.jPanel2, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.jPanel6);
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.jPanelRight.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelRight.add((Component)this.jSlider1, gridBagConstraints);
        this.jPanelPianoParent.setBorder(BorderFactory.createTitledBorder("Piano"));
        this.jPanelPianoParent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MX00View.this.jPanelPianoParentComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                MX00View.this.jPanelPianoParentComponentShown(evt);
            }
        });
        this.jPanelPianoParent.setLayout(new BoxLayout(this.jPanelPianoParent, 2));
        this.jScrollPane3.setVerticalScrollBarPolicy(22);
        this.jPanelPiano.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MX00View.this.jPanelPianoComponentResized(evt);
            }
        });
        this.jPanelPiano.setLayout(new GridBagLayout());
        this.jScrollPane3.setViewportView(this.jPanelPiano);
        this.jPanelPianoParent.add(this.jScrollPane3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelRight.add((Component)this.jPanelPianoParent, gridBagConstraints);
        this.jTextFieldSongFile.setEditable(false);
        this.jTextFieldSongFile.setText("3.Playinng");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelRight.add((Component)this.jTextFieldSongFile, gridBagConstraints);
        this.\uff4aButtonPause.setText("PAUSE");
        this.\uff4aButtonPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MX00View.this.\uff4aButtonPauseActionPerformed(evt);
            }
        });
        this.jPanelRight.add((Component)this.\uff4aButtonPause, new GridBagConstraints());
        this.jSplitPane1.setRightComponent(this.jPanelRight);
        this.add((Component)this.jSplitPane1, "card2");
        this.jSplitPane1.getAccessibleContext().setAccessibleDescription("");
    }

    public void createPianoControls(int lowNote, int octaveRange, final boolean[] activeChannels, final int[] listPrograms, final int[] drumProgs) {
        if (!SwingUtilities.isEventDispatchThread()) {
            final int againNote = lowNote;
            final int againRange = octaveRange;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MX00View.this.createPianoControls(againNote, againRange, activeChannels, listPrograms, drumProgs);
                }
            });
            return;
        }
        this.invalidate();
        this._listKeyboard = new MX00PianoPanel[16];
        this._drumPanel = null;
        for (int i = this.jPanelPiano.getComponentCount(); i >= 1; --i) {
            Component comp = this.jPanelPiano.getComponent(i - 1);
            this.jPanelPiano.remove(comp);
        }
        int height = 50;
        this._drumPanel = new MX00DrumPadPanel();
        for (Object note : (Component)drumProgs) {
            this._drumPanel.addNote((int)note);
        }
        int rows = 0;
        for (int ch = 0; ch < 16; ++ch) {
            if (!activeChannels[ch]) continue;
            MXPianoComponent keys = new MXPianoComponent();
            while (octaveRange <= 4) {
                octaveRange += 2;
                lowNote -= 12;
            }
            while (octaveRange < 5) {
                ++octaveRange;
            }
            keys.setNoteRange(lowNote, octaveRange);
            if (ch == DRUM_CH) {
                if (this._drumPanel == null) continue;
                GridBagConstraints cont = new GridBagConstraints();
                cont.gridx = 0;
                cont.gridy = rows++;
                cont.weightx = 1.0;
                cont.weighty = 0.0;
                cont.fill = 2;
                this._drumPanel.setMinimumSize(new Dimension(300, height));
                cont.fill = 2;
                this.jPanelPiano.add((Component)this._drumPanel, cont);
                continue;
            }
            MX00PianoPanel piano = new MX00PianoPanel(keys);
            piano.setChannel(ch);
            piano.updateProgramNumber(listPrograms[ch] < 0 ? 0 : listPrograms[ch]);
            piano.setMinimumSize(new Dimension(300, height));
            piano.setPreferredSize(new Dimension(300, height));
            piano.setMaximumSize(new Dimension(2000, height));
            GridBagConstraints cont = new GridBagConstraints();
            cont.gridx = 0;
            cont.gridy = rows++;
            cont.weightx = 1.0;
            cont.weighty = 0.0;
            cont.fill = 2;
            this.jPanelPiano.add((Component)piano, cont);
            this._listKeyboard[ch] = piano;
        }
        GridBagConstraints cont2 = new GridBagConstraints();
        cont2.gridx = 0;
        cont2.gridy = rows;
        cont2.gridwidth = 0;
        cont2.fill = 1;
        cont2.weightx = 1.0;
        cont2.weighty = 3.0;
        this.jPanelPiano.add((Component)new JPanel(), cont2);
        GridBagConstraints cont = new GridBagConstraints();
        cont.gridx = 0;
        cont.gridy = rows++;
        cont.gridwidth = 0;
        cont.fill = 1;
        cont.weightx = 1.0;
        cont.weighty = 1.0;
        cont.fill = 1;
        this.jPanelPiano.add((Component)new JPanel(), cont);
        this.autoResizePiano();
    }

    public void autoResizePiano() {
        try {
            if (this._drumPanel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MX00View.this._drumPanel.setPreferredSize(new Dimension(MX00View.this.jPanelRight.getWidth() - 70, 350));
                        MX00View.this._drumPanel.updateUI();
                        int maxHeight = 0;
                        for (JToggleButton c : MX00View.this._drumPanel.listDrums) {
                            if (c == null) continue;
                            Rectangle r = c.getBounds();
                            int height = r.y + r.height;
                            if (maxHeight >= height) continue;
                            maxHeight = height;
                        }
                        MX00View.this._drumPanel.setPreferredSize(new Dimension(MX00View.this.jPanelRight.getWidth() - 70, maxHeight));
                        MX00View.this._drumPanel.setSize(new Dimension(MX00View.this.jPanelRight.getWidth() - 70, maxHeight));
                    }
                });
            }
            for (int ch = 0; ch < 16; ++ch) {
                if (this._listKeyboard[ch] == null) continue;
                this._listKeyboard[ch].autoAdjustHeight(this.jPanelRight.getWidth() - 70);
                this._listKeyboard[ch]._keys.invalidate();
            }
            this.revalidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        MXFileOpenChooser chooser = new MXFileOpenChooser();
        chooser.addExtension(".mid", "Standard MIDI File");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle("Add Standard MIDI File");
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        this._process._playListModel.addElement(new FileWithId(file));
    }

    private void jListPlayListValueChanged(ListSelectionEvent evt) {
        int x = this.jListPlayList.getSelectedIndex();
        if (x >= 0) {
            FileWithId f = (FileWithId)this._process._playListModel.get(x);
            DefaultListModel<Object> model = new DefaultListModel<Object>();
            Date lastDate = new Date(f._file.lastModified());
            String textDate = DateFormat.getDateTimeInstance().format(lastDate);
            model.addElement("Path: " + f._file.getPath());
            model.addElement("Size: " + f._file.length());
            model.addElement("Date: " + textDate);
            this._selectedItem = f;
            try {
                String[] str = MXMIDIInForPlayer.readFileInfo(f._file);
                model.addElement("MetaInfo: ");
                for (int i = 0; i < str.length; ++i) {
                    model.addElement(str[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.jListFileInfo.setModel(model);
        }
    }

    private void jButtonEraseActionPerformed(ActionEvent evt) {
        int x = this.jListPlayList.getSelectedIndex();
        if (x >= 0) {
            FileWithId file = (FileWithId)this._process._playListModel.elementAt(x);
            if (this._process._file != null && this._process._file._id == file._id) {
                if (JOptionPane.showConfirmDialog(this, file + " is current song.\nThis operation will cancel Chain / Repeat.", null, 2) == 0) {
                    this.jCheckBoxChain.setSelected(false);
                    this.jCheckBoxRepeat.setSelected(false);
                    this._process._playListModel.remove(x);
                }
            } else {
                this._process._playListModel.remove(x);
            }
        }
    }

    private void jButtonUpActionPerformed(ActionEvent evt) {
        int x = this.jListPlayList.getSelectedIndex();
        if (x >= 1) {
            FileWithId f = (FileWithId)this._process._playListModel.elementAt(x);
            this._process._playListModel.remove(x);
            this._process._playListModel.add(x - 1, f);
            this.jListPlayList.setSelectedIndex(x - 1);
        }
    }

    private void jButtonDownActionPerformed(ActionEvent evt) {
        int x = this.jListPlayList.getSelectedIndex();
        if (x >= 0 && x < this._process._playListModel.size() - 1) {
            FileWithId f = (FileWithId)this._process._playListModel.elementAt(x);
            this._process._playListModel.remove(x);
            this._process._playListModel.add(x + 1, f);
            this.jListPlayList.setSelectedIndex(x + 1);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.autoResizePiano();
    }

    private void jPanelPianoComponentResized(ComponentEvent evt) {
    }

    private void \uff4aButtonPauseActionPerformed(ActionEvent evt) {
        if (this._player.isSequencerPlaying()) {
            this._player.stopSequencer();
        } else {
            if (this._process._file != null) {
                this._selectedItem = this._process._file;
            }
            this.turnOnMusic(this._selectedItem, this.jSlider1.getValue());
        }
    }

    private void jButtonPlayActionPerformed(ActionEvent evt) {
        this._player.stopSequencer();
        this.turnOnMusic(this._selectedItem, 0);
    }

    private void jCheckBoxChainActionPerformed(ActionEvent evt) {
        this._process._playAsChained = this.jCheckBoxChain.isSelected();
    }

    private void jCheckBoxRepeatActionPerformed(ActionEvent evt) {
        this._process._playAsRepeated = this.jCheckBoxRepeat.isSelected();
    }

    private void jPanelPianoParentComponentResized(ComponentEvent evt) {
    }

    private void jPanelPianoParentComponentShown(ComponentEvent evt) {
    }

    public void updatePianoKeys(final int dword) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MX00View.this.updatePianoKeys(dword);
                }
            });
            return;
        }
        int status = dword >> 16 & 0xFF;
        int data1 = dword >> 8 & 0xFF;
        int data2 = dword & 0xFF;
        int command = status & 0xF0;
        int channel = status & 0xF;
        if (command >= 128 && command <= 239) {
            MX00PianoPanel piano;
            if (command == 144 && data2 == 0) {
                command = 128;
            }
            if (command == 144) {
                if (channel != DRUM_CH) {
                    MX00PianoPanel piano2 = this._listKeyboard[channel];
                    if (piano2 != null) {
                        piano2.getKeys().noteOn(data1);
                    }
                } else {
                    MX00DrumPadPanel kit = this._drumPanel;
                    kit.noteOn(data1);
                }
            } else if (command == 128) {
                if (channel != DRUM_CH) {
                    MX00PianoPanel piano3 = this._listKeyboard[channel];
                    if (piano3 != null) {
                        piano3.getKeys().noteOff(data1);
                    }
                } else if (this._drumPanel != null) {
                    MX00DrumPadPanel kit = this._drumPanel;
                    kit.noteOff(data1);
                }
            } else if (command == 176 && data1 == 64) {
                MX00PianoPanel piano4 = this._listKeyboard[channel];
                if (piano4 != null) {
                    piano4.getKeys().sustain(data2);
                }
            } else if (command == 176 && data1 == 123) {
                MX00PianoPanel piano5 = this._listKeyboard[channel];
                if (piano5 != null) {
                    piano5.getKeys().allNoteOff();
                }
            } else if (command == 192 && (piano = this._listKeyboard[channel]) != null) {
                piano.updateProgramNumber(data1);
            }
        }
    }

    @Override
    public void smfPlayNote(SMFMessage e) {
    }

    @Override
    public void smfStarted() {
    }

    @Override
    public void smfStoped(boolean fineFinish) {
        FileWithId file = this._lastPlayeed;
        FileWithId next = null;
        if (!fineFinish) {
            return;
        }
        if (this._process._playAsChained) {
            for (int i = 0; i < this._process._playListModel.size(); ++i) {
                FileWithId seek = (FileWithId)this._process._playListModel.get(i);
                if (seek != file) continue;
                if (++i < this._process._playListModel.size()) {
                    next = (FileWithId)this._process._playListModel.get(i);
                } else {
                    if (!this._process._playAsRepeated) continue;
                    i = 0;
                    next = i < this._process._playListModel.size() ? (FileWithId)this._process._playListModel.get(0) : null;
                }
                break;
            }
        } else {
            next = this._process._playAsRepeated ? file : null;
        }
        if (next != null) {
            this._selectedItem = next;
            this.turnOnMusic(this._selectedItem, 0);
        }
    }

    @Override
    public void smfProgress(int pos, int finish) {
        if (pos == 0) {
            MXMain.getMain().getLayerProcess().resendProgramChange();
        }
        this.jSlider1.setMaximum(finish);
        this.jSlider1.setValue(pos);
    }

    public void turnOnMusic(final FileWithId file, int pos) {
        try {
            if (file == null) {
                JOptionPane.showMessageDialog(this, "Choice one from PlayList", "Error", 0);
                return;
            }
            if (this._process._playListModel.indexOf(file) < 0) {
                JOptionPane.showMessageDialog(this, file + " is not in PlayList", "Error", 0);
                return;
            }
            try {
                this.setSongName(file.toString());
                this._player.openFile(file._file);
                this._lastPlayeed = file;
                this._process._file = file;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.jListPlayList.setSelectedValue(file, true);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MX00View.this.jListPlayList.setSelectedValue(file, true);
                    }
                });
            }
            this._player.startSequencer(this, pos);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

