/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.mx00playlist;

import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import jp.synthtarou.midimixer.libs.common.FileWithId;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingNode;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.mx00playlist.MX00View;

public class MX00Process
extends MXReceiver
implements MXSettingTarget {
    private static final MXDebugPrint _debug = new MXDebugPrint(MX00Process.class);
    MX00View _view;
    FileWithId _file;
    DefaultListModel _playListModel = new DefaultListModel();
    MXSetting _setting = new MXSetting("PlayList");
    boolean _playAsChained;
    boolean _playAsRepeated;

    public MX00Process() {
        this._setting.setTarget(this);
        this._view = new MX00View(this);
    }

    public void readSettings() {
        this._setting.readSettingFile();
        if (this._playListModel.size() == 0) {
            this._playListModel.addElement(new FileWithId(new File("SynthTAROU000.mid")));
            this._playListModel.addElement(new FileWithId(new File("SynthTAROU001.mid")));
            this._playListModel.addElement(new FileWithId(new File("SynthTAROU002.mid")));
        }
        this._view.settingUpdated();
    }

    @Override
    public String getReceiverName() {
        return "SMF Player";
    }

    @Override
    public JComponent getReceiverView() {
        return this._view;
    }

    @Override
    public void prepareSettingFields(MXSetting config) {
        config.register("playAsLooped");
        config.register("playAsChained");
        config.register("song[]");
    }

    @Override
    public void afterReadSettingFile(MXSetting config) {
        this._playListModel.clear();
        this._playAsRepeated = config.getSettingAsBoolean("playAsLooped", false);
        this._playAsChained = config.getSettingAsBoolean("playAsChained", false);
        ArrayList<MXSettingNode> nodeList = this._setting.findByPath("song[]");
        int min = 100000;
        int max = -1;
        for (MXSettingNode node : nodeList) {
            String name = node.getName();
            try {
                int x = Integer.parseInt(name);
                if (x < min) {
                    min = x;
                }
                if (x <= max) continue;
                max = x;
            }
            catch (NumberFormatException e) {
                _debug.printStackTrace(e);
            }
        }
        for (int x = min; x <= max; ++x) {
            String value = config.getSetting("song[" + x + "]");
            if (value == null || value.length() <= 0) continue;
            FileWithId file = new FileWithId(new File(value));
            this._playListModel.addElement(file);
        }
    }

    @Override
    public void beforeWriteSettingFile(MXSetting config) {
        config.clearValue();
        config.setSetting("playAsLooped", this._playAsRepeated);
        config.setSetting("playAsChained", this._playAsChained);
        for (int i = 0; i < this._playListModel.getSize(); ++i) {
            FileWithId f = (FileWithId)this._playListModel.get(i);
            config.setSetting("song[" + (i + 1) + "]", f._file.getPath());
        }
    }

    @Override
    protected void processMXMessageImpl(MXMessage message) {
    }

    public void updatePianoKeys(int dword) {
        this._view.updatePianoKeys(dword);
    }

    public void createPianoControls(int lowNote, int octaveRange, boolean[] activeChannels, int[] listPrograms, int[] drumProgs) {
        this._view.createPianoControls(lowNote, octaveRange, activeChannels, listPrograms, drumProgs);
    }
}

