/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.vst;

import jp.synthtarou.midimixer.libs.common.async.Transaction;
import jp.synthtarou.midimixer.libs.vst.VSTInstance;
import jp.synthtarou.midimixer.mx80vst.MX80Process;
import jp.synthtarou.midimixer.mx80vst.VSTInstancePanel;
import jp.synthtarou.midimixer.windows.MXLIB02VST3;

public class VSTStream {
    private static VSTStream _instance;
    private int _offer = -1;
    private int _stream = -1;
    private int _blockSize = 512;
    private int _sampleRate = 44100;
    private boolean _open = false;
    private int _lastSamplingRate;
    private int _lastBlockSize;
    boolean activeReload = false;

    public static synchronized VSTStream getInstance() {
        if (_instance == null) {
            _instance = new VSTStream();
        }
        return _instance;
    }

    private VSTStream() {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (!vst.isUsable()) {
            return;
        }
        Transaction tr = new Transaction("transaction");
        vst.postInitializeStream(tr.getTransactionTicket());
        if (tr.awaitResult() == 0) {
            int spare = -1;
            for (int i = 0; i < vst.countStream(); ++i) {
                String name = vst.nameOfStream(i);
                String type = vst.typeNameOfStream(i);
                if (!type.equalsIgnoreCase("ASIO")) continue;
                if (spare < 0) {
                    spare = i;
                }
                if (name.contains("FL Studio")) {
                    this._offer = i;
                }
                if (this._offer >= 0 || !name.contains("ASIO 4 ALL")) continue;
                this._offer = i;
            }
            if (this._offer < 0) {
                this._offer = spare;
            }
            System.out.println("offer = " + this._offer);
        }
    }

    public Transaction postOpenStream(Transaction task) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (task == null) {
            task = new Transaction("postOpenStream " + this.getName(this._stream));
        }
        if (vst.isUsable()) {
            VSTInstancePanel panel;
            int x;
            boolean[] loaded = null;
            MX80Process process = MX80Process.getInstance();
            if (this.activeReload && (this._lastBlockSize != this._blockSize || this._lastSamplingRate != this._sampleRate) && this._lastBlockSize != 0 && this._lastBlockSize != 0) {
                System.out.println("Need Reload 1 " + this._blockSize + " , " + this._sampleRate);
                loaded = new boolean[16];
                for (x = 0; x < 16; ++x) {
                    panel = process.getInstrumentPanel(x);
                    if (!panel.isOpen()) continue;
                    loaded[x] = true;
                    panel.enterCloseVST();
                    VSTInstance.waitQueued(null);
                }
            }
            vst.postOpenStream(this._stream, this._sampleRate, this._blockSize, task.getTransactionTicket());
            this._lastSamplingRate = this._sampleRate;
            this._lastBlockSize = this._blockSize;
            if (this.activeReload && loaded != null) {
                System.out.println("Need Reload 2 " + this._blockSize + " , " + this._sampleRate);
                for (x = 0; x < 16; ++x) {
                    if (!loaded[x]) continue;
                    panel = process.getInstrumentPanel(x);
                    panel.enterOpenVST();
                    VSTInstance.waitQueued(null);
                }
            }
        } else {
            task.letsCancel();
        }
        return task;
    }

    public boolean isOpen() {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (vst.isUsable()) {
            this._open = vst.isStreamOpen();
            return this._open;
        }
        return false;
    }

    public Transaction postCloseStream(Transaction task) {
        if (task == null) {
            task = new Transaction("postCloseStream " + this.getName(this._stream));
        }
        if (this._open) {
            MXLIB02VST3 vst = MXLIB02VST3.getInstance();
            System.out.println("closing stream " + this.getName(this._stream));
            vst.postCloseStream(task.getTransactionTicket());
            task.awaitResult();
            this._open = false;
        } else {
            task.letsCancel();
        }
        return task;
    }

    public int count() {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (vst.isUsable()) {
            return vst.countStream();
        }
        return -1;
    }

    public String getName(int x) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (vst.isUsable()) {
            return vst.nameOfStream(x);
        }
        return null;
    }

    public String getTypeName(int x) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (vst.isUsable()) {
            return vst.typeNameOfStream(x);
        }
        return null;
    }

    public int getStream() {
        return this._stream;
    }

    public void setStream(int x) {
        this._stream = x;
    }

    public int getOffer() {
        return this._offer;
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    public void setBlockSize(int blockSize) {
        this._blockSize = blockSize;
    }

    public int getSampleRate() {
        return this._sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this._sampleRate = sampleRate;
    }
}

