/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.vst;

import java.io.File;
import javax.swing.filechooser.FileSystemView;
import jp.synthtarou.midimixer.libs.common.async.Transaction;
import jp.synthtarou.midimixer.libs.settings.MXSettingUtil;
import jp.synthtarou.midimixer.libs.vst.IndexedFile;
import jp.synthtarou.midimixer.windows.MXLIB02VST3;

public class VSTInstance {
    static MXLIB02VST3 vst = MXLIB02VST3.getInstance();
    private static IndexedFile _vstRoot;
    private static IndexedFile _globalRoot;
    private final int _slot;
    private final boolean _isEffect;
    private String _path;
    private String _name;
    private String _detail;
    public int _insertValue = 127;
    public int _sendAuxValue = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VSTInstance(boolean effectType, int slot) {
        this._slot = slot;
        this._isEffect = effectType;
        if (_vstRoot == null) {
            File global;
            File appdir = MXSettingUtil.getAppBaseDirectory();
            File vst = new File(appdir, "vst");
            if (!vst.exists()) {
                vst.mkdirs();
            }
            _vstRoot = new IndexedFile(vst);
            File document = FileSystemView.getFileSystemView().getDefaultDirectory();
            File docMixrecipe = new File(document, "MIXRecipe");
            if (!docMixrecipe.exists()) {
                docMixrecipe.mkdirs();
            }
            if (!(global = new File(docMixrecipe, "vst_global")).exists()) {
                global.mkdirs();
            }
            _globalRoot = new IndexedFile(global);
        }
        try {
            _vstRoot.getLock();
            if (effectType) {
                _vstRoot.setTitle(slot + 16, "EFFECT" + slot);
            } else {
                _vstRoot.setTitle(slot, "SLOT" + slot);
            }
        }
        finally {
            _vstRoot.releaseLock();
        }
    }

    public static File getTotalRecallSetting(boolean effectMode, int rack) {
        try {
            _vstRoot.getLock();
            if (effectMode) {
                File file = _vstRoot.getPath(16 + rack);
                return file;
            }
            File file = _vstRoot.getPath(rack);
            return file;
        }
        finally {
            _vstRoot.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexedFile getGlobalSetting(String vstPath) {
        try {
            _globalRoot.getLock();
            int x = _globalRoot.findTitle(vstPath);
            if (x < 0 && (x = _globalRoot.newFileEntry(vstPath)) < 0) {
                IndexedFile indexedFile = null;
                return indexedFile;
            }
            File vstRoot = _globalRoot.getPath(x);
            if (!vstRoot.exists()) {
                vstRoot.mkdirs();
            }
            IndexedFile indexedFile = new IndexedFile(vstRoot);
            return indexedFile;
        }
        finally {
            _globalRoot.releaseLock();
        }
    }

    public boolean isEffect() {
        return this._isEffect;
    }

    public int getSlot() {
        return this._slot;
    }

    public String getName() {
        return this._name;
    }

    public String getPath() {
        return this._path;
    }

    public String getDetail() {
        return this._detail;
    }

    public int getBusCount() {
        int x = vst.getBusCount(this._isEffect, this._slot);
        return x;
    }

    public int getBusVolume(int bus) {
        float f = vst.getBusVolume(this._isEffect, this._slot, bus) * 127.0f;
        return (int)f;
    }

    public void setBusVolume(int bus, int volume) {
        float f = (float)volume / 127.0f;
        vst.setBusVolume(this._isEffect, this._slot, bus, f);
    }

    public int getInsertBalanace() {
        float f = vst.getInsertBalance(this._slot) * 127.0f;
        return (int)f;
    }

    public void setInsertBalance(int volume) {
        float f = (float)volume / 127.0f;
        vst.setInsertBalance(this._slot, f);
    }

    public int getAuxSend() {
        float f = vst.getAuxSend(this._slot) * 127.0f;
        return (int)f;
    }

    public void setAuxSend(int volume) {
        float f = (float)volume / 127.0f;
        vst.setAuxSend(this._slot, f);
    }

    public void setPath(String path) {
        int i2;
        if (path == null) {
            this._path = "";
            this._name = "";
            this._detail = "";
            return;
        }
        this._path = path;
        int i1 = path.lastIndexOf(47);
        if (i1 < (i2 = path.lastIndexOf(92))) {
            i1 = i2;
        }
        this._name = this._path.substring(i1 + 1);
        this._detail = "-";
    }

    public boolean isOpen() {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (vst.isUsable()) {
            return vst.isLaunchedVST(this._isEffect, this._slot);
        }
        return false;
    }

    public Transaction postLaunchVST(Transaction task) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (task == null) {
            task = new Transaction("postLaunchVST " + this._path);
        }
        if (vst.isUsable() && this._path != null && new File(this._path).exists()) {
            if (this.isOpen()) {
                vst.postRemoveSynth(this._isEffect, this._slot, 0);
            }
            vst.postLaunchVST(this._isEffect, this._slot, this._path, task.getTransactionTicket());
            return task;
        }
        task.letsCancel();
        return task;
    }

    public Transaction postCloseVST(Transaction task) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (task == null) {
            task = new Transaction("postCloseVST " + this._path);
        }
        if (this.isOpen()) {
            vst.postRemoveSynth(this._isEffect, this._slot, task.getTransactionTicket());
            return task;
        }
        task.letsCancel();
        return task;
    }

    public boolean isEditorOpen() {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (this.isOpen()) {
            return vst.isEditorOpen(this._isEffect, this._slot);
        }
        return false;
    }

    public Transaction postOpenEditor(Transaction task, Transaction whenClose) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (task == null) {
            task = new Transaction("postOpenEditor " + this._path);
        }
        if (whenClose == null) {
            whenClose = new Transaction("postOpenEditor#closeHandler " + this._path);
        }
        if (vst.isUsable() && this._slot >= 0) {
            vst.postOpenEditor(this._isEffect, this._slot, task.getTransactionTicket(), whenClose.getTransactionTicket());
            return task;
        }
        task.letsCancel();
        return task;
    }

    public Transaction postCloseEditor(Transaction task) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (task == null) {
            task = new Transaction("postCloseEditor " + this._path);
        }
        if (vst.isUsable() && this._slot >= 0) {
            vst.postCloseEditor(this._isEffect, this._slot, task.getTransactionTicket());
            return task;
        }
        task.letsCancel();
        return task;
    }

    public Transaction postSavePreset(String path, Transaction task) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (task == null) {
            task = new Transaction("savePreset " + path);
        }
        if (vst.isUsable() && this._slot >= 0 && vst.isLaunchedVST(this._isEffect, this._slot)) {
            vst.savePreset(this._isEffect, this._slot, path, task.getTransactionTicket());
            return task;
        }
        task.letsCancel();
        return task;
    }

    public Transaction postLoadPreset(String path, Transaction task) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (task == null) {
            task = new Transaction("loadPreset " + path);
        }
        if (vst.isUsable() && this._slot >= 0 && new File(path).exists()) {
            vst.loadPreset(this._isEffect, this._slot, path, task.getTransactionTicket());
            return task;
        }
        task.letsCancel();
        return task;
    }

    public static Transaction waitQueued(Transaction task) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (task == null) {
            task = new Transaction("waitQueued");
        }
        if (vst.isUsable()) {
            vst.waitQueued(task.getTransactionTicket());
            return task;
        }
        task.letsCancel();
        return task;
    }

    public boolean postShortMessage(int dword) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (vst.isUsable() && this._slot >= 0) {
            vst.postShortMessage(this._isEffect, this._slot, dword);
            return true;
        }
        return false;
    }

    public boolean postLongMessage(byte[] data) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (vst.isUsable() && this._slot >= 0) {
            vst.postLongMessage(this._isEffect, this._slot, data);
            return true;
        }
        return false;
    }

    public static Transaction stopEngine(Transaction task) {
        MXLIB02VST3 vst = MXLIB02VST3.getInstance();
        if (task == null) {
            task = new Transaction("stopEngine");
        }
        if (vst.isUsable()) {
            vst.stopEngine(task.getTransactionTicket());
            return task;
        }
        task.letsCancel();
        return task;
    }
}

