/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.vst;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeMap;

public class VSTFolder {
    private Callback _callback = new Callback(){

        @Override
        public void seekingCallback(String text, long hit, long total) {
            System.out.println(hit + " / " + total + " = " + text);
        }
    };
    private long _progressTotal;
    private long _progrssHit;
    private boolean _scanDone;
    public boolean _cancelOperation;
    private String _targetExtension;
    public File _rootDirectory = null;
    private TreeMap<File, ArrayList<File>> _listResult = new TreeMap();

    public TreeMap<File, ArrayList<File>> getListResult() {
        return this._listResult;
    }

    public VSTFolder() {
    }

    public static void main(String[] args) {
        VSTFolder filter = new VSTFolder(".mid");
        File root = new File("C:/midi");
        filter.setRootDirectory(root);
        filter.scan(null);
        for (File dir : filter.getListResult().keySet()) {
            System.out.println("@" + VSTFolder.getAsAbsolute(root, dir));
            ArrayList<File> childs = filter.getListResult().get(dir);
            for (File file : childs) {
                System.out.println("    " + VSTFolder.getAsAbsolute(dir, file));
            }
        }
    }

    public static String getAsAbsolute(File root, File target) {
        String rootPath = root.getPath();
        String targetPath = target.getPath();
        if (targetPath.equals(rootPath)) {
            return "";
        }
        if (targetPath.startsWith(rootPath)) {
            return targetPath.substring(rootPath.length() + 1);
        }
        return targetPath;
    }

    public VSTFolder(String extension) {
        this.setExtension(extension);
    }

    public void setRootDirectory(File directory) {
        this._rootDirectory = directory;
    }

    public void scan(ArrayList<String> listSkip) {
        this._cancelOperation = false;
        if (this._rootDirectory == null) {
            System.err.println("FileExtensionFilter::startScan rootDirectory is null");
            return;
        }
        if (!this._rootDirectory.isDirectory()) {
            System.err.println("FileExtensionFilter::startScan rootDirectory[" + this._rootDirectory + "] is not directory");
            return;
        }
        System.err.println("FileExtensionFilter::startScan " + this._targetExtension + " in [" + this._rootDirectory + "] ");
        LinkedList<File> listDirctory = new LinkedList<File>();
        listDirctory.add(this._rootDirectory);
        TreeMap newResult = new TreeMap();
        this._progressTotal = 0L;
        this._progrssHit = 0L;
        while (!listDirctory.isEmpty()) {
            File dir = (File)listDirctory.pop();
            File[] childs = dir.listFiles();
            if (childs == null) continue;
            ArrayList<File> list = new ArrayList<File>();
            for (File f : childs) {
                String path;
                ++this._progressTotal;
                if (this._cancelOperation) {
                    return;
                }
                if (this._progressTotal % 1000L == 0L) {
                    this._callback.seekingCallback(VSTFolder.getAsAbsolute(this._rootDirectory, f), this._progrssHit, this._progressTotal);
                }
                if (this.isSkipTarget(listSkip, path = f.getPath())) continue;
                if (this.matchFilter(path)) {
                    list.add(f);
                    ++this._progrssHit;
                    continue;
                }
                if (!f.isDirectory()) continue;
                listDirctory.add(f);
            }
            if (list.size() <= 0) continue;
            newResult.put(dir, list);
        }
        this._callback.seekingCallback("Done", this._progrssHit, this._progressTotal);
        this._listResult = newResult;
        this._scanDone = true;
    }

    public void setExtension(String extension) {
        if (extension.startsWith("*.")) {
            extension = extension.substring(2);
        } else if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        for (char ch : extension.toCharArray()) {
            switch (ch) {
                case '*': 
                case '<': 
                case '>': {
                    throw new IllegalArgumentException("Bad Filter (contains *><)");
                }
            }
        }
        this._targetExtension = extension.toLowerCase();
    }

    public boolean matchFilter(String path) {
        int last = path.lastIndexOf(46);
        String extension = "";
        if (last > 0) {
            extension = path.substring(last + 1).toLowerCase();
        }
        return this._targetExtension.equals(extension);
    }

    public void cancelOperation() {
        this._cancelOperation = true;
    }

    boolean isSkipTarget(ArrayList<String> listSkip, String path) {
        if (listSkip != null) {
            for (String skip : listSkip) {
                if (!path.equalsIgnoreCase(skip)) continue;
                System.out.println("check skip " + skip + " for " + path);
                return true;
            }
        }
        return false;
    }

    public void setResult(TreeMap<File, ArrayList<File>> newReult) {
        this._listResult = newReult;
    }

    public void setCallback(Callback _callback) {
        this._callback = _callback;
    }

    public void setScanDone(boolean done) {
        this._scanDone = done;
    }

    public boolean isScanDone() {
        return this._scanDone;
    }

    public static interface Callback {
        public void seekingCallback(String var1, long var2, long var4);
    }
}

