/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.vst;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.vst.IndexedFile;
import jp.synthtarou.midimixer.libs.vst.MXPresetAction;
import jp.synthtarou.midimixer.libs.vst.TextInputPanel;

public class MXPresetPanel
extends JPanel {
    IndexedFile _file;
    MXWrapList<Integer> _listModel;
    MXPresetAction _action;
    private JButton jButtonClose;
    private JButton jButtonLoad;
    private JButton jButtonSave;
    private JLabel jLabelTitlte;
    private JList<String> jListEntry;
    private JScrollPane jScrollPane1;

    public MXPresetPanel(IndexedFile file, MXPresetAction action) {
        this.initComponents();
        this.setPreferredSize(new Dimension(500, 300));
        this._file = file;
        this._action = action;
        this._listModel = this.createListModel();
        this.jListEntry.setModel(this._listModel);
    }

    public static void main(String[] args) {
        IndexedFile root = new IndexedFile(new File("C:/test"));
        MXPresetAction action = new MXPresetAction(){

            @Override
            public boolean presetActionSave(File file) {
                block4: {
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(file);
                        out.write("abc".getBytes());
                        out.close();
                        out = null;
                    }
                    catch (IOException e) {
                        if (out == null) break block4;
                        try {
                            out.close();
                            out = null;
                            file.delete();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                return true;
            }

            @Override
            public boolean presetActionLoad(File file) {
                System.out.println("Loading " + file);
                return true;
            }
        };
        root.getLock();
        MXPresetPanel panel = new MXPresetPanel(root, action);
        MXUtil.showAsDialog(null, panel, "total recall");
        root.releaseLock();
        System.exit(0);
    }

    public MXWrapList<Integer> createListModel() {
        this._file.readIndexFile();
        MXWrapList<Integer> model = new MXWrapList<Integer>();
        for (int i = 0; i < 128; ++i) {
            String title = this._file.getTitle(i);
            if (title == null) {
                title = " - ";
            }
            String text = this.createLine(i, title);
            model.addNameAndValue(text, i);
        }
        return model;
    }

    public String createLine(int num, String title) {
        return Integer.toString(num) + ": " + title;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListEntry = new JList();
        this.jButtonLoad = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.jLabelTitlte = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder("Save / Load Preset"));
        this.setLayout(new GridBagLayout());
        this.jListEntry.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jListEntry);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonLoad.setText("Load");
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXPresetPanel.this.jButtonLoadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jButtonLoad, gridBagConstraints);
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXPresetPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXPresetPanel.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.jButtonClose, gridBagConstraints);
        this.jLabelTitlte.setText("Title");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabelTitlte, gridBagConstraints);
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        if (this._action == null) {
            return;
        }
        int index = this.jListEntry.getSelectedIndex();
        if (index >= 0) {
            Integer x = this._listModel.valueOfIndex(index);
            if (x != index) {
                System.err.println("Something Wrong , List Index != Data Index");
                return;
            }
            if (this._action.presetActionLoad(this._file.getPath(x))) {
                MXUtil.getOwnerWindow(this).setVisible(false);
            }
        }
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        int index = this.jListEntry.getSelectedIndex();
        if (index >= 0) {
            Integer x = this._listModel.valueOfIndex(index);
            if (x != index) {
                System.err.println("Something Wrong , List Index != Data Index");
                return;
            }
            TextInputPanel panel = new TextInputPanel();
            String title = this._file.getTitle(x);
            String ret = panel.showAsDialog(this, title);
            if (ret != null) {
                title = ret;
                this._file.setTitle(x, title);
                if (this._action.presetActionSave(this._file.getPath(x))) {
                    MXUtil.getOwnerWindow(this).setVisible(false);
                }
                this.jListEntry.setModel(this.createListModel());
            }
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        MXUtil.getOwnerWindow(this).setVisible(false);
    }
}

