/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.vst;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.TreeMap;

public class IndexedFile {
    Comparator<Integer> comparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer int1, Integer int2) {
            return int1.compareTo(int2);
        }
    };
    TreeMap<Integer, String> _listEntry = new TreeMap(this.comparator);
    File _baseDir;
    File _indexFile;
    File _indexLockFile;
    File _indexTempFile;
    FileOutputStream _lock;

    public File getBaseDir() {
        return this._baseDir;
    }

    public IndexedFile(File baseDir) {
        this._baseDir = baseDir;
        this._indexTempFile = new File(this._baseDir, "MXIndex.tmp");
        this._indexLockFile = new File(this._baseDir, "MXIndex.lcok");
        this._indexFile = new File(this._baseDir, "MXIndex");
    }

    public synchronized boolean getLock() {
        if (this._lock == null) {
            try {
                this._lock = new FileOutputStream(this._indexLockFile);
                this.readIndexFile();
                return true;
            }
            catch (IOException iOException) {}
        } else {
            return true;
        }
        return false;
    }

    public synchronized void releaseLock() {
        if (this._lock != null) {
            try {
                this._lock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized String getTitle(int index) {
        if (this._lock == null) {
            throw new IllegalStateException("getLock before Operation");
        }
        String title = this._listEntry.get(index);
        return title;
    }

    public synchronized void setTitle(int index, String title) {
        if (this._lock == null) {
            throw new IllegalStateException("getLock before Operation");
        }
        this._listEntry.put(index, title);
        this.writeIndexFile();
    }

    public synchronized File getPath(int file) {
        Object fileName = "0000000" + String.valueOf(file);
        if (((String)fileName).length() > 8) {
            fileName = ((String)fileName).substring(((String)fileName).length() - 8);
        }
        return new File(this._baseDir, (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean readIndexFile() {
        if (this._lock == null) {
            throw new IllegalStateException("getLock before Operation");
        }
        this._listEntry.clear();
        File[] children = this._baseDir.listFiles();
        if (children != null) {
            for (File f : children) {
                int fileX;
                String title = f.getName();
                try {
                    fileX = Integer.parseInt(title);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                this._listEntry.put(fileX, title);
            }
        }
        BufferedReader reader = null;
        try {
            String line;
            Charset utf8 = Charset.forName("utf-8");
            reader = new BufferedReader(new FileReader(this._indexFile, utf8));
            while ((line = reader.readLine()) != null) {
                int splitPos = line.indexOf("=");
                if (splitPos < 0) continue;
                String file = line.substring(0, splitPos);
                String title = line.substring(splitPos + 1);
                int fileX = -1;
                try {
                    fileX = Integer.parseInt(file);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                this._listEntry.put(fileX, title);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeIndexFile() {
        if (this._lock == null) {
            throw new IllegalStateException("getLock before Operation");
        }
        Charset utf8 = Charset.forName("utf-8");
        FileWriter fwrite = null;
        BufferedWriter bwrite = null;
        try {
            fwrite = new FileWriter(this._indexTempFile, utf8);
            bwrite = new BufferedWriter(fwrite);
            for (Integer file : this._listEntry.keySet()) {
                String title = this._listEntry.get(file);
                File f = this.getPath(file);
                bwrite.write(f.getName() + "=" + title + "\n");
            }
            bwrite.flush();
            bwrite.close();
            this._indexFile.delete();
            this._indexTempFile.renameTo(this._indexFile);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bwrite != null) {
                try {
                    bwrite.close();
                }
                catch (IOException iOException) {}
                bwrite = null;
                if (fwrite != null) {
                    try {
                        fwrite.close();
                    }
                    catch (IOException iOException) {}
                    fwrite = null;
                }
            }
        }
        this._indexTempFile.delete();
        return false;
    }

    public synchronized int findTitle(String title) {
        if (this._lock == null) {
            throw new IllegalStateException("getLock before Operation");
        }
        for (Integer n : this._listEntry.keySet()) {
            String name = this._listEntry.get(n);
            if (!name.equalsIgnoreCase(title)) continue;
            return n;
        }
        return -1;
    }

    public synchronized int newFileEntry(String title) {
        if (this._lock == null) {
            new IllegalStateException("getLock before Operation");
        }
        int next = this._listEntry.size() + 1;
        do {
            File f;
            if ((f = this.getPath(next)).exists()) continue;
            this._listEntry.put(next, title);
            this.writeIndexFile();
            return next;
        } while (++next < 100000000);
        return -1;
    }
}

