/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.swing.themes;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Window;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jp.synthtarou.midimixer.libs.common.MXWrap;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import jp.synthtarou.midimixer.libs.swing.CurvedSlider;
import jp.synthtarou.midimixer.libs.swing.themes.MetalForestTheme;
import jp.synthtarou.midimixer.libs.swing.themes.MetalSeaTheme;
import jp.synthtarou.midimixer.libs.swing.themes.MetalStoneTheme;
import jp.synthtarou.midimixer.libs.swing.themes.MetalWineTheme;

public class ThemeManager
implements MXSettingTarget {
    MXSetting _setting;
    static ThemeManager _manager = new ThemeManager();
    public boolean colorfulMetalTheme;
    public String themeName;
    public String fontName;
    public int fontSize;
    public int fontStyle;
    public static final int THEME_SEA = 0;
    public static final int THEME_FOREST = 1;
    public static final int THEME_WINE = 2;
    public static final int THEME_STONE = 3;
    public static String[] additionalTheme;

    public static ThemeManager getInstance() {
        return _manager;
    }

    public ThemeManager() {
        additionalTheme = new String[]{"*Sea", "*Forest", "*WineRed", "*Stone"};
        this._setting = new MXSetting("ThemeManager");
        this._setting.setTarget(this);
        this._setting.readSettingFile();
    }

    public void setUITheme(String themeName) {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        try {
            boolean done = false;
            for (int i = 0; i < additionalTheme.length; ++i) {
                if (!additionalTheme[i].equals(themeName)) continue;
                DefaultMetalTheme theme = null;
                this.colorfulMetalTheme = true;
                switch (i) {
                    case 1: {
                        theme = new MetalForestTheme();
                        break;
                    }
                    case 2: {
                        theme = new MetalWineTheme();
                        break;
                    }
                    case 0: {
                        theme = new MetalSeaTheme();
                        break;
                    }
                    case 3: {
                        theme = new MetalStoneTheme();
                    }
                }
                MetalLookAndFeel.setCurrentTheme(theme);
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Metal".equalsIgnoreCase(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                }
                done = true;
            }
            if (!done) {
                this.colorfulMetalTheme = false;
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!themeName.equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFont(String name, int style, int size) {
        Font f2;
        try {
            f2 = new Font(name, style, size);
        }
        catch (Exception e) {
            name = "Dialog";
            f2 = new Font(name, style, size);
        }
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            if (!entry.getKey().toString().toLowerCase().endsWith("font")) continue;
            FontUIResource f1 = new FontUIResource(f2);
            UIManager.put(entry.getKey(), f1);
        }
    }

    public void updateUITree() {
        Window[] win = Window.getWindows();
        for (int i = 0; i < win.length; ++i) {
            ThemeManager.updateComponentTreeUI(win[i]);
            if (!(win[i] instanceof JDialog)) continue;
            win[i].pack();
        }
    }

    public static void updateComponentTreeUI(Component c) {
        ThemeManager.updateComponentTreeUI0(c);
        c.invalidate();
        c.validate();
        c.repaint();
    }

    private static void updateComponentTreeUI0(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.updateUI();
            JPopupMenu jpm = jc.getComponentPopupMenu();
            if (jpm != null) {
                ThemeManager.updateComponentTreeUI(jpm);
            }
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (Component child : children) {
                ThemeManager.updateComponentTreeUI0(child);
            }
        }
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        setting.register("themeLabelColorful");
        setting.register("themeName");
        setting.register("fontName");
        setting.register("fontSize");
        setting.register("fontStyle");
        setting.register("circleIsCircce");
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        this.colorfulMetalTheme = setting.getSettingAsBoolean("themeLabelColorful", false);
        this.themeName = setting.getSetting("themeName");
        if (this.themeName == null || this.themeName.isEmpty()) {
            this.themeName = "Metal";
        }
        this.fontName = setting.getSetting("fontName");
        if (this.fontName == null || this.fontName.isEmpty()) {
            this.fontName = "\u30e1\u30a4\u30ea\u30aa";
        }
        this.fontSize = setting.getSettingAsInt("fontSize", 12);
        this.fontStyle = setting.getSettingAsInt("fontStyle", 0);
        this.setFont(this.fontName, this.fontStyle, this.fontSize);
        this.setUITheme(this.themeName);
        CurvedSlider.setMouseCircleIsCircle(setting.getSettingAsBoolean("circleIsCircce", true));
        this.updateUITree();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        setting.setSetting("themeLabelColorful", this.colorfulMetalTheme);
        setting.setSetting("themeName", this.themeName);
        setting.setSetting("fontName", this.fontName);
        setting.setSetting("fontSize", this.fontSize);
        setting.setSetting("fontStyle", this.fontStyle);
        setting.setSetting("circleIsCircce", CurvedSlider.isMouseCircleIsCircle());
    }

    public MXWrapList<String> getLookAndFeelModel() {
        MXWrapList<String> model = new MXWrapList<String>();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            model.addNameAndValue(info.getName(), info.getName());
        }
        return model;
    }

    public MXWrapList<String> getFontNameModel() {
        MXWrapList<String> model = new MXWrapList<String>();
        String[] names = new String[]{"Dialog", "Monospaced", "Meiryo", "Serif", "SansSerif"};
        String set = ThemeManager.getInstance().fontName;
        for (int i = 0; i < names.length; ++i) {
            model.addNameAndValue(names[i], names[i]);
            if (!names[i].equals(set)) continue;
            model.setSelectedItem(model.get(model.size() - 1));
        }
        return model;
    }

    public MXWrapList<Integer> getFontStyleModel() {
        MXWrapList<Integer> model = new MXWrapList<Integer>();
        model.addNameAndValue("Plain", 0);
        model.addNameAndValue("Italic", 2);
        model.addNameAndValue("Bold", 1);
        model.addNameAndValue("BoldItalic", 3);
        for (int i = 0; i < model.size(); ++i) {
            MXWrap wrap = (MXWrap)model.get(i);
            if ((Integer)wrap.value != this.fontStyle) continue;
            model.setSelectedItem(wrap);
        }
        return model;
    }

    public MXWrapList<Integer> getFontSizeModel() {
        MXWrapList<Integer> model = new MXWrapList<Integer>();
        for (int x = 6; x < 16; ++x) {
            model.addNameAndValue(String.valueOf(x), x);
        }
        for (int i = 0; i < model.size(); ++i) {
            MXWrap wrap = (MXWrap)model.get(i);
            if ((Integer)wrap.value != this.fontSize) continue;
            model.setSelectedItem(wrap);
        }
        return model;
    }

    public boolean isColorfulMetalTheme() {
        return this.colorfulMetalTheme;
    }
}

