/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import jp.synthtarou.midimixer.MXStatic;

public class MXSpinnerMouseExt {
    JSpinner _spinner;
    JComponent _parent;
    Point _basePoint;

    public MXSpinnerMouseExt(JComponent parent, JSpinner spinner) {
        this._spinner = spinner;
        this._parent = parent;
        LinkedList<Component> list = new LinkedList<Component>();
        list.add(parent);
        while (!list.isEmpty()) {
            Component c = (Component)list.removeFirst();
            if (c instanceof Container) {
                EventListener[] p = (MouseListener[])c;
                Component[] children = p.getComponents();
                for (int i = 0; i < children.length; ++i) {
                    list.add(children[i]);
                }
            }
            for (MouseListener mouseListener : c.getMouseListeners()) {
                if (!(mouseListener instanceof MouseManager)) continue;
                c.removeMouseListener(mouseListener);
                break;
            }
            for (EventListener eventListener : c.getMouseMotionListeners()) {
                if (!(eventListener instanceof MouseManager)) continue;
                c.removeMouseMotionListener((MouseMotionListener)eventListener);
                break;
            }
            for (EventListener eventListener : c.getMouseWheelListeners()) {
                if (!(eventListener instanceof MouseManager)) continue;
                c.removeMouseWheelListener((MouseWheelListener)eventListener);
                break;
            }
            MouseManager l = new MouseManager();
            c.addMouseListener(l);
            c.addMouseMotionListener(l);
            c.addMouseWheelListener(l);
        }
    }

    public class MouseManager
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        @Override
        public void mouseDragged(MouseEvent e) {
            if (MXStatic._trapMouseForOnlySelect) {
                return;
            }
            this.mouseMoved(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (MXStatic._trapMouseForOnlySelect) {
                return;
            }
            if (MXSpinnerMouseExt.this._spinner.isEnabled() && MXSpinnerMouseExt.this._basePoint != null) {
                Point p2 = e.getLocationOnScreen();
                int div = p2.y - MXSpinnerMouseExt.this._basePoint.y - (p2.x - MXSpinnerMouseExt.this._basePoint.x);
                div *= 5;
                div /= 200;
                SpinnerModel model = MXSpinnerMouseExt.this._spinner.getModel();
                if (model instanceof SpinnerNumberModel) {
                    SpinnerNumberModel number = (SpinnerNumberModel)model;
                    int x = (Integer)number.getNumber();
                    int v = div;
                    if ((x -= v) < (Integer)number.getMinimum()) {
                        x = (Integer)number.getMinimum();
                    }
                    if (x > (Integer)number.getMaximum()) {
                        x = (Integer)number.getMaximum();
                    }
                    MXSpinnerMouseExt.this._spinner.setValue(x);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MXStatic._trapMouseForOnlySelect) {
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (MXStatic._trapMouseForOnlySelect) {
                return;
            }
            if (MXSpinnerMouseExt.this._spinner.isEnabled()) {
                MXSpinnerMouseExt.this._basePoint = e.getLocationOnScreen();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (MXStatic._trapMouseForOnlySelect) {
                return;
            }
            MXSpinnerMouseExt.this._basePoint = null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (MXStatic._trapMouseForOnlySelect) {
                return;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (MXStatic._trapMouseForOnlySelect) {
                return;
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            SpinnerModel model;
            if (MXStatic._trapMouseForOnlySelect) {
                return;
            }
            if (MXSpinnerMouseExt.this._spinner.isEnabled() && (model = MXSpinnerMouseExt.this._spinner.getModel()) instanceof SpinnerNumberModel) {
                SpinnerNumberModel number = (SpinnerNumberModel)model;
                int x = (Integer)number.getNumber();
                int v = e.getWheelRotation();
                if ((x -= v) < (Integer)number.getMinimum()) {
                    x = (Integer)number.getMinimum();
                }
                if (x > (Integer)number.getMaximum()) {
                    x = (Integer)number.getMaximum();
                }
                MXSpinnerMouseExt.this._spinner.setValue(x);
            }
        }
    }
}

