/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Objects;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSliderUI;
import jp.synthtarou.midimixer.MXStatic;

public class MXSliderUIForTablet
extends BasicSliderUI {
    BasicSliderUI lastUI;

    public MXSliderUIForTablet(final JSlider slider) {
        super(slider);
        for (MouseListener mouseListener : slider.getMouseListeners()) {
            slider.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : slider.getMouseMotionListeners()) {
            slider.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        BasicSliderUI basicSliderUI = this.lastUI = (BasicSliderUI)slider.getUI();
        Objects.requireNonNull(basicSliderUI);
        BasicSliderUI.TrackListener tl = new BasicSliderUI.TrackListener(basicSliderUI){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                if (MXStatic._trapMouseForOnlySelect) {
                    return;
                }
                if (slider.isEnabled()) {
                    BasicSliderUI ui = (BasicSliderUI)slider.getUI();
                    Point p = e.getPoint();
                    if (slider.getOrientation() == 0) {
                        int value = ui.valueForXPosition(p.x);
                        slider.setValue(value);
                    } else {
                        int value = ui.valueForYPosition(p.y);
                        slider.setValue(value);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseClicked(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseClicked(e);
            }

            @Override
            public boolean shouldScroll(int dir) {
                return false;
            }
        };
        slider.addMouseListener(tl);
        slider.addMouseMotionListener(tl);
    }
}

