/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.swing.themes.ThemeManager;

public class CurvedSlider
extends JPanel
implements MouseListener,
MouseMotionListener {
    private double _minAngleRad = 0.0;
    private double _maxAngleRad = 0.0;
    private int _rangeFrom = 0;
    private int _rangeTo = 0;
    private int _value = 0;
    private boolean _inverted = false;
    private Color _highlight;
    private Color _textBack;
    int _circleR;
    static Font staticFont = new Font("Serif", 1, 12);
    static boolean mouseModeCircle = true;
    double startValue = 0.0;
    Point startPoint = null;
    public Runnable _editor = null;
    ArrayList<ChangeListener> listenerList = new ArrayList();

    public void setEditable(boolean e) {
        super.setEnabled(e);
        this.updateUI();
    }

    public void setInverted(boolean invert) {
        this._inverted = invert;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this._highlight = new JTextField().getSelectionColor();
        this._textBack = MXUtil.mixedColor(Color.red, Color.yellow, 90);
    }

    public CurvedSlider(int circleR) {
        this._circleR = circleR;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setMinimumSize(new Dimension(circleR, circleR));
        this.setMaximumSize(new Dimension(circleR, circleR));
        this.setPreferredSize(new Dimension(circleR, circleR));
        this.setSize(new Dimension(circleR, circleR));
        double minAngle = 3.839724354387525;
        double maxAngle = -0.6981317007977318;
        this.setAngles(minAngle, maxAngle);
    }

    public void setAngles(double minAngleRad, double maxAngleRad) {
        this._minAngleRad = minAngleRad;
        this._maxAngleRad = maxAngleRad;
        this.repaint();
    }

    public void setRange(int rangeFrom, int rangeto) {
        this._rangeFrom = rangeFrom;
        this._rangeTo = rangeto;
        this.repaint();
    }

    public void setValue(int value) {
        if (this._value != value) {
            this._value = value;
            this.repaint();
            this.vokeListenerList();
        }
    }

    public int getValue() {
        return this._value;
    }

    @Override
    protected void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        Color foreground = this.getForeground();
        Color background = this.getBackground();
        if (!this.isEnabled()) {
            foreground = MXUtil.mixedColor(foreground, Color.white, 30);
        }
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(background);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double alpha = ((double)this._value - (double)this._rangeFrom) / (double)(this._rangeTo - this._rangeFrom);
        if (this._inverted) {
            alpha = ((double)this._rangeTo - (double)this._value) / (double)(this._rangeTo - this._rangeFrom);
        }
        double angleRad = this._minAngleRad + alpha * (this._maxAngleRad - this._minAngleRad);
        double radius = (double)Math.min(this.getWidth(), this.getHeight()) / 3.0;
        double thickness = 15.0;
        double xC = (double)this.getWidth() / 2.0;
        double yC = (double)this.getHeight() / 2.0;
        double x0 = xC + Math.cos(angleRad) * (radius - 15.0);
        double y0 = yC - Math.sin(angleRad) * (radius - 15.0);
        double x1 = xC + Math.cos(angleRad) * radius;
        double y1 = yC - Math.sin(angleRad) * radius;
        Arc2D.Double a0 = new Arc2D.Double(xC - radius - 2.0, yC - radius - 2.0, radius + radius + 4.0, radius + radius + 4.0, Math.toDegrees(this._minAngleRad + 0.15), Math.toDegrees(this._maxAngleRad - this._minAngleRad - 0.3), 2);
        g.setColor(foreground);
        g.fill(a0);
        Arc2D.Double a1 = new Arc2D.Double(xC - radius, yC - radius, radius + radius, radius + radius, Math.toDegrees(angleRad), Math.toDegrees(this._maxAngleRad - angleRad), 2);
        g.setColor(this._highlight);
        g.fill(a1);
        Arc2D.Double a2 = new Arc2D.Double(xC - radius, yC - radius, radius + radius, radius + radius, Math.toDegrees(this._minAngleRad), Math.toDegrees(angleRad - this._minAngleRad), 2);
        g.setColor(this._textBack);
        g.fill(a2);
        Arc2D.Double a1inner = new Arc2D.Double(xC - radius / 2.0 - 3.0, yC - radius / 2.0 - 3.0, (radius + radius) / 2.0 + 6.0, (radius + radius) / 2.0 + 6.0, Math.toDegrees(this._minAngleRad), Math.toDegrees(this._maxAngleRad - this._minAngleRad), 2);
        g.setColor(foreground);
        g.fill(a1inner);
        Arc2D.Double b1inner = new Arc2D.Double(xC - radius / 2.0, yC - radius / 2.0, (radius + radius) / 2.0, (radius + radius) / 2.0, Math.toDegrees(this._minAngleRad + 1.0), Math.toDegrees(this._maxAngleRad - this._minAngleRad - 2.0), 2);
        g.setColor(background);
        g.fill(b1inner);
        String str = String.valueOf(this._value);
        if (ThemeManager.getInstance().isColorfulMetalTheme()) {
            g.setColor(MXUtil.mixedColor(Color.red, Color.yellow, 30));
        } else {
            g.setColor(MXUtil.mixedColor(Color.blue, Color.pink, 30));
        }
        g.setFont(staticFont);
        int x = g.getFontMetrics().stringWidth(str);
        int y = g.getFontMetrics().getHeight();
        g.drawString(str, (this.getWidth() - x) / 2, this.getHeight() - 4);
    }

    public static void setMouseCircleIsCircle(boolean isCircle) {
        mouseModeCircle = isCircle;
    }

    public static boolean isMouseCircleIsCircle() {
        return mouseModeCircle;
    }

    private void updateAngle(Point p) {
        double xC = this.startPoint.x;
        double yC = this.startPoint.y;
        if (this.startPoint == null) {
            return;
        }
        if (mouseModeCircle) {
            xC = (double)this.getWidth() / 2.0;
            yC = (double)this.getHeight() / 2.0;
        }
        double dx = p.getX() - xC;
        double dy = p.getY() - yC;
        if (mouseModeCircle) {
            double angleRad = Math.atan2(-dy, dx);
            if (angleRad < -1.5707963267948966) {
                angleRad = Math.PI * 2 + angleRad;
            }
            angleRad = Math.max(this._maxAngleRad, Math.min(this._minAngleRad, angleRad));
            double alpha = (angleRad - this._minAngleRad) / (this._maxAngleRad - this._minAngleRad);
            double value = (double)this._rangeFrom + alpha * (double)(this._rangeTo - this._rangeFrom);
            this.setValue((int)value);
        } else {
            double distance = dx - dy;
            double range = this._rangeTo - this._rangeFrom;
            double value2 = this.startValue + distance * range / 250.0;
            if (value2 < (double)this._rangeFrom) {
                value2 = this._rangeFrom;
            }
            if (value2 > (double)this._rangeTo) {
                value2 = this._rangeTo;
            }
            this.setValue((int)value2);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isEnabled() && !SwingUtilities.isRightMouseButton(e)) {
            this.updateAngle(e.getPoint());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isEnabled() && !SwingUtilities.isRightMouseButton(e)) {
            this.startPoint = e.getPoint();
            this.startValue = this._value;
            this.updateAngle(e.getPoint());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.startPoint = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        this.listenerList.add(listener);
    }

    public synchronized void vokeListenerList() {
        ChangeEvent evt = new ChangeEvent(this);
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).stateChanged(evt);
        }
    }
}

