/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.settings;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.settings.MXSettingException;

public class StringPath
extends ArrayList<String>
implements Cloneable {
    private static final MXDebugPrint _debug = new MXDebugPrint(StringPath.class);

    @Override
    public StringPath clone() {
        StringPath p = new StringPath();
        p.addAll(this);
        return p;
    }

    public static StringPath parsePath(String name) throws MXSettingException {
        StringPath path = new StringPath();
        char[] buffer = name.toCharArray();
        StringBuffer writingChar = new StringBuffer();
        for (int x = 0; x < buffer.length; ++x) {
            String part;
            char ch = buffer[x];
            if (ch == '.') {
                part = writingChar.toString();
                writingChar = new StringBuffer();
                if (part.length() < 1) continue;
                if (part.charAt(0) >= '0' && part.charAt(0) <= '9') {
                    try {
                        Integer.parseInt(part);
                    }
                    catch (NumberFormatException e) {
                        throw new MXSettingException(e);
                    }
                }
                path.add(part);
                continue;
            }
            if (ch == '[') {
                int nextClose;
                if (writingChar.length() >= 1) {
                    part = writingChar.toString();
                    writingChar = new StringBuffer();
                    if (part.length() >= 1) {
                        if (part.charAt(0) >= '0' && part.charAt(0) <= '9') {
                            try {
                                Integer.parseInt(part);
                            }
                            catch (NumberFormatException e) {
                                throw new MXSettingException(e);
                            }
                        }
                        path.add(part);
                    }
                }
                for (nextClose = x + 1; nextClose < buffer.length && buffer[nextClose] != ']'; ++nextClose) {
                }
                if (nextClose - x - 1 >= 0) {
                    String number = new String(buffer, x + 1, nextClose - x - 1);
                    if (number.length() == 0) {
                        number = "0";
                    }
                    try {
                        Integer.parseInt(number);
                        path.add(number);
                    }
                    catch (NumberFormatException e) {
                        throw new MXSettingException(number);
                    }
                } else {
                    throw new MXSettingException("???");
                }
                if (nextClose + 1 < buffer.length && buffer[nextClose + 1] == '.') {
                    ++nextClose;
                }
                x = nextClose;
                continue;
            }
            writingChar.append(ch);
        }
        if (writingChar.length() >= 1) {
            String part = writingChar.toString();
            writingChar = new StringBuffer();
            if (part.length() >= 1) {
                if (part.charAt(0) >= '0' && part.charAt(0) <= '9') {
                    try {
                        Integer.parseInt(part);
                    }
                    catch (NumberFormatException e) {
                        _debug.printStackTrace(e, part + " is not number");
                        return null;
                    }
                }
                path.add(part);
            }
        }
        return path;
    }
}

