/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Calendar;
import java.util.Date;
import jp.synthtarou.midimixer.libs.settings.MXSetting;

public class MXSettingUtil {
    public static boolean isInteger(String text) {
        for (int x = 0; x < text.length(); ++x) {
            char ch = text.charAt(x);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return text.length() != 0;
    }

    public static File getAppBaseDirectory() {
        String fileName = null;
        try {
            ProtectionDomain pd = MXSetting.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            URL location = cs.getLocation();
            URI uri = location.toURI();
            Path path = Paths.get(uri);
            fileName = path.toString();
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        File base = new File(fileName);
        if (base.isFile()) {
            base = base.getParentFile();
        }
        return base;
    }

    public static File getSettingDirectory() {
        File dir = new File(MXSettingUtil.getAppBaseDirectory(), "settings");
        if (dir.isDirectory()) {
            return dir;
        }
        try {
            Path p = Paths.get(dir.toURI());
            Files.createDirectory(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    public static File createTemporaryFile(File target) {
        File dir = target.getParentFile();
        String fileName = target.getName();
        for (int i = 1; i < 100; ++i) {
            String newName = fileName + "_temporary" + String.valueOf(i);
            File newFile = new File(dir, newName);
            if (newFile.exists()) continue;
            try {
                new FileOutputStream(newFile).close();
            }
            catch (IOException e) {
                continue;
            }
            return newFile;
        }
        return null;
    }

    public static File autobackupFile(File target) {
        String fileExt;
        String forward;
        File parent = target.getParentFile();
        String fileName = target.getName();
        int lastDot = fileName.indexOf(46);
        if (lastDot >= 0) {
            forward = fileName.substring(0, lastDot);
            fileExt = fileName.substring(lastDot);
        } else {
            forward = fileName;
            fileExt = "";
        }
        Date lastMod = new Date(target.lastModified());
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastMod);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        String newName1 = forward + "_back" + year + "-" + month + "-" + day;
        String newName3 = fileExt;
        for (int count = 1; count <= 99; ++count) {
            String newName;
            if (count == 0) {
                newName = newName1 + newName3;
            } else {
                String newName2 = "(" + count + ")";
                newName = newName1 + newName2 + newName3;
            }
            File f = new File(parent, newName);
            if (f.isFile()) continue;
            target.renameTo(f);
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSameFile(File f1, File f2) {
        FileInputStream in1 = null;
        FileInputStream in2 = null;
        try {
            if (!f1.isFile() || !f2.isFile()) {
                boolean bl = false;
                return bl;
            }
            in1 = new FileInputStream(f1);
            in2 = new FileInputStream(f2);
            byte[] buffer1 = new byte[4096];
            byte[] buffer2 = new byte[4096];
            block32: while (true) {
                int x2;
                int x1;
                if ((x1 = in1.read(buffer1)) != (x2 = in2.read(buffer2))) {
                    boolean bl = false;
                    return bl;
                }
                if (x1 <= 0) {
                    boolean bl = true;
                    return bl;
                }
                int i = 0;
                while (true) {
                    if (i >= x1) continue block32;
                    if (buffer1[i] != buffer2[i]) {
                        boolean bl = false;
                        return bl;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (in1 != null) {
                try {
                    in1.close();
                }
                catch (IOException iOException) {}
            }
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

