/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFTempo;

public final class SMFTempoList {
    ArrayList<SMFTempo> _listTempos;
    int _fileResolution;

    public void setFileResolution(int reso) {
        this._fileResolution = reso;
    }

    public int getFileResolution() {
        return this._fileResolution;
    }

    public SMFTempoList(ArrayList<SMFMessage> listMessage, int fileResolution) {
        int resolution = fileResolution;
        ArrayList<SMFMessage> tempoEvents = new ArrayList<SMFMessage>();
        if (listMessage != null) {
            for (SMFMessage message : listMessage) {
                if (message._status != 255) continue;
                switch (message._dataType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 32: 
                    case 47: 
                    case 84: 
                    case 88: 
                    case 89: 
                    case 117: {
                        break;
                    }
                    case 81: {
                        tempoEvents.add(message);
                    }
                }
            }
        }
        if (tempoEvents.isEmpty() || ((SMFMessage)tempoEvents.get((int)0))._tick != 0L) {
            SMFMessage mm;
            if (tempoEvents.isEmpty()) {
                byte b1 = (byte)(SMFTempo.DEFAULT_MPQ >> 16);
                byte b2 = (byte)(SMFTempo.DEFAULT_MPQ >> 8);
                byte b3 = (byte)SMFTempo.DEFAULT_MPQ;
                mm = new SMFMessage(0L, 255, 81, new byte[]{b1, b2, b3});
            } else {
                mm = (SMFMessage)tempoEvents.get(0);
            }
            tempoEvents.add(0, mm);
        }
        this._listTempos = new ArrayList();
        SMFTempo e = new SMFTempo();
        e.mpqStack = ((SMFMessage)tempoEvents.get(0)).getMetaTempo();
        e.cumulativeTicks = 0L;
        e.cumulativeMicroseconds = 0L;
        this._listTempos.add(e);
        for (SMFMessage event : tempoEvents) {
            long tick;
            SMFTempo prev = e;
            e = new SMFTempo();
            e.cumulativeTicks = tick = event._tick;
            long deltaTick = tick - prev.cumulativeTicks;
            e.mpqStack = event.getMetaTempo();
            long deltaMicroseconds = SMFTempoList.TicksToMicroseconds(deltaTick, prev.mpqStack, resolution);
            e.cumulativeMicroseconds = prev.cumulativeMicroseconds + deltaMicroseconds;
            this._listTempos.add(e);
        }
        this.setFileResolution(resolution);
    }

    public void addTempo(long time, long tick, long mpq) {
        SMFTempo t = new SMFTempo();
        t.cumulativeMicroseconds = time;
        t.cumulativeTicks = tick;
        t.mpqStack = mpq;
        this._listTempos.add(t);
    }

    public long MicrosecondsToTicks(long us) {
        int index = this.GetIndexFromMicroseconds(us);
        SMFTempo e = this._listTempos.get(index);
        long mpq = e.mpqStack;
        long cumUs = e.cumulativeMicroseconds;
        long cumTicks = e.cumulativeTicks;
        long deltaUs = us - cumUs;
        long deltaTicks = SMFTempoList.MicrosecondsToTicks(deltaUs, mpq, this._fileResolution);
        return cumTicks + deltaTicks;
    }

    public long TicksToMicroseconds(long tick) {
        int index = this.GetIndexFromTick(tick);
        SMFTempo e = this._listTempos.get(index);
        long mpq = e.mpqStack;
        long cumUs = e.cumulativeMicroseconds;
        long cumTicks = e.cumulativeTicks;
        long deltaTick = tick - cumTicks;
        long deltaUs = SMFTempoList.TicksToMicroseconds(deltaTick, mpq, this.getFileResolution());
        return cumUs + deltaUs;
    }

    private int GetIndexFromMicroseconds(long us) {
        int lo = -1;
        int hi = this._listTempos.size();
        while (hi - lo > 1) {
            int m = hi - (hi - lo) / 2;
            SMFTempo e = this._listTempos.get(m);
            if (e.cumulativeMicroseconds <= us) {
                lo = m;
                continue;
            }
            hi = m;
        }
        return lo;
    }

    private int GetIndexFromTick(long tick) {
        int lo = -1;
        int hi = this._listTempos.size();
        while (hi - lo > 1) {
            int m = hi - (hi - lo) / 2;
            SMFTempo e = this._listTempos.get(m);
            if (e.cumulativeTicks <= tick) {
                lo = m;
                continue;
            }
            hi = m;
        }
        return lo;
    }

    private static long MicrosecondsToTicks(long us, long mpq, int resolution) {
        return us * (long)resolution / mpq;
    }

    private static long TicksToMicroseconds(long tick, long mqp, int resolution) {
        return tick * mqp / (long)resolution;
    }
}

