/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessageList;
import jp.synthtarou.midimixer.libs.midi.smf.SMFPlayer;
import jp.synthtarou.midimixer.libs.midi.smf.SMFTempoList;

public class SMFRecorder {
    SMFTempoList _listTempo;
    SMFPlayer _player = new SMFPlayer();
    SMFMessageList _listMessage;
    long _startClock = System.currentTimeMillis();

    public void startRecording() {
        this._startClock = System.currentTimeMillis();
        this._player = new SMFPlayer();
        this._player._paraPlay = true;
        this._listTempo = new SMFTempoList(null, 96);
        this._listMessage = this._player.listMessage();
    }

    public SMFPlayer getPlayer() {
        return this._player;
    }

    public long currentTick() {
        long spent = System.currentTimeMillis() - this._startClock;
        return this._listTempo.MicrosecondsToTicks(spent * 1000L);
    }

    public void addNote(MXMessage message) {
        byte[] data = message.createBytes();
        int port = message.getPort();
        if (data.length >= 3) {
            int status = data[0] & 0xFF;
            int data1 = data[1] & 0xFF;
            int data2 = data[2] & 0xFF;
            if (data.length >= 5 && status == 255 && data1 == 81) {
                SMFMessage smf = new SMFMessage(this.currentTick(), status, data1, new byte[]{data[2], data[3], data[4]});
                smf._port = port;
                this._listMessage.add(smf);
                int mpq1 = (data[2] & 0xFF) << 16;
                int mpq2 = (data[3] & 0xFF) << 8;
                int mpq3 = data[4] & 0xFF;
                this._listTempo.addTempo(System.currentTimeMillis() - this._startClock, this.currentTick(), mpq1 + mpq2 + mpq3);
                return;
            }
            if (status == 255) {
                byte[] newData = new byte[data.length - 2];
                for (int i = 0; i < newData.length; ++i) {
                    newData[i] = data[i + 2];
                }
                SMFMessage smf = new SMFMessage(this.currentTick(), status, data1, newData);
                smf._port = port;
                this._listMessage.add(smf);
                return;
            }
            if (status == 240 || status == 247) {
                byte[] newData = new byte[data.length - 1];
                for (int i = 0; i < newData.length; ++i) {
                    newData[i] = data[i + 1];
                }
                SMFMessage smf = new SMFMessage(this.currentTick(), status, status, newData);
                smf._port = port;
                this._listMessage.add(smf);
                return;
            }
            SMFMessage smf = new SMFMessage(this.currentTick(), status, data1, data2);
            smf._port = port;
            this._listMessage.add(smf);
            return;
        }
    }
}

