/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.smf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import jp.synthtarou.midimixer.MXThreadList;
import jp.synthtarou.midimixer.libs.midi.smf.SMFCallback;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessageList;
import jp.synthtarou.midimixer.libs.midi.smf.SMFParser;
import jp.synthtarou.midimixer.libs.midi.smf.SMFTempoList;

public class SMFPlayer {
    private SMFMessageList _listMessage;
    private int _position;
    private int _smpteFormat = -99999;
    private int _resolution = 96;
    private File _lastFile;
    boolean _paraPlay = false;
    boolean _breakSequence;
    SMFMessage[] firstNote = null;
    boolean _isRunning;
    boolean _noteOnly = false;
    int _forceSingleChannel = -1;
    SMFCallback _callback;

    public SMFPlayer() {
        this._listMessage = new SMFMessageList();
        this._smpteFormat = -99999;
        this._resolution = 96;
        this.firstNote = new SMFMessage[16];
    }

    public SMFPlayer(File file) throws IOException {
        SMFParser parser = new SMFParser(file);
        this._lastFile = file;
        this._listMessage = parser.getMessageList();
        this._resolution = parser.getFileInfo().getResolution();
        this._smpteFormat = parser.getFileInfo().getSmpteFormat();
    }

    public File getLastFile() {
        return this._lastFile;
    }

    public SMFMessageList listMessage() {
        return this._listMessage;
    }

    public void startPlayer(SMFCallback callback) {
        if (this.isRunning()) {
            this.stopPlayer();
        }
        this._callback = callback;
        Thread t = MXThreadList.newThread("SMFPlayer", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SMFPlayer.this._callback.smfStarted();
                SMFPlayer.this.allNoteOff();
                try {
                    SMFPlayer.this.resetControllers();
                    if (SMFPlayer.this._smpteFormat > 0) {
                        SMFPlayer.this.playWithSMPTE(SMFPlayer.this._smpteFormat, SMFPlayer.this._resolution);
                        SMFPlayer.this._isRunning = false;
                    } else {
                        SMFPlayer.this.playWithTempo();
                        SMFPlayer.this._isRunning = false;
                    }
                }
                catch (Throwable e) {
                    SMFPlayer.this._isRunning = false;
                    e.printStackTrace();
                }
                finally {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.notifyAll();
                    }
                }
                SMFPlayer.this.allNoteOff();
                SMFPlayer.this._callback.smfStoped(!SMFPlayer.this._breakSequence);
            }
        });
        t.setDaemon(true);
        t.start();
        this._isRunning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlayer() {
        this._breakSequence = true;
        SMFPlayer sMFPlayer = this;
        synchronized (sMFPlayer) {
            this.notifyAll();
        }
        while (this._isRunning) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected boolean sendProgramChangeBeforeNote() {
        int pos;
        ArrayList<SMFMessage> list = this._listMessage.listAll();
        SMFMessage[] firstProgram = new SMFMessage[16];
        SMFMessage[] firstBank0 = new SMFMessage[16];
        SMFMessage[] firstBank32 = new SMFMessage[16];
        this.firstNote = new SMFMessage[16];
        int doneCh = 0;
        for (pos = this._position; pos < list.size(); ++pos) {
            SMFMessage smf = (SMFMessage)list.get(pos);
            int command = smf._status & 0xF0;
            int channel = smf._status & 0xF;
            int data1 = smf._data1;
            if (this.firstNote[channel] != null) continue;
            if (command == 192) {
                firstProgram[channel] = smf;
                continue;
            }
            if (command == 176 && data1 == 0) {
                firstBank0[channel] = smf;
                continue;
            }
            if (command == 176 && data1 == 32) {
                firstBank32[channel] = smf;
                continue;
            }
            if (command != 144) continue;
            this.firstNote[channel] = smf;
            if (++doneCh >= 16) break;
        }
        pos = 0;
        boolean didProgramChange = false;
        for (int ch = 0; ch < 16; ++ch) {
            if (firstBank0[ch] != null && firstBank32[ch] != null) {
                this.smfPlayNote(firstBank0[ch]);
                this.smfPlayNote(firstBank32[ch]);
                didProgramChange = true;
            }
            if (firstProgram[ch] == null) continue;
            this.smfPlayNote(firstProgram[ch]);
            didProgramChange = true;
        }
        if (didProgramChange) {
            try {
                System.out.println("*** Did Program Change*");
                Thread.sleep(150 * doneCh);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return didProgramChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playWithSMPTE(int smpteFormat, int fileResolution) throws InvalidMidiDataException {
        long elapsed;
        long elapsedTicks;
        this._breakSequence = false;
        double frameRate = smpteFormat;
        if (smpteFormat == 29) {
            frameRate = 29.97;
        }
        double tickPerMilliSecond = frameRate * (double)fileResolution / 1000.0;
        int pos = this._position;
        if (!this._paraPlay && this._position == 0) {
            this.sendProgramChangeBeforeNote();
        }
        ArrayList<SMFMessage> list = this._listMessage.listAll();
        long stopWatch = System.currentTimeMillis();
        long alreadySpent = (long)((double)((SMFMessage)list.get((int)pos))._tick * tickPerMilliSecond) / 1000L;
        stopWatch -= alreadySpent;
        while (!this._breakSequence && pos < list.size() && (elapsedTicks = (long)((double)(elapsed = System.currentTimeMillis() - stopWatch) * tickPerMilliSecond)) >= 0L) {
            while (!this._breakSequence && ((SMFMessage)list.get((int)pos))._tick <= elapsedTicks) {
                this._position = pos;
                this._callback.smfProgress(pos, list.size());
                SMFMessage currentEvent = (SMFMessage)list.get(pos++);
                if (currentEvent.isBinaryMessage() || currentEvent.isMetaMessage()) {
                    this.smfPlayNote(currentEvent);
                    if (pos < list.size()) continue;
                    break;
                }
                if (currentEvent._status < 128) continue;
                int status = currentEvent._status;
                int data1 = currentEvent._data1;
                int data2 = currentEvent._data2;
                int command = status & 0xF0;
                int channel = status & 0xF;
                if (this.firstNote != null && this.firstNote[channel] != null) {
                    if (command == 192 || command == 176 && (data1 == 0 || data1 == 32)) continue;
                    if (command == 144 && this.firstNote[channel] == currentEvent) {
                        this.firstNote[channel] = null;
                    }
                }
                this.smfPlayNote(currentEvent);
                if (pos < list.size()) continue;
                break;
            }
            try {
                if (!this._breakSequence && pos < list.size()) {
                    long nextTick = ((SMFMessage)list.get((int)pos))._tick;
                    int nextMillis = (int)((double)nextTick / tickPerMilliSecond - (double)System.currentTimeMillis());
                    long differ = (long)nextMillis - (System.currentTimeMillis() - stopWatch);
                    SMFPlayer sMFPlayer = this;
                    synchronized (sMFPlayer) {
                        if (differ >= 10L) {
                            this.wait(differ - 5L);
                        } else {
                            this.wait(1L);
                        }
                        continue;
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                this._breakSequence = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playWithTempo() throws InvalidMidiDataException {
        long elapsed;
        long elapsedTicks;
        this._breakSequence = false;
        SMFTempoList tempo = new SMFTempoList(this._listMessage.listAll(), this._resolution);
        int pos = this._position;
        if (!this._paraPlay && this._position == 0) {
            this.sendProgramChangeBeforeNote();
        }
        ArrayList<SMFMessage> list = this._listMessage.listAll();
        long stopWatch = System.currentTimeMillis();
        long alreadySpent = tempo.TicksToMicroseconds(((SMFMessage)list.get((int)pos))._tick) / 1000L;
        stopWatch -= alreadySpent;
        while (!this._breakSequence && pos < list.size() && (elapsedTicks = tempo.MicrosecondsToTicks(elapsed = (System.currentTimeMillis() - stopWatch) * 1000L)) >= 0L) {
            while (!this._breakSequence && ((SMFMessage)list.get((int)pos))._tick <= elapsedTicks) {
                this._position = pos;
                this._callback.smfProgress(pos, list.size());
                SMFMessage currentEvent = (SMFMessage)list.get(pos++);
                if (currentEvent.isBinaryMessage() || currentEvent.isMetaMessage()) {
                    if (currentEvent.getBinary().length == 0 || currentEvent.getBinary()[0] == 0) continue;
                    this.smfPlayNote(currentEvent);
                    if (pos < list.size()) continue;
                    break;
                }
                if (currentEvent._status < 128) continue;
                int status = currentEvent._status;
                int data1 = currentEvent._data1;
                int data2 = currentEvent._data2;
                int command = status & 0xF0;
                int channel = status & 0xF;
                if (this.firstNote != null && this.firstNote[channel] != null) {
                    if (command == 192 || command == 176 && (data1 == 0 || data1 == 32)) continue;
                    if (command == 144 && this.firstNote[channel] == currentEvent) {
                        this.firstNote[channel] = null;
                    }
                }
                this.smfPlayNote(currentEvent);
                if (pos < list.size()) continue;
                break;
            }
            try {
                if (!this._breakSequence && pos < list.size()) {
                    long nextTick = ((SMFMessage)list.get((int)pos))._tick;
                    long nextMillis = tempo.TicksToMicroseconds(nextTick) / 1000L;
                    long differ = nextMillis - (System.currentTimeMillis() - stopWatch);
                    SMFPlayer sMFPlayer = this;
                    synchronized (sMFPlayer) {
                        if (differ >= 10L) {
                            this.wait(differ - 5L);
                        } else {
                            this.wait(1L);
                        }
                        continue;
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                this._breakSequence = true;
            }
        }
    }

    public void resetControllers() {
        if (this.getCurrentPosition() == 0 && !this._paraPlay) {
            int start = 0;
            int end = 15;
            if (this._forceSingleChannel >= 0) {
                start = this._forceSingleChannel;
                end = this._forceSingleChannel;
            }
            for (int i = start; i <= end; ++i) {
                SMFMessage message = new SMFMessage(0L, 176 + i, 64, 0);
                this.smfPlayNote(message);
                message = new SMFMessage(0L, 176 + i, 123, 127);
                this.smfPlayNote(message);
                message = new SMFMessage(0L, 176 + i, 11, 127);
                this.smfPlayNote(message);
                message = new SMFMessage(0L, 176 + i, 7, 127);
                this.smfPlayNote(message);
            }
        }
    }

    public void allNoteOff() {
        if (this._paraPlay) {
            return;
        }
        int chFrom = 0;
        int chTo = 15;
        if (this._forceSingleChannel >= 0) {
            chFrom = this._forceSingleChannel;
            chTo = this._forceSingleChannel;
        }
        for (int i = chFrom; i <= chTo; ++i) {
            SMFMessage message = new SMFMessage(0L, 176 + i, 64, 0);
            this.smfPlayNote(message);
            message = new SMFMessage(0L, 176 + i, 123, 127);
            this.smfPlayNote(message);
            message = new SMFMessage(0L, 176 + i, 120, 127);
            this.smfPlayNote(message);
        }
    }

    public synchronized boolean isRunning() {
        return this._isRunning;
    }

    public int getCurrentPosition() {
        return this._position;
    }

    public void setCurrentPosition(int pos) {
        if (pos > this.getLength()) {
            throw new IllegalArgumentException("timing error pos = " + pos + " length " + this.getLength());
        }
        this._position = pos;
    }

    public int getLength() {
        return this._listMessage.size();
    }

    public void smfPlayNote(SMFMessage smf) {
        try {
            if (smf.isBinaryMessage()) {
                this._callback.smfPlayNote(smf);
            } else {
                int dword = smf.toDwordMessage();
                if (this._noteOnly) {
                    boolean skip = true;
                    int status = dword >> 16 & 0xFF;
                    int data1 = dword >> 8 & 0xFF;
                    int data2 = dword & 0xFF;
                    if (this._forceSingleChannel >= 0 && status >= 128 && status <= 239) {
                        status = status & 0xF0 | this._forceSingleChannel;
                    }
                    switch (status & 0xF0) {
                        case 128: 
                        case 144: 
                        case 224: {
                            skip = false;
                            break;
                        }
                        case 176: {
                            if (data1 != 64 && data1 != 1 && data1 != 123 && data1 != 120) break;
                            skip = false;
                        }
                    }
                    if (skip) {
                        return;
                    }
                }
                this._callback.smfPlayNote(smf);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setForceSingleChannel(int ch) {
        this._forceSingleChannel = ch;
    }

    public void setFilterNoteOnly(boolean only) {
        this._noteOnly = only;
    }

    public void setStartPosition(int pos) {
        this._position = pos;
    }

    public int getPositionOfFirstNote() {
        boolean firstNoetPos = false;
        ArrayList<SMFMessage> list = this.listMessage().listAll();
        int pos = 0;
        for (SMFMessage smf : list) {
            int command = smf._status;
            if ((command & 0xF0) == 144) {
                return pos;
            }
            ++pos;
        }
        return 0;
    }
}

